/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.util;

import java.io.Serializable;
import org.apache.commons.configuration.Configuration;
import org.apache.tinkerpop.gremlin.process.computer.util.VertexProgramHelper;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.structure.Graph;

public final class PureTraversal<S, E>
implements Serializable,
Cloneable {
    private Traversal.Admin<S, E> pureTraversal;
    private transient Traversal.Admin<S, E> cachedTraversal;

    public PureTraversal(Traversal.Admin<S, E> pureTraversal) {
        this.pureTraversal = pureTraversal;
    }

    public Traversal.Admin<S, E> getPure() {
        return this.pureTraversal.clone();
    }

    public Traversal.Admin<S, E> get() {
        if (null == this.cachedTraversal) {
            this.cachedTraversal = this.pureTraversal.clone();
        }
        return this.cachedTraversal;
    }

    public void storeState(Configuration configuration, String configurationKey) {
        try {
            VertexProgramHelper.serialize(this, configuration, configurationKey);
        }
        catch (IllegalArgumentException e) {
            configuration.setProperty(configurationKey, this);
        }
    }

    public int hashCode() {
        return this.pureTraversal.hashCode();
    }

    public boolean equals(Object other) {
        return other instanceof PureTraversal && this.pureTraversal.equals(((PureTraversal)other).pureTraversal);
    }

    public static <S, E> void storeState(Configuration configuration, String configurationKey, Traversal.Admin<S, E> traversal) {
        new PureTraversal<S, E>(traversal).storeState(configuration, configurationKey);
    }

    public static <S, E> PureTraversal<S, E> loadState(Configuration configuration, String configurationKey, Graph graph) {
        Object configValue = configuration.getProperty(configurationKey);
        PureTraversal pureTraversal = configValue instanceof String ? (PureTraversal)VertexProgramHelper.deserialize(configuration, configurationKey) : (PureTraversal)configValue;
        pureTraversal.pureTraversal.setGraph(graph);
        return pureTraversal;
    }

    public String toString() {
        return this.get().toString();
    }

    public PureTraversal<S, E> clone() {
        try {
            PureTraversal clone = (PureTraversal)super.clone();
            clone.pureTraversal = this.pureTraversal.clone();
            clone.cachedTraversal = null;
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }
}

