/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.util.AbstractExplanation;
import org.apache.tinkerpop.gremlin.process.traversal.util.DefaultTraversalStrategies;
import org.apache.tinkerpop.gremlin.process.traversal.util.ImmutableExplanation;
import org.javatuples.Pair;
import org.javatuples.Triplet;

public class TraversalExplanation
extends AbstractExplanation
implements Serializable {
    private Traversal.Admin<?, ?> traversal;
    private List<Pair<TraversalStrategy, Traversal.Admin<?, ?>>> strategyTraversals = new ArrayList();

    protected TraversalExplanation() {
    }

    public TraversalExplanation(Traversal.Admin<?, ?> traversal) {
        this.traversal = traversal.clone();
        DefaultTraversalStrategies mutatingStrategies = new DefaultTraversalStrategies();
        for (TraversalStrategy<?> strategy : this.traversal.getStrategies().toList()) {
            Traversal.Admin<?, ?> mutatingTraversal = this.traversal.clone();
            mutatingStrategies.addStrategies(strategy);
            mutatingTraversal.setStrategies(mutatingStrategies);
            mutatingTraversal.applyStrategies();
            this.strategyTraversals.add(Pair.with(strategy, mutatingTraversal));
        }
    }

    public List<Pair<TraversalStrategy, Traversal.Admin<?, ?>>> getStrategyTraversals() {
        return Collections.unmodifiableList(this.strategyTraversals);
    }

    public Traversal.Admin<?, ?> getOriginalTraversal() {
        return this.traversal;
    }

    public ImmutableExplanation asImmutable() {
        return new ImmutableExplanation(this.getOriginalTraversalAsString(), this.getIntermediates().collect(Collectors.toList()));
    }

    @Override
    protected Stream<String> getStrategyTraversalsAsString() {
        return this.strategyTraversals.stream().map(Pair::getValue0).map(Object::toString);
    }

    @Override
    protected String getOriginalTraversalAsString() {
        return this.getOriginalTraversal().toString();
    }

    @Override
    protected Stream<Triplet<String, String, String>> getIntermediates() {
        return this.strategyTraversals.stream().map(p -> Triplet.with(((TraversalStrategy)p.getValue0()).toString(), ((TraversalStrategy)p.getValue0()).getTraversalCategory().getSimpleName(), ((Traversal.Admin)p.getValue1()).toString()));
    }
}

