/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.io.graphson;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.tinkerpop.gremlin.structure.io.graphson.TypeInfo;
import org.apache.tinkerpop.shaded.jackson.annotation.JsonTypeInfo;
import org.apache.tinkerpop.shaded.jackson.core.JsonGenerator;
import org.apache.tinkerpop.shaded.jackson.databind.BeanProperty;
import org.apache.tinkerpop.shaded.jackson.databind.jsontype.TypeIdResolver;
import org.apache.tinkerpop.shaded.jackson.databind.jsontype.TypeSerializer;

public abstract class AbstractGraphSONTypeSerializer
extends TypeSerializer {
    protected final TypeIdResolver idRes;
    protected final String propertyName;
    protected final TypeInfo typeInfo;
    protected final String valuePropertyName;
    protected final Map<Class, Class> classMap = new HashMap<Class, Class>();

    AbstractGraphSONTypeSerializer(TypeIdResolver idRes, String propertyName, TypeInfo typeInfo, String valuePropertyName) {
        this.idRes = idRes;
        this.propertyName = propertyName;
        this.typeInfo = typeInfo;
        this.valuePropertyName = valuePropertyName;
    }

    @Override
    public TypeSerializer forProperty(BeanProperty beanProperty) {
        return this;
    }

    @Override
    public JsonTypeInfo.As getTypeInclusion() {
        return JsonTypeInfo.As.WRAPPER_OBJECT;
    }

    @Override
    public String getPropertyName() {
        return this.propertyName;
    }

    @Override
    public TypeIdResolver getTypeIdResolver() {
        return this.idRes;
    }

    protected boolean canWriteTypeId() {
        return this.typeInfo != null && this.typeInfo == TypeInfo.PARTIAL_TYPES;
    }

    protected void writeTypePrefix(JsonGenerator jsonGenerator, String s) throws IOException {
        jsonGenerator.writeStartObject();
        jsonGenerator.writeStringField(this.propertyName, s);
        jsonGenerator.writeFieldName(this.valuePropertyName);
    }

    protected void writeTypeSuffix(JsonGenerator jsonGenerator) throws IOException {
        jsonGenerator.writeEndObject();
    }

    protected abstract Class getClassFromObject(Object var1);
}

