/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.util.star;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.commons.configuration.BaseConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.tinkerpop.gremlin.process.computer.GraphComputer;
import org.apache.tinkerpop.gremlin.process.computer.GraphFilter;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Transaction;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.structure.util.Attachable;
import org.apache.tinkerpop.gremlin.structure.util.ElementHelper;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;

public final class StarGraph
implements Graph,
Serializable {
    private static final Configuration STAR_GRAPH_CONFIGURATION = new BaseConfiguration();
    protected Long nextId = 0L;
    protected StarVertex starVertex = null;
    protected Map<Object, Map<String, Object>> edgeProperties = null;
    protected Map<Object, Map<String, Object>> metaProperties = null;
    protected final boolean internStrings;
    protected final boolean compareIdsUsingStrings;

    private StarGraph() {
        this(true, true);
    }

    private StarGraph(boolean internStrings, boolean compareIdsUsingStrings) {
        this.internStrings = internStrings;
        this.compareIdsUsingStrings = compareIdsUsingStrings;
    }

    public StarVertex getStarVertex() {
        return this.starVertex;
    }

    private Long nextId() {
        StarGraph starGraph = this;
        Long l = starGraph.nextId;
        Long l2 = starGraph.nextId = Long.valueOf(starGraph.nextId + 1L);
        return l;
    }

    @Override
    public Vertex addVertex(Object ... keyValues) {
        if (null == this.starVertex) {
            ElementHelper.legalPropertyKeyValueArray(keyValues);
            this.starVertex = new StarVertex(ElementHelper.getIdValue(keyValues).orElse(this.nextId()), ElementHelper.getLabelValue(keyValues).orElse("vertex"));
            ElementHelper.attachProperties((Vertex)this.starVertex, VertexProperty.Cardinality.list, keyValues);
            return this.starVertex;
        }
        return new StarAdjacentVertex(ElementHelper.getIdValue(keyValues).orElse(this.nextId()));
    }

    @Override
    public <C extends GraphComputer> C compute(Class<C> graphComputerClass) throws IllegalArgumentException {
        throw Graph.Exceptions.graphComputerNotSupported();
    }

    @Override
    public GraphComputer compute() throws IllegalArgumentException {
        throw Graph.Exceptions.graphComputerNotSupported();
    }

    @Override
    public Iterator<Vertex> vertices(Object ... vertexIds) {
        if (null == this.starVertex) {
            return Collections.emptyIterator();
        }
        if (vertexIds.length > 0 && vertexIds[0] instanceof StarVertex) {
            return Stream.of(vertexIds).map(v -> (Vertex)v).iterator();
        }
        if (this.idExists(this.starVertex.id(), vertexIds)) {
            return IteratorUtils.of(this.starVertex);
        }
        return Collections.emptyIterator();
    }

    @Override
    public Iterator<Edge> edges(Object ... edgeIds) {
        return null == this.starVertex ? Collections.emptyIterator() : Stream.concat(null == this.starVertex.inEdges ? Stream.empty() : this.starVertex.inEdges.values().stream(), null == this.starVertex.outEdges ? Stream.empty() : this.starVertex.outEdges.values().stream()).flatMap(Collection::stream).filter(edge -> {
            if (edgeIds.length > 0 && edgeIds[0] instanceof Edge) {
                return this.idExists(edge.id(), Stream.of(edgeIds).map(e -> ((Edge)e).id()).toArray());
            }
            return this.idExists(edge.id(), edgeIds);
        }).iterator();
    }

    @Override
    public Transaction tx() {
        throw Graph.Exceptions.transactionsNotSupported();
    }

    @Override
    public Graph.Variables variables() {
        throw Graph.Exceptions.variablesNotSupported();
    }

    @Override
    public Configuration configuration() {
        return STAR_GRAPH_CONFIGURATION;
    }

    @Override
    public Graph.Features features() {
        return StarGraphFeatures.INSTANCE;
    }

    @Override
    public void close() throws Exception {
    }

    public String toString() {
        return StringFactory.graphString(this, "starOf:" + this.starVertex);
    }

    public static StarGraph open() {
        return new StarGraph();
    }

    public static StarGraph of(Vertex vertex) {
        if (vertex instanceof StarVertex) {
            return (StarGraph)vertex.graph();
        }
        StarGraph starGraph = new StarGraph();
        StarVertex starVertex = (StarVertex)starGraph.addVertex(T.id, vertex.id(), T.label, vertex.label());
        boolean supportsMetaProperties = vertex.graph().features().vertex().supportsMetaProperties();
        vertex.properties(new String[0]).forEachRemaining(vp -> {
            VertexProperty starVertexProperty = starVertex.property(VertexProperty.Cardinality.list, vp.key(), vp.value(), T.id, vp.id());
            if (supportsMetaProperties) {
                vp.properties(new String[0]).forEachRemaining(p -> starVertexProperty.property(p.key(), p.value()));
            }
        });
        vertex.edges(Direction.IN, new String[0]).forEachRemaining(edge -> {
            Edge starEdge = starVertex.addInEdge(edge.label(), starGraph.addVertex(T.id, edge.outVertex().id()), T.id, edge.id());
            edge.properties(new String[0]).forEachRemaining(p -> starEdge.property(p.key(), p.value()));
        });
        vertex.edges(Direction.OUT, new String[0]).forEachRemaining(edge -> {
            Edge starEdge = starVertex.addOutEdge(edge.label(), starGraph.addVertex(T.id, edge.inVertex().id()), T.id, edge.id());
            edge.properties(new String[0]).forEachRemaining(p -> starEdge.property(p.key(), p.value()));
        });
        return starGraph;
    }

    @Deprecated
    public static Builder builder() {
        return StarGraph.build();
    }

    public static Builder build() {
        return new Builder();
    }

    public Optional<StarGraph> applyGraphFilter(GraphFilter graphFilter) {
        if (null == this.starVertex) {
            return Optional.empty();
        }
        Optional<StarVertex> filtered = this.starVertex.applyGraphFilter(graphFilter);
        return filtered.isPresent() ? Optional.of((StarGraph)filtered.get().graph()) : Optional.empty();
    }

    private boolean idExists(Object id, Object ... providedIds) {
        if (this.compareIdsUsingStrings) {
            return ElementHelper.idExists(id, providedIds);
        }
        if (0 == providedIds.length) {
            return true;
        }
        if (1 == providedIds.length) {
            return id.equals(providedIds[0]);
        }
        for (Object temp : providedIds) {
            if (!temp.equals(id)) continue;
            return true;
        }
        return false;
    }

    static {
        STAR_GRAPH_CONFIGURATION.setProperty("gremlin.graph", StarGraph.class.getCanonicalName());
    }

    static class StarGraphVertexPropertyFeatures
    implements Graph.Features.VertexPropertyFeatures {
        public static final StarGraphVertexPropertyFeatures INSTANCE = new StarGraphVertexPropertyFeatures();

        private StarGraphVertexPropertyFeatures() {
        }

        @Override
        public boolean supportsCustomIds() {
            return false;
        }

        @Override
        public boolean willAllowId(Object id) {
            return true;
        }
    }

    static class StarGraphGraphFeatures
    implements Graph.Features.GraphFeatures {
        public static final StarGraphGraphFeatures INSTANCE = new StarGraphGraphFeatures();

        private StarGraphGraphFeatures() {
        }

        @Override
        public boolean supportsTransactions() {
            return false;
        }

        @Override
        public boolean supportsPersistence() {
            return false;
        }

        @Override
        public boolean supportsThreadedTransactions() {
            return false;
        }
    }

    static class StarGraphEdgeFeatures
    implements Graph.Features.EdgeFeatures {
        public static final StarGraphEdgeFeatures INSTANCE = new StarGraphEdgeFeatures();

        private StarGraphEdgeFeatures() {
        }

        @Override
        public boolean supportsCustomIds() {
            return false;
        }

        @Override
        public boolean willAllowId(Object id) {
            return true;
        }
    }

    static class StarGraphVertexFeatures
    implements Graph.Features.VertexFeatures {
        public static final StarGraphVertexFeatures INSTANCE = new StarGraphVertexFeatures();

        private StarGraphVertexFeatures() {
        }

        @Override
        public Graph.Features.VertexPropertyFeatures properties() {
            return StarGraphVertexPropertyFeatures.INSTANCE;
        }

        @Override
        public boolean supportsCustomIds() {
            return false;
        }

        @Override
        public boolean willAllowId(Object id) {
            return true;
        }
    }

    public static class StarGraphFeatures
    implements Graph.Features {
        public static final StarGraphFeatures INSTANCE = new StarGraphFeatures();

        private StarGraphFeatures() {
        }

        @Override
        public Graph.Features.GraphFeatures graph() {
            return StarGraphGraphFeatures.INSTANCE;
        }

        @Override
        public Graph.Features.EdgeFeatures edge() {
            return StarGraphEdgeFeatures.INSTANCE;
        }

        @Override
        public Graph.Features.VertexFeatures vertex() {
            return StarGraphVertexFeatures.INSTANCE;
        }

        public String toString() {
            return StringFactory.featureString(this);
        }
    }

    public final class StarProperty<V>
    implements Property<V>,
    Attachable<Property<V>> {
        private final String key;
        private final V value;
        private final Element element;

        private StarProperty(String key, V value, Element element) {
            this.key = StarGraph.this.internStrings ? key.intern() : key;
            this.value = value;
            this.element = element;
        }

        @Override
        public String key() {
            return this.key;
        }

        @Override
        public V value() throws NoSuchElementException {
            return this.value;
        }

        @Override
        public boolean isPresent() {
            return true;
        }

        @Override
        public Element element() {
            return this.element;
        }

        @Override
        public void remove() {
            throw Property.Exceptions.propertyRemovalNotSupported();
        }

        public String toString() {
            return StringFactory.propertyString(this);
        }

        public boolean equals(Object object) {
            return ElementHelper.areEqual(this, object);
        }

        public int hashCode() {
            return ElementHelper.hashCode(this);
        }

        @Override
        public Property<V> get() {
            return this;
        }
    }

    public final class StarInEdge
    extends StarEdge {
        private StarInEdge(Object id, String label, Object otherId) {
            super(id, label, otherId);
        }

        @Override
        public Vertex outVertex() {
            return new StarAdjacentVertex(this.otherId);
        }

        @Override
        public Vertex inVertex() {
            return StarGraph.this.starVertex;
        }
    }

    public final class StarOutEdge
    extends StarEdge {
        private StarOutEdge(Object id, String label, Object otherId) {
            super(id, label, otherId);
        }

        @Override
        public Vertex outVertex() {
            return StarGraph.this.starVertex;
        }

        @Override
        public Vertex inVertex() {
            return new StarAdjacentVertex(this.otherId);
        }
    }

    public abstract class StarEdge
    extends StarElement<Edge>
    implements Edge {
        protected final Object otherId;

        private StarEdge(Object id, String label, Object otherId) {
            super(id, label);
            this.otherId = otherId;
        }

        @Override
        public <V> Property<V> property(String key, V value) {
            Map<String, Object> properties;
            ElementHelper.validateProperty(key, value);
            if (null == StarGraph.this.edgeProperties) {
                StarGraph.this.edgeProperties = new HashMap<Object, Map<String, Object>>();
            }
            if (null == (properties = StarGraph.this.edgeProperties.get(this.id))) {
                properties = new HashMap<String, Object>();
                StarGraph.this.edgeProperties.put(this.id, properties);
            }
            properties.put(key, value);
            return new StarProperty(key, value, this);
        }

        @Override
        public <V> Iterator<Property<V>> properties(String ... propertyKeys) {
            Map<String, Object> properties;
            Map<String, Object> map = properties = null == StarGraph.this.edgeProperties ? null : StarGraph.this.edgeProperties.get(this.id);
            if (null == properties || properties.isEmpty()) {
                return Collections.emptyIterator();
            }
            if (propertyKeys.length == 0) {
                return properties.entrySet().stream().map(entry -> new StarProperty((String)entry.getKey(), entry.getValue(), this)).iterator();
            }
            if (propertyKeys.length == 1) {
                Object v = properties.get(propertyKeys[0]);
                return null == v ? Collections.emptyIterator() : IteratorUtils.of(new StarProperty(propertyKeys[0], v, this));
            }
            return properties.entrySet().stream().filter(entry -> ElementHelper.keyExists((String)entry.getKey(), propertyKeys)).map(entry -> new StarProperty((String)entry.getKey(), entry.getValue(), this)).iterator();
        }

        @Override
        public Iterator<Vertex> vertices(Direction direction) {
            if (direction.equals((Object)Direction.OUT)) {
                return IteratorUtils.of(this.outVertex());
            }
            if (direction.equals((Object)Direction.IN)) {
                return IteratorUtils.of(this.inVertex());
            }
            return IteratorUtils.of(this.outVertex(), this.inVertex());
        }

        @Override
        public void remove() {
            throw Edge.Exceptions.edgeRemovalNotSupported();
        }

        public String toString() {
            return StringFactory.edgeString(this);
        }
    }

    public class StarAdjacentVertex
    implements Vertex {
        private final Object id;

        private StarAdjacentVertex(Object id) {
            this.id = id;
        }

        @Override
        public Edge addEdge(String label, Vertex inVertex, Object ... keyValues) {
            if (inVertex.equals(StarGraph.this.starVertex)) {
                return StarGraph.this.starVertex.addInEdge(label, this, keyValues);
            }
            throw GraphComputer.Exceptions.adjacentVertexEdgesAndVerticesCanNotBeReadOrUpdated();
        }

        @Override
        public <V> VertexProperty<V> property(String key, V value, Object ... keyValues) {
            throw GraphComputer.Exceptions.adjacentVertexPropertiesCanNotBeReadOrUpdated();
        }

        @Override
        public <V> VertexProperty<V> property(VertexProperty.Cardinality cardinality, String key, V value, Object ... keyValues) {
            throw GraphComputer.Exceptions.adjacentVertexPropertiesCanNotBeReadOrUpdated();
        }

        @Override
        public Iterator<Edge> edges(Direction direction, String ... edgeLabels) {
            throw GraphComputer.Exceptions.adjacentVertexEdgesAndVerticesCanNotBeReadOrUpdated();
        }

        @Override
        public Iterator<Vertex> vertices(Direction direction, String ... edgeLabels) {
            throw GraphComputer.Exceptions.adjacentVertexEdgesAndVerticesCanNotBeReadOrUpdated();
        }

        @Override
        public Object id() {
            return this.id;
        }

        @Override
        public String label() {
            throw GraphComputer.Exceptions.adjacentVertexLabelsCanNotBeRead();
        }

        @Override
        public Graph graph() {
            return StarGraph.this;
        }

        @Override
        public void remove() {
            throw Vertex.Exceptions.vertexRemovalNotSupported();
        }

        @Override
        public <V> Iterator<VertexProperty<V>> properties(String ... propertyKeys) {
            throw GraphComputer.Exceptions.adjacentVertexPropertiesCanNotBeReadOrUpdated();
        }

        public boolean equals(Object other) {
            return ElementHelper.areEqual((Element)this, other);
        }

        public int hashCode() {
            return ElementHelper.hashCode(this);
        }

        public String toString() {
            return StringFactory.vertexString(this);
        }
    }

    public final class StarVertexProperty<V>
    extends StarElement<VertexProperty<V>>
    implements VertexProperty<V> {
        private final V value;

        private StarVertexProperty(Object id, String key, V value) {
            super(id, key);
            this.value = value;
        }

        @Override
        public String key() {
            return this.label();
        }

        @Override
        public V value() throws NoSuchElementException {
            return this.value;
        }

        @Override
        public boolean isPresent() {
            return true;
        }

        @Override
        public Vertex element() {
            return StarGraph.this.starVertex;
        }

        @Override
        public void remove() {
            if (null != StarGraph.this.starVertex.vertexProperties) {
                StarGraph.this.starVertex.vertexProperties.get(this.label).remove(this);
            }
        }

        @Override
        public <U> Iterator<Property<U>> properties(String ... propertyKeys) {
            Map<String, Object> properties;
            Map<String, Object> map = properties = null == StarGraph.this.metaProperties ? null : StarGraph.this.metaProperties.get(this.id);
            if (null == properties || properties.isEmpty()) {
                return Collections.emptyIterator();
            }
            if (propertyKeys.length == 0) {
                return properties.entrySet().stream().map(entry -> new StarProperty((String)entry.getKey(), entry.getValue(), this)).iterator();
            }
            if (propertyKeys.length == 1) {
                Object v = properties.get(propertyKeys[0]);
                return null == v ? Collections.emptyIterator() : IteratorUtils.of(new StarProperty(propertyKeys[0], v, this));
            }
            return properties.entrySet().stream().filter(entry -> ElementHelper.keyExists((String)entry.getKey(), propertyKeys)).map(entry -> new StarProperty((String)entry.getKey(), entry.getValue(), this)).iterator();
        }

        public <U> Property<U> property(String key, U value) {
            Map<String, Object> properties;
            ElementHelper.validateProperty(key, value);
            if (null == StarGraph.this.metaProperties) {
                StarGraph.this.metaProperties = new HashMap<Object, Map<String, Object>>();
            }
            if (null == (properties = StarGraph.this.metaProperties.get(this.id))) {
                properties = new HashMap<String, Object>();
                StarGraph.this.metaProperties.put(this.id, properties);
            }
            properties.put(key, value);
            return new StarProperty(key, value, this);
        }

        public String toString() {
            return StringFactory.propertyString(this);
        }
    }

    public final class StarVertex
    extends StarElement<Vertex>
    implements Vertex {
        protected Map<String, List<Edge>> outEdges;
        protected Map<String, List<Edge>> inEdges;
        protected Map<String, List<VertexProperty>> vertexProperties;

        public StarVertex(Object id, String label) {
            super(id, label);
            this.outEdges = null;
            this.inEdges = null;
            this.vertexProperties = null;
        }

        public void dropEdges(Direction direction) {
            if ((direction.equals((Object)Direction.OUT) || direction.equals((Object)Direction.BOTH)) && null != this.outEdges) {
                this.outEdges.clear();
                this.outEdges = null;
            }
            if ((direction.equals((Object)Direction.IN) || direction.equals((Object)Direction.BOTH)) && null != this.inEdges) {
                this.inEdges.clear();
                this.inEdges = null;
            }
        }

        public void dropEdges(Direction direction, String edgeLabel) {
            if (null != this.outEdges && (direction.equals((Object)Direction.OUT) || direction.equals((Object)Direction.BOTH))) {
                this.outEdges.remove(edgeLabel);
                if (this.outEdges.isEmpty()) {
                    this.outEdges = null;
                }
            }
            if (null != this.inEdges && (direction.equals((Object)Direction.IN) || direction.equals((Object)Direction.BOTH))) {
                this.inEdges.remove(edgeLabel);
                if (this.inEdges.isEmpty()) {
                    this.inEdges = null;
                }
            }
        }

        public void dropVertexProperties(String ... propertyKeys) {
            if (null != this.vertexProperties) {
                for (String key : propertyKeys) {
                    this.vertexProperties.remove(key);
                }
            }
        }

        @Override
        public Edge addEdge(String label, Vertex inVertex, Object ... keyValues) {
            Edge edge = this.addOutEdge(label, inVertex, keyValues);
            if (inVertex.equals(this)) {
                if (ElementHelper.getIdValue(keyValues).isPresent()) {
                    this.addInEdge(label, this, keyValues);
                } else {
                    Object[] keyValuesWithId = Arrays.copyOf(keyValues, keyValues.length + 2);
                    keyValuesWithId[keyValuesWithId.length - 2] = T.id;
                    keyValuesWithId[keyValuesWithId.length - 1] = edge.id();
                    this.addInEdge(label, this, keyValuesWithId);
                }
            }
            return edge;
        }

        @Override
        public <V> VertexProperty<V> property(String key, V value, Object ... keyValues) {
            ElementHelper.validateProperty(key, value);
            ElementHelper.legalPropertyKeyValueArray(keyValues);
            return this.property(VertexProperty.Cardinality.single, key, value, keyValues);
        }

        Edge addOutEdge(String label, Vertex inVertex, Object ... keyValues) {
            List<Edge> outE;
            ElementHelper.validateLabel(label);
            ElementHelper.legalPropertyKeyValueArray(keyValues);
            if (null == this.outEdges) {
                this.outEdges = new HashMap<String, List<Edge>>();
            }
            if (null == (outE = this.outEdges.get(label))) {
                outE = new ArrayList<Edge>();
                this.outEdges.put(label, outE);
            }
            StarOutEdge outEdge = new StarOutEdge(ElementHelper.getIdValue(keyValues).orElse(StarGraph.this.nextId()), label, inVertex.id());
            ElementHelper.attachProperties(outEdge, keyValues);
            outE.add(outEdge);
            return outEdge;
        }

        Edge addInEdge(String label, Vertex outVertex, Object ... keyValues) {
            List<Edge> inE;
            ElementHelper.validateLabel(label);
            ElementHelper.legalPropertyKeyValueArray(keyValues);
            if (null == this.inEdges) {
                this.inEdges = new HashMap<String, List<Edge>>();
            }
            if (null == (inE = this.inEdges.get(label))) {
                inE = new ArrayList<Edge>();
                this.inEdges.put(label, inE);
            }
            StarInEdge inEdge = new StarInEdge(ElementHelper.getIdValue(keyValues).orElse(StarGraph.this.nextId()), label, outVertex.id());
            ElementHelper.attachProperties(inEdge, keyValues);
            inE.add(inEdge);
            return inEdge;
        }

        @Override
        public <V> VertexProperty<V> property(VertexProperty.Cardinality cardinality, String key, V value, Object ... keyValues) {
            ElementHelper.legalPropertyKeyValueArray(keyValues);
            if (null == this.vertexProperties) {
                this.vertexProperties = new HashMap<String, List<VertexProperty>>();
            }
            ArrayList list = cardinality.equals((Object)VertexProperty.Cardinality.single) ? new ArrayList(1) : (List)this.vertexProperties.getOrDefault(key, new ArrayList());
            StarVertexProperty vertexProperty = new StarVertexProperty(ElementHelper.getIdValue(keyValues).orElse(StarGraph.this.nextId()), key, value);
            ElementHelper.attachProperties(vertexProperty, keyValues);
            list.add(vertexProperty);
            this.vertexProperties.put(key, list);
            return vertexProperty;
        }

        @Override
        public Iterator<Edge> edges(Direction direction, String ... edgeLabels) {
            if (direction.equals((Object)Direction.OUT)) {
                return null == this.outEdges ? Collections.emptyIterator() : (edgeLabels.length == 0 ? IteratorUtils.flatMap(this.outEdges.values().iterator(), List::iterator) : this.outEdges.entrySet().stream().filter(entry -> ElementHelper.keyExists((String)entry.getKey(), edgeLabels)).map(Map.Entry::getValue).flatMap(Collection::stream).iterator());
            }
            if (direction.equals((Object)Direction.IN)) {
                return null == this.inEdges ? Collections.emptyIterator() : (edgeLabels.length == 0 ? IteratorUtils.flatMap(this.inEdges.values().iterator(), List::iterator) : this.inEdges.entrySet().stream().filter(entry -> ElementHelper.keyExists((String)entry.getKey(), edgeLabels)).map(Map.Entry::getValue).flatMap(Collection::stream).iterator());
            }
            return IteratorUtils.concat(this.edges(Direction.IN, edgeLabels), this.edges(Direction.OUT, edgeLabels));
        }

        @Override
        public Iterator<Vertex> vertices(Direction direction, String ... edgeLabels) {
            if (direction.equals((Object)Direction.OUT)) {
                return IteratorUtils.map(this.edges(direction, edgeLabels), Edge::inVertex);
            }
            if (direction.equals((Object)Direction.IN)) {
                return IteratorUtils.map(this.edges(direction, edgeLabels), Edge::outVertex);
            }
            return IteratorUtils.concat(this.vertices(Direction.IN, edgeLabels), this.vertices(Direction.OUT, edgeLabels));
        }

        @Override
        public void remove() {
            throw new IllegalStateException("The star vertex can not be removed from the StarGraph: " + this);
        }

        public String toString() {
            return StringFactory.vertexString(this);
        }

        @Override
        public <V> Iterator<VertexProperty<V>> properties(String ... propertyKeys) {
            if (null == this.vertexProperties || this.vertexProperties.isEmpty()) {
                return Collections.emptyIterator();
            }
            if (propertyKeys.length == 0) {
                return this.vertexProperties.entrySet().stream().flatMap(entry -> ((List)entry.getValue()).stream()).iterator();
            }
            if (propertyKeys.length == 1) {
                return this.vertexProperties.getOrDefault(propertyKeys[0], Collections.emptyList()).iterator();
            }
            return this.vertexProperties.entrySet().stream().filter(entry -> ElementHelper.keyExists((String)entry.getKey(), propertyKeys)).flatMap(entry -> ((List)entry.getValue()).stream()).iterator();
        }

        public Optional<StarVertex> applyGraphFilter(GraphFilter graphFilter) {
            if (!graphFilter.hasFilter()) {
                return Optional.of(this);
            }
            if (graphFilter.legalVertex(this)) {
                if (graphFilter.hasEdgeFilter()) {
                    if (graphFilter.checkEdgeLegality(Direction.OUT).negative()) {
                        this.dropEdges(Direction.OUT);
                    }
                    if (graphFilter.checkEdgeLegality(Direction.IN).negative()) {
                        this.dropEdges(Direction.IN);
                    }
                    if (null != this.outEdges) {
                        for (String key : new HashSet<String>(this.outEdges.keySet())) {
                            if (!graphFilter.checkEdgeLegality(Direction.OUT, key).negative()) continue;
                            this.dropEdges(Direction.OUT, key);
                        }
                    }
                    if (null != this.inEdges) {
                        for (String key : new HashSet<String>(this.inEdges.keySet())) {
                            if (!graphFilter.checkEdgeLegality(Direction.IN, key).negative()) continue;
                            this.dropEdges(Direction.IN, key);
                        }
                    }
                    if (null != this.inEdges || null != this.outEdges) {
                        HashMap<String, List<Edge>> outEdges = new HashMap<String, List<Edge>>();
                        HashMap<String, List<Edge>> inEdges = new HashMap<String, List<Edge>>();
                        graphFilter.legalEdges(this).forEachRemaining(edge -> {
                            if (edge instanceof StarOutEdge) {
                                ArrayList<Edge> edges = (ArrayList<Edge>)outEdges.get(edge.label());
                                if (null == edges) {
                                    edges = new ArrayList<Edge>();
                                    outEdges.put(edge.label(), edges);
                                }
                                edges.add((Edge)edge);
                            } else {
                                ArrayList<Edge> edges = (ArrayList<Edge>)inEdges.get(edge.label());
                                if (null == edges) {
                                    edges = new ArrayList<Edge>();
                                    inEdges.put(edge.label(), edges);
                                }
                                edges.add((Edge)edge);
                            }
                        });
                        if (outEdges.isEmpty()) {
                            this.dropEdges(Direction.OUT);
                        } else {
                            this.outEdges = outEdges;
                        }
                        if (inEdges.isEmpty()) {
                            this.dropEdges(Direction.IN);
                        } else {
                            this.inEdges = inEdges;
                        }
                    }
                }
                return Optional.of(this);
            }
            return Optional.empty();
        }
    }

    public abstract class StarElement<E extends Element>
    implements Element,
    Attachable<E> {
        protected final Object id;
        protected final String label;

        protected StarElement(Object id, String label) {
            this.id = id;
            this.label = StarGraph.this.internStrings ? label.intern() : label;
        }

        @Override
        public Object id() {
            return this.id;
        }

        @Override
        public String label() {
            return this.label;
        }

        @Override
        public Graph graph() {
            return StarGraph.this;
        }

        public boolean equals(Object other) {
            return ElementHelper.areEqual(this, other);
        }

        public int hashCode() {
            return ElementHelper.hashCode(this);
        }

        @Override
        public E get() {
            return (E)this;
        }
    }

    public static class Builder {
        private boolean internStrings = true;
        private boolean compareIdsUsingStrings = true;

        private Builder() {
        }

        public Builder internStrings(boolean b) {
            this.internStrings = b;
            return this;
        }

        public Builder compareIdsUsingStrings(boolean b) {
            this.compareIdsUsingStrings = b;
            return this;
        }

        @Deprecated
        public StarGraph build() {
            return this.create();
        }

        public StarGraph create() {
            return new StarGraph(this.internStrings, this.compareIdsUsingStrings);
        }
    }
}

