/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.tinkergraph.process.traversal.step.sideEffect;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.tinkerpop.gremlin.process.traversal.Compare;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.step.HasContainerHolder;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.GraphStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.HasContainer;
import org.apache.tinkerpop.gremlin.process.traversal.util.AndP;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.util.CloseableIterator;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerGraph;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerGraphIterator;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerHelper;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;

public final class TinkerGraphStep<S, E extends Element>
extends GraphStep<S, E>
implements HasContainerHolder,
AutoCloseable {
    private final List<HasContainer> hasContainers = new ArrayList<HasContainer>();
    private final List<Iterator> iterators = new ArrayList<Iterator>();

    public TinkerGraphStep(GraphStep<S, E> originalGraphStep) {
        super(originalGraphStep.getTraversal(), originalGraphStep.getReturnClass(), originalGraphStep.isStartStep(), originalGraphStep.getIds());
        originalGraphStep.getLabels().forEach(this::addLabel);
        this.setIteratorSupplier(() -> Vertex.class.isAssignableFrom(this.returnClass) ? this.vertices() : this.edges());
    }

    private Iterator<? extends Edge> edges() {
        TinkerGraph graph = (TinkerGraph)this.getTraversal().getGraph().get();
        HasContainer indexedContainer = this.getIndexKey(Edge.class);
        Iterator<Object> iterator = null == this.ids ? Collections.emptyIterator() : (this.ids.length > 0 ? this.iteratorList(graph.edges(this.ids)) : (null == indexedContainer ? this.iteratorList(graph.edges(new Object[0])) : TinkerHelper.queryEdgeIndex(graph, indexedContainer.getKey(), indexedContainer.getPredicate().getValue()).stream().filter(edge -> HasContainer.testAll((Object)edge, this.hasContainers)).collect(Collectors.toList()).iterator()));
        this.iterators.add(iterator);
        return iterator;
    }

    private Iterator<? extends Vertex> vertices() {
        TinkerGraph graph = (TinkerGraph)this.getTraversal().getGraph().get();
        HasContainer indexedContainer = this.getIndexKey(Vertex.class);
        Iterator<Object> iterator = null == this.ids ? Collections.emptyIterator() : (this.ids.length > 0 ? this.iteratorList(graph.vertices(this.ids)) : (null == indexedContainer ? this.iteratorList(graph.vertices(new Object[0])) : IteratorUtils.filter(TinkerHelper.queryVertexIndex(graph, indexedContainer.getKey(), indexedContainer.getPredicate().getValue()).iterator(), vertex -> HasContainer.testAll((Object)vertex, this.hasContainers))));
        this.iterators.add(iterator);
        return iterator;
    }

    private HasContainer getIndexKey(Class<? extends Element> indexedClass) {
        Set<String> indexedKeys = ((TinkerGraph)this.getTraversal().getGraph().get()).getIndexedKeys(indexedClass);
        Iterator<HasContainer> itty = IteratorUtils.filter(this.hasContainers.iterator(), c -> c.getPredicate().getBiPredicate() == Compare.eq && indexedKeys.contains(c.getKey()));
        return itty.hasNext() ? itty.next() : null;
    }

    @Override
    public String toString() {
        if (this.hasContainers.isEmpty()) {
            return super.toString();
        }
        return null == this.ids || 0 == this.ids.length ? StringFactory.stepString(this, this.returnClass.getSimpleName().toLowerCase(), this.hasContainers) : StringFactory.stepString(this, this.returnClass.getSimpleName().toLowerCase(), Arrays.toString(this.ids), this.hasContainers);
    }

    private <E extends Element> Iterator<E> iteratorList(Iterator<E> iterator) {
        ArrayList<Element> list = new ArrayList<Element>();
        while (iterator.hasNext()) {
            Element e = (Element)iterator.next();
            if (!HasContainer.testAll((Object)e, this.hasContainers)) continue;
            list.add(e);
        }
        CloseableIterator.closeIterator(iterator);
        return new TinkerGraphIterator(list.iterator());
    }

    @Override
    public List<HasContainer> getHasContainers() {
        return Collections.unmodifiableList(this.hasContainers);
    }

    @Override
    public void addHasContainer(HasContainer hasContainer) {
        if (hasContainer.getPredicate() instanceof AndP) {
            for (P predicate : ((AndP)hasContainer.getPredicate()).getPredicates()) {
                this.addHasContainer(new HasContainer(hasContainer.getKey(), predicate));
            }
        } else {
            this.hasContainers.add(hasContainer);
        }
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.hasContainers.hashCode();
    }

    @Override
    public void close() {
        this.iterators.forEach(CloseableIterator::closeIterator);
    }
}

