/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.core.attribute;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.text.similarity.LevenshteinDistance;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.janusgraph.graphdb.query.JanusGraphPredicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum Text implements JanusGraphPredicate
{
    CONTAINS{

        @Override
        public boolean test(Object value, Object condition) {
            this.preevaluate(value, condition);
            return value != null && this.evaluateRaw(value.toString(), (String)condition);
        }

        @Override
        public boolean evaluateRaw(String value, String terms) {
            HashSet tokens = Sets.newHashSet(1.tokenize(value.toLowerCase()));
            terms = terms.trim();
            List<String> tokenTerms = 1.tokenize(terms.toLowerCase());
            if (!terms.isEmpty() && tokenTerms.isEmpty()) {
                return false;
            }
            for (String term : tokenTerms) {
                if (tokens.contains(term)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean isValidCondition(Object condition) {
            return condition instanceof String && StringUtils.isNotBlank((String)condition);
        }

        public String toString() {
            return "textContains";
        }
    }
    ,
    CONTAINS_PREFIX{

        @Override
        public boolean test(Object value, Object condition) {
            this.preevaluate(value, condition);
            return value != null && this.evaluateRaw(value.toString(), (String)condition);
        }

        @Override
        public boolean evaluateRaw(String value, String prefix) {
            for (String token : 2.tokenize(value.toLowerCase())) {
                if (!PREFIX.evaluateRaw(token, prefix.toLowerCase())) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isValidCondition(Object condition) {
            return condition instanceof String;
        }

        public String toString() {
            return "textContainsPrefix";
        }
    }
    ,
    CONTAINS_REGEX{

        @Override
        public boolean test(Object value, Object condition) {
            this.preevaluate(value, condition);
            return value != null && this.evaluateRaw(value.toString(), (String)condition);
        }

        @Override
        public boolean evaluateRaw(String value, String regex) {
            for (String token : 3.tokenize(value.toLowerCase())) {
                if (!REGEX.evaluateRaw(token, regex)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isValidCondition(Object condition) {
            return condition instanceof String && StringUtils.isNotBlank(condition.toString());
        }

        public String toString() {
            return "textContainsRegex";
        }
    }
    ,
    PREFIX{

        @Override
        public boolean test(Object value, Object condition) {
            this.preevaluate(value, condition);
            return value != null && this.evaluateRaw(value.toString(), (String)condition);
        }

        @Override
        public boolean evaluateRaw(String value, String prefix) {
            return value.startsWith(prefix.trim());
        }

        @Override
        public boolean isValidCondition(Object condition) {
            return condition instanceof String;
        }

        public String toString() {
            return "textPrefix";
        }
    }
    ,
    REGEX{

        @Override
        public boolean test(Object value, Object condition) {
            this.preevaluate(value, condition);
            return value != null && this.evaluateRaw(value.toString(), (String)condition);
        }

        @Override
        public boolean evaluateRaw(String value, String regex) {
            return value.matches(regex);
        }

        @Override
        public boolean isValidCondition(Object condition) {
            return condition instanceof String && StringUtils.isNotBlank(condition.toString());
        }

        public String toString() {
            return "textRegex";
        }
    }
    ,
    FUZZY{

        @Override
        public boolean test(Object value, Object condition) {
            this.preevaluate(value, condition);
            return value != null && this.evaluateRaw(value.toString(), (String)condition);
        }

        @Override
        public boolean evaluateRaw(String value, String term) {
            return Text.isFuzzy(term.trim(), value.trim());
        }

        @Override
        public boolean isValidCondition(Object condition) {
            return condition instanceof String && StringUtils.isNotBlank(condition.toString());
        }

        public String toString() {
            return "textFuzzy";
        }
    }
    ,
    CONTAINS_FUZZY{

        @Override
        public boolean test(Object value, Object condition) {
            this.preevaluate(value, condition);
            return value != null && this.evaluateRaw(value.toString(), (String)condition);
        }

        @Override
        public boolean evaluateRaw(String value, String term) {
            for (String token : 7.tokenize(value.toLowerCase())) {
                if (!Text.isFuzzy(term.toLowerCase(), token)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isValidCondition(Object condition) {
            return condition instanceof String && StringUtils.isNotBlank(condition.toString());
        }

        public String toString() {
            return "textContainsFuzzy";
        }
    };

    private static final Logger log;
    private static final int MIN_TOKEN_LENGTH = 1;
    public static final Set<Text> HAS_CONTAINS;

    private static boolean isFuzzy(String term, String value) {
        int distance = (term = term.trim()).length() < 3 ? 0 : (term.length() < 6 ? 1 : 2);
        return LevenshteinDistance.getDefaultInstance().apply(value, term) <= distance;
    }

    public void preevaluate(Object value, Object condition) {
        Preconditions.checkArgument((boolean)this.isValidCondition(condition), (String)"Invalid condition provided: %s", (Object[])new Object[]{condition});
        if (!(value instanceof String)) {
            log.debug("Value not a string: " + value);
        }
    }

    abstract boolean evaluateRaw(String var1, String var2);

    public static List<String> tokenize(String str) {
        ArrayList<String> tokens = new ArrayList<String>();
        int previous = 0;
        for (int p = 0; p < str.length(); ++p) {
            if (Character.isLetterOrDigit(str.charAt(p))) continue;
            if (p > previous + 1) {
                tokens.add(str.substring(previous, p));
            }
            previous = p + 1;
        }
        if (previous + 1 < str.length()) {
            tokens.add(str.substring(previous));
        }
        return tokens;
    }

    @Override
    public boolean isValidValueType(Class<?> clazz) {
        Preconditions.checkNotNull(clazz);
        return clazz.equals(String.class);
    }

    @Override
    public boolean hasNegation() {
        return false;
    }

    @Override
    public JanusGraphPredicate negate() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isQNF() {
        return true;
    }

    public static <V> P<V> textContains(V value) {
        return new P<Object>(CONTAINS, value);
    }

    public static <V> P<V> textContainsPrefix(V value) {
        return new P<Object>(CONTAINS_PREFIX, value);
    }

    public static <V> P<V> textContainsRegex(V value) {
        return new P<Object>(CONTAINS_REGEX, value);
    }

    public static <V> P<V> textPrefix(V value) {
        return new P<Object>(PREFIX, value);
    }

    public static <V> P<V> textRegex(V value) {
        return new P<Object>(REGEX, value);
    }

    public static <V> P<V> textContainsFuzzy(V value) {
        return new P<Object>(CONTAINS_FUZZY, value);
    }

    public static <V> P<V> textFuzzy(V value) {
        return new P<Object>(FUZZY, value);
    }

    static {
        log = LoggerFactory.getLogger(Text.class);
        HAS_CONTAINS = Collections.unmodifiableSet(EnumSet.of(CONTAINS, CONTAINS_PREFIX, CONTAINS_REGEX, CONTAINS_FUZZY));
    }
}

