/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.util;

import java.io.File;
import org.janusgraph.diskstorage.BackendException;
import org.janusgraph.diskstorage.PermanentBackendException;

public class DirectoryUtil {
    public static File getOrCreateDataDirectory(String location) throws BackendException {
        return DirectoryUtil.getOrCreateDataDirectory(location, null);
    }

    public static File getOrCreateDataDirectory(String location, String childLocation) throws BackendException {
        File storageDir = null != childLocation ? new File(location, childLocation) : new File(location);
        if (storageDir.exists() && storageDir.isFile()) {
            throw new PermanentBackendException(String.format("%s exists but is a file.", location));
        }
        if (!storageDir.exists() && !storageDir.mkdirs()) {
            throw new PermanentBackendException(String.format("Failed to create directory %s for local storage.", location));
        }
        return storageDir;
    }
}

