/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.database;

import com.carrotsearch.hppc.LongArrayList;
import com.carrotsearch.hppc.LongHashSet;
import com.carrotsearch.hppc.LongObjectHashMap;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Map;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.janusgraph.core.Cardinality;
import org.janusgraph.core.JanusGraphVertexProperty;
import org.janusgraph.core.Multiplicity;
import org.janusgraph.core.PropertyKey;
import org.janusgraph.core.RelationType;
import org.janusgraph.diskstorage.Entry;
import org.janusgraph.diskstorage.EntryMetaData;
import org.janusgraph.diskstorage.ReadBuffer;
import org.janusgraph.diskstorage.StaticBuffer;
import org.janusgraph.diskstorage.keycolumnvalue.SliceQuery;
import org.janusgraph.diskstorage.util.BufferUtil;
import org.janusgraph.diskstorage.util.StaticArrayEntry;
import org.janusgraph.graphdb.database.RelationReader;
import org.janusgraph.graphdb.database.idhandling.IDHandler;
import org.janusgraph.graphdb.database.idhandling.VariableLong;
import org.janusgraph.graphdb.database.serialize.DataOutput;
import org.janusgraph.graphdb.database.serialize.InternalAttributeUtil;
import org.janusgraph.graphdb.database.serialize.Serializer;
import org.janusgraph.graphdb.internal.InternalRelation;
import org.janusgraph.graphdb.internal.InternalRelationType;
import org.janusgraph.graphdb.internal.Order;
import org.janusgraph.graphdb.internal.RelationCategory;
import org.janusgraph.graphdb.relations.EdgeDirection;
import org.janusgraph.graphdb.relations.RelationCache;
import org.janusgraph.graphdb.types.TypeInspector;
import org.janusgraph.graphdb.types.system.ImplicitKey;
import org.janusgraph.util.datastructures.Interval;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EdgeSerializer
implements RelationReader {
    private static final Logger logger = LoggerFactory.getLogger(EdgeSerializer.class);
    private static final int DEFAULT_COLUMN_CAPACITY = 60;
    private static final int DEFAULT_CAPACITY = 128;
    private final Serializer serializer;

    public EdgeSerializer(Serializer serializer) {
        this.serializer = serializer;
    }

    public RelationCache readRelation(Entry data, boolean parseHeaderOnly, TypeInspector tx) {
        RelationCache map = data.getCache();
        if (map == null || !parseHeaderOnly && !map.hasProperties()) {
            map = this.parseRelation(data, parseHeaderOnly, tx);
            data.setCache(map);
        }
        return map;
    }

    public Direction parseDirection(Entry data) {
        RelationCache map = data.getCache();
        if (map != null) {
            return map.direction;
        }
        return IDHandler.readRelationType((ReadBuffer)data.asReadBuffer()).dirID.getDirection();
    }

    @Override
    public RelationCache parseRelation(Entry data, boolean excludeProperties, TypeInspector tx) {
        Object other;
        long relationId;
        ReadBuffer in = data.asReadBuffer();
        IDHandler.RelationTypeParse typeAndDir = IDHandler.readRelationType(in);
        long typeId = typeAndDir.typeId;
        Direction dir = typeAndDir.dirID.getDirection();
        RelationType relationType = tx.getExistingRelationType(typeId);
        InternalRelationType def = (InternalRelationType)relationType;
        Multiplicity multiplicity = def.multiplicity();
        long[] keySignature = def.getSortKey();
        int startKeyPos = in.getPosition();
        int endKeyPos = 0;
        if (relationType.isEdgeLabel()) {
            long otherVertexId;
            if (multiplicity.isConstrained()) {
                if (multiplicity.isUnique(dir)) {
                    otherVertexId = VariableLong.readPositive(in);
                } else {
                    in.movePositionTo(data.getValuePosition());
                    otherVertexId = VariableLong.readPositiveBackward(in);
                    in.movePositionTo(data.getValuePosition());
                }
                relationId = VariableLong.readPositive(in);
            } else {
                in.movePositionTo(data.getValuePosition());
                relationId = VariableLong.readPositiveBackward(in);
                otherVertexId = VariableLong.readPositiveBackward(in);
                endKeyPos = in.getPosition();
                in.movePositionTo(data.getValuePosition());
            }
            other = otherVertexId;
        } else {
            assert (relationType.isPropertyKey());
            PropertyKey key = (PropertyKey)relationType;
            if (multiplicity.isConstrained()) {
                other = this.readPropertyValue(in, key);
                relationId = VariableLong.readPositive(in);
            } else {
                in.movePositionTo(data.getValuePosition());
                relationId = VariableLong.readPositiveBackward(in);
                endKeyPos = in.getPosition();
                in.movePositionTo(data.getValuePosition());
                other = this.readPropertyValue(in, key);
            }
            Preconditions.checkNotNull((Object)other, (Object)"Encountered error in deserializer [null value returned]. Check serializer compatibility.");
        }
        if (!excludeProperties) {
            LongObjectHashMap<Object> properties = new LongObjectHashMap<Object>(4);
            if (!multiplicity.isConstrained() && keySignature.length > 0) {
                int currentPos = in.getPosition();
                assert (endKeyPos > startKeyPos);
                int keyLength = endKeyPos - startKeyPos;
                in.movePositionTo(startKeyPos);
                ReadBuffer inKey = in;
                if (def.getSortOrder() == Order.DESC) {
                    inKey = in.subrange(keyLength, true);
                }
                this.readInlineTypes(keySignature, properties, inKey, tx, InlineType.KEY);
                in.movePositionTo(currentPos);
            }
            this.readInlineTypes(def.getSignature(), properties, in, tx, InlineType.SIGNATURE);
            while (in.hasRemaining()) {
                PropertyKey type = tx.getExistingPropertyKey(IDHandler.readInlineRelationType(in));
                Object propertyValue = this.readInline(in, type, InlineType.NORMAL);
                assert (propertyValue != null);
                properties.put(type.longId(), propertyValue);
            }
            if (data.hasMetaData()) {
                for (Map.Entry<EntryMetaData, Object> metas : data.getMetaData().entrySet()) {
                    ImplicitKey key = ImplicitKey.MetaData2ImplicitKey.get((Object)metas.getKey());
                    if (key == null) continue;
                    assert (metas.getValue() != null);
                    properties.put(key.longId(), metas.getValue());
                }
            }
            return new RelationCache(dir, typeId, relationId, other, properties);
        }
        return new RelationCache(dir, typeId, relationId, other);
    }

    private void readInlineTypes(long[] keyIds, LongObjectHashMap<Object> properties, ReadBuffer in, TypeInspector tx, InlineType inlineType) {
        for (long keyId : keyIds) {
            PropertyKey keyType = tx.getExistingPropertyKey(keyId);
            Object value = this.readInline(in, keyType, inlineType);
            if (value == null) continue;
            properties.put(keyId, value);
        }
    }

    private Object readInline(ReadBuffer read, PropertyKey key, InlineType inlineType) {
        return this.readPropertyValue(read, key, inlineType);
    }

    private Object readPropertyValue(ReadBuffer read, PropertyKey key) {
        return this.readPropertyValue(read, key, InlineType.NORMAL);
    }

    private Object readPropertyValue(ReadBuffer read, PropertyKey key, InlineType inlineType) {
        if (InternalAttributeUtil.hasGenericDataType(key)) {
            return this.serializer.readClassAndObject(read);
        }
        if (inlineType.writeByteOrdered()) {
            return this.serializer.readObjectByteOrder(read, key.dataType());
        }
        return this.serializer.readObject(read, key.dataType());
    }

    private static IDHandler.DirectionID getDirID(Direction dir, RelationCategory rt) {
        switch (rt) {
            case PROPERTY: {
                assert (dir == Direction.OUT);
                return IDHandler.DirectionID.PROPERTY_DIR;
            }
            case EDGE: {
                switch (dir) {
                    case OUT: {
                        return IDHandler.DirectionID.EDGE_OUT_DIR;
                    }
                    case IN: {
                        return IDHandler.DirectionID.EDGE_IN_DIR;
                    }
                }
                throw new IllegalArgumentException("Invalid direction: " + (Object)((Object)dir));
            }
        }
        throw new IllegalArgumentException("Invalid relation type: " + rt);
    }

    public Entry writeRelation(InternalRelation relation, int position, TypeInspector tx) {
        return this.writeRelation(relation, (InternalRelationType)relation.getType(), position, tx);
    }

    public StaticArrayEntry writeRelation(InternalRelation relation, InternalRelationType type, int position, TypeInspector tx) {
        int valuePosition;
        assert (type == relation.getType() || type.getBaseType() != null && type.getBaseType().equals(relation.getType()));
        Direction dir = EdgeDirection.fromPosition(position);
        Preconditions.checkArgument((type.isUnidirected(Direction.BOTH) || type.isUnidirected(dir) ? 1 : 0) != 0);
        long typeId = type.longId();
        IDHandler.DirectionID dirID = EdgeSerializer.getDirID(dir, relation.isProperty() ? RelationCategory.PROPERTY : RelationCategory.EDGE);
        DataOutput out = this.serializer.getDataOutput(128);
        IDHandler.writeRelationType(out, typeId, dirID, type.isInvisibleType());
        Multiplicity multiplicity = type.multiplicity();
        long[] sortKey = type.getSortKey();
        assert (!multiplicity.isConstrained() || sortKey.length == 0) : type.name();
        int keyStartPos = out.getPosition();
        if (!multiplicity.isConstrained()) {
            this.writeInlineTypes(sortKey, relation, out, tx, InlineType.KEY);
        }
        int keyEndPos = out.getPosition();
        long relationId = relation.longId();
        if (relation.isEdge()) {
            long otherVertexId = relation.getVertex((position + 1) % 2).longId();
            if (multiplicity.isConstrained()) {
                if (multiplicity.isUnique(dir)) {
                    valuePosition = out.getPosition();
                    VariableLong.writePositive(out, otherVertexId);
                } else {
                    VariableLong.writePositiveBackward(out, otherVertexId);
                    valuePosition = out.getPosition();
                }
                VariableLong.writePositive(out, relationId);
            } else {
                VariableLong.writePositiveBackward(out, otherVertexId);
                VariableLong.writePositiveBackward(out, relationId);
                valuePosition = out.getPosition();
            }
        } else {
            assert (relation.isProperty());
            Preconditions.checkArgument((boolean)relation.isProperty());
            Object value = ((JanusGraphVertexProperty)((Object)relation)).value();
            Preconditions.checkNotNull(value);
            PropertyKey key = (PropertyKey)((Object)type);
            assert (key.dataType().isInstance(value));
            if (multiplicity.isConstrained()) {
                if (multiplicity.isUnique(dir)) {
                    valuePosition = out.getPosition();
                    this.writePropertyValue(out, key, value);
                } else {
                    this.writePropertyValue(out, key, value);
                    valuePosition = out.getPosition();
                }
                VariableLong.writePositive(out, relationId);
            } else {
                assert (multiplicity.getCardinality() == Cardinality.LIST);
                VariableLong.writePositiveBackward(out, relationId);
                valuePosition = out.getPosition();
                this.writePropertyValue(out, key, value);
            }
        }
        long[] signature = type.getSignature();
        this.writeInlineTypes(signature, relation, out, tx, InlineType.SIGNATURE);
        LongHashSet writtenTypes = new LongHashSet(sortKey.length + signature.length);
        if (sortKey.length > 0 || signature.length > 0) {
            for (long id : sortKey) {
                writtenTypes.add(id);
            }
            for (long id : signature) {
                writtenTypes.add(id);
            }
        }
        LongArrayList remainingTypes = new LongArrayList(8);
        for (PropertyKey t : relation.getPropertyKeysDirect()) {
            if (t instanceof ImplicitKey || writtenTypes.contains(t.longId())) continue;
            remainingTypes.add(t.longId());
        }
        long[] remaining = remainingTypes.toArray();
        Arrays.sort(remaining);
        for (long tid : remaining) {
            PropertyKey t = tx.getExistingPropertyKey(tid);
            this.writeInline(out, t, relation.getValueDirect(t), InlineType.NORMAL);
        }
        assert (valuePosition > 0);
        return new StaticArrayEntry(type.getSortOrder() == Order.DESC ? out.getStaticBufferFlipBytes(keyStartPos, keyEndPos) : out.getStaticBuffer(), valuePosition);
    }

    private void writeInlineTypes(long[] keyIds, InternalRelation relation, DataOutput out, TypeInspector tx, InlineType inlineType) {
        for (long keyId : keyIds) {
            PropertyKey t = tx.getExistingPropertyKey(keyId);
            this.writeInline(out, t, relation.getValueDirect(t), inlineType);
        }
    }

    private void writeInline(DataOutput out, PropertyKey inlineKey, Object value, InlineType inlineType) {
        assert (inlineType.writeInlineKey() || !InternalAttributeUtil.hasGenericDataType(inlineKey));
        if (inlineType.writeInlineKey()) {
            IDHandler.writeInlineRelationType(out, inlineKey.longId());
        }
        this.writePropertyValue(out, inlineKey, value, inlineType);
    }

    private void writePropertyValue(DataOutput out, PropertyKey key, Object value) {
        this.writePropertyValue(out, key, value, InlineType.NORMAL);
    }

    private void writePropertyValue(DataOutput out, PropertyKey key, Object value, InlineType inlineType) {
        if (InternalAttributeUtil.hasGenericDataType(key)) {
            assert (!inlineType.writeByteOrdered());
            out.writeClassAndObject(value);
        } else {
            assert (value == null || value.getClass().equals(key.dataType()));
            if (inlineType.writeByteOrdered()) {
                out.writeObjectByteOrder(value, key.dataType());
            } else {
                out.writeObject(value, key.dataType());
            }
        }
    }

    public SliceQuery getQuery(RelationCategory resultType, boolean querySystemTypes) {
        Preconditions.checkNotNull((Object)resultType);
        StaticBuffer[] bound = IDHandler.getBounds(resultType, querySystemTypes);
        return new SliceQuery(bound[0], bound[1]);
    }

    public SliceQuery getQuery(InternalRelationType type, Direction dir, TypedInterval[] sortKey) {
        RelationCategory rt;
        Preconditions.checkNotNull((Object)type);
        Preconditions.checkNotNull((Object)((Object)dir));
        Preconditions.checkArgument((type.isUnidirected(Direction.BOTH) || type.isUnidirected(dir) ? 1 : 0) != 0);
        StaticBuffer sliceStart = null;
        StaticBuffer sliceEnd = null;
        RelationCategory relationCategory = rt = type.isPropertyKey() ? RelationCategory.PROPERTY : RelationCategory.EDGE;
        if (dir == Direction.BOTH) {
            assert (type.isEdgeLabel());
            sliceStart = IDHandler.getRelationType(type.longId(), EdgeSerializer.getDirID(Direction.OUT, rt), type.isInvisibleType());
            sliceEnd = IDHandler.getRelationType(type.longId(), EdgeSerializer.getDirID(Direction.IN, rt), type.isInvisibleType());
            assert (sliceStart.compareTo(sliceEnd) < 0);
            sliceEnd = BufferUtil.nextBiggerBuffer(sliceEnd);
        } else {
            IDHandler.DirectionID dirID = EdgeSerializer.getDirID(dir, rt);
            DataOutput colStart = this.serializer.getDataOutput(60);
            DataOutput colEnd = this.serializer.getDataOutput(60);
            IDHandler.writeRelationType(colStart, type.longId(), dirID, type.isInvisibleType());
            IDHandler.writeRelationType(colEnd, type.longId(), dirID, type.isInvisibleType());
            long[] sortKeyIDs = type.getSortKey();
            Preconditions.checkArgument((sortKey.length >= sortKeyIDs.length ? 1 : 0) != 0);
            assert (colStart.getPosition() == colEnd.getPosition());
            int keyStartPos = colStart.getPosition();
            int keyEndPos = -1;
            for (int i = 0; i < sortKey.length && sortKey[i] != null; ++i) {
                PropertyKey propertyKey = sortKey[i].key;
                Interval interval = sortKey[i].interval;
                if (i >= sortKeyIDs.length) {
                    assert (!type.multiplicity().isUnique(dir));
                    assert (propertyKey == ImplicitKey.JANUSGRAPHID || propertyKey == ImplicitKey.ADJACENT_ID);
                    assert (propertyKey != ImplicitKey.ADJACENT_ID || i == sortKeyIDs.length);
                    assert (propertyKey != ImplicitKey.JANUSGRAPHID || !type.multiplicity().isConstrained() && (i == sortKeyIDs.length && propertyKey.isPropertyKey() || i == sortKeyIDs.length + 1 && propertyKey.isEdgeLabel()));
                    assert (colStart.getPosition() == colEnd.getPosition());
                    assert (interval == null || interval.isPoints());
                    keyEndPos = colStart.getPosition();
                } else {
                    assert (!type.multiplicity().isConstrained());
                    assert (propertyKey.longId() == sortKeyIDs[i]);
                }
                if (interval == null || interval.isEmpty()) break;
                if (interval.isPoints()) {
                    if (propertyKey == ImplicitKey.JANUSGRAPHID || propertyKey == ImplicitKey.ADJACENT_ID) {
                        assert (!type.multiplicity().isUnique(dir));
                        VariableLong.writePositiveBackward(colStart, (Long)interval.getStart());
                        VariableLong.writePositiveBackward(colEnd, (Long)interval.getEnd());
                        continue;
                    }
                    this.writeInline(colStart, propertyKey, interval.getStart(), InlineType.KEY);
                    this.writeInline(colEnd, propertyKey, interval.getEnd(), InlineType.KEY);
                    continue;
                }
                if (interval.getStart() != null) {
                    this.writeInline(colStart, propertyKey, interval.getStart(), InlineType.KEY);
                }
                if (interval.getEnd() != null) {
                    this.writeInline(colEnd, propertyKey, interval.getEnd(), InlineType.KEY);
                }
                switch (type.getSortOrder()) {
                    case ASC: {
                        sliceStart = colStart.getStaticBuffer();
                        sliceEnd = colEnd.getStaticBuffer();
                        if (!interval.startInclusive()) {
                            sliceStart = BufferUtil.nextBiggerBuffer(sliceStart);
                        }
                        if (!interval.endInclusive()) break;
                        sliceEnd = BufferUtil.nextBiggerBuffer(sliceEnd);
                        break;
                    }
                    case DESC: {
                        sliceEnd = colStart.getStaticBufferFlipBytes(keyStartPos, colStart.getPosition());
                        sliceStart = colEnd.getStaticBufferFlipBytes(keyStartPos, colEnd.getPosition());
                        if (interval.startInclusive()) {
                            sliceEnd = BufferUtil.nextBiggerBuffer(sliceEnd);
                        }
                        if (interval.endInclusive()) break;
                        sliceStart = BufferUtil.nextBiggerBuffer(sliceStart);
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)type.getSortOrder().toString());
                    }
                }
                assert (sliceStart.compareTo(sliceEnd) <= 0);
                break;
            }
            if (sliceStart == null) {
                assert (sliceEnd == null && colStart.getPosition() == colEnd.getPosition());
                if (keyEndPos < 0) {
                    keyEndPos = colStart.getPosition();
                }
                switch (type.getSortOrder()) {
                    case ASC: {
                        sliceStart = colStart.getStaticBuffer();
                        break;
                    }
                    case DESC: {
                        sliceStart = colStart.getStaticBufferFlipBytes(keyStartPos, keyEndPos);
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)type.getSortOrder().toString());
                    }
                }
                sliceEnd = BufferUtil.nextBiggerBuffer(sliceStart);
            }
        }
        return new SliceQuery(sliceStart, sliceEnd);
    }

    public static class TypedInterval {
        public final PropertyKey key;
        public final Interval interval;

        public TypedInterval(PropertyKey key, Interval interval) {
            this.key = key;
            this.interval = interval;
        }
    }

    private static enum InlineType {
        KEY,
        SIGNATURE,
        NORMAL;


        public boolean writeInlineKey() {
            return this == NORMAL;
        }

        public boolean writeByteOrdered() {
            return this == KEY;
        }
    }
}

