/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.database;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.janusgraph.core.Cardinality;
import org.janusgraph.core.JanusGraphElement;
import org.janusgraph.core.JanusGraphRelation;
import org.janusgraph.core.JanusGraphVertex;
import org.janusgraph.core.JanusGraphVertexProperty;
import org.janusgraph.core.PropertyKey;
import org.janusgraph.core.RelationType;
import org.janusgraph.core.schema.Parameter;
import org.janusgraph.core.schema.SchemaStatus;
import org.janusgraph.diskstorage.BackendException;
import org.janusgraph.diskstorage.BackendTransaction;
import org.janusgraph.diskstorage.Entry;
import org.janusgraph.diskstorage.EntryList;
import org.janusgraph.diskstorage.EntryMetaData;
import org.janusgraph.diskstorage.MetaAnnotatable;
import org.janusgraph.diskstorage.ReadBuffer;
import org.janusgraph.diskstorage.StaticBuffer;
import org.janusgraph.diskstorage.configuration.Configuration;
import org.janusgraph.diskstorage.indexing.IndexEntry;
import org.janusgraph.diskstorage.indexing.IndexFeatures;
import org.janusgraph.diskstorage.indexing.IndexInformation;
import org.janusgraph.diskstorage.indexing.IndexProvider;
import org.janusgraph.diskstorage.indexing.IndexQuery;
import org.janusgraph.diskstorage.indexing.KeyInformation;
import org.janusgraph.diskstorage.indexing.RawQuery;
import org.janusgraph.diskstorage.indexing.StandardKeyInformation;
import org.janusgraph.diskstorage.keycolumnvalue.KeySliceQuery;
import org.janusgraph.diskstorage.util.BufferUtil;
import org.janusgraph.diskstorage.util.HashingUtil;
import org.janusgraph.diskstorage.util.StaticArrayEntry;
import org.janusgraph.graphdb.configuration.GraphDatabaseConfiguration;
import org.janusgraph.graphdb.database.StandardJanusGraph;
import org.janusgraph.graphdb.database.idhandling.VariableLong;
import org.janusgraph.graphdb.database.management.ManagementSystem;
import org.janusgraph.graphdb.database.serialize.DataOutput;
import org.janusgraph.graphdb.database.serialize.InternalAttributeUtil;
import org.janusgraph.graphdb.database.serialize.Serializer;
import org.janusgraph.graphdb.idmanagement.IDManager;
import org.janusgraph.graphdb.internal.ElementCategory;
import org.janusgraph.graphdb.internal.InternalRelation;
import org.janusgraph.graphdb.internal.InternalRelationType;
import org.janusgraph.graphdb.internal.InternalVertex;
import org.janusgraph.graphdb.internal.Order;
import org.janusgraph.graphdb.internal.OrderList;
import org.janusgraph.graphdb.query.JanusGraphPredicate;
import org.janusgraph.graphdb.query.condition.Condition;
import org.janusgraph.graphdb.query.condition.ConditionUtil;
import org.janusgraph.graphdb.query.condition.PredicateCondition;
import org.janusgraph.graphdb.query.graph.GraphCentricQueryBuilder;
import org.janusgraph.graphdb.query.graph.IndexQueryBuilder;
import org.janusgraph.graphdb.query.graph.JointIndexQuery;
import org.janusgraph.graphdb.query.graph.MultiKeySliceQuery;
import org.janusgraph.graphdb.query.vertex.VertexCentricQueryBuilder;
import org.janusgraph.graphdb.relations.RelationIdentifier;
import org.janusgraph.graphdb.transaction.StandardJanusGraphTx;
import org.janusgraph.graphdb.types.CompositeIndexType;
import org.janusgraph.graphdb.types.IndexField;
import org.janusgraph.graphdb.types.IndexType;
import org.janusgraph.graphdb.types.MixedIndexType;
import org.janusgraph.graphdb.types.ParameterIndexField;
import org.janusgraph.graphdb.types.ParameterType;
import org.janusgraph.util.encoding.LongEncoding;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexSerializer {
    private static final Logger log = LoggerFactory.getLogger(IndexSerializer.class);
    private static final int DEFAULT_OBJECT_BYTELEN = 30;
    private static final byte FIRST_INDEX_COLUMN_BYTE = 0;
    private final Serializer serializer;
    private final Configuration configuration;
    private final Map<String, ? extends IndexInformation> mixedIndexes;
    private final boolean hashKeys;
    private final HashingUtil.HashLength hashLength = HashingUtil.HashLength.SHORT;

    public IndexSerializer(Configuration config, Serializer serializer, Map<String, ? extends IndexInformation> indexes, boolean hashKeys) {
        this.serializer = serializer;
        this.configuration = config;
        this.mixedIndexes = indexes;
        this.hashKeys = hashKeys;
        if (hashKeys) {
            log.info("Hashing index keys");
        }
    }

    public boolean containsIndex(String indexName) {
        return this.mixedIndexes.containsKey(indexName);
    }

    public String getDefaultFieldName(PropertyKey key, Parameter[] parameters, String indexName) {
        Preconditions.checkArgument((!ParameterType.MAPPED_NAME.hasParameter(parameters) ? 1 : 0) != 0, (String)"A field name mapping has been specified for key: %s", (Object[])new Object[]{key});
        Preconditions.checkArgument((boolean)this.containsIndex(indexName), (String)"Unknown backing index: %s", (Object[])new Object[]{indexName});
        String fieldname = this.configuration.get(GraphDatabaseConfiguration.INDEX_NAME_MAPPING, indexName) != false ? key.name() : IndexSerializer.keyID2Name(key);
        return this.mixedIndexes.get(indexName).mapKey2Field(fieldname, new StandardKeyInformation(key, parameters));
    }

    public static void register(MixedIndexType index, PropertyKey key, BackendTransaction tx) throws BackendException {
        tx.getIndexTransaction(index.getBackingIndexName()).register(index.getStoreName(), IndexSerializer.key2Field(index, key), IndexSerializer.getKeyInformation(index.getField(key)));
    }

    public boolean supports(MixedIndexType index, ParameterIndexField field) {
        return this.getMixedIndex(index).supports(IndexSerializer.getKeyInformation(field));
    }

    public boolean supports(MixedIndexType index, ParameterIndexField field, JanusGraphPredicate predicate) {
        return this.getMixedIndex(index).supports(IndexSerializer.getKeyInformation(field), predicate);
    }

    public IndexFeatures features(MixedIndexType index) {
        return this.getMixedIndex(index).getFeatures();
    }

    private IndexInformation getMixedIndex(MixedIndexType index) {
        IndexInformation indexinfo = this.mixedIndexes.get(index.getBackingIndexName());
        Preconditions.checkArgument((indexinfo != null ? 1 : 0) != 0, (Object)("Index is unknown or not configured: " + index.getBackingIndexName()));
        return indexinfo;
    }

    private static StandardKeyInformation getKeyInformation(ParameterIndexField field) {
        return new StandardKeyInformation(field.getFieldKey(), field.getParameters());
    }

    public IndexInfoRetriever getIndexInfoRetriever(StandardJanusGraphTx tx) {
        return new IndexInfoRetriever(tx);
    }

    private static IndexUpdate.Type getUpdateType(InternalRelation relation) {
        assert (relation.isNew() || relation.isRemoved());
        return relation.isNew() ? IndexUpdate.Type.ADD : IndexUpdate.Type.DELETE;
    }

    private static boolean indexAppliesTo(IndexType index, JanusGraphElement element) {
        return !(!index.getElement().isInstance(element) || index instanceof CompositeIndexType && ((CompositeIndexType)index).getStatus() == SchemaStatus.DISABLED || index.hasSchemaTypeConstraint() && !index.getElement().matchesConstraint(index.getSchemaTypeConstraint(), element));
    }

    public Collection<IndexUpdate> getIndexUpdates(InternalRelation relation) {
        assert (relation.isNew() || relation.isRemoved());
        HashSet updates = Sets.newHashSet();
        IndexUpdate.Type updateType = IndexSerializer.getUpdateType(relation);
        int ttl = updateType == IndexUpdate.Type.ADD ? StandardJanusGraph.getTTL(relation) : 0;
        for (RelationType relationType : relation.getPropertyKeysDirect()) {
            if (!(relationType instanceof PropertyKey)) continue;
            PropertyKey key = (PropertyKey)relationType;
            for (IndexType index : ((InternalRelationType)((Object)key)).getKeyIndexes()) {
                IndexUpdate<String, IndexEntry> update;
                if (!IndexSerializer.indexAppliesTo(index, relation)) continue;
                if (index instanceof CompositeIndexType) {
                    CompositeIndexType iIndex = (CompositeIndexType)index;
                    RecordEntry[] record = IndexSerializer.indexMatch(relation, iIndex);
                    if (record == null) continue;
                    update = new IndexUpdate(iIndex, updateType, this.getIndexKey(iIndex, record), this.getIndexEntry(iIndex, record, relation), relation);
                } else {
                    assert (relation.valueOrNull(key) != null);
                    if (((MixedIndexType)index).getField(key).getStatus() == SchemaStatus.DISABLED) continue;
                    update = this.getMixedIndexUpdate(relation, key, relation.valueOrNull(key), (MixedIndexType)index, updateType);
                }
                if (ttl > 0) {
                    update.setTTL(ttl);
                }
                updates.add(update);
            }
        }
        return updates;
    }

    private static PropertyKey[] getKeysOfRecords(RecordEntry[] record) {
        PropertyKey[] keys = new PropertyKey[record.length];
        for (int i = 0; i < record.length; ++i) {
            keys[i] = record[i].key;
        }
        return keys;
    }

    private static int getIndexTTL(InternalVertex vertex, PropertyKey ... keys) {
        int ttl = StandardJanusGraph.getTTL(vertex);
        for (PropertyKey key : keys) {
            int kttl = ((InternalRelationType)((Object)key)).getTTL();
            if (kttl <= 0 || kttl >= ttl && ttl > 0) continue;
            ttl = kttl;
        }
        return ttl;
    }

    public Collection<IndexUpdate> getIndexUpdates(InternalVertex vertex, Collection<InternalRelation> updatedProperties) {
        if (updatedProperties.isEmpty()) {
            return Collections.emptyList();
        }
        HashSet updates = Sets.newHashSet();
        for (InternalRelation rel : updatedProperties) {
            assert (rel.isProperty());
            JanusGraphVertexProperty p = (JanusGraphVertexProperty)((Object)rel);
            assert (rel.isNew() || rel.isRemoved());
            assert (rel.getVertex(0).equals(vertex));
            IndexUpdate.Type updateType = IndexSerializer.getUpdateType(rel);
            for (IndexType index : ((InternalRelationType)((Object)p.propertyKey())).getKeyIndexes()) {
                if (!IndexSerializer.indexAppliesTo(index, vertex)) continue;
                if (index.isCompositeIndex()) {
                    CompositeIndexType cIndex = (CompositeIndexType)index;
                    IndexRecords updateRecords = IndexSerializer.indexMatches(vertex, cIndex, updateType == IndexUpdate.Type.DELETE, p.propertyKey(), new RecordEntry(p));
                    for (RecordEntry[] record : updateRecords) {
                        IndexUpdate update = new IndexUpdate(cIndex, updateType, this.getIndexKey(cIndex, record), this.getIndexEntry(cIndex, record, vertex), vertex);
                        int ttl = IndexSerializer.getIndexTTL(vertex, IndexSerializer.getKeysOfRecords(record));
                        if (ttl > 0 && updateType == IndexUpdate.Type.ADD) {
                            update.setTTL(ttl);
                        }
                        updates.add(update);
                    }
                    continue;
                }
                if (((MixedIndexType)index).getField(p.propertyKey()).getStatus() == SchemaStatus.DISABLED) continue;
                IndexUpdate<String, IndexEntry> update = this.getMixedIndexUpdate(vertex, p.propertyKey(), p.value(), (MixedIndexType)index, updateType);
                int ttl = IndexSerializer.getIndexTTL(vertex, p.propertyKey());
                if (ttl > 0 && updateType == IndexUpdate.Type.ADD) {
                    update.setTTL(ttl);
                }
                updates.add(update);
            }
        }
        return updates;
    }

    private IndexUpdate<String, IndexEntry> getMixedIndexUpdate(JanusGraphElement element, PropertyKey key, Object value, MixedIndexType index, IndexUpdate.Type updateType) {
        return new IndexUpdate<String, IndexEntry>(index, updateType, IndexSerializer.element2String(element), new IndexEntry(IndexSerializer.key2Field(index.getField(key)), value), element);
    }

    public void reindexElement(JanusGraphElement element, MixedIndexType index, Map<String, Map<String, List<IndexEntry>>> documentsPerStore) {
        if (!IndexSerializer.indexAppliesTo(index, element)) {
            return;
        }
        ArrayList entries = Lists.newArrayList();
        for (ParameterIndexField field : index.getFieldKeys()) {
            PropertyKey key = field.getFieldKey();
            if (field.getStatus() == SchemaStatus.DISABLED) continue;
            if (!element.properties(key.name()).hasNext()) continue;
            element.values(key.name()).forEachRemaining(value -> entries.add(new IndexEntry(IndexSerializer.key2Field(field), value)));
        }
        Map documents = documentsPerStore.computeIfAbsent(index.getStoreName(), k -> Maps.newHashMap());
        this.getDocuments(documentsPerStore, index).put(IndexSerializer.element2String(element), entries);
    }

    private Map<String, List<IndexEntry>> getDocuments(Map<String, Map<String, List<IndexEntry>>> documentsPerStore, MixedIndexType index) {
        return documentsPerStore.computeIfAbsent(index.getStoreName(), k -> Maps.newHashMap());
    }

    public void removeElement(Object elementId, MixedIndexType index, Map<String, Map<String, List<IndexEntry>>> documentsPerStore) {
        Preconditions.checkArgument((index.getElement() == ElementCategory.VERTEX && elementId instanceof Long || index.getElement().isRelation() && elementId instanceof RelationIdentifier ? 1 : 0) != 0, (String)"Invalid element id [%s] provided for index: %s", (Object[])new Object[]{elementId, index});
        this.getDocuments(documentsPerStore, index).put(IndexSerializer.element2String(elementId), Lists.newArrayList());
    }

    public Set<IndexUpdate<StaticBuffer, Entry>> reindexElement(JanusGraphElement element, CompositeIndexType index) {
        List records;
        HashSet indexEntries = Sets.newHashSet();
        if (!IndexSerializer.indexAppliesTo(index, element)) {
            return indexEntries;
        }
        if (element instanceof JanusGraphVertex) {
            records = IndexSerializer.indexMatches((JanusGraphVertex)element, index);
        } else {
            assert (element instanceof JanusGraphRelation);
            records = Collections.EMPTY_LIST;
            RecordEntry[] record = IndexSerializer.indexMatch((JanusGraphRelation)element, index);
            if (record != null) {
                records = ImmutableList.of((Object)record);
            }
        }
        for (RecordEntry[] record : records) {
            indexEntries.add(new IndexUpdate(index, IndexUpdate.Type.ADD, this.getIndexKey(index, record), this.getIndexEntry(index, record, element), element));
        }
        return indexEntries;
    }

    public static RecordEntry[] indexMatch(JanusGraphRelation relation, CompositeIndexType index) {
        IndexField[] fields = index.getFieldKeys();
        RecordEntry[] match = new RecordEntry[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            IndexField f = fields[i];
            Object value = relation.valueOrNull(f.getFieldKey());
            if (value == null) {
                return null;
            }
            match[i] = new RecordEntry(relation.longId(), value, f.getFieldKey());
        }
        return match;
    }

    public static IndexRecords indexMatches(JanusGraphVertex vertex, CompositeIndexType index) {
        return IndexSerializer.indexMatches(vertex, index, null, null);
    }

    public static IndexRecords indexMatches(JanusGraphVertex vertex, CompositeIndexType index, PropertyKey replaceKey, Object replaceValue) {
        IndexRecords matches = new IndexRecords();
        IndexField[] fields = index.getFieldKeys();
        if (IndexSerializer.indexAppliesTo(index, vertex)) {
            IndexSerializer.indexMatches(vertex, new RecordEntry[fields.length], matches, fields, 0, false, replaceKey, new RecordEntry(0L, replaceValue, replaceKey));
        }
        return matches;
    }

    private static IndexRecords indexMatches(JanusGraphVertex vertex, CompositeIndexType index, boolean onlyLoaded, PropertyKey replaceKey, RecordEntry replaceValue) {
        IndexRecords matches = new IndexRecords();
        IndexField[] fields = index.getFieldKeys();
        IndexSerializer.indexMatches(vertex, new RecordEntry[fields.length], matches, fields, 0, onlyLoaded, replaceKey, replaceValue);
        return matches;
    }

    private static void indexMatches(JanusGraphVertex vertex, RecordEntry[] current, IndexRecords matches, IndexField[] fields, int pos, boolean onlyLoaded, PropertyKey replaceKey, RecordEntry replaceValue) {
        Object values;
        if (pos >= fields.length) {
            matches.add(current);
            return;
        }
        PropertyKey key = fields[pos].getFieldKey();
        if (key.equals(replaceKey)) {
            values = ImmutableList.of((Object)replaceValue);
        } else {
            Iterable<JanusGraphVertexProperty> props;
            values = new ArrayList();
            if (onlyLoaded || !vertex.isNew() && IDManager.VertexIDType.PartitionedVertex.is(vertex.longId())) {
                VertexCentricQueryBuilder qb = ((InternalVertex)vertex).tx().query(vertex);
                ((VertexCentricQueryBuilder)qb.noPartitionRestriction()).type(key);
                if (onlyLoaded) {
                    qb.queryOnlyLoaded();
                }
                props = qb.properties();
            } else {
                props = vertex.query().keys(new String[]{key.name()}).properties();
            }
            for (JanusGraphVertexProperty p : props) {
                assert (!onlyLoaded || p.isLoaded() || p.isRemoved());
                assert (key.dataType().equals(p.value().getClass())) : key + " -> " + p;
                values.add(new RecordEntry(p));
            }
        }
        Iterator iterator = values.iterator();
        while (iterator.hasNext()) {
            RecordEntry value;
            current[pos] = value = (RecordEntry)iterator.next();
            IndexSerializer.indexMatches(vertex, current, matches, fields, pos + 1, onlyLoaded, replaceKey, replaceValue);
        }
    }

    public Stream<Object> query(JointIndexQuery.Subquery query, BackendTransaction tx) {
        IndexType index = query.getIndex();
        if (index.isCompositeIndex()) {
            MultiKeySliceQuery sq = query.getCompositeQuery();
            List<EntryList> rs = sq.execute(tx);
            ArrayList<Serializable> results = new ArrayList<Serializable>(rs.get(0).size());
            for (EntryList r : rs) {
                Iterator<Entry> iterator = r.reuseIterator();
                block4: while (iterator.hasNext()) {
                    Entry entry = iterator.next();
                    ReadBuffer entryValue = entry.asReadBuffer();
                    entryValue.movePositionTo(entry.getValuePosition());
                    switch (index.getElement()) {
                        case VERTEX: {
                            results.add(Long.valueOf(VariableLong.readPositive(entryValue)));
                            continue block4;
                        }
                    }
                    results.add(IndexSerializer.bytebuffer2RelationId(entryValue));
                }
            }
            return results.stream();
        }
        return tx.indexQuery(index.getBackingIndexName(), query.getMixedQuery()).map(IndexSerializer::string2ElementId);
    }

    public MultiKeySliceQuery getQuery(CompositeIndexType index, List<Object[]> values) {
        ArrayList<KeySliceQuery> ksqs = new ArrayList<KeySliceQuery>(values.size());
        for (Object[] value : values) {
            ksqs.add(new KeySliceQuery(this.getIndexKey(index, value), BufferUtil.zeroBuffer(1), BufferUtil.oneBuffer(1)));
        }
        return new MultiKeySliceQuery(ksqs);
    }

    public IndexQuery getQuery(final MixedIndexType index, Condition condition, OrderList orders) {
        Condition<JanusGraphElement> newCondition = ConditionUtil.literalTransformation(condition, new Function<Condition<JanusGraphElement>, Condition<JanusGraphElement>>(){

            @Nullable
            public Condition<JanusGraphElement> apply(Condition<JanusGraphElement> condition) {
                Preconditions.checkArgument((boolean)(condition instanceof PredicateCondition));
                PredicateCondition pc = (PredicateCondition)condition;
                PropertyKey key = (PropertyKey)pc.getKey();
                return new PredicateCondition(IndexSerializer.key2Field(index, key), pc.getPredicate(), pc.getValue());
            }
        });
        ImmutableList newOrders = IndexQuery.NO_ORDER;
        if (!orders.isEmpty() && GraphCentricQueryBuilder.indexCoversOrder(index, orders)) {
            ImmutableList.Builder lb = ImmutableList.builder();
            for (int i = 0; i < orders.size(); ++i) {
                lb.add((Object)new IndexQuery.OrderEntry(IndexSerializer.key2Field(index, orders.getKey(i)), orders.getOrder(i), orders.getKey(i).dataType()));
            }
            newOrders = lb.build();
        }
        return new IndexQuery(index.getStoreName(), newCondition, newOrders);
    }

    private String createQueryString(IndexQueryBuilder query, ElementCategory resultType, StandardJanusGraphTx transaction, MixedIndexType index) {
        Preconditions.checkArgument((index.getElement() == resultType ? 1 : 0) != 0, (String)"Index is not configured for the desired result type: %s", (Object[])new Object[]{resultType});
        String backingIndexName = index.getBackingIndexName();
        IndexProvider indexInformation = (IndexProvider)this.mixedIndexes.get(backingIndexName);
        StringBuilder qB = new StringBuilder(query.getQuery());
        String prefix = query.getPrefix();
        Preconditions.checkNotNull((Object)prefix);
        int replacements = 0;
        int pos = 0;
        while (pos < qB.length() && (pos = qB.indexOf(prefix, pos)) >= 0) {
            String replacement;
            boolean quoteTerminated;
            int startPos = pos;
            StringBuilder keyBuilder = new StringBuilder();
            boolean bl = quoteTerminated = qB.charAt(pos += prefix.length()) == '\"';
            if (quoteTerminated) {
                ++pos;
            }
            while (pos < qB.length() && (Character.isLetterOrDigit(qB.charAt(pos)) || quoteTerminated && qB.charAt(pos) != '\"' || qB.charAt(pos) == '*')) {
                keyBuilder.append(qB.charAt(pos));
                ++pos;
            }
            if (quoteTerminated) {
                // empty if block
            }
            int endPos = ++pos;
            String keyName = keyBuilder.toString();
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank(keyName), (String)"Found reference to empty key at position [%s]", (Object[])new Object[]{startPos});
            if (keyName.equals("*")) {
                replacement = indexInformation.getFeatures().getWildcardField();
            } else if (transaction.containsRelationType(keyName)) {
                PropertyKey key = transaction.getPropertyKey(keyName);
                Preconditions.checkNotNull((Object)key);
                Preconditions.checkArgument((boolean)index.indexesKey(key), (String)"The used key [%s] is not indexed in the targeted index [%s]", (Object[])new Object[]{key.name(), query.getIndex()});
                replacement = IndexSerializer.key2Field(index, key);
            } else {
                Preconditions.checkArgument((query.getUnknownKeyName() != null ? 1 : 0) != 0, (String)"Found reference to nonexistent property key in query at position [%s]: %s", (Object[])new Object[]{startPos, keyName});
                replacement = query.getUnknownKeyName();
            }
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank(replacement));
            qB.replace(startPos, endPos, replacement);
            pos = startPos + replacement.length();
            ++replacements;
        }
        String queryStr = qB.toString();
        if (replacements <= 0) {
            log.warn("Could not convert given {} index query: [{}]", (Object)resultType, (Object)query.getQuery());
        }
        log.info("Converted query string with {} replacements: [{}] => [{}]", new Object[]{replacements, query.getQuery(), queryStr});
        return queryStr;
    }

    private ImmutableList<IndexQuery.OrderEntry> getOrders(IndexQueryBuilder query, ElementCategory resultType, StandardJanusGraphTx transaction, MixedIndexType index) {
        if (query.getOrders() == null) {
            return ImmutableList.of();
        }
        Preconditions.checkArgument((index.getElement() == resultType ? 1 : 0) != 0, (String)"Index is not configured for the desired result type: %s", (Object[])new Object[]{resultType});
        ArrayList<IndexQuery.OrderEntry> orderReplacement = new ArrayList<IndexQuery.OrderEntry>();
        for (Parameter order : query.getOrders()) {
            if (transaction.containsRelationType(order.key())) {
                PropertyKey key = transaction.getPropertyKey(order.key());
                Preconditions.checkNotNull((Object)key);
                Preconditions.checkArgument((boolean)index.indexesKey(key), (String)"The used key [%s] is not indexed in the targeted index [%s]", (Object[])new Object[]{key.name(), query.getIndex()});
                orderReplacement.add(new IndexQuery.OrderEntry(IndexSerializer.key2Field(index, key), Order.convert((org.apache.tinkerpop.gremlin.process.traversal.Order)order.value()), key.dataType()));
                continue;
            }
            Preconditions.checkArgument((query.getUnknownKeyName() != null ? 1 : 0) != 0, (String)"Found reference to nonexistent property key in query orders %s", (Object[])new Object[]{order.key()});
        }
        return ImmutableList.copyOf(orderReplacement);
    }

    public Stream<RawQuery.Result> executeQuery(IndexQueryBuilder query, ElementCategory resultType, BackendTransaction backendTx, StandardJanusGraphTx transaction) {
        MixedIndexType index = IndexSerializer.getMixedIndex(query.getIndex(), transaction);
        String queryStr = this.createQueryString(query, resultType, transaction, index);
        ImmutableList<IndexQuery.OrderEntry> orders = this.getOrders(query, resultType, transaction, index);
        RawQuery rawQuery = new RawQuery(index.getStoreName(), queryStr, orders, query.getParameters());
        if (query.hasLimit()) {
            rawQuery.setLimit(query.getLimit());
        }
        rawQuery.setOffset(query.getOffset());
        return backendTx.rawQuery(index.getBackingIndexName(), rawQuery).map(result -> new RawQuery.Result<Object>(IndexSerializer.string2ElementId((String)result.getResult()), result.getScore()));
    }

    public Long executeTotals(IndexQueryBuilder query, ElementCategory resultType, BackendTransaction backendTx, StandardJanusGraphTx transaction) {
        MixedIndexType index = IndexSerializer.getMixedIndex(query.getIndex(), transaction);
        String queryStr = this.createQueryString(query, resultType, transaction, index);
        RawQuery rawQuery = new RawQuery(index.getStoreName(), queryStr, query.getParameters());
        if (query.hasLimit()) {
            rawQuery.setLimit(query.getLimit());
        }
        rawQuery.setOffset(query.getOffset());
        return backendTx.totals(index.getBackingIndexName(), rawQuery);
    }

    private static MixedIndexType getMixedIndex(String indexName, StandardJanusGraphTx transaction) {
        IndexType index = ManagementSystem.getGraphIndexDirect(indexName, transaction);
        Preconditions.checkArgument((index != null ? 1 : 0) != 0, (String)"Index with name [%s] is unknown or not configured properly", (Object[])new Object[]{indexName});
        Preconditions.checkArgument((boolean)index.isMixedIndex());
        return (MixedIndexType)index;
    }

    private static String element2String(JanusGraphElement element) {
        return IndexSerializer.element2String(element.id());
    }

    private static String element2String(Object elementId) {
        Preconditions.checkArgument((elementId instanceof Long || elementId instanceof RelationIdentifier ? 1 : 0) != 0);
        if (elementId instanceof Long) {
            return IndexSerializer.longID2Name((Long)elementId);
        }
        return ((RelationIdentifier)elementId).toString();
    }

    private static Object string2ElementId(String str) {
        if (str.contains("-")) {
            return RelationIdentifier.parse(str);
        }
        return IndexSerializer.name2LongID(str);
    }

    private static String key2Field(MixedIndexType index, PropertyKey key) {
        return IndexSerializer.key2Field(index.getField(key));
    }

    private static String key2Field(ParameterIndexField field) {
        assert (field != null);
        return ParameterType.MAPPED_NAME.findParameter(field.getParameters(), IndexSerializer.keyID2Name(field.getFieldKey()));
    }

    private static String keyID2Name(PropertyKey key) {
        return IndexSerializer.longID2Name(key.longId());
    }

    private static String longID2Name(long id) {
        Preconditions.checkArgument((id > 0L ? 1 : 0) != 0);
        return LongEncoding.encode(id);
    }

    private static long name2LongID(String name) {
        return LongEncoding.decode(name);
    }

    private StaticBuffer getIndexKey(CompositeIndexType index, RecordEntry[] record) {
        return this.getIndexKey(index, IndexRecords.getValues(record));
    }

    private StaticBuffer getIndexKey(CompositeIndexType index, Object[] values) {
        DataOutput out = this.serializer.getDataOutput(248);
        VariableLong.writePositive(out, index.getID());
        IndexField[] fields = index.getFieldKeys();
        Preconditions.checkArgument((fields.length > 0 && fields.length == values.length ? 1 : 0) != 0);
        for (int i = 0; i < fields.length; ++i) {
            IndexField f = fields[i];
            Object value = values[i];
            Preconditions.checkNotNull((Object)value);
            if (InternalAttributeUtil.hasGenericDataType(f.getFieldKey())) {
                out.writeClassAndObject(value);
                continue;
            }
            assert (value.getClass().equals(f.getFieldKey().dataType())) : value.getClass() + " - " + f.getFieldKey().dataType();
            out.writeObjectNotNull(value);
        }
        StaticBuffer key = out.getStaticBuffer();
        if (this.hashKeys) {
            key = HashingUtil.hashPrefixKey(this.hashLength, key);
        }
        return key;
    }

    public long getIndexIdFromKey(StaticBuffer key) {
        if (this.hashKeys) {
            key = HashingUtil.getKey(this.hashLength, key);
        }
        return VariableLong.readPositive(key.asReadBuffer());
    }

    private Entry getIndexEntry(CompositeIndexType index, RecordEntry[] record, JanusGraphElement element) {
        DataOutput out = this.serializer.getDataOutput(9 + 8 * record.length + 32);
        out.putByte((byte)0);
        if (index.getCardinality() != Cardinality.SINGLE) {
            VariableLong.writePositive(out, element.longId());
            if (index.getCardinality() != Cardinality.SET) {
                for (RecordEntry re : record) {
                    VariableLong.writePositive(out, re.relationId);
                }
            }
        }
        int valuePosition = out.getPosition();
        if (element instanceof JanusGraphVertex) {
            VariableLong.writePositive(out, element.longId());
        } else {
            assert (element instanceof JanusGraphRelation);
            RelationIdentifier rid = (RelationIdentifier)element.id();
            long[] longs = rid.getLongRepresentation();
            Preconditions.checkArgument((longs.length == 3 || longs.length == 4 ? 1 : 0) != 0);
            for (long aLong : longs) {
                VariableLong.writePositive(out, aLong);
            }
        }
        return new StaticArrayEntry(out.getStaticBuffer(), valuePosition);
    }

    private static RelationIdentifier bytebuffer2RelationId(ReadBuffer b) {
        long[] relationId = new long[4];
        for (int i = 0; i < 3; ++i) {
            relationId[i] = VariableLong.readPositive(b);
        }
        if (b.hasRemaining()) {
            relationId[3] = VariableLong.readPositive(b);
        } else {
            relationId = Arrays.copyOfRange(relationId, 0, 3);
        }
        return RelationIdentifier.get(relationId);
    }

    private static class RecordEntry {
        final long relationId;
        final Object value;
        final PropertyKey key;

        private RecordEntry(long relationId, Object value, PropertyKey key) {
            this.relationId = relationId;
            this.value = value;
            this.key = key;
        }

        private RecordEntry(JanusGraphVertexProperty property) {
            this(property.longId(), property.value(), property.propertyKey());
        }
    }

    public static class IndexRecords
    extends ArrayList<RecordEntry[]> {
        @Override
        public boolean add(RecordEntry[] record) {
            return super.add(Arrays.copyOf(record, record.length));
        }

        public Iterable<Object[]> getRecordValues() {
            return Iterables.transform((Iterable)this, (Function)new Function<RecordEntry[], Object[]>(){

                @Nullable
                public Object[] apply(RecordEntry[] record) {
                    return IndexRecords.getValues(record);
                }
            });
        }

        private static Object[] getValues(RecordEntry[] record) {
            Object[] values = new Object[record.length];
            for (int i = 0; i < values.length; ++i) {
                values[i] = record[i].value;
            }
            return values;
        }
    }

    public static class IndexUpdate<K, E> {
        private final IndexType index;
        private final Type mutationType;
        private final K key;
        private final E entry;
        private final JanusGraphElement element;

        private IndexUpdate(IndexType index, Type mutationType, K key, E entry, JanusGraphElement element) {
            assert (index != null && mutationType != null && key != null && entry != null && element != null);
            assert (!index.isCompositeIndex() || key instanceof StaticBuffer && entry instanceof Entry);
            assert (!index.isMixedIndex() || key instanceof String && entry instanceof IndexEntry);
            this.index = index;
            this.mutationType = mutationType;
            this.key = key;
            this.entry = entry;
            this.element = element;
        }

        public JanusGraphElement getElement() {
            return this.element;
        }

        public IndexType getIndex() {
            return this.index;
        }

        public Type getType() {
            return this.mutationType;
        }

        public K getKey() {
            return this.key;
        }

        public E getEntry() {
            return this.entry;
        }

        public boolean isAddition() {
            return this.mutationType == Type.ADD;
        }

        public boolean isDeletion() {
            return this.mutationType == Type.DELETE;
        }

        public boolean isCompositeIndex() {
            return this.index.isCompositeIndex();
        }

        public boolean isMixedIndex() {
            return this.index.isMixedIndex();
        }

        public void setTTL(int ttl) {
            Preconditions.checkArgument((ttl > 0 && this.mutationType == Type.ADD ? 1 : 0) != 0);
            ((MetaAnnotatable)this.entry).setMetaData(EntryMetaData.TTL, ttl);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.index, this.mutationType, this.key, this.entry});
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || !(other instanceof IndexUpdate)) {
                return false;
            }
            IndexUpdate oth = (IndexUpdate)other;
            return this.index.equals(oth.index) && this.mutationType == oth.mutationType && this.key.equals(oth.key) && this.entry.equals(oth.entry);
        }

        private static enum Type {
            ADD,
            DELETE;

        }
    }

    public static class IndexInfoRetriever
    implements KeyInformation.Retriever {
        private final StandardJanusGraphTx transaction;

        private IndexInfoRetriever(StandardJanusGraphTx tx) {
            Preconditions.checkNotNull((Object)tx);
            this.transaction = tx;
        }

        @Override
        public KeyInformation.IndexRetriever get(final String index) {
            return new KeyInformation.IndexRetriever(){
                final Map<String, KeyInformation.StoreRetriever> indexes = new ConcurrentHashMap<String, KeyInformation.StoreRetriever>();

                @Override
                public KeyInformation get(String store, String key) {
                    return this.get(store).get(key);
                }

                @Override
                public KeyInformation.StoreRetriever get(String store) {
                    if (this.indexes.get(store) == null) {
                        Preconditions.checkNotNull((Object)transaction, (Object)"Retriever has not been initialized");
                        MixedIndexType extIndex = IndexSerializer.getMixedIndex(store, transaction);
                        assert (extIndex.getBackingIndexName().equals(index));
                        ImmutableMap.Builder b = ImmutableMap.builder();
                        for (ParameterIndexField field : extIndex.getFieldKeys()) {
                            b.put((Object)IndexSerializer.key2Field(field), (Object)IndexSerializer.getKeyInformation(field));
                        }
                        ImmutableMap infoMap = b.build();
                        KeyInformation.StoreRetriever storeRetriever = arg_0 -> ((ImmutableMap)infoMap).get(arg_0);
                        this.indexes.put(store, storeRetriever);
                    }
                    return this.indexes.get(store);
                }
            };
        }
    }
}

