/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.olap.job;

import com.google.common.base.Preconditions;
import java.time.Instant;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.janusgraph.core.JanusGraph;
import org.janusgraph.core.JanusGraphException;
import org.janusgraph.core.RelationType;
import org.janusgraph.core.schema.Index;
import org.janusgraph.diskstorage.configuration.ConfigNamespace;
import org.janusgraph.diskstorage.configuration.ConfigOption;
import org.janusgraph.diskstorage.configuration.Configuration;
import org.janusgraph.diskstorage.keycolumnvalue.scan.ScanMetrics;
import org.janusgraph.graphdb.configuration.GraphDatabaseConfiguration;
import org.janusgraph.graphdb.database.StandardJanusGraph;
import org.janusgraph.graphdb.database.management.ManagementSystem;
import org.janusgraph.graphdb.transaction.StandardJanusGraphTx;
import org.janusgraph.graphdb.transaction.StandardTransactionBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class IndexUpdateJob {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected static final String SUCCESS_TX = "success-tx";
    protected static final String FAILED_TX = "failed-tx";
    public static final ConfigNamespace INDEX_JOB_NS = new ConfigNamespace(GraphDatabaseConfiguration.JOB_NS, "index", "Configuration options relating to index jobs");
    public static final ConfigOption<String> INDEX_NAME = new ConfigOption<String>(INDEX_JOB_NS, "index-name", "The name of the index to be repaired. For vertex-centric indexes this is the name of the edge label or property key on which the index is installed.", ConfigOption.Type.LOCAL, String.class);
    public static final ConfigOption<String> INDEX_RELATION_TYPE = new ConfigOption<String>(INDEX_JOB_NS, "relation-type", "For a vertex-centric index, this is the name of the index associated with the relation type configured under index-name. This should remain empty for global graph indexes.", ConfigOption.Type.LOCAL, "", Objects::nonNull);
    protected String indexRelationTypeName = null;
    protected String indexName = null;
    protected StandardJanusGraph graph;
    protected ManagementSystem managementSystem = null;
    protected StandardJanusGraphTx writeTx;
    protected Index index;
    protected RelationType indexRelationType;
    protected Instant jobStartTime;

    public IndexUpdateJob() {
    }

    protected IndexUpdateJob(IndexUpdateJob copy) {
        this.indexName = copy.indexName;
        this.indexRelationTypeName = copy.indexRelationTypeName;
    }

    public IndexUpdateJob(String indexName, String indexRelationTypeName) {
        this.indexName = indexName;
        this.indexRelationTypeName = indexRelationTypeName;
    }

    public boolean isGlobalGraphIndex() {
        return this.indexRelationTypeName == null || StringUtils.isBlank(this.indexRelationTypeName);
    }

    public boolean isRelationTypeIndex() {
        return !this.isGlobalGraphIndex();
    }

    public void workerIterationStart(JanusGraph graph, Configuration config, ScanMetrics metrics) {
        this.graph = (StandardJanusGraph)graph;
        Preconditions.checkArgument((boolean)config.has(GraphDatabaseConfiguration.JOB_START_TIME, new String[0]), (Object)"Invalid configuration for this job. Start time is required.");
        this.jobStartTime = Instant.ofEpochMilli(config.get(GraphDatabaseConfiguration.JOB_START_TIME, new String[0]));
        if (this.indexName == null) {
            Preconditions.checkArgument((boolean)config.has(INDEX_NAME, new String[0]), (Object)"Need to configure the name of the index to be repaired");
            this.indexName = config.get(INDEX_NAME, new String[0]);
            this.indexRelationTypeName = config.get(INDEX_RELATION_TYPE, new String[0]);
            this.log.info("Read index information: name={} type={}", (Object)this.indexName, (Object)this.indexRelationTypeName);
        }
        try {
            this.managementSystem = (ManagementSystem)graph.openManagement();
            if (this.isGlobalGraphIndex()) {
                this.index = this.managementSystem.getGraphIndex(this.indexName);
            } else {
                this.indexRelationType = this.managementSystem.getRelationType(this.indexRelationTypeName);
                Preconditions.checkArgument((this.indexRelationType != null ? 1 : 0) != 0, (String)"Could not find relation type: %s", (Object[])new Object[]{this.indexRelationTypeName});
                this.index = this.managementSystem.getRelationIndex(this.indexRelationType, this.indexName);
            }
            Preconditions.checkArgument((this.index != null ? 1 : 0) != 0, (String)"Could not find index: %s [%s]", (Object[])new Object[]{this.indexName, this.indexRelationTypeName});
            this.log.info("Found index {}", (Object)this.indexName);
            this.validateIndexStatus();
            StandardTransactionBuilder txb = this.graph.buildTransaction();
            txb.commitTime(this.jobStartTime);
            this.writeTx = (StandardJanusGraphTx)txb.start();
        }
        catch (Exception e) {
            if (null != this.managementSystem && this.managementSystem.isOpen()) {
                this.managementSystem.rollback();
            }
            if (this.writeTx != null && this.writeTx.isOpen()) {
                this.writeTx.rollback();
            }
            metrics.incrementCustom(FAILED_TX);
            throw new JanusGraphException(e.getMessage(), e);
        }
    }

    public void workerIterationEnd(ScanMetrics metrics) {
        try {
            if (null != this.managementSystem && this.managementSystem.isOpen()) {
                this.managementSystem.commit();
            }
            if (this.writeTx != null && this.writeTx.isOpen()) {
                this.writeTx.commit();
            }
            metrics.incrementCustom(SUCCESS_TX);
        }
        catch (RuntimeException e) {
            this.log.error("Transaction commit threw runtime exception:", (Throwable)e);
            metrics.incrementCustom(FAILED_TX);
            throw e;
        }
    }

    protected abstract void validateIndexStatus();
}

