/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.relations;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.janusgraph.core.EdgeLabel;
import org.janusgraph.core.PropertyKey;
import org.janusgraph.graphdb.internal.ElementLifeCycle;
import org.janusgraph.graphdb.internal.InternalVertex;
import org.janusgraph.graphdb.relations.AbstractEdge;
import org.janusgraph.graphdb.relations.ReassignableRelation;
import org.janusgraph.graphdb.relations.StandardRelation;
import org.janusgraph.graphdb.types.system.ImplicitKey;

public class StandardEdge
extends AbstractEdge
implements StandardRelation,
ReassignableRelation {
    private static final Map<PropertyKey, Object> EMPTY_PROPERTIES = ImmutableMap.of();
    private byte lifecycle;
    private long previousID = 0L;
    private volatile Map<PropertyKey, Object> properties = EMPTY_PROPERTIES;

    public StandardEdge(long id, EdgeLabel label, InternalVertex start, InternalVertex end, byte lifecycle) {
        super(id, label, start, end);
        this.lifecycle = lifecycle;
    }

    @Override
    public long getPreviousID() {
        return this.previousID;
    }

    @Override
    public void setPreviousID(long previousID) {
        Preconditions.checkArgument((previousID > 0L ? 1 : 0) != 0);
        Preconditions.checkArgument((this.previousID == 0L ? 1 : 0) != 0);
        this.previousID = previousID;
    }

    @Override
    public <O> O getValueDirect(PropertyKey type) {
        return (O)this.properties.get(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPropertyDirect(PropertyKey key, Object value) {
        Preconditions.checkArgument((!(key instanceof ImplicitKey) ? 1 : 0) != 0, (String)"Cannot use implicit type [%s] when setting property", (Object[])new Object[]{key.name()});
        if (this.properties == EMPTY_PROPERTIES) {
            if (this.tx().getConfiguration().isSingleThreaded()) {
                this.properties = new HashMap<PropertyKey, Object>(5);
            } else {
                StandardEdge standardEdge = this;
                synchronized (standardEdge) {
                    if (this.properties == EMPTY_PROPERTIES) {
                        this.properties = Collections.synchronizedMap(new HashMap(5));
                    }
                }
            }
        }
        this.tx().checkPropertyConstraintForEdgeOrCreatePropertyConstraint(this, key);
        this.properties.put(key, value);
    }

    @Override
    public Iterable<PropertyKey> getPropertyKeysDirect() {
        return Lists.newArrayList(this.properties.keySet());
    }

    @Override
    public <O> O removePropertyDirect(PropertyKey key) {
        if (!this.properties.isEmpty()) {
            return (O)this.properties.remove(key);
        }
        return null;
    }

    @Override
    public byte getLifeCycle() {
        return this.lifecycle;
    }

    @Override
    public synchronized void remove() {
        if (!ElementLifeCycle.isRemoved(this.lifecycle)) {
            this.tx().removeRelation(this);
            this.lifecycle = ElementLifeCycle.update(this.lifecycle, ElementLifeCycle.Event.REMOVED);
        }
    }
}

