/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.tinkerpop;

import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.janusgraph.diskstorage.keycolumnvalue.StoreFeatures;
import org.janusgraph.graphdb.database.StandardJanusGraph;
import org.janusgraph.graphdb.transaction.StandardJanusGraphTx;

public class JanusGraphFeatures
implements Graph.Features {
    private final Graph.Features.GraphFeatures graphFeatures;
    private final Graph.Features.VertexFeatures vertexFeatures;
    private final Graph.Features.EdgeFeatures edgeFeatures;
    private final StandardJanusGraph graph;

    private JanusGraphFeatures(StandardJanusGraph graph, StoreFeatures storageFeatures) {
        this.graphFeatures = new JanusGraphGeneralFeatures(storageFeatures.supportsPersistence());
        this.vertexFeatures = new JanusGraphVertexFeatures();
        this.edgeFeatures = new JanusGraphEdgeFeatures();
        this.graph = graph;
    }

    @Override
    public Graph.Features.GraphFeatures graph() {
        return this.graphFeatures;
    }

    @Override
    public Graph.Features.VertexFeatures vertex() {
        return this.vertexFeatures;
    }

    @Override
    public Graph.Features.EdgeFeatures edge() {
        return this.edgeFeatures;
    }

    public String toString() {
        return StringFactory.featureString(this);
    }

    public static JanusGraphFeatures getFeatures(StandardJanusGraph graph, StoreFeatures storageFeatures) {
        return new JanusGraphFeatures(graph, storageFeatures);
    }

    private static class JanusGraphEdgeFeatures
    implements Graph.Features.EdgeFeatures {
        private JanusGraphEdgeFeatures() {
        }

        @Override
        public Graph.Features.EdgePropertyFeatures properties() {
            return new JanusGraphEdgePropertyFeatures();
        }

        @Override
        public boolean supportsCustomIds() {
            return true;
        }

        @Override
        public boolean supportsUserSuppliedIds() {
            return false;
        }

        @Override
        public boolean supportsNumericIds() {
            return false;
        }

        @Override
        public boolean supportsAnyIds() {
            return false;
        }

        @Override
        public boolean supportsUuidIds() {
            return false;
        }

        @Override
        public boolean supportsStringIds() {
            return false;
        }
    }

    private class JanusGraphVertexFeatures
    implements Graph.Features.VertexFeatures {
        private JanusGraphVertexFeatures() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public VertexProperty.Cardinality getCardinality(String key) {
            StandardJanusGraphTx tx = (StandardJanusGraphTx)JanusGraphFeatures.this.graph.newTransaction();
            try {
                if (!tx.containsPropertyKey(key)) {
                    VertexProperty.Cardinality cardinality = tx.getConfiguration().getAutoSchemaMaker().defaultPropertyCardinality(key).convert();
                    return cardinality;
                }
                VertexProperty.Cardinality cardinality = tx.getPropertyKey(key).cardinality().convert();
                return cardinality;
            }
            finally {
                tx.rollback();
            }
        }

        @Override
        public Graph.Features.VertexPropertyFeatures properties() {
            return new JanusGraphVertexPropertyFeatures();
        }

        @Override
        public boolean supportsNumericIds() {
            return true;
        }

        @Override
        public boolean supportsUserSuppliedIds() {
            return JanusGraphFeatures.this.graph.getConfiguration().allowVertexIdSetting();
        }

        @Override
        public boolean supportsAnyIds() {
            return false;
        }

        @Override
        public boolean supportsUuidIds() {
            return false;
        }

        @Override
        public boolean supportsStringIds() {
            return false;
        }

        @Override
        public boolean supportsCustomIds() {
            return false;
        }
    }

    private static class JanusGraphEdgePropertyFeatures
    extends JanusGraphDataTypeFeatures
    implements Graph.Features.EdgePropertyFeatures {
        private JanusGraphEdgePropertyFeatures() {
        }
    }

    private static class JanusGraphVertexPropertyFeatures
    extends JanusGraphDataTypeFeatures
    implements Graph.Features.VertexPropertyFeatures {
        private JanusGraphVertexPropertyFeatures() {
        }

        @Override
        public boolean supportsUserSuppliedIds() {
            return false;
        }

        @Override
        public boolean supportsNumericIds() {
            return false;
        }

        @Override
        public boolean supportsAnyIds() {
            return false;
        }

        @Override
        public boolean supportsUuidIds() {
            return false;
        }
    }

    private static class JanusGraphGeneralFeatures
    extends JanusGraphDataTypeFeatures
    implements Graph.Features.GraphFeatures {
        private final boolean persists;

        private JanusGraphGeneralFeatures(boolean persists) {
            this.persists = persists;
        }

        @Override
        public Graph.Features.VariableFeatures variables() {
            return new JanusGraphVariableFeatures();
        }

        @Override
        public boolean supportsComputer() {
            return true;
        }

        @Override
        public boolean supportsPersistence() {
            return this.persists;
        }

        @Override
        public boolean supportsTransactions() {
            return true;
        }

        @Override
        public boolean supportsThreadedTransactions() {
            return true;
        }
    }

    private static class JanusGraphVariableFeatures
    extends JanusGraphDataTypeFeatures
    implements Graph.Features.VariableFeatures {
        private JanusGraphVariableFeatures() {
        }
    }

    private static class JanusGraphDataTypeFeatures
    implements Graph.Features.DataTypeFeatures {
        private JanusGraphDataTypeFeatures() {
        }

        @Override
        public boolean supportsMapValues() {
            return true;
        }

        @Override
        public boolean supportsMixedListValues() {
            return false;
        }

        @Override
        public boolean supportsSerializableValues() {
            return false;
        }

        @Override
        public boolean supportsUniformListValues() {
            return false;
        }
    }
}

