/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.vertices;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.Iterator;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.janusgraph.core.InvalidElementException;
import org.janusgraph.core.JanusGraphEdge;
import org.janusgraph.core.JanusGraphRelation;
import org.janusgraph.core.JanusGraphVertex;
import org.janusgraph.core.JanusGraphVertexProperty;
import org.janusgraph.core.PropertyKey;
import org.janusgraph.core.VertexLabel;
import org.janusgraph.graphdb.internal.AbstractElement;
import org.janusgraph.graphdb.internal.ElementLifeCycle;
import org.janusgraph.graphdb.internal.InternalVertex;
import org.janusgraph.graphdb.query.vertex.VertexCentricQueryBuilder;
import org.janusgraph.graphdb.transaction.StandardJanusGraphTx;
import org.janusgraph.graphdb.types.VertexLabelVertex;
import org.janusgraph.graphdb.types.system.BaseLabel;
import org.janusgraph.graphdb.types.system.BaseVertexLabel;
import org.janusgraph.graphdb.util.ElementHelper;

public abstract class AbstractVertex
extends AbstractElement
implements InternalVertex,
Vertex {
    private final StandardJanusGraphTx tx;

    protected AbstractVertex(StandardJanusGraphTx tx, long id) {
        super(id);
        assert (tx != null);
        this.tx = tx;
    }

    @Override
    public final InternalVertex it() {
        if (this.tx.isOpen()) {
            return this;
        }
        InternalVertex next = (InternalVertex)this.tx.getNextTx().getVertex(this.longId());
        if (next == null) {
            throw InvalidElementException.removedException(this);
        }
        return next;
    }

    @Override
    public final StandardJanusGraphTx tx() {
        return this.tx.isOpen() ? this.tx : this.tx.getNextTx();
    }

    public final boolean isTxOpen() {
        return this.tx.isOpen();
    }

    @Override
    public long getCompareId() {
        if (this.tx.isPartitionedVertex(this)) {
            return this.tx.getIdInspector().getCanonicalVertexId(this.longId());
        }
        return this.longId();
    }

    public String toString() {
        return StringFactory.vertexString(this);
    }

    @Override
    public Object id() {
        return this.longId();
    }

    @Override
    public boolean isModified() {
        return ElementLifeCycle.isModified(this.it().getLifeCycle());
    }

    protected final void verifyAccess() {
        if (this.isRemoved()) {
            throw InvalidElementException.removedException(this);
        }
    }

    @Override
    public synchronized void remove() {
        this.verifyAccess();
        Iterator<JanusGraphRelation> iterator = ((VertexCentricQueryBuilder)this.it().query().noPartitionRestriction()).relations().iterator();
        while (iterator.hasNext()) {
            iterator.next();
            iterator.remove();
        }
        for (JanusGraphRelation r : ((VertexCentricQueryBuilder)((VertexCentricQueryBuilder)this.it().query().noPartitionRestriction()).system()).relations()) {
            r.remove();
        }
    }

    @Override
    public String label() {
        return this.vertexLabel().name();
    }

    protected Vertex getVertexLabelInternal() {
        return (Vertex)Iterables.getOnlyElement(((VertexCentricQueryBuilder)((VertexCentricQueryBuilder)((VertexCentricQueryBuilder)this.tx().query(this).noPartitionRestriction()).type(BaseLabel.VertexLabelEdge)).direction(Direction.OUT)).vertices(), null);
    }

    @Override
    public VertexLabel vertexLabel() {
        Vertex label = this.getVertexLabelInternal();
        if (label == null) {
            return BaseVertexLabel.DEFAULT_VERTEXLABEL;
        }
        return (VertexLabelVertex)label;
    }

    @Override
    public VertexCentricQueryBuilder query() {
        this.verifyAccess();
        return this.tx().query(this);
    }

    public <O> O valueOrNull(PropertyKey key) {
        return this.property(key.name()).orElse(null);
    }

    @Override
    public <V> JanusGraphVertexProperty<V> property(String key, V value, Object ... keyValues) {
        JanusGraphVertexProperty p = this.tx().addProperty(this.it(), this.tx().getOrCreatePropertyKey(key, value), value);
        ElementHelper.attachProperties(p, keyValues);
        return p;
    }

    @Override
    public <V> JanusGraphVertexProperty<V> property(VertexProperty.Cardinality cardinality, String key, V value, Object ... keyValues) {
        JanusGraphVertexProperty p = this.tx().addProperty(cardinality, this.it(), this.tx().getOrCreatePropertyKey(key, value, cardinality), value);
        ElementHelper.attachProperties(p, keyValues);
        return p;
    }

    @Override
    public JanusGraphEdge addEdge(String label, Vertex vertex, Object ... keyValues) {
        Preconditions.checkArgument((boolean)(vertex instanceof JanusGraphVertex), (String)"Invalid vertex provided: %s", (Object[])new Object[]{vertex});
        JanusGraphEdge edge = this.tx().addEdge(this.it(), (JanusGraphVertex)vertex, this.tx().getOrCreateEdgeLabel(label));
        ElementHelper.attachProperties(edge, keyValues);
        return edge;
    }

    @Override
    public Iterator<Edge> edges(Direction direction, String ... labels) {
        return ((VertexCentricQueryBuilder)((VertexCentricQueryBuilder)this.query().direction(direction)).labels(labels)).edges().iterator();
    }

    @Override
    public <V> Iterator<VertexProperty<V>> properties(String ... keys) {
        return ((VertexCentricQueryBuilder)((VertexCentricQueryBuilder)this.query().direction(Direction.OUT)).keys(keys)).properties().iterator();
    }

    @Override
    public Iterator<Vertex> vertices(Direction direction, String ... edgeLabels) {
        return ((VertexCentricQueryBuilder)((VertexCentricQueryBuilder)this.query().direction(direction)).labels(edgeLabels)).vertices().iterator();
    }
}

