/*
 * Decompiled with CFR 0.152.
 */
package com.arcadeanalytics.provider.neo4j3;

import com.arcadeanalytics.provider.DataSourceInfo;
import com.arcadeanalytics.provider.neo4j3.Neo4jType;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.neo4j.driver.v1.AuthTokens;
import org.neo4j.driver.v1.Config;
import org.neo4j.driver.v1.Driver;
import org.neo4j.driver.v1.GraphDatabase;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000&\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\u001a\u000e\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u001e\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u001a\u0016\u0010\r\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0001\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"connectionTemplate", "", "createConnectionUrl", "datasource", "Lcom/arcadeanalytics/provider/DataSourceInfo;", "getDriver", "Lorg/neo4j/driver/v1/Driver;", "toArcadeId", "dataSource", "type", "Lcom/arcadeanalytics/provider/neo4j3/Neo4jType;", "neo4jId", "", "toNeo4jId", "arcadeId", "arcade-connectors-neo4j3"})
public final class Neo4jIdUtilsKt {
    private static final String connectionTemplate = "bolt://{server}:{port}";

    @NotNull
    public static final String toArcadeId(@NotNull DataSourceInfo dataSource, @NotNull Neo4jType type, long neo4jId) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        return String.valueOf(dataSource.getId()) + type.suffix() + neo4jId;
    }

    @NotNull
    public static final String toNeo4jId(@NotNull DataSourceInfo dataSource, @NotNull String arcadeId) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        Intrinsics.checkNotNullParameter((Object)arcadeId, (String)"arcadeId");
        String cleaned = StringUtils.removeStart(arcadeId, String.valueOf(dataSource.getId()) + Neo4jType.NODE.suffix());
        String string = StringUtils.removeStart(cleaned, String.valueOf(dataSource.getId()) + Neo4jType.EDGE.suffix());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringUtils.removeStart(\u2026 Neo4jType.EDGE.suffix())");
        return string;
    }

    @NotNull
    public static final String createConnectionUrl(@NotNull DataSourceInfo datasource) {
        Intrinsics.checkNotNullParameter((Object)datasource, (String)"datasource");
        return StringsKt.replace$default((String)StringsKt.replace$default((String)connectionTemplate, (String)"{server}", (String)datasource.getServer(), (boolean)false, (int)4, null), (String)"{port}", (String)String.valueOf(datasource.getPort()), (boolean)false, (int)4, null);
    }

    @NotNull
    public static final Driver getDriver(@NotNull DataSourceInfo datasource) {
        Intrinsics.checkNotNullParameter((Object)datasource, (String)"datasource");
        String connectionUrl = Neo4jIdUtilsKt.createConnectionUrl(datasource);
        Config config = Config.build().withConnectionTimeout(30L, TimeUnit.SECONDS).withMaxConnectionPoolSize(1).toConfig();
        Driver driver = GraphDatabase.driver(connectionUrl, AuthTokens.basic(datasource.getUsername(), datasource.getPassword()), config);
        Intrinsics.checkNotNullExpressionValue((Object)driver, (String)"GraphDatabase.driver(\n  \u2026e.password), config\n    )");
        return driver;
    }
}

