/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.messaging.v1;

import java.io.IOException;
import java.util.Map;
import org.neo4j.driver.internal.messaging.ValuePacker;
import org.neo4j.driver.internal.packstream.PackOutput;
import org.neo4j.driver.internal.packstream.PackStream;
import org.neo4j.driver.internal.value.InternalValue;
import org.neo4j.driver.v1.Value;

public class ValuePackerV1
implements ValuePacker {
    protected final PackStream.Packer packer;
    private final boolean byteArraySupportEnabled;

    public ValuePackerV1(PackOutput output, boolean byteArraySupportEnabled) {
        this.packer = new PackStream.Packer(output);
        this.byteArraySupportEnabled = byteArraySupportEnabled;
    }

    @Override
    public final void packStructHeader(int size, byte signature) throws IOException {
        this.packer.packStructHeader(size, signature);
    }

    @Override
    public final void pack(String string) throws IOException {
        this.packer.pack(string);
    }

    @Override
    public final void pack(Value value) throws IOException {
        if (!(value instanceof InternalValue)) {
            throw new IllegalArgumentException("Unable to pack: " + value);
        }
        this.packInternalValue((InternalValue)value);
    }

    @Override
    public final void pack(Map<String, Value> map2) throws IOException {
        if (map2 == null || map2.size() == 0) {
            this.packer.packMapHeader(0);
            return;
        }
        this.packer.packMapHeader(map2.size());
        for (Map.Entry<String, Value> entry : map2.entrySet()) {
            this.packer.pack(entry.getKey());
            this.pack(entry.getValue());
        }
    }

    protected void packInternalValue(InternalValue value) throws IOException {
        switch (value.typeConstructor()) {
            case NULL: {
                this.packer.packNull();
                break;
            }
            case BYTES: {
                if (!this.byteArraySupportEnabled) {
                    throw new PackStream.UnPackable("Packing bytes is not supported as the current server this driver connected to does not support unpack bytes.");
                }
                this.packer.pack(value.asByteArray());
                break;
            }
            case STRING: {
                this.packer.pack(value.asString());
                break;
            }
            case BOOLEAN: {
                this.packer.pack(value.asBoolean());
                break;
            }
            case INTEGER: {
                this.packer.pack(value.asLong());
                break;
            }
            case FLOAT: {
                this.packer.pack(value.asDouble());
                break;
            }
            case MAP: {
                this.packer.packMapHeader(value.size());
                for (String s : value.keys()) {
                    this.packer.pack(s);
                    this.pack(value.get(s));
                }
                break;
            }
            case LIST: {
                this.packer.packListHeader(value.size());
                for (Value item : value.values()) {
                    this.pack(item);
                }
                break;
            }
            default: {
                throw new IOException("Unknown type: " + value.type().name());
            }
        }
    }
}

