/*
 * Decompiled with CFR 0.152.
 */
package com.arcadeanalytics.provider.neo4j3;

import com.arcadeanalytics.data.Sprite;
import com.arcadeanalytics.data.SpritePlayer;
import com.arcadeanalytics.provider.DataSourceGraphProvider;
import com.arcadeanalytics.provider.DataSourceInfo;
import com.arcadeanalytics.provider.neo4j3.Neo4jDialect;
import com.arcadeanalytics.provider.neo4j3.Neo4jGraphProvider;
import com.arcadeanalytics.provider.neo4j3.Neo4jIdUtilsKt;
import com.arcadeanalytics.provider.neo4j3.Neo4jType;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.neo4j.driver.v1.AccessMode;
import org.neo4j.driver.v1.Driver;
import org.neo4j.driver.v1.Record;
import org.neo4j.driver.v1.Session;
import org.neo4j.driver.v1.StatementResult;
import org.neo4j.driver.v1.Value;
import org.neo4j.driver.v1.types.Node;
import org.neo4j.driver.v1.types.Relationship;
import org.neo4j.driver.v1.util.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\nH\u0002J(\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\nH\u0002J \u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\r\u001a\u00020\u000eH\u0002J \u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u0016H\u0016J\u000e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\n0\u001cH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/arcadeanalytics/provider/neo4j3/Neo4jGraphProvider;", "Lcom/arcadeanalytics/provider/DataSourceGraphProvider;", "()V", "allFields", "Ljava/util/regex/Pattern;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "queries", "", "", "countEdges", "", "session", "Lorg/neo4j/driver/v1/Session;", "countNodes", "label", "indexLabel", "", "dataSource", "Lcom/arcadeanalytics/provider/DataSourceInfo;", "processor", "Lcom/arcadeanalytics/data/SpritePlayer;", "indexNodes", "indexRelationships", "provideTo", "player", "supportedDataSourceTypes", "", "arcade-connectors-neo4j3"})
public final class Neo4jGraphProvider
implements DataSourceGraphProvider {
    private final Logger log = LoggerFactory.getLogger(Neo4jGraphProvider.class);
    private final Map<String, String> queries = MapsKt.mapOf((kotlin.Pair[])new kotlin.Pair[]{TuplesKt.to((Object)"NEO4J::LABELS", (Object)"CALL db.labels() YIELD label"), TuplesKt.to((Object)"NEO4J::EDGES", (Object)"CALL db.relationshipTypes() YIELD relationshipType"), TuplesKt.to((Object)"NEO4J_MEMGRAPH::LABELS", (Object)"MATCH (n) UNWIND labels(n) AS label RETURN DISTINCT label"), TuplesKt.to((Object)"NEO4J_MEMGRAPH::EDGES", (Object)"MATCH ()-[r]->() RETURN DISTINCT type(r) AS relationshipType")});
    private final Pattern allFields;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void provideTo(@NotNull DataSourceInfo dataSource, @NotNull SpritePlayer player) {
        Intrinsics.checkParameterIsNotNull((Object)dataSource, (String)"dataSource");
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        AutoCloseable autoCloseable = Neo4jIdUtilsKt.getDriver(dataSource);
        boolean bl = false;
        Throwable throwable = null;
        try {
            Driver driver = (Driver)autoCloseable;
            boolean bl2 = false;
            AutoCloseable autoCloseable2 = driver.session(AccessMode.READ);
            boolean bl3 = false;
            Throwable throwable2 = null;
            try {
                Session session = (Session)autoCloseable2;
                boolean bl4 = false;
                Session session2 = session;
                Intrinsics.checkExpressionValueIsNotNull((Object)session2, (String)"session");
                this.indexNodes(dataSource, player, session2);
                this.indexRelationships(dataSource, player, session);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, (Throwable)throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    private final void indexNodes(DataSourceInfo dataSource, SpritePlayer processor, Session session) {
        StatementResult labels = session.run(this.queries.get(dataSource.getType() + "::LABELS"));
        List<Record> list = labels.list();
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"labels.list()");
        Sequence $this$forEach$iv = SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)list), (Function1)indexNodes.1.INSTANCE);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String label = (String)element$iv;
            boolean bl = false;
            String string = label;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"label");
            this.indexLabel(dataSource, processor, session, string);
        }
    }

    private final void indexRelationships(DataSourceInfo dataSource, SpritePlayer processor, Session session) {
        int edges2 = this.countEdges(session);
        int skip = 0;
        int limit = Math.min(edges2, 10000);
        int fetched = 0;
        while (fetched < edges2) {
            ImmutableMap params = ImmutableMap.of((Object)"skip", (Object)skip, (Object)"limit", (Object)limit);
            this.log.info("fetching edges from '{}' with query '{}' and params {} - {}", new Object[]{session, "MATCH ()-[r]->() RETURN r SKIP $skip LIMIT $limit", skip, limit});
            StatementResult rels = session.run("MATCH ()-[r]->() RETURN r SKIP $skip LIMIT $limit", (Map)params);
            while (rels.hasNext()) {
                Record record = rels.next();
                List<Pair<String, Value>> list = record.fields();
                Intrinsics.checkExpressionValueIsNotNull(list, (String)"record.fields()");
                Sequence $this$forEach$iv = SequencesKt.map((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)list), (Function1)indexRelationships.1.INSTANCE), (Function1)indexRelationships.2.INSTANCE), (Function1)indexRelationships.3.INSTANCE), (Function1)indexRelationships.4.INSTANCE), (Function1)((Function1)new Function1<Relationship, Sprite>(this, dataSource){
                    final /* synthetic */ Neo4jGraphProvider this$0;
                    final /* synthetic */ DataSourceInfo $dataSource;

                    @NotNull
                    public final Sprite invoke(Relationship n) {
                        Sprite sprite = new Sprite();
                        Map<String, Object> map2 = n.asMap();
                        Intrinsics.checkExpressionValueIsNotNull(map2, (String)"n.asMap()");
                        Sprite sprite2 = sprite.load(map2);
                        String string = n.type();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"n.type()");
                        return sprite2.add("@class", string).add("_a_id", Neo4jIdUtilsKt.toArcadeId(this.$dataSource, Neo4jType.EDGE, n.id())).add("_a_type", "edge").apply(Neo4jGraphProvider.access$getAllFields$p(this.this$0), (Function1)indexRelationships.1.INSTANCE);
                    }
                    {
                        this.this$0 = neo4jGraphProvider;
                        this.$dataSource = dataSourceInfo;
                        super(1);
                    }
                }));
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Sprite s = (Sprite)element$iv;
                    boolean bl = false;
                    processor.play(s);
                }
                ++fetched;
            }
            skip = limit;
            limit += 10000;
        }
        processor.end();
    }

    private final void indexLabel(DataSourceInfo dataSource, SpritePlayer processor, Session session, String label) {
        int nodes = this.countNodes(session, label);
        this.log.info("fetching data from '{}' - for label {} total nodes '{}' ", new Object[]{session, label, nodes});
        int skip = 0;
        int limit = Math.min(nodes, 10000);
        int fetched = 0;
        while (fetched < nodes) {
            this.log.info("fetching data from '{}' with query ' {} ' ", (Object)session, (Object)("MATCH (n:" + label + ") RETURN n SKIP " + skip + " LIMIT " + limit));
            StatementResult result = session.run("MATCH (n:" + label + ") RETURN n SKIP " + skip + " LIMIT " + limit);
            while (result.hasNext()) {
                Record record = result.next();
                List<Pair<String, Value>> list = record.fields();
                Intrinsics.checkExpressionValueIsNotNull(list, (String)"record.fields()");
                Sequence $this$forEach$iv = SequencesKt.map((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)list), (Function1)indexLabel.1.INSTANCE), (Function1)indexLabel.2.INSTANCE), (Function1)indexLabel.3.INSTANCE), (Function1)((Function1)new Function1<Node, Sprite>(this, dataSource){
                    final /* synthetic */ Neo4jGraphProvider this$0;
                    final /* synthetic */ DataSourceInfo $dataSource;

                    @NotNull
                    public final Sprite invoke(Node n) {
                        Sprite sprite = new Sprite();
                        Map<String, Object> map2 = n.asMap();
                        Intrinsics.checkExpressionValueIsNotNull(map2, (String)"n.asMap()");
                        Sprite sprite2 = sprite.load(map2);
                        Iterable<String> iterable = n.labels();
                        Intrinsics.checkExpressionValueIsNotNull(iterable, (String)"n.labels()");
                        return sprite2.addAll("@class", iterable).add("_a_id", Neo4jIdUtilsKt.toArcadeId(this.$dataSource, Neo4jType.NODE, n.id())).add("_a_type", "node").apply(Neo4jGraphProvider.access$getAllFields$p(this.this$0), (Function1)indexLabel.1.INSTANCE);
                    }
                    {
                        this.this$0 = neo4jGraphProvider;
                        this.$dataSource = dataSourceInfo;
                        super(1);
                    }
                }));
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Sprite s = (Sprite)element$iv;
                    boolean bl = false;
                    processor.play(s);
                }
                ++fetched;
            }
            skip = limit;
            limit += 10000;
        }
        this.log.info("label '{}' indexed -  totals {}/{} ", new Object[]{label, fetched, nodes});
        processor.end();
    }

    private final int countNodes(Session session, String label) {
        int count = session.run("MATCH (n:" + label + ") RETURN count(*) AS count").single().get("count").asInt();
        this.log.info("nodes for label '{}' : {}", (Object)label, (Object)count);
        return count;
    }

    private final int countEdges(Session session) {
        int count = session.run("MATCH ()-[r]->() RETURN count(*) AS count").single().get("count").asInt();
        this.log.info("edges count: {}", (Object)count);
        return count;
    }

    @NotNull
    public Set<String> supportedDataSourceTypes() {
        return SetsKt.setOf((Object[])new String[]{Neo4jDialect.NEO4J.name(), Neo4jDialect.NEO4J_MEMGRAPH.name()});
    }

    public Neo4jGraphProvider() {
        Pattern pattern = Pattern.compile(".*");
        Intrinsics.checkExpressionValueIsNotNull((Object)pattern, (String)"Pattern.compile(\".*\")");
        this.allFields = pattern;
    }

    public static final /* synthetic */ Pattern access$getAllFields$p(Neo4jGraphProvider $this) {
        return $this.allFields;
    }
}

