/*
 * Decompiled with CFR 0.152.
 */
package com.arcadeanalytics.provider.neo4j3;

import com.arcadeanalytics.data.Sprite;
import com.arcadeanalytics.provider.CytoData;
import com.arcadeanalytics.provider.Data;
import com.arcadeanalytics.provider.DataSourceInfo;
import com.arcadeanalytics.provider.GraphData;
import com.arcadeanalytics.provider.Position;
import com.arcadeanalytics.provider.TypeMapperKt;
import com.arcadeanalytics.provider.neo4j3.Neo4jDataProvider;
import com.arcadeanalytics.provider.neo4j3.Neo4jIdUtilsKt;
import com.arcadeanalytics.provider.neo4j3.Neo4jType;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.neo4j.driver.v1.Record;
import org.neo4j.driver.v1.StatementResult;
import org.neo4j.driver.v1.Value;
import org.neo4j.driver.v1.types.Node;
import org.neo4j.driver.v1.types.Path;
import org.neo4j.driver.v1.types.Relationship;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0002J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ0\u0010\u000e\u001a\u00020\u000f2\u001e\u0010\u0010\u001a\u001a\u0012\u0004\u0012\u00020\u0012\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00010\u00110\u00112\u0006\u0010\u0013\u001a\u00020\u000fH\u0002J0\u0010\u000e\u001a\u00020\u00142\u001e\u0010\u0010\u001a\u001a\u0012\u0004\u0012\u00020\u0012\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00010\u00110\u00112\u0006\u0010\u0015\u001a\u00020\u0014H\u0002J\u0010\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u000fH\u0002J\u0010\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u0014H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/arcadeanalytics/provider/neo4j3/Neo4jStatementResultMapper;", "", "dataSource", "Lcom/arcadeanalytics/provider/DataSourceInfo;", "maxTraversal", "", "(Lcom/arcadeanalytics/provider/DataSourceInfo;I)V", "countInOut", "Lcom/arcadeanalytics/provider/CytoData;", "cyto", "map", "Lcom/arcadeanalytics/provider/GraphData;", "result", "Lorg/neo4j/driver/v1/StatementResult;", "mapProperties", "Lorg/neo4j/driver/v1/types/Node;", "nodesClasses", "", "", "node", "Lorg/neo4j/driver/v1/types/Relationship;", "rel", "toCytoData", "Companion", "arcade-connectors-neo4j3"})
public final class Neo4jStatementResultMapper {
    private final DataSourceInfo dataSource;
    private final int maxTraversal;
    private static final Logger log;
    public static final Companion Companion;

    private final CytoData countInOut(CytoData cyto) {
        boolean bl = false;
        Map inAndOutCountByEdgeType = new LinkedHashMap();
        String string = "@in";
        Map map2 = inAndOutCountByEdgeType;
        bl = false;
        Map map3 = new LinkedHashMap();
        map2.putIfAbsent(string, map3);
        string = "@out";
        map2 = inAndOutCountByEdgeType;
        bl = false;
        map3 = new LinkedHashMap();
        map2.putIfAbsent(string, map3);
        cyto.getData().getRecord().putAll(inAndOutCountByEdgeType);
        cyto.getData().getRecord().put("@edgeCount", 0);
        return cyto;
    }

    private final CytoData toCytoData(Node node) {
        String id = Neo4jIdUtilsKt.toArcadeId(this.dataSource, Neo4jType.NODE, node.id());
        Sprite sprite = new Sprite();
        Map<String, Object> map2 = node.asMap();
        Intrinsics.checkExpressionValueIsNotNull(map2, (String)"node.asMap()");
        Sprite record = sprite.load(map2).rename("id", "_id_");
        Map map3 = record.asMap();
        if (map3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.MutableMap<kotlin.String, kotlin.Any>");
        }
        Data data = new Data(id, null, null, null, TypeIntrinsics.asMutableMap((Object)map3), 14, null);
        Iterable<String> iterable = node.labels();
        Intrinsics.checkExpressionValueIsNotNull(iterable, (String)"node.labels()");
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        Position position = null;
        String string5 = "nodes";
        String string6 = CollectionsKt.joinToString$default(iterable, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
        Data data2 = data;
        CytoData cytoData = new CytoData(string6, string5, data2, position, string4, string3, string2, string, 248, null);
        return cytoData;
    }

    private final CytoData toCytoData(Relationship rel) {
        String id = Neo4jIdUtilsKt.toArcadeId(this.dataSource, Neo4jType.EDGE, rel.id());
        String source = Neo4jIdUtilsKt.toArcadeId(this.dataSource, Neo4jType.NODE, rel.startNodeId());
        String target = Neo4jIdUtilsKt.toArcadeId(this.dataSource, Neo4jType.NODE, rel.endNodeId());
        Sprite sprite = new Sprite();
        Map<String, Object> map2 = rel.asMap();
        Intrinsics.checkExpressionValueIsNotNull(map2, (String)"rel.asMap()");
        Sprite record = sprite.load(map2).rename("id", "_id_");
        Map map3 = record.asMap();
        if (map3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.MutableMap<kotlin.String, kotlin.Any>");
        }
        String string = target;
        String string2 = source;
        Map map4 = TypeIntrinsics.asMutableMap((Object)map3);
        Data data = new Data(id, null, string2, string, map4, 2, null);
        String string3 = rel.type();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"rel.type()");
        string2 = null;
        map4 = null;
        String string4 = null;
        String string5 = null;
        Position position = null;
        String string6 = "edges";
        String string7 = string3;
        Data data2 = data;
        CytoData cytoData = new CytoData(string7, string6, data2, position, string5, string4, (String)((Object)map4), string2, 248, null);
        return cytoData;
    }

    @NotNull
    public final GraphData map(@NotNull StatementResult result) {
        Intrinsics.checkParameterIsNotNull((Object)result, (String)"result");
        log.info("mapping result max {} ", (Object)this.maxTraversal);
        boolean bl = false;
        Map nodesClasses = new LinkedHashMap();
        boolean bl2 = false;
        Map edgeClasses = new LinkedHashMap();
        boolean bl3 = false;
        Set nodes = new LinkedHashSet();
        boolean bl4 = false;
        Set rels = new LinkedHashSet();
        boolean fetchMore = true;
        int fetched = 0;
        while (result.hasNext() && fetchMore) {
            Record record = result.next();
            List<Value> list = record.values();
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"record.values()");
            Sequence $this$forEach$iv = CollectionsKt.asSequence((Iterable)list);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String string;
                Value f = (Value)element$iv;
                boolean bl5 = false;
                if (f.type().name() == null) continue;
                int n = -1;
                switch (string.hashCode()) {
                    case 0x255C25: {
                        if (!string.equals("PATH")) break;
                        n = 1;
                        break;
                    }
                    case 2401794: {
                        if (!string.equals("NODE")) break;
                        n = 2;
                        break;
                    }
                    case 2055429688: {
                        if (!string.equals("RELATIONSHIP")) break;
                        n = 3;
                        break;
                    }
                }
                switch (n) {
                    case 2: {
                        Node node;
                        Node node2 = node = f.asNode();
                        Intrinsics.checkExpressionValueIsNotNull((Object)node2, (String)"node");
                        nodes.add(node2);
                        break;
                    }
                    case 3: {
                        Relationship relationship = f.asRelationship();
                        Intrinsics.checkExpressionValueIsNotNull((Object)relationship, (String)"f.asRelationship()");
                        rels.add(relationship);
                        break;
                    }
                    case 1: {
                        Path path = f.asPath();
                        Collection collection = rels;
                        Iterable<Relationship> iterable = path.relationships();
                        Intrinsics.checkExpressionValueIsNotNull(iterable, (String)"path.relationships()");
                        CollectionsKt.addAll((Collection)collection, iterable);
                        Collection collection2 = nodes;
                        Iterable<Node> iterable2 = path.nodes();
                        Intrinsics.checkExpressionValueIsNotNull(iterable2, (String)"path.nodes()");
                        CollectionsKt.addAll((Collection)collection2, iterable2);
                    }
                }
            }
            if (fetched++ % 1000 == 0) {
                log.info("fethced:: {} ", (Object)fetched);
                log.info(" sizes {} . {} ", (Object)nodes.size(), (Object)rels.size());
            }
            fetchMore = nodes.size() < this.maxTraversal || rels.size() < this.maxTraversal;
        }
        log.info("nodes:: {} - rels:: {}", (Object)nodes.size(), (Object)rels.size());
        Set relsWithEachEnds2 = SequencesKt.toSet((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)rels), (Function1)((Function1)new Function1<Relationship, Boolean>(nodes){
            final /* synthetic */ Set $nodes;

            public final boolean invoke(@NotNull Relationship rel) {
                Intrinsics.checkParameterIsNotNull((Object)rel, (String)"rel");
                long endNodeId = rel.endNodeId();
                long startNodeId = rel.startNodeId();
                boolean foundStart = false;
                boolean foundEnd = false;
                for (Node node : this.$nodes) {
                    if (node.id() == endNodeId) {
                        foundEnd = true;
                        continue;
                    }
                    if (node.id() != startNodeId) continue;
                    foundStart = true;
                }
                return foundStart && foundEnd;
            }
            {
                this.$nodes = set;
                super(1);
            }
        })));
        Set cytoNodes2 = SequencesKt.toSet((Sequence)SequencesKt.map((Sequence)SequencesKt.map((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)nodes), (Function1)((Function1)new Function1<Node, Node>(this, nodesClasses){
            final /* synthetic */ Neo4jStatementResultMapper this$0;
            final /* synthetic */ Map $nodesClasses;

            @NotNull
            public final Node invoke(@NotNull Node c) {
                Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
                return Neo4jStatementResultMapper.access$mapProperties(this.this$0, this.$nodesClasses, c);
            }
            {
                this.this$0 = neo4jStatementResultMapper;
                this.$nodesClasses = map2;
                super(1);
            }
        })), (Function1)((Function1)new Function1<Node, CytoData>(this){
            final /* synthetic */ Neo4jStatementResultMapper this$0;

            @NotNull
            public final CytoData invoke(@NotNull Node n) {
                Intrinsics.checkParameterIsNotNull((Object)n, (String)"n");
                return Neo4jStatementResultMapper.access$toCytoData(this.this$0, n);
            }
            {
                this.this$0 = neo4jStatementResultMapper;
                super(1);
            }
        })), (Function1)((Function1)new Function1<CytoData, CytoData>(this){
            final /* synthetic */ Neo4jStatementResultMapper this$0;

            @NotNull
            public final CytoData invoke(@NotNull CytoData c) {
                Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
                return Neo4jStatementResultMapper.access$countInOut(this.this$0, c);
            }
            {
                this.this$0 = neo4jStatementResultMapper;
                super(1);
            }
        })));
        Set edges2 = SequencesKt.toSet((Sequence)SequencesKt.map((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)relsWithEachEnds2), (Function1)((Function1)new Function1<Relationship, Relationship>(this, edgeClasses){
            final /* synthetic */ Neo4jStatementResultMapper this$0;
            final /* synthetic */ Map $edgeClasses;

            @NotNull
            public final Relationship invoke(@NotNull Relationship c) {
                Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
                return Neo4jStatementResultMapper.access$mapProperties(this.this$0, this.$edgeClasses, c);
            }
            {
                this.this$0 = neo4jStatementResultMapper;
                this.$edgeClasses = map2;
                super(1);
            }
        })), (Function1)((Function1)new Function1<Relationship, CytoData>(this){
            final /* synthetic */ Neo4jStatementResultMapper this$0;

            @NotNull
            public final CytoData invoke(@NotNull Relationship r) {
                Intrinsics.checkParameterIsNotNull((Object)r, (String)"r");
                return Neo4jStatementResultMapper.access$toCytoData(this.this$0, r);
            }
            {
                this.this$0 = neo4jStatementResultMapper;
                super(1);
            }
        })));
        GraphData graphData = new GraphData(nodesClasses, edgeClasses, cytoNodes2, edges2, !fetchMore);
        log.info("totals mapped: nodes {} - edges {} - truncated {} ", new Object[]{graphData.getNodes().size(), graphData.getEdges().size(), graphData.getTruncated()});
        return graphData;
    }

    private final Node mapProperties(Map<String, Map<String, Object>> nodesClasses, Node node) {
        Iterable<String> iterable = node.labels();
        Intrinsics.checkExpressionValueIsNotNull(iterable, (String)"node.labels()");
        String className = CollectionsKt.joinToString$default(iterable, (CharSequence)"_", null, null, (int)0, null, null, (int)62, null);
        nodesClasses.putIfAbsent(className, new HashMap());
        Map<String, Object> properties = nodesClasses.get(className);
        Iterable<String> iterable2 = node.keys();
        Intrinsics.checkExpressionValueIsNotNull(iterable2, (String)"node.keys()");
        Iterable<String> $this$forEach$iv = iterable2;
        boolean $i$f$forEach = false;
        Iterator<String> iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            String element$iv;
            String k = element$iv = iterator.next();
            boolean bl = false;
            Map<String, Object> map2 = properties;
            if (map2 == null) continue;
            String string = node.get(k).type().name();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"node.get(k).type().name()");
            map2.putIfAbsent(k, TypeMapperKt.mapType((String)string));
        }
        return node;
    }

    private final Relationship mapProperties(Map<String, Map<String, Object>> nodesClasses, Relationship rel) {
        nodesClasses.putIfAbsent(rel.type(), new HashMap());
        Map<String, Object> properties = nodesClasses.get(rel.type());
        Iterable<String> iterable = rel.keys();
        Intrinsics.checkExpressionValueIsNotNull(iterable, (String)"rel.keys()");
        Iterable<String> $this$forEach$iv = iterable;
        boolean $i$f$forEach = false;
        Iterator<String> iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            String element$iv;
            String k = element$iv = iterator.next();
            boolean bl = false;
            Map<String, Object> map2 = properties;
            if (map2 == null) continue;
            map2.putIfAbsent(k, rel.get(k).type().name());
        }
        return rel;
    }

    public Neo4jStatementResultMapper(@NotNull DataSourceInfo dataSource, int maxTraversal) {
        Intrinsics.checkParameterIsNotNull((Object)dataSource, (String)"dataSource");
        this.dataSource = dataSource;
        this.maxTraversal = maxTraversal;
    }

    static {
        Companion = new Companion(null);
        log = LoggerFactory.getLogger(Neo4jDataProvider.class);
    }

    public static final /* synthetic */ Node access$mapProperties(Neo4jStatementResultMapper $this, Map nodesClasses, Node node) {
        return $this.mapProperties((Map<String, Map<String, Object>>)nodesClasses, node);
    }

    public static final /* synthetic */ CytoData access$toCytoData(Neo4jStatementResultMapper $this, Node node) {
        return $this.toCytoData(node);
    }

    public static final /* synthetic */ CytoData access$countInOut(Neo4jStatementResultMapper $this, CytoData cyto) {
        return $this.countInOut(cyto);
    }

    public static final /* synthetic */ Relationship access$mapProperties(Neo4jStatementResultMapper $this, Map nodesClasses, Relationship rel) {
        return $this.mapProperties((Map<String, Map<String, Object>>)nodesClasses, rel);
    }

    public static final /* synthetic */ CytoData access$toCytoData(Neo4jStatementResultMapper $this, Relationship rel) {
        return $this.toCytoData(rel);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/arcadeanalytics/provider/neo4j3/Neo4jStatementResultMapper$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "arcade-connectors-neo4j3"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

