/*
 * Decompiled with CFR 0.152.
 */
package com.arcadeanalytics.provider.orient2;

import com.arcadeanalytics.provider.orient2.OrientDBDocumentCollector;
import com.arcadeanalytics.provider.orient2.OrientDBUtilsKt;
import com.orientechnologies.orient.core.command.OCommandResultListener;
import com.orientechnologies.orient.core.record.impl.ODocument;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0016J\n\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/arcadeanalytics/provider/orient2/OrientDBResultListener;", "Lcom/orientechnologies/orient/core/command/OCommandResultListener;", "documentCollector", "Lcom/arcadeanalytics/provider/orient2/OrientDBDocumentCollector;", "limit", "", "(Lcom/arcadeanalytics/provider/orient2/OrientDBDocumentCollector;I)V", "edges", "nodes", "end", "", "getResult", "", "result", "", "record", "arcade-connectors-orientdb2"})
public final class OrientDBResultListener
implements OCommandResultListener {
    private int nodes;
    private int edges;
    private final OrientDBDocumentCollector documentCollector;
    private final int limit;

    @Override
    public boolean result(@NotNull Object record) {
        int n;
        Intrinsics.checkNotNullParameter((Object)record, (String)"record");
        ODocument document = (ODocument)record;
        this.documentCollector.collect(document);
        if (OrientDBUtilsKt.isVertexType(document)) {
            n = this.nodes;
            this.nodes = n + 1;
        } else if (OrientDBUtilsKt.isEdgeType(document)) {
            n = this.edges;
            this.edges = n + 1;
        } else {
            n = this.nodes;
            this.nodes = n + 1;
        }
        boolean fetchMore = this.nodes < this.limit || this.edges < this.limit;
        this.documentCollector.truncated(!fetchMore);
        return fetchMore;
    }

    @Override
    public void end() {
    }

    @Override
    @Nullable
    public Object getResult() {
        return null;
    }

    public OrientDBResultListener(@NotNull OrientDBDocumentCollector documentCollector, int limit) {
        Intrinsics.checkNotNullParameter((Object)documentCollector, (String)"documentCollector");
        this.documentCollector = documentCollector;
        this.limit = limit;
    }
}

