/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.log;

import com.orientechnologies.common.log.OAnsiCode;
import com.orientechnologies.common.log.OLogFormatter;
import java.text.DateFormat;
import java.util.Date;
import java.util.IllegalFormatException;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class OAnsiLogFormatter
extends OLogFormatter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String customFormatMessage(LogRecord iRecord) {
        Level level = iRecord.getLevel();
        String message = OAnsiCode.format(iRecord.getMessage());
        Object[] additionalArgs = iRecord.getParameters();
        String requester = this.getSourceClassSimpleName(iRecord.getLoggerName());
        StringBuilder buffer = new StringBuilder(512);
        buffer.append(EOL);
        buffer.append("$ANSI{cyan ");
        DateFormat dateFormat = OAnsiLogFormatter.dateFormat;
        synchronized (dateFormat) {
            buffer.append(OAnsiLogFormatter.dateFormat.format(new Date()));
        }
        buffer.append("}");
        if (OAnsiCode.isSupportsColors()) {
            if (level == Level.SEVERE) {
                buffer.append("$ANSI{red ");
            } else if (level == Level.WARNING) {
                buffer.append("$ANSI{yellow ");
            } else if (level == Level.INFO) {
                buffer.append("$ANSI{green ");
            } else if (level == Level.CONFIG) {
                buffer.append("$ANSI{green ");
            } else if (level == Level.CONFIG) {
                buffer.append("$ANSI{white ");
            }
        }
        buffer.append(String.format(" %-5.5s ", level.getName()));
        if (OAnsiCode.isSupportsColors()) {
            buffer.append("}");
        }
        try {
            if (additionalArgs != null) {
                buffer.append(String.format(message, additionalArgs));
            } else {
                buffer.append(message);
            }
        }
        catch (IllegalFormatException ignore) {
            buffer.append(message);
        }
        if (requester != null) {
            buffer.append(" [");
            buffer.append(requester);
            buffer.append(']');
        }
        return OAnsiCode.format(buffer.toString());
    }
}

