/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.profiler;

import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;

public class OProfilerEntry {
    public String name = null;
    public long entries = 0L;
    public long last = 0L;
    public long min = 999999999L;
    public long max = 0L;
    public float average = 0.0f;
    public long total = 0L;
    public final long firstExecution;
    public long lastExecution;
    public String payLoad;
    public String description;
    public long lastResetEntries = 0L;
    public long lastReset;
    public Set<String> users = new HashSet<String>();

    public OProfilerEntry() {
        this.lastExecution = this.firstExecution = System.currentTimeMillis();
    }

    public void updateLastExecution() {
        this.lastExecution = System.currentTimeMillis();
    }

    public ODocument toDocument() {
        ODocument doc = new ODocument();
        doc.field("entries", this.entries);
        doc.field("last", this.last);
        doc.field("min", this.min);
        doc.field("max", this.max);
        doc.field("average", Float.valueOf(this.average));
        doc.field("total", this.total);
        doc.field("firstExecution", this.firstExecution);
        doc.field("lastExecution", this.lastExecution);
        doc.field("lastReset", this.lastReset);
        doc.field("lastResetEntries", this.lastResetEntries);
        if (this.payLoad != null) {
            doc.field("payload", this.payLoad);
        }
        return doc;
    }

    public String toJSON() {
        StringBuilder buffer = new StringBuilder(1024);
        this.toJSON(buffer);
        return buffer.toString();
    }

    public void toJSON(StringBuilder buffer) {
        buffer.append('{');
        buffer.append(String.format(Locale.ENGLISH, "\"%s\":%d,", "entries", this.entries));
        buffer.append(String.format(Locale.ENGLISH, "\"%s\":%d,", "last", this.last));
        buffer.append(String.format(Locale.ENGLISH, "\"%s\":%d,", "min", this.min));
        buffer.append(String.format(Locale.ENGLISH, "\"%s\":%d,", "max", this.max));
        buffer.append(String.format(Locale.ENGLISH, "\"%s\":%.2f,", "average", Float.valueOf(this.average)));
        buffer.append(String.format(Locale.ENGLISH, "\"%s\":%d,", "total", this.total));
        buffer.append(String.format(Locale.ENGLISH, "\"%s\":%d,", "firstExecution", this.firstExecution));
        buffer.append(String.format(Locale.ENGLISH, "\"%s\":%d,", "lastExecution", this.lastExecution));
        buffer.append(String.format(Locale.ENGLISH, "\"%s\":%d,", "lastReset", this.lastReset));
        buffer.append(String.format(Locale.ENGLISH, "\"%s\":%d,", "lastResetEntries,", this.lastResetEntries));
        if (this.payLoad != null) {
            buffer.append(String.format(Locale.ENGLISH, "\"%s\":\"%s\"", "payload,", this.payLoad));
        }
        buffer.append(String.format(Locale.ENGLISH, "\"%s\": [", "users"));
        String usersList = "";
        int i = 0;
        for (String user : this.users) {
            buffer.append(String.format(Locale.ENGLISH, "%s\"%s\"", i > 0 ? "," : "", user));
            ++i;
        }
        buffer.append(String.format(Locale.ENGLISH, "%s", usersList));
        buffer.append(String.format(Locale.ENGLISH, "]", new Object[0]));
        buffer.append('}');
    }

    public String toString() {
        return String.format("Profiler entry [%s]: total=%d, average=%.2f, items=%d, last=%d, max=%d, min=%d", this.name, this.total, Float.valueOf(this.average), this.entries, this.last, this.max, this.min);
    }
}

