/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.client.remote;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.client.remote.ORemoteConnectionManager;
import com.orientechnologies.orient.client.remote.OStorageRemote;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.engine.OEngineAbstract;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.storage.OStorage;
import java.util.Map;

public class OEngineRemote
extends OEngineAbstract {
    public static final String NAME = "remote";
    public static final String PREFIX = "remote:";
    protected volatile ORemoteConnectionManager connectionManager;

    @Override
    public OStorage createStorage(String iURL, Map<String, String> iConfiguration) {
        try {
            return new OStorageRemote(null, iURL, "rw");
        }
        catch (Exception e) {
            String message = "Error on opening database: " + iURL;
            OLogManager.instance().error(this, message, e, new Object[0]);
            throw OException.wrapException(new ODatabaseException(message), e);
        }
    }

    @Override
    public void removeStorage(OStorage iStorage) {
    }

    @Override
    public void startup() {
        super.startup();
        this.connectionManager = new ORemoteConnectionManager(OGlobalConfiguration.NETWORK_LOCK_TIMEOUT.getValueAsLong());
    }

    @Override
    public void shutdown() {
        try {
            if (this.connectionManager != null) {
                this.connectionManager.close();
            }
        }
        finally {
            super.shutdown();
        }
    }

    @Override
    public String getNameFromPath(String dbPath) {
        return dbPath;
    }

    public ORemoteConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    @Override
    public String getName() {
        return NAME;
    }
}

