/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.compression;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.compression.OCompression;
import com.orientechnologies.orient.core.compression.impl.OGZIPCompression;
import com.orientechnologies.orient.core.compression.impl.OHighZIPCompression;
import com.orientechnologies.orient.core.compression.impl.OLowZIPCompression;
import com.orientechnologies.orient.core.compression.impl.ONothingCompression;
import com.orientechnologies.orient.core.compression.impl.OSnappyCompression;
import com.orientechnologies.orient.core.exception.OSecurityException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class OCompressionFactory {
    public static final OCompressionFactory INSTANCE = new OCompressionFactory();
    private final Map<String, OCompression> compressions = new HashMap<String, OCompression>();
    private final Map<String, Class<? extends OCompression>> compressionClasses = new HashMap<String, Class<? extends OCompression>>();

    public OCompressionFactory() {
        this.register(new OHighZIPCompression());
        this.register(new OLowZIPCompression());
        this.register(new OGZIPCompression());
        this.register(new OSnappyCompression());
        this.register(new ONothingCompression());
    }

    public OCompression getCompression(String name, String iOptions) {
        OCompression compression = this.compressions.get(name);
        if (compression == null) {
            Class compressionClass = name == null ? ONothingCompression.class : this.compressionClasses.get(name);
            if (compressionClass != null) {
                try {
                    compression = (OCompression)compressionClass.newInstance();
                    compression.configure(iOptions);
                }
                catch (Exception e) {
                    throw OException.wrapException(new OSecurityException("Cannot instantiate compression algorithm '" + name + "'"), e);
                }
            } else {
                throw new OSecurityException("Compression with name '" + name + "' is absent");
            }
        }
        return compression;
    }

    public void register(OCompression compression) {
        try {
            String name = compression.name();
            if (this.compressions.containsKey(name)) {
                throw new IllegalArgumentException("Compression with name '" + name + "' was already registered");
            }
            if (this.compressionClasses.containsKey(name)) {
                throw new IllegalArgumentException("Compression with name '" + name + "' was already registered");
            }
            this.compressions.put(name, compression);
        }
        catch (Exception e) {
            OLogManager.instance().error(this, "Cannot register storage compression algorithm '%s'", e, compression);
        }
    }

    public void register(Class<? extends OCompression> compression) {
        try {
            OCompression tempInstance = compression.newInstance();
            String name = tempInstance.name();
            if (this.compressions.containsKey(name)) {
                throw new IllegalArgumentException("Compression with name '" + name + "' was already registered");
            }
            if (this.compressionClasses.containsKey(tempInstance.name())) {
                throw new IllegalArgumentException("Compression with name '" + name + "' was already registered");
            }
            this.compressionClasses.put(name, compression);
        }
        catch (Exception e) {
            OLogManager.instance().error(this, "Cannot register storage compression algorithm '%s'", e, compression);
        }
    }

    public Set<String> getCompressions() {
        return this.compressions.keySet();
    }
}

