/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql;

import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.Comparator;

class OSoftQueryResultTimSort<E> {
    private static final int MIN_MERGE = 32;
    private final String query;
    private final ReferenceQueue<E> queue;

    OSoftQueryResultTimSort(String query, ReferenceQueue<E> queue) {
        this.query = query;
        this.queue = queue;
    }

    public void sort(SoftReference<E>[] a, int lo, int hi, Comparator<? super E> c) {
        int runLen;
        assert (c != null);
        int nRemaining = hi - lo;
        if (nRemaining < 2) {
            return;
        }
        if (nRemaining < 32) {
            int initRunLen = this.countRunAndMakeAscending(a, lo, hi, c);
            this.binarySort(a, lo, hi, lo + initRunLen, c);
            return;
        }
        SortState sortState = new SortState(a, c, hi - lo);
        int minRun = this.minRunLength(nRemaining);
        do {
            if ((runLen = this.countRunAndMakeAscending(a, lo, hi, c)) < minRun) {
                int force = nRemaining <= minRun ? nRemaining : minRun;
                this.binarySort(a, lo, lo + force, lo + runLen, c);
                runLen = force;
            }
            sortState.pushRun(lo, runLen);
            sortState.mergeCollapse();
            lo += runLen;
        } while ((nRemaining -= runLen) != 0);
        assert (lo == hi);
        sortState.mergeForceCollapse();
        assert (sortState.stackSize == 1);
    }

    private void binarySort(SoftReference<E>[] a, int lo, int hi, int start, Comparator<? super E> c) {
        assert (lo <= start && start <= hi);
        if (start == lo) {
            ++start;
        }
        while (start < hi) {
            SoftReference<E> pivot = a[start];
            int left = lo;
            int right = start;
            assert (left <= right);
            while (left < right) {
                int mid = left + right >>> 1;
                if (c.compare(this.getItem(pivot), this.getItem(a[mid])) < 0) {
                    right = mid;
                    continue;
                }
                left = mid + 1;
            }
            assert (left == right);
            int n = start - left;
            switch (n) {
                case 2: {
                    a[left + 2] = a[left + 1];
                }
                case 1: {
                    a[left + 1] = a[left];
                    break;
                }
                default: {
                    System.arraycopy(a, left, a, left + 1, n);
                }
            }
            a[left] = pivot;
            ++start;
        }
    }

    private int countRunAndMakeAscending(SoftReference<E>[] a, int lo, int hi, Comparator<? super E> c) {
        assert (lo < hi);
        int runHi = lo + 1;
        if (runHi == hi) {
            return 1;
        }
        if (c.compare(this.getItem(a[runHi++]), this.getItem(a[lo])) < 0) {
            while (runHi < hi && c.compare(this.getItem(a[runHi]), this.getItem(a[runHi - 1])) < 0) {
                ++runHi;
            }
            this.reverseRange(a, lo, runHi);
        } else {
            while (runHi < hi && c.compare(this.getItem(a[runHi]), this.getItem(a[runHi - 1])) >= 0) {
                ++runHi;
            }
        }
        return runHi - lo;
    }

    private E getItem(SoftReference<E> ref) {
        this.checkQueue();
        E result = ref.get();
        if (result == null) {
            this.throwCanExecuteException();
        }
        return result;
    }

    private void checkQueue() {
        if (this.queue.poll() != null) {
            this.throwCanExecuteException();
        }
    }

    private void throwCanExecuteException() {
        if (this.query != null) {
            throw new OCommandExecutionException("Cannot execute query \"" + this.query + "\": low heap memory");
        }
        throw new OCommandExecutionException("Cannot execute query: low heap memory");
    }

    private void reverseRange(SoftReference<E>[] a, int lo, int hi) {
        --hi;
        while (lo < hi) {
            SoftReference<E> t = a[lo];
            a[lo++] = a[hi];
            a[hi--] = t;
        }
    }

    private int minRunLength(int n) {
        assert (n >= 0);
        int r = 0;
        while (n >= 32) {
            r |= n & 1;
            n >>= 1;
        }
        return n + r;
    }

    private class SortState {
        private final SoftReference<E>[] a;
        private final int aLength;
        private final Comparator<? super E> c;
        private static final int MIN_GALLOP = 7;
        private int minGallop = 7;
        private static final int INITIAL_TMP_STORAGE_LENGTH = 256;
        private SoftReference<E>[] tmp;
        private int tmpLength = 0;
        private int stackSize = 0;
        private final int[] runBase;
        private final int[] runLen;

        private SortState(SoftReference<E>[] a, Comparator<? super E> c, int len) {
            this.aLength = len;
            this.a = a;
            this.c = c;
            this.tmpLength = len < 512 ? len >>> 1 : 256;
            this.tmp = new SoftReference[this.tmpLength];
            int stackLen = len < 120 ? 5 : (len < 1542 ? 10 : (len < 119151 ? 19 : 40));
            this.runBase = new int[stackLen];
            this.runLen = new int[stackLen];
        }

        private void pushRun(int runBase, int runLen) {
            this.runBase[this.stackSize] = runBase;
            this.runLen[this.stackSize] = runLen;
            ++this.stackSize;
        }

        private void mergeCollapse() {
            while (this.stackSize > 1) {
                int n = this.stackSize - 2;
                if (n >= 1 && this.runLen[n - 1] <= this.runLen[n] + this.runLen[n + 1] || n >= 2 && this.runLen[n - 2] <= this.runLen[n] + this.runLen[n - 1]) {
                    if (this.runLen[n - 1] < this.runLen[n + 1]) {
                        --n;
                    }
                } else if (this.runLen[n] > this.runLen[n + 1]) break;
                this.mergeAt(n);
            }
        }

        private void mergeForceCollapse() {
            while (this.stackSize > 1) {
                int n = this.stackSize - 2;
                if (n > 0 && this.runLen[n - 1] < this.runLen[n + 1]) {
                    --n;
                }
                this.mergeAt(n);
            }
        }

        private void mergeAt(int i) {
            assert (this.stackSize >= 2);
            assert (i >= 0);
            assert (i == this.stackSize - 2 || i == this.stackSize - 3);
            int base1 = this.runBase[i];
            int len1 = this.runLen[i];
            int base2 = this.runBase[i + 1];
            int len2 = this.runLen[i + 1];
            assert (len1 > 0 && len2 > 0);
            assert (base1 + len1 == base2);
            this.runLen[i] = len1 + len2;
            if (i == this.stackSize - 3) {
                this.runBase[i + 1] = this.runBase[i + 2];
                this.runLen[i + 1] = this.runLen[i + 2];
            }
            --this.stackSize;
            int k = this.gallopRight(this.a[base2], this.a, base1, len1, 0, this.c);
            assert (k >= 0);
            base1 += k;
            if ((len1 -= k) == 0) {
                return;
            }
            len2 = this.gallopLeft(this.a[base1 + len1 - 1], this.a, base2, len2, len2 - 1, this.c);
            assert (len2 >= 0);
            if (len2 == 0) {
                return;
            }
            if (len1 <= len2) {
                this.mergeLo(base1, len1, base2, len2);
            } else {
                this.mergeHi(base1, len1, base2, len2);
            }
        }

        private int gallopLeft(SoftReference<E> key, SoftReference<E>[] a, int base, int len, int hint, Comparator<? super E> c) {
            int maxOfs;
            assert (len > 0 && hint >= 0 && hint < len);
            int lastOfs = 0;
            int ofs = 1;
            if (c.compare(OSoftQueryResultTimSort.this.getItem(key), OSoftQueryResultTimSort.this.getItem(a[base + hint])) > 0) {
                maxOfs = len - hint;
                while (ofs < maxOfs && c.compare(OSoftQueryResultTimSort.this.getItem(key), OSoftQueryResultTimSort.this.getItem(a[base + hint + ofs])) > 0) {
                    lastOfs = ofs;
                    if ((ofs = (ofs << 1) + 1) > 0) continue;
                    ofs = maxOfs;
                }
                if (ofs > maxOfs) {
                    ofs = maxOfs;
                }
                lastOfs += hint;
                ofs += hint;
            } else {
                maxOfs = hint + 1;
                while (ofs < maxOfs && c.compare(OSoftQueryResultTimSort.this.getItem(key), OSoftQueryResultTimSort.this.getItem(a[base + hint - ofs])) <= 0) {
                    lastOfs = ofs;
                    if ((ofs = (ofs << 1) + 1) > 0) continue;
                    ofs = maxOfs;
                }
                if (ofs > maxOfs) {
                    ofs = maxOfs;
                }
                int tmp = lastOfs;
                lastOfs = hint - ofs;
                ofs = hint - tmp;
            }
            assert (-1 <= lastOfs && lastOfs < ofs && ofs <= len);
            ++lastOfs;
            while (lastOfs < ofs) {
                int m = lastOfs + (ofs - lastOfs >>> 1);
                if (c.compare(OSoftQueryResultTimSort.this.getItem(key), OSoftQueryResultTimSort.this.getItem(a[base + m])) > 0) {
                    lastOfs = m + 1;
                    continue;
                }
                ofs = m;
            }
            assert (lastOfs == ofs);
            return ofs;
        }

        private int gallopRight(SoftReference<E> key, SoftReference<E>[] a, int base, int len, int hint, Comparator<? super E> c) {
            int maxOfs;
            assert (len > 0 && hint >= 0 && hint < len);
            int ofs = 1;
            int lastOfs = 0;
            if (c.compare(OSoftQueryResultTimSort.this.getItem(key), OSoftQueryResultTimSort.this.getItem(a[base + hint])) < 0) {
                maxOfs = hint + 1;
                while (ofs < maxOfs && c.compare(OSoftQueryResultTimSort.this.getItem(key), OSoftQueryResultTimSort.this.getItem(a[base + hint - ofs])) < 0) {
                    lastOfs = ofs;
                    if ((ofs = (ofs << 1) + 1) > 0) continue;
                    ofs = maxOfs;
                }
                if (ofs > maxOfs) {
                    ofs = maxOfs;
                }
                int tmp = lastOfs;
                lastOfs = hint - ofs;
                ofs = hint - tmp;
            } else {
                maxOfs = len - hint;
                while (ofs < maxOfs && c.compare(OSoftQueryResultTimSort.this.getItem(key), OSoftQueryResultTimSort.this.getItem(a[base + hint + ofs])) >= 0) {
                    lastOfs = ofs;
                    if ((ofs = (ofs << 1) + 1) > 0) continue;
                    ofs = maxOfs;
                }
                if (ofs > maxOfs) {
                    ofs = maxOfs;
                }
                lastOfs += hint;
                ofs += hint;
            }
            assert (-1 <= lastOfs && lastOfs < ofs && ofs <= len);
            ++lastOfs;
            while (lastOfs < ofs) {
                int m = lastOfs + (ofs - lastOfs >>> 1);
                if (c.compare(OSoftQueryResultTimSort.this.getItem(key), OSoftQueryResultTimSort.this.getItem(a[base + m])) < 0) {
                    ofs = m;
                    continue;
                }
                lastOfs = m + 1;
            }
            assert (lastOfs == ofs);
            return ofs;
        }

        private void mergeLo(int base1, int len1, int base2, int len2) {
            assert (len1 > 0 && len2 > 0 && base1 + len1 == base2);
            SoftReference<E>[] a = this.a;
            SoftReference<E>[] tmp = this.ensureCapacity(len1);
            System.arraycopy(a, base1, tmp, 0, len1);
            int cursor1 = 0;
            int cursor2 = base2;
            int dest = base1;
            a[dest++] = a[cursor2++];
            if (--len2 == 0) {
                System.arraycopy(tmp, cursor1, a, dest, len1);
                return;
            }
            if (len1 == 1) {
                System.arraycopy(a, cursor2, a, dest, len2);
                a[dest + len2] = tmp[cursor1];
                return;
            }
            Comparator c = this.c;
            int minGallop = this.minGallop;
            block0: while (true) {
                int count1 = 0;
                int count2 = 0;
                do {
                    assert (len1 > 1 && len2 > 0);
                    if (c.compare(OSoftQueryResultTimSort.this.getItem(a[cursor2]), OSoftQueryResultTimSort.this.getItem(tmp[cursor1])) < 0) {
                        a[dest++] = a[cursor2++];
                        ++count2;
                        count1 = 0;
                        if (--len2 != 0) continue;
                        break block0;
                    }
                    a[dest++] = tmp[cursor1++];
                    ++count1;
                    count2 = 0;
                    if (--len1 == 1) break block0;
                } while ((count1 | count2) < minGallop);
                do {
                    assert (len1 > 1 && len2 > 0);
                    count1 = this.gallopRight(a[cursor2], tmp, cursor1, len1, 0, c);
                    if (count1 != 0) {
                        System.arraycopy(tmp, cursor1, a, dest, count1);
                        dest += count1;
                        cursor1 += count1;
                        if ((len1 -= count1) <= 1) break block0;
                    }
                    a[dest++] = a[cursor2++];
                    if (--len2 == 0) break block0;
                    count2 = this.gallopLeft(tmp[cursor1], a, cursor2, len2, 0, c);
                    if (count2 != 0) {
                        System.arraycopy(a, cursor2, a, dest, count2);
                        dest += count2;
                        cursor2 += count2;
                        if ((len2 -= count2) == 0) break block0;
                    }
                    a[dest++] = tmp[cursor1++];
                    if (--len1 == 1) break block0;
                    --minGallop;
                } while (count1 >= 7 | count2 >= 7);
                if (minGallop < 0) {
                    minGallop = 0;
                }
                minGallop += 2;
            }
            int n = this.minGallop = minGallop < 1 ? 1 : minGallop;
            if (len1 == 1) {
                assert (len2 > 0);
                System.arraycopy(a, cursor2, a, dest, len2);
                a[dest + len2] = tmp[cursor1];
            } else {
                if (len1 == 0) {
                    throw new IllegalArgumentException("Comparison method violates its general contract!");
                }
                assert (len2 == 0);
                assert (len1 > 1);
                System.arraycopy(tmp, cursor1, a, dest, len1);
            }
        }

        private void mergeHi(int base1, int len1, int base2, int len2) {
            assert (len1 > 0 && len2 > 0 && base1 + len1 == base2);
            SoftReference<E>[] a = this.a;
            SoftReference<E>[] tmp = this.ensureCapacity(len2);
            System.arraycopy(a, base2, tmp, 0, len2);
            int cursor1 = base1 + len1 - 1;
            int cursor2 = len2 - 1;
            int dest = base2 + len2 - 1;
            a[dest--] = a[cursor1--];
            if (--len1 == 0) {
                System.arraycopy(tmp, 0, a, dest - (len2 - 1), len2);
                return;
            }
            if (len2 == 1) {
                System.arraycopy(a, (cursor1 -= len1) + 1, a, (dest -= len1) + 1, len1);
                a[dest] = tmp[cursor2];
                return;
            }
            Comparator c = this.c;
            int minGallop = this.minGallop;
            block0: while (true) {
                int count1 = 0;
                int count2 = 0;
                do {
                    assert (len1 > 0 && len2 > 1);
                    if (c.compare(OSoftQueryResultTimSort.this.getItem(tmp[cursor2]), OSoftQueryResultTimSort.this.getItem(a[cursor1])) < 0) {
                        a[dest--] = a[cursor1--];
                        ++count1;
                        count2 = 0;
                        if (--len1 != 0) continue;
                        break block0;
                    }
                    a[dest--] = tmp[cursor2--];
                    ++count2;
                    count1 = 0;
                    if (--len2 == 1) break block0;
                } while ((count1 | count2) < minGallop);
                do {
                    assert (len1 > 0 && len2 > 1);
                    count1 = len1 - this.gallopRight(tmp[cursor2], a, base1, len1, len1 - 1, c);
                    if (count1 != 0) {
                        System.arraycopy(a, (cursor1 -= count1) + 1, a, (dest -= count1) + 1, count1);
                        if ((len1 -= count1) == 0) break block0;
                    }
                    a[dest--] = tmp[cursor2--];
                    if (--len2 == 1) break block0;
                    count2 = len2 - this.gallopLeft(a[cursor1], tmp, 0, len2, len2 - 1, c);
                    if (count2 != 0) {
                        System.arraycopy(tmp, (cursor2 -= count2) + 1, a, (dest -= count2) + 1, count2);
                        if ((len2 -= count2) <= 1) break block0;
                    }
                    a[dest--] = a[cursor1--];
                    if (--len1 == 0) break block0;
                    --minGallop;
                } while (count1 >= 7 | count2 >= 7);
                if (minGallop < 0) {
                    minGallop = 0;
                }
                minGallop += 2;
            }
            int n = this.minGallop = minGallop < 1 ? 1 : minGallop;
            if (len2 == 1) {
                assert (len1 > 0);
                System.arraycopy(a, (cursor1 -= len1) + 1, a, (dest -= len1) + 1, len1);
                a[dest] = tmp[cursor2];
            } else {
                if (len2 == 0) {
                    throw new IllegalArgumentException("Comparison method violates its general contract!");
                }
                assert (len1 == 0);
                assert (len2 > 0);
                System.arraycopy(tmp, 0, a, dest - (len2 - 1), len2);
            }
        }

        private SoftReference<E>[] ensureCapacity(int minCapacity) {
            if (this.tmpLength < minCapacity) {
                int newSize = minCapacity;
                newSize |= newSize >> 1;
                newSize |= newSize >> 2;
                newSize |= newSize >> 4;
                newSize |= newSize >> 8;
                newSize |= newSize >> 16;
                newSize = ++newSize < 0 ? minCapacity : Math.min(newSize, this.aLength >>> 1);
                this.tmp = new SoftReference[newSize];
                this.tmpLength = newSize;
            }
            return this.tmp;
        }
    }
}

