/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.sql.OSQLEngine;
import com.orientechnologies.orient.core.sql.functions.OIndexableSQLFunction;
import com.orientechnologies.orient.core.sql.functions.OSQLFunction;
import com.orientechnologies.orient.core.sql.parser.OBinaryCompareOperator;
import com.orientechnologies.orient.core.sql.parser.OExpression;
import com.orientechnologies.orient.core.sql.parser.OFromClause;
import com.orientechnologies.orient.core.sql.parser.OIdentifier;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import com.orientechnologies.orient.core.sql.parser.OrientSqlVisitor;
import com.orientechnologies.orient.core.sql.parser.SimpleNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class OFunctionCall
extends SimpleNode {
    protected OIdentifier name;
    protected boolean star = false;
    protected List<OExpression> params = new ArrayList<OExpression>();

    public OFunctionCall(int id) {
        super(id);
    }

    public OFunctionCall(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public Object jjtAccept(OrientSqlVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public boolean isStar() {
        return this.star;
    }

    public void setStar(boolean star) {
        this.star = star;
    }

    public List<OExpression> getParams() {
        return this.params;
    }

    public void setParams(List<OExpression> params) {
        this.params = params;
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        this.name.toString(params, builder);
        builder.append("(");
        if (this.star) {
            builder.append("*");
        } else {
            boolean first = true;
            for (OExpression expr : this.params) {
                if (!first) {
                    builder.append(", ");
                }
                expr.toString(params, builder);
                first = false;
            }
        }
        builder.append(")");
    }

    public Object execute(Object targetObjects, OCommandContext ctx) {
        return this.execute(targetObjects, ctx, this.name.getStringValue());
    }

    private Object execute(Object targetObjects, OCommandContext ctx, String name) {
        OIdentifiable record;
        ArrayList<Object> paramValues = new ArrayList<Object>();
        OIdentifiable oIdentifiable = record = ctx == null ? null : (OIdentifiable)ctx.getVariable("$current");
        if (record == null && targetObjects instanceof OIdentifiable) {
            record = (OIdentifiable)targetObjects;
        }
        for (OExpression expr : this.params) {
            paramValues.add(expr.execute(record, ctx));
        }
        OSQLFunction function = OSQLEngine.getInstance().getFunction(name);
        if (function != null) {
            return function.execute(targetObjects, record, null, paramValues.toArray(), ctx);
        }
        throw new UnsupportedOperationException("This expression is not currently supported: " + this.toString());
    }

    public static ODatabaseDocumentInternal getDatabase() {
        return ODatabaseRecordThreadLocal.instance().get();
    }

    public boolean isIndexedFunctionCall() {
        OSQLFunction function = OSQLEngine.getInstance().getFunction(this.name.getStringValue());
        return function instanceof OIndexableSQLFunction;
    }

    public Iterable<OIdentifiable> executeIndexedFunction(OFromClause target, OCommandContext ctx, OBinaryCompareOperator operator, Object rightValue) {
        OSQLFunction function = OSQLEngine.getInstance().getFunction(this.name.getStringValue());
        if (function instanceof OIndexableSQLFunction) {
            return ((OIndexableSQLFunction)function).searchFromTarget(target, operator, rightValue, ctx, this.getParams().toArray(new OExpression[0]));
        }
        return null;
    }

    public long estimateIndexedFunction(OFromClause target, OCommandContext ctx, OBinaryCompareOperator operator, Object rightValue) {
        OSQLFunction function = OSQLEngine.getInstance().getFunction(this.name.getStringValue());
        if (function instanceof OIndexableSQLFunction) {
            return ((OIndexableSQLFunction)function).estimate(target, operator, rightValue, ctx, this.getParams().toArray(new OExpression[0]));
        }
        return -1L;
    }
}

