/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.sql.OSQLEngine;
import com.orientechnologies.orient.core.sql.functions.OSQLFunction;
import com.orientechnologies.orient.core.sql.functions.OSQLFunctionFiltered;
import com.orientechnologies.orient.core.sql.method.OSQLMethod;
import com.orientechnologies.orient.core.sql.parser.OExpression;
import com.orientechnologies.orient.core.sql.parser.OIdentifier;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import com.orientechnologies.orient.core.sql.parser.OrientSqlVisitor;
import com.orientechnologies.orient.core.sql.parser.SimpleNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class OMethodCall
extends SimpleNode {
    static Set<String> graphMethods = new HashSet<String>(Arrays.asList("out", "in", "both", "outE", "inE", "bothE", "bothV", "outV", "inV"));
    static Set<String> bidirectionalMethods = new HashSet<String>(Arrays.asList("out", "in", "both", "oute", "ine", "inv", "outv"));
    protected OIdentifier methodName;
    protected List<OExpression> params = new ArrayList<OExpression>();

    public OMethodCall(int id) {
        super(id);
    }

    public OMethodCall(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public Object jjtAccept(OrientSqlVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        builder.append(".");
        this.methodName.toString(params, builder);
        builder.append("(");
        boolean first = true;
        for (OExpression param : this.params) {
            if (!first) {
                builder.append(", ");
            }
            param.toString(params, builder);
            first = false;
        }
        builder.append(")");
    }

    public boolean isBidirectional() {
        return bidirectionalMethods.contains(this.methodName.getStringValue().toLowerCase(Locale.ENGLISH));
    }

    public Object execute(Object targetObjects, OCommandContext ctx) {
        return this.execute(targetObjects, ctx, this.methodName.getStringValue(), this.params, null);
    }

    public Object execute(Object targetObjects, Iterable<OIdentifiable> iPossibleResults, OCommandContext ctx) {
        return this.execute(targetObjects, ctx, this.methodName.getStringValue(), this.params, iPossibleResults);
    }

    private Object execute(Object targetObjects, OCommandContext ctx, String name, List<OExpression> iParams, Iterable<OIdentifiable> iPossibleResults) {
        ArrayList<Object> paramValues = new ArrayList<Object>();
        for (OExpression expr : iParams) {
            paramValues.add(expr.execute((OIdentifiable)ctx.getVariable("$current"), ctx));
        }
        if (graphMethods.contains(name)) {
            OSQLFunction function = OSQLEngine.getInstance().getFunction(name);
            if (function instanceof OSQLFunctionFiltered) {
                return ((OSQLFunctionFiltered)function).execute(targetObjects, (OIdentifiable)ctx.getVariable("$current"), null, paramValues.toArray(), iPossibleResults, ctx);
            }
            return function.execute(targetObjects, (OIdentifiable)ctx.getVariable("$current"), null, paramValues.toArray(), ctx);
        }
        OSQLMethod method = OSQLEngine.getMethod(name);
        if (method != null) {
            return method.execute(targetObjects, (OIdentifiable)ctx.getVariable("$current"), ctx, targetObjects, paramValues.toArray());
        }
        throw new UnsupportedOperationException("OMethod call, something missing in the implementation...?");
    }

    public Object executeReverse(Object targetObjects, OCommandContext ctx) {
        if (!this.isBidirectional()) {
            throw new UnsupportedOperationException();
        }
        String straightName = this.methodName.getStringValue();
        if (straightName.equalsIgnoreCase("out")) {
            return this.execute(targetObjects, ctx, "in", this.params, null);
        }
        if (straightName.equalsIgnoreCase("in")) {
            return this.execute(targetObjects, ctx, "out", this.params, null);
        }
        if (straightName.equalsIgnoreCase("both")) {
            return this.execute(targetObjects, ctx, "both", this.params, null);
        }
        if (straightName.equalsIgnoreCase("outE")) {
            return this.execute(targetObjects, ctx, "outV", this.params, null);
        }
        if (straightName.equalsIgnoreCase("outV")) {
            return this.execute(targetObjects, ctx, "outE", this.params, null);
        }
        if (straightName.equalsIgnoreCase("inE")) {
            return this.execute(targetObjects, ctx, "inV", this.params, null);
        }
        if (straightName.equalsIgnoreCase("inV")) {
            return this.execute(targetObjects, ctx, "inE", this.params, null);
        }
        throw new UnsupportedOperationException("Invalid reverse traversal: " + this.methodName);
    }

    public static ODatabaseDocumentInternal getDatabase() {
        return ODatabaseRecordThreadLocal.instance().get();
    }
}

