/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.sql.parser.OBinaryCompareOperator;
import com.orientechnologies.orient.core.sql.parser.OBooleanExpression;
import com.orientechnologies.orient.core.sql.parser.OExpression;
import com.orientechnologies.orient.core.sql.parser.OInputParameter;
import com.orientechnologies.orient.core.sql.parser.OMathExpression;
import com.orientechnologies.orient.core.sql.parser.OSelectStatement;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import com.orientechnologies.orient.core.sql.parser.OrientSqlVisitor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ONotInCondition
extends OBooleanExpression {
    protected OExpression left;
    protected OBinaryCompareOperator operator;
    protected OSelectStatement rightStatement;
    protected Object right;
    protected OInputParameter rightParam;
    protected OMathExpression rightMathExpression;
    private static final Object UNSET = new Object();
    private Object inputFinalValue = UNSET;

    public ONotInCondition(int id) {
        super(id);
    }

    public ONotInCondition(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public Object jjtAccept(OrientSqlVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    @Override
    public boolean evaluate(OIdentifiable currentRecord, OCommandContext ctx) {
        return false;
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        this.left.toString(params, builder);
        builder.append(" NOT IN ");
        if (this.rightStatement != null) {
            builder.append("(");
            this.rightStatement.toString(params, builder);
            builder.append(")");
        } else if (this.right != null) {
            builder.append(this.convertToString(this.right));
        } else if (this.rightParam != null) {
            this.rightParam.toString(params, builder);
        } else if (this.rightMathExpression != null) {
            this.rightMathExpression.toString(params, builder);
        }
    }

    private String convertToString(Object o) {
        if (o instanceof String) {
            return "\"" + ((String)o).replaceAll("\"", "\\\"") + "\"";
        }
        return o.toString();
    }

    @Override
    public boolean supportsBasicCalculation() {
        if (this.operator != null && !this.operator.supportsBasicCalculation()) {
            return false;
        }
        if (this.left != null && !this.left.supportsBasicCalculation()) {
            return false;
        }
        return this.rightMathExpression == null || this.rightMathExpression.supportsBasicCalculation();
    }

    @Override
    protected int getNumberOfExternalCalculations() {
        int total = 0;
        if (this.operator != null && !this.operator.supportsBasicCalculation()) {
            ++total;
        }
        if (this.left != null && !this.left.supportsBasicCalculation()) {
            ++total;
        }
        if (this.rightMathExpression != null && !this.rightMathExpression.supportsBasicCalculation()) {
            ++total;
        }
        return total;
    }

    @Override
    protected List<Object> getExternalCalculationConditions() {
        ArrayList<Object> result = new ArrayList<Object>();
        if (this.operator != null && !this.operator.supportsBasicCalculation()) {
            result.add(this);
        }
        if (this.rightMathExpression != null && !this.rightMathExpression.supportsBasicCalculation()) {
            result.add(this.rightMathExpression);
        }
        return result;
    }

    @Override
    public List<String> getMatchPatternInvolvedAliases() {
        List<String> leftX = this.left == null ? null : this.left.getMatchPatternInvolvedAliases();
        List<String> rightX = this.rightMathExpression == null ? null : this.rightMathExpression.getMatchPatternInvolvedAliases();
        ArrayList<String> result = new ArrayList<String>();
        if (leftX != null) {
            result.addAll(leftX);
        }
        if (rightX != null) {
            result.addAll(rightX);
        }
        return result.size() == 0 ? null : result;
    }
}

