/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.http.command.post;

import com.orientechnologies.common.util.OPatternConst;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OPropertyImpl;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.serializer.record.string.ORecordSerializerStringAbstract;
import com.orientechnologies.orient.server.network.protocol.http.OHttpRequest;
import com.orientechnologies.orient.server.network.protocol.http.OHttpResponse;
import com.orientechnologies.orient.server.network.protocol.http.command.OServerCommandAuthenticatedDbAbstract;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class OServerCommandPostStudio
extends OServerCommandAuthenticatedDbAbstract {
    private static final String[] NAMES = new String[]{"POST|studio/*"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(OHttpRequest iRequest, OHttpResponse iResponse) throws Exception {
        ODatabase db = null;
        try {
            String[] params;
            String[] urlParts = this.checkSyntax(iRequest.url, 3, "Syntax error: studio/<database>/<context>");
            db = this.getProfiledDatabaseInstance(iRequest);
            String req = iRequest.content;
            String operation = null;
            String rid = null;
            String className = null;
            HashMap<String, String> fields = new HashMap<String, String>();
            for (String p : params = req.split("&")) {
                String value;
                String[] pairs = p.split("=");
                String string = value = pairs.length == 1 ? null : pairs[1];
                if ("oper".equals(pairs[0])) {
                    operation = value;
                    continue;
                }
                if ("0".equals(pairs[0])) {
                    rid = value;
                    continue;
                }
                if ("1".equals(pairs[0])) {
                    className = value;
                    continue;
                }
                if (pairs[0].startsWith("@class")) {
                    className = value;
                    continue;
                }
                if (pairs[0].startsWith("@") || pairs[0].equals("id")) continue;
                fields.put(pairs[0], value);
            }
            String context = urlParts[2];
            if ("document".equals(context)) {
                this.executeDocument(iRequest, iResponse, (ODatabaseDocument)db, operation, rid, className, fields);
            } else if ("classes".equals(context)) {
                this.executeClasses(iRequest, iResponse, (ODatabaseDocument)db, operation, rid, className, fields);
            } else if ("clusters".equals(context)) {
                this.executeClusters(iRequest, iResponse, (ODatabaseDocument)db, operation, rid, className, fields);
            } else if ("classProperties".equals(context)) {
                this.executeClassProperties(iRequest, iResponse, (ODatabaseDocument)db, operation, rid, className, fields);
            } else if ("classIndexes".equals(context)) {
                this.executeClassIndexes(iRequest, iResponse, (ODatabaseDocument)db, operation, rid, className, fields);
            }
        }
        finally {
            if (db != null) {
                db.close();
            }
        }
        return false;
    }

    private void executeClassProperties(OHttpRequest iRequest, OHttpResponse iResponse, ODatabaseDocument db, String operation, String rid, String className, Map<String, String> fields) throws IOException {
        OClass cls = db.getMetadata().getSchema().getClass(rid);
        if (cls == null) {
            iResponse.send(500, "Error", "text/plain", "Error: Class '" + rid + "' not found.", null);
            return;
        }
        if ("add".equals(operation)) {
            iRequest.data.commandInfo = "Studio add property";
            try {
                OType type = OType.valueOf(fields.get("type"));
                OPropertyImpl prop = type == OType.LINK || type == OType.LINKLIST || type == OType.LINKSET || type == OType.LINKMAP ? (OPropertyImpl)cls.createProperty(fields.get("name"), type, db.getMetadata().getSchema().getClass(fields.get("linkedClass"))) : (OPropertyImpl)cls.createProperty(fields.get("name"), type);
                if (fields.get("linkedType") != null) {
                    prop.setLinkedType(OType.valueOf(fields.get("linkedType")));
                }
                if (fields.get("mandatory") != null) {
                    prop.setMandatory("on".equals(fields.get("mandatory")));
                }
                if (fields.get("readonly") != null) {
                    prop.setReadonly("on".equals(fields.get("readonly")));
                }
                if (fields.get("notNull") != null) {
                    prop.setNotNull("on".equals(fields.get("notNull")));
                }
                if (fields.get("min") != null) {
                    prop.setMin(fields.get("min"));
                }
                if (fields.get("max") != null) {
                    prop.setMax(fields.get("max"));
                }
                iResponse.send(200, "OK", "text/plain", "Property " + fields.get("name") + " created successfully", null);
            }
            catch (Exception e) {
                iResponse.send(500, "Error on creating a new property in class " + rid + ": " + e, "text/plain", "Error on creating a new property in class " + rid + ": " + e, null);
            }
        } else if ("del".equals(operation)) {
            iRequest.data.commandInfo = "Studio delete property";
            cls.dropProperty(className);
            iResponse.send(200, "OK", "text/plain", "Property " + fields.get("name") + " deleted successfully.", null);
        }
    }

    private void executeClasses(OHttpRequest iRequest, OHttpResponse iResponse, ODatabaseDocument db, String operation, String rid, String className, Map<String, String> fields) throws IOException {
        if ("add".equals(operation)) {
            iRequest.data.commandInfo = "Studio add class";
            try {
                String superClassName = fields.get("superClass");
                OClass superClass = superClassName != null ? db.getMetadata().getSchema().getClass(superClassName) : null;
                OClass cls = db.getMetadata().getSchema().createClass(fields.get("name"), superClass);
                String alias = fields.get("alias");
                if (alias != null) {
                    cls.setShortName(alias);
                }
                iResponse.send(200, "OK", "text/plain", "Class '" + rid + "' created successfully with id=" + db.getMetadata().getSchema().getClasses().size(), null);
            }
            catch (Exception e) {
                iResponse.send(500, "Error on creating the new class '" + rid + "': " + e, "text/plain", "Error on creating the new class '" + rid + "': " + e, null);
            }
        } else if ("del".equals(operation)) {
            iRequest.data.commandInfo = "Studio delete class";
            db.getMetadata().getSchema().dropClass(rid);
            iResponse.send(200, "OK", "text/plain", "Class '" + rid + "' deleted successfully.", null);
        }
    }

    private void executeClusters(OHttpRequest iRequest, OHttpResponse iResponse, ODatabaseDocument db, String operation, String rid, String iClusterName, Map<String, String> fields) throws IOException {
        if ("add".equals(operation)) {
            iRequest.data.commandInfo = "Studio add cluster";
            int clusterId = db.addCluster(fields.get("name"), new Object[0]);
            iResponse.send(200, "OK", "text/plain", "Cluster " + fields.get("name") + "' created successfully with id=" + clusterId, null);
        } else if ("del".equals(operation)) {
            iRequest.data.commandInfo = "Studio delete cluster";
            db.dropCluster(rid, false);
            iResponse.send(200, "OK", "text/plain", "Cluster " + fields.get("name") + "' deleted successfully", null);
        }
    }

    private void executeDocument(OHttpRequest iRequest, OHttpResponse iResponse, ODatabaseDocument db, String operation, String rid, String className, Map<String, String> fields) throws IOException {
        if ("edit".equals(operation)) {
            iRequest.data.commandInfo = "Studio edit document";
            if (rid == null) {
                throw new IllegalArgumentException("Record ID not found in request");
            }
            ODocument doc = new ODocument(className, new ORecordId(rid));
            doc.reload(null, true);
            for (Map.Entry<String, String> f : fields.entrySet()) {
                Object oldValue = doc.rawField(f.getKey());
                String userValue = f.getValue();
                if (userValue != null && userValue.equals("undefined")) {
                    doc.removeField(f.getKey());
                    continue;
                }
                ArrayList<Object> newValue = ORecordSerializerStringAbstract.getTypeValue(userValue);
                if (newValue != null && newValue instanceof Collection) {
                    ArrayList<Object> array = new ArrayList<Object>();
                    for (String s : (Collection)newValue) {
                        Object v = ORecordSerializerStringAbstract.getTypeValue(s);
                        array.add(v);
                    }
                    newValue = array;
                }
                if (oldValue != null && oldValue.equals(userValue)) continue;
                doc.field(f.getKey(), newValue);
            }
            doc.save();
            iResponse.send(200, "OK", "text/plain", "Record " + rid + " updated successfully.", null);
        } else if ("add".equals(operation)) {
            iRequest.data.commandInfo = "Studio create document";
            ODocument doc = new ODocument(className);
            for (Map.Entry<String, String> f : fields.entrySet()) {
                doc.field(f.getKey(), f.getValue());
            }
            doc.save();
            iResponse.send(201, "OK", "text/plain", "Record " + doc.getIdentity() + " updated successfully.", null);
        } else if ("del".equals(operation)) {
            iRequest.data.commandInfo = "Studio delete document";
            if (rid == null) {
                throw new IllegalArgumentException("Record ID not found in request");
            }
            ODocument doc = new ODocument(new ORecordId(rid));
            doc.load();
            doc.delete();
            iResponse.send(200, "OK", "text/plain", "Record " + rid + " deleted successfully.", null);
        } else {
            iResponse.send(500, "Error", "text/plain", "Operation not supported", null);
        }
    }

    private void executeClassIndexes(OHttpRequest iRequest, OHttpResponse iResponse, ODatabaseDocument db, String operation, String rid, String className, Map<String, String> fields) throws IOException {
        OClass cls = db.getMetadata().getSchema().getClass(rid);
        if (cls == null) {
            iResponse.send(500, "Error", "text/plain", "Error: Class '" + rid + "' not found.", null);
            return;
        }
        if ("add".equals(operation)) {
            iRequest.data.commandInfo = "Studio add index";
            try {
                String[] fieldNames = OPatternConst.PATTERN_COMMA_SEPARATED.split(fields.get("fields").trim());
                String indexType = fields.get("type");
                cls.createIndex(fields.get("name"), indexType, fieldNames);
                iResponse.send(200, "OK", "text/plain", "Index " + fields.get("name") + " created successfully", null);
            }
            catch (Exception e) {
                iResponse.send(500, "Error on creating a new index for class " + rid + ": " + e, "text/plain", "Error on creating a new index for class " + rid + ": " + e, null);
            }
        } else if ("del".equals(operation)) {
            iRequest.data.commandInfo = "Studio delete index";
            try {
                OIndex<?> index = cls.getClassIndex(className);
                if (index == null) {
                    iResponse.send(500, "Error", "text/plain", "Error: Index '" + className + "' not found in class '" + rid + "'.", null);
                    return;
                }
                db.getMetadata().getIndexManager().dropIndex(index.getName());
                iResponse.send(200, "OK", "text/plain", "Index " + className + " deleted successfully.", null);
            }
            catch (Exception e) {
                iResponse.send(500, "Error on deletion index '" + className + "' for class " + rid + ": " + e, "text/plain", "Error on deletion index '" + className + "' for class " + rid + ": " + e, null);
            }
        } else {
            iResponse.send(500, "Error", "text/plain", "Operation not supported", null);
        }
    }

    @Override
    public String[] getNames() {
        return NAMES;
    }
}

