/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.stresstest;

import com.orientechnologies.orient.client.remote.OServerAdmin;
import com.orientechnologies.orient.client.remote.OStorageRemote;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.stresstest.ODatabaseIdentifier;

public class ODatabaseUtils {
    public static void createDatabase(ODatabaseIdentifier databaseIdentifier) throws Exception {
        switch (databaseIdentifier.getMode()) {
            case PLOCAL: 
            case MEMORY: {
                ODatabaseDocumentTx db = new ODatabaseDocumentTx(databaseIdentifier.getUrl());
                if (db.exists()) break;
                db.create();
                break;
            }
            case REMOTE: {
                OServerAdmin adm = new OServerAdmin(databaseIdentifier.getUrl()).connect("root", databaseIdentifier.getPassword());
                if (adm.existsDatabase()) break;
                adm.createDatabase(databaseIdentifier.getName(), "document", "plocal");
            }
        }
    }

    public static ODatabase openDatabase(ODatabaseIdentifier databaseIdentifier, OStorageRemote.CONNECTION_STRATEGY connectionStrategy) {
        ODatabaseDocumentTx database = null;
        switch (databaseIdentifier.getMode()) {
            case PLOCAL: 
            case MEMORY: {
                database = (ODatabaseDocumentTx)new ODatabaseDocumentTx(databaseIdentifier.getUrl()).open("admin", "admin");
                break;
            }
            case REMOTE: {
                database = new ODatabaseDocumentTx(databaseIdentifier.getUrl());
                database.setProperty("connectionStrategy", connectionStrategy.toString());
                database.open("root", databaseIdentifier.getPassword());
            }
        }
        return database;
    }

    public static void dropDatabase(ODatabaseIdentifier databaseIdentifier) throws Exception {
        switch (databaseIdentifier.getMode()) {
            case PLOCAL: 
            case MEMORY: {
                ODatabaseUtils.openDatabase(databaseIdentifier, OStorageRemote.CONNECTION_STRATEGY.STICKY).drop();
                break;
            }
            case REMOTE: {
                new OServerAdmin(databaseIdentifier.getUrl()).connect("root", databaseIdentifier.getPassword()).dropDatabase(databaseIdentifier.getName(), "plocal");
            }
        }
    }
}

