/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.util.wrappers.id;

import com.tinkerpop.blueprints.CloseableIterable;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Index;
import com.tinkerpop.blueprints.util.wrappers.id.IdEdge;
import com.tinkerpop.blueprints.util.wrappers.id.IdEdgeIterable;
import com.tinkerpop.blueprints.util.wrappers.id.IdGraph;

public class IdEdgeIndex
implements Index<Edge> {
    private final Index<Edge> baseIndex;
    private final IdGraph idGraph;

    public IdEdgeIndex(Index<Edge> baseIndex, IdGraph idGraph) {
        if (null == baseIndex) {
            throw new IllegalArgumentException("null base index");
        }
        this.idGraph = idGraph;
        this.baseIndex = baseIndex;
    }

    @Override
    public String getIndexName() {
        return this.baseIndex.getIndexName();
    }

    @Override
    public Class<Edge> getIndexClass() {
        return this.baseIndex.getIndexClass();
    }

    @Override
    public void put(String key, Object value, Edge element) {
        this.baseIndex.put(key, value, this.getBaseElement(element));
    }

    @Override
    public CloseableIterable<Edge> get(String key, Object value) {
        return new IdEdgeIterable(this.baseIndex.get(key, value), this.idGraph);
    }

    @Override
    public CloseableIterable<Edge> query(String key, Object query) {
        return new IdEdgeIterable(this.baseIndex.query(key, query), this.idGraph);
    }

    @Override
    public long count(String key, Object value) {
        return this.baseIndex.count(key, value);
    }

    @Override
    public void remove(String key, Object value, Edge element) {
        this.baseIndex.remove(key, value, this.getBaseElement(element));
    }

    private Edge getBaseElement(Edge e) {
        return (Edge)((IdEdge)e).baseElement;
    }
}

