/*
 * Decompiled with CFR 0.152.
 */
package com.arcadeanalytics.provider.orient2;

import com.arcadeanalytics.provider.CytoData;
import com.arcadeanalytics.provider.Data;
import com.arcadeanalytics.provider.DataSourceGraphDataProvider;
import com.arcadeanalytics.provider.DataSourceInfo;
import com.arcadeanalytics.provider.GraphData;
import com.arcadeanalytics.provider.Position;
import com.arcadeanalytics.provider.TypeMapperKt;
import com.arcadeanalytics.provider.orient2.OrientDBDataSourceGraphDataProvider;
import com.arcadeanalytics.provider.orient2.OrientDBDocumentCollector;
import com.arcadeanalytics.provider.orient2.OrientDBResultListener;
import com.arcadeanalytics.provider.orient2.OrientDBUtilsKt;
import com.google.common.collect.Maps;
import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ridbag.ORidBag;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.query.OSQLAsynchQuery;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.impls.orient.OrientEdge;
import com.tinkerpop.blueprints.impls.orient.OrientGraphNoTx;
import com.tinkerpop.blueprints.impls.orient.OrientVertex;
import java.io.Closeable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.apache.commons.lang3.RegExUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\nH\u0002J#\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\u0014H\u0002\u00a2\u0006\u0002\u0010\u0015J\u001c\u0010\u0016\u001a\u00020\u00072\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00190\u0018H\u0002J\u0010\u0010\u001a\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\nH\u0002J?\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00100\u00142\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00100\u00142\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00100\u0014H\u0016\u00a2\u0006\u0002\u0010!J;\u0010\"\u001a\u00020\u001d2\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\u00142\u0006\u0010#\u001a\u00020\u00102\u0006\u0010$\u001a\u00020\u00102\u0006\u0010%\u001a\u00020&H\u0016\u00a2\u0006\u0002\u0010'J \u0010(\u001a\u00020\u001d2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010)\u001a\u00020\u00102\u0006\u0010*\u001a\u00020&H\u0016J#\u0010+\u001a\u00020\u001d2\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\u0014H\u0016\u00a2\u0006\u0002\u0010,J \u0010-\u001a\u00020\u001d2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010.\u001a\u00020\u00102\u0006\u0010*\u001a\u00020&H\u0016J0\u0010-\u001a\u00020\u001d2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010.\u001a\u00020\u00102\u0006\u0010/\u001a\u00020\u00102\u0006\u00100\u001a\u00020\u00102\u0006\u0010*\u001a\u00020&H\u0016J\u0018\u00101\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\n2\u0006\u00102\u001a\u00020\u0010H\u0002J\u0018\u00103\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\nH\u0002J \u00104\u001a\u00020\u001d2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u000208H\u0002J\u0018\u00109\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\nH\u0002J0\u0010:\u001a\u00020\n2\u001e\u0010;\u001a\u001a\u0012\u0004\u0012\u00020\u0010\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00190<0\u00182\u0006\u0010=\u001a\u00020\nH\u0002J0\u0010>\u001a\u00020\u00072\u001e\u0010;\u001a\u001a\u0012\u0004\u0012\u00020\u0010\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00190<0<2\u0006\u0010=\u001a\u00020\nH\u0002J\u000e\u0010?\u001a\b\u0012\u0004\u0012\u00020\u00100@H\u0016J\u0010\u0010A\u001a\u00020B2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010C\u001a\u00020D2\u0006\u0010\u001b\u001a\u00020\nH\u0002J\u001c\u0010E\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u001b\u001a\u00020\nH\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006F"}, d2={"Lcom/arcadeanalytics/provider/orient2/OrientDBDataSourceGraphDataProvider;", "Lcom/arcadeanalytics/provider/DataSourceGraphDataProvider;", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "addConnectedVertex", "", "connectedVertices", "", "Lcom/orientechnologies/orient/core/record/impl/ODocument;", "vertex", "Lcom/tinkerpop/blueprints/impls/orient/OrientVertex;", "clean", "d", "cleanIds", "", "dataSource", "Lcom/arcadeanalytics/provider/DataSourceInfo;", "ids", "", "(Lcom/arcadeanalytics/provider/DataSourceInfo;[Ljava/lang/String;)Ljava/lang/String;", "cleanRecord", "record", "", "", "countInAndOut", "doc", "edges", "Lcom/arcadeanalytics/provider/GraphData;", "fromIds", "edgesLabel", "toIds", "(Lcom/arcadeanalytics/provider/DataSourceInfo;[Ljava/lang/String;[Ljava/lang/String;[Ljava/lang/String;)Lcom/arcadeanalytics/provider/GraphData;", "expand", "direction", "edgeLabel", "maxTraversal", "", "(Lcom/arcadeanalytics/provider/DataSourceInfo;[Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;I)Lcom/arcadeanalytics/provider/GraphData;", "fetchData", "query", "limit", "load", "(Lcom/arcadeanalytics/provider/DataSourceInfo;[Ljava/lang/String;)Lcom/arcadeanalytics/provider/GraphData;", "loadFromClass", "className", "propName", "propertyValue", "mapField", "fieldName", "mapInAndOut", "mapResultSet", "db", "Lcom/orientechnologies/orient/core/db/document/ODatabaseDocumentTx;", "collector", "Lcom/arcadeanalytics/provider/orient2/OrientDBDocumentCollector;", "mapRid", "populateClasses", "classes", "", "element", "populateProperties", "supportedDataSourceTypes", "", "testConnection", "", "toData", "Lcom/arcadeanalytics/provider/CytoData;", "transformToMap", "arcade-connectors-orientdb2"})
public final class OrientDBDataSourceGraphDataProvider
implements DataSourceGraphDataProvider {
    private final Logger log = LoggerFactory.getLogger(OrientDBDataSourceGraphDataProvider.class);

    @NotNull
    public Set<String> supportedDataSourceTypes() {
        return SetsKt.setOf((Object)"ORIENTDB");
    }

    public boolean testConnection(@NotNull DataSourceInfo dataSource) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        this.log.info("testing connection to data source '{}' ", (Object)dataSource.getId());
        try {
            this.fetchData(dataSource, "SELECT FROM V LIMIT 1", 1);
            this.log.info("connection to data source '{}' works fine", (Object)dataSource.getId());
        }
        catch (Exception e) {
            throw (Throwable)new RuntimeException(e);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public GraphData fetchData(@NotNull DataSourceInfo dataSource, @NotNull String query, int limit) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Closeable closeable = OrientDBUtilsKt.open(dataSource);
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            ODatabaseDocumentTx db = (ODatabaseDocumentTx)closeable;
            boolean bl3 = false;
            this.log.info("fetching data from '{}' with query '{}' ", (Object)dataSource.getId(), (Object)StringUtils.truncate(query, 256));
            OrientDBDocumentCollector collector = new OrientDBDocumentCollector();
            db.query(new OSQLAsynchQuery(query, new OrientDBResultListener(collector, limit)), new Object[0]);
            this.log.info("Query executed, returned {} records with limit {} ", (Object)collector.size(), (Object)limit);
            GraphData data = this.mapResultSet(dataSource, db, collector);
            this.log.info("Fetched {} nodes and {} edges ", (Object)data.getNodes().size(), (Object)data.getEdges().size());
            GraphData graphData = data;
            return graphData;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final CytoData toData(ODocument doc) {
        CytoData cytoData;
        String string;
        Map<String, Object> record = this.transformToMap(doc);
        HashMap ins = new HashMap();
        record.put("@in", ins);
        HashMap outs = new HashMap();
        record.put("@out", outs);
        Set keys2 = SequencesKt.toMutableSet((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)record.entrySet()), (Function1)toData.keys.1.INSTANCE), (Function1)((Function1)new Function1<Map.Entry<String, Object>, String>(ins){
            final /* synthetic */ HashMap $ins;

            @NotNull
            public final String invoke(@NotNull Map.Entry<String, Object> e) {
                Intrinsics.checkNotNullParameter(e, (String)"e");
                Map map = this.$ins;
                String string = RegExUtils.removeFirst(e.getKey(), "in_");
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"removeFirst(e.key, \"in_\")");
                map.put(string, e.getValue());
                return e.getKey();
            }
            {
                this.$ins = hashMap;
                super(1);
            }
        })));
        keys2.addAll(SequencesKt.toSet((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)record.entrySet()), (Function1)toData.1.INSTANCE), (Function1)((Function1)new Function1<Map.Entry<String, Object>, String>(outs){
            final /* synthetic */ HashMap $outs;

            @NotNull
            public final String invoke(@NotNull Map.Entry<String, Object> e) {
                Intrinsics.checkNotNullParameter(e, (String)"e");
                Map map = this.$outs;
                String string = RegExUtils.removeFirst(e.getKey(), "out_");
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"removeFirst(e.key, \"out_\")");
                map.put(string, e.getValue());
                return e.getKey();
            }
            {
                this.$outs = hashMap;
                super(1);
            }
        }))));
        Sequence $this$forEach$iv = CollectionsKt.asSequence((Iterable)keys2);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String k = (String)element$iv;
            boolean bl = false;
            record.remove(k);
        }
        this.cleanRecord(record);
        if (OrientDBUtilsKt.isEdgeType(doc)) {
            String id;
            String source = (String)doc.field("@outId");
            String target = (String)doc.field("@inId");
            String string2 = id = (String)doc.field("@id");
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"id");
            String string3 = source;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"source");
            String string4 = target;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"target");
            string = string4;
            String string5 = string3;
            Map<String, Object> map = record;
            Data data = new Data(string2, null, string5, string, map, 2, null);
            Object RET = doc.field("@class");
            Intrinsics.checkNotNullExpressionValue(RET, (String)"doc.field(\"@class\")");
            string = null;
            string5 = null;
            map = null;
            String string6 = null;
            Position position = null;
            String string7 = (String)RET;
            Data data2 = data;
            String string8 = "edge";
            CytoData cytoData2 = new CytoData(string7, string8, data2, position, string6, map, string5, string, 248, null);
            cytoData = cytoData2;
        } else {
            String id;
            String string9 = id = (String)doc.field("@id");
            Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"id");
            Data data = new Data(string9, null, null, null, record, 14, null);
            Object RET = doc.field("@class");
            Intrinsics.checkNotNullExpressionValue(RET, (String)"doc.field(\"@class\")");
            Iterator iterator = null;
            String string10 = null;
            string = null;
            String string11 = null;
            Position position = null;
            String string12 = (String)RET;
            Data data3 = data;
            String string13 = "nodes";
            CytoData cytoData3 = new CytoData(string12, string13, data3, position, string11, string, string10, (String)((Object)iterator), 248, null);
            cytoData = cytoData3;
        }
        return cytoData;
    }

    private final void cleanRecord(Map<String, Object> record) {
        record.remove("@type");
        record.remove("@rid");
        record.remove("@id");
        record.remove("@inId");
        record.remove("@outId");
        record.remove("@class");
        record.remove("@version");
        record.remove("@fieldtypes");
    }

    private final Map<String, Object> transformToMap(ODocument doc) {
        String className;
        ORID id;
        HashMap map = new HashMap();
        for (String field : doc.fieldNames()) {
            Object value;
            OType fieldType = doc.fieldType(field);
            if (fieldType == OType.LINK || fieldType == OType.LINKBAG || fieldType == OType.LINKLIST || fieldType == OType.LINKSET || fieldType == OType.LINKMAP || (value = doc.field(field)) == null) continue;
            if (value instanceof ODocument) {
                value = this.transformToMap((ODocument)value);
            } else if (value instanceof ORID) {
                value = value.toString();
            }
            Map map2 = map;
            String string = field;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"field");
            map2.put(string, value);
        }
        ORID oRID = id = doc.getIdentity();
        Intrinsics.checkNotNullExpressionValue((Object)oRID, (String)"id");
        if (oRID.isValid()) {
            ((Map)map).put("@rid", id.toString());
        }
        if ((className = doc.getClassName()) != null) {
            ((Map)map).put("@class", className);
        }
        return map;
    }

    private final Object mapField(ODocument doc, String fieldName) {
        OType type;
        OType oType = type = doc.fieldType(fieldName);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)oType), (String)"type");
        if (oType.isEmbedded()) {
            doc.field(fieldName, OType.EMBEDDED);
        }
        Object RET = doc.field(fieldName);
        Intrinsics.checkNotNullExpressionValue(RET, (String)"doc.field(fieldName)");
        return RET;
    }

    private final GraphData mapResultSet(DataSourceInfo dataSource, ODatabaseDocumentTx db, OrientDBDocumentCollector collector) {
        OrientGraphNoTx graph = new OrientGraphNoTx(db);
        boolean bl = false;
        Set nodes = new LinkedHashSet();
        boolean bl2 = false;
        Set edges = new LinkedHashSet();
        List<ODocument> resultSet = collector.collected();
        Sequence $this$forEach$iv = CollectionsKt.asSequence((Iterable)resultSet);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            OrientEdge edge;
            ODocument doc = (ODocument)element$iv;
            boolean bl3 = false;
            if (OrientDBUtilsKt.isVertexType(doc)) {
                OrientVertex vertex;
                OrientVertex orientVertex = vertex = graph.getVertex(doc);
                Intrinsics.checkNotNullExpressionValue((Object)orientVertex, (String)"vertex");
                ODocument oDocument = orientVertex.getRecord();
                Intrinsics.checkNotNullExpressionValue((Object)oDocument, (String)"vertex.record");
                oDocument.setTrackingChanges(false);
                vertex.getRecord().field("@edgeCount", (int)vertex.countEdges(Direction.BOTH, new String[0]));
                nodes.add(vertex);
                continue;
            }
            if (!OrientDBUtilsKt.isEdgeType(doc)) continue;
            OrientEdge orientEdge = edge = graph.getEdge(doc);
            Intrinsics.checkNotNullExpressionValue((Object)orientEdge, (String)"edge");
            edges.add(orientEdge);
            OrientVertex orientVertex = graph.getVertex(edge.getVertex(Direction.IN));
            Intrinsics.checkNotNullExpressionValue((Object)orientVertex, (String)"graph.getVertex(edge.getVertex(Direction.IN))");
            nodes.add(orientVertex);
            OrientVertex orientVertex2 = graph.getVertex(edge.getVertex(Direction.OUT));
            Intrinsics.checkNotNullExpressionValue((Object)orientVertex2, (String)"graph.getVertex(edge.getVertex(Direction.OUT))");
            nodes.add(orientVertex2);
        }
        this.log.info("Computing edge map on {} edges...", (Object)edges.size());
        $i$f$forEach = false;
        Map edgeClasses2 = new LinkedHashMap();
        Set cytoEdges2 = SequencesKt.toSet((Sequence)SequencesKt.map((Sequence)SequencesKt.map((Sequence)SequencesKt.map((Sequence)SequencesKt.map((Sequence)SequencesKt.map((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)edges), (Function1)mapResultSet.cytoEdges.1.INSTANCE), (Function1)((Function1)new Function1<ODocument, ODocument>(this, edgeClasses2){
            final /* synthetic */ OrientDBDataSourceGraphDataProvider this$0;
            final /* synthetic */ Map $edgeClasses;

            @NotNull
            public final ODocument invoke(ODocument d) {
                ODocument oDocument = d;
                Intrinsics.checkNotNullExpressionValue((Object)oDocument, (String)"d");
                return OrientDBDataSourceGraphDataProvider.access$populateClasses(this.this$0, this.$edgeClasses, oDocument);
            }
            {
                this.this$0 = orientDBDataSourceGraphDataProvider;
                this.$edgeClasses = map;
                super(1);
            }
        })), (Function1)((Function1)new Function1<ODocument, ODocument>(this, dataSource){
            final /* synthetic */ OrientDBDataSourceGraphDataProvider this$0;
            final /* synthetic */ DataSourceInfo $dataSource;

            @NotNull
            public final ODocument invoke(@NotNull ODocument d) {
                Intrinsics.checkNotNullParameter((Object)d, (String)"d");
                return OrientDBDataSourceGraphDataProvider.access$mapRid(this.this$0, this.$dataSource, d);
            }
            {
                this.this$0 = orientDBDataSourceGraphDataProvider;
                this.$dataSource = dataSourceInfo;
                super(1);
            }
        })), (Function1)((Function1)new Function1<ODocument, ODocument>(this, dataSource){
            final /* synthetic */ OrientDBDataSourceGraphDataProvider this$0;
            final /* synthetic */ DataSourceInfo $dataSource;

            @NotNull
            public final ODocument invoke(@NotNull ODocument d) {
                Intrinsics.checkNotNullParameter((Object)d, (String)"d");
                return OrientDBDataSourceGraphDataProvider.access$mapInAndOut(this.this$0, this.$dataSource, d);
            }
            {
                this.this$0 = orientDBDataSourceGraphDataProvider;
                this.$dataSource = dataSourceInfo;
                super(1);
            }
        })), (Function1)((Function1)new Function1<ODocument, ODocument>(this){
            final /* synthetic */ OrientDBDataSourceGraphDataProvider this$0;

            @NotNull
            public final ODocument invoke(@NotNull ODocument d) {
                Intrinsics.checkNotNullParameter((Object)d, (String)"d");
                return OrientDBDataSourceGraphDataProvider.access$countInAndOut(this.this$0, d);
            }
            {
                this.this$0 = orientDBDataSourceGraphDataProvider;
                super(1);
            }
        })), (Function1)((Function1)new Function1<ODocument, CytoData>(this){
            final /* synthetic */ OrientDBDataSourceGraphDataProvider this$0;

            @NotNull
            public final CytoData invoke(@NotNull ODocument d) {
                Intrinsics.checkNotNullParameter((Object)d, (String)"d");
                return OrientDBDataSourceGraphDataProvider.access$toData(this.this$0, d);
            }
            {
                this.this$0 = orientDBDataSourceGraphDataProvider;
                super(1);
            }
        })));
        this.log.info("Computing vertex map on {} vertices...", (Object)nodes.size());
        boolean element$iv = false;
        Map nodeClasses2 = new LinkedHashMap();
        Set cytoNodes2 = SequencesKt.toSet((Sequence)SequencesKt.map((Sequence)SequencesKt.map((Sequence)SequencesKt.map((Sequence)SequencesKt.map((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)nodes), (Function1)mapResultSet.cytoNodes.1.INSTANCE), (Function1)((Function1)new Function1<ODocument, ODocument>(this, nodeClasses2){
            final /* synthetic */ OrientDBDataSourceGraphDataProvider this$0;
            final /* synthetic */ Map $nodeClasses;

            @NotNull
            public final ODocument invoke(ODocument d) {
                ODocument oDocument = d;
                Intrinsics.checkNotNullExpressionValue((Object)oDocument, (String)"d");
                return OrientDBDataSourceGraphDataProvider.access$populateClasses(this.this$0, this.$nodeClasses, oDocument);
            }
            {
                this.this$0 = orientDBDataSourceGraphDataProvider;
                this.$nodeClasses = map;
                super(1);
            }
        })), (Function1)((Function1)new Function1<ODocument, ODocument>(this, dataSource){
            final /* synthetic */ OrientDBDataSourceGraphDataProvider this$0;
            final /* synthetic */ DataSourceInfo $dataSource;

            @NotNull
            public final ODocument invoke(@NotNull ODocument d) {
                Intrinsics.checkNotNullParameter((Object)d, (String)"d");
                return OrientDBDataSourceGraphDataProvider.access$mapRid(this.this$0, this.$dataSource, d);
            }
            {
                this.this$0 = orientDBDataSourceGraphDataProvider;
                this.$dataSource = dataSourceInfo;
                super(1);
            }
        })), (Function1)((Function1)new Function1<ODocument, ODocument>(this){
            final /* synthetic */ OrientDBDataSourceGraphDataProvider this$0;

            @NotNull
            public final ODocument invoke(@NotNull ODocument d) {
                Intrinsics.checkNotNullParameter((Object)d, (String)"d");
                return OrientDBDataSourceGraphDataProvider.access$countInAndOut(this.this$0, d);
            }
            {
                this.this$0 = orientDBDataSourceGraphDataProvider;
                super(1);
            }
        })), (Function1)((Function1)new Function1<ODocument, CytoData>(this){
            final /* synthetic */ OrientDBDataSourceGraphDataProvider this$0;

            @NotNull
            public final CytoData invoke(@NotNull ODocument d) {
                Intrinsics.checkNotNullParameter((Object)d, (String)"d");
                return OrientDBDataSourceGraphDataProvider.access$toData(this.this$0, d);
            }
            {
                this.this$0 = orientDBDataSourceGraphDataProvider;
                super(1);
            }
        })));
        return new GraphData(nodeClasses2, edgeClasses2, cytoNodes2, cytoEdges2, collector.isTruncated$arcade_connectors_orientdb2());
    }

    private final void addConnectedVertex(Set<ODocument> connectedVertices, OrientVertex vertex) {
        ODocument record;
        ODocument oDocument = record = vertex.getRecord();
        Intrinsics.checkNotNullExpressionValue((Object)oDocument, (String)"record");
        if (connectedVertices.add(oDocument)) {
            record.setTrackingChanges(false);
            record.field("@edgeCount", vertex.countEdges(Direction.BOTH, new String[0]));
        }
    }

    private final ODocument countInAndOut(ODocument doc) {
        Object[] objectArray = doc.fieldNames();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"doc.fieldNames()");
        Sequence $this$forEach$iv = SequencesKt.filter((Sequence)ArraysKt.asSequence((Object[])objectArray), (Function1)countInAndOut.1.INSTANCE);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String f = (String)element$iv;
            boolean bl = false;
            int size = OMultiValue.getSize(doc.field(f));
            doc.removeField(f);
            doc.field(f, size);
        }
        return doc;
    }

    private final ODocument clean(ODocument d) {
        for (String f : d.fieldNames()) {
            Object fieldValue = d.field(f);
            if (!(fieldValue instanceof ORidBag) && !(fieldValue instanceof OIdentifiable)) continue;
            d.removeField(f);
        }
        d.detach();
        return d;
    }

    private final ODocument mapInAndOut(DataSourceInfo dataSource, ODocument d) {
        if (!d.containsField("out")) {
            return d;
        }
        Object RET = d.rawField("out");
        if (RET == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.orientechnologies.orient.core.db.record.OIdentifiable");
        }
        ORID outRid = ((OIdentifiable)RET).getIdentity();
        StringBuilder stringBuilder = new StringBuilder().append(dataSource.getId()).append('_');
        ORID oRID = outRid;
        Intrinsics.checkNotNullExpressionValue((Object)oRID, (String)"outRid");
        d.field("@outId", stringBuilder.append(oRID.getClusterId()).append('_').append(outRid.getClusterPosition()).toString());
        d.removeField("out");
        Object RET2 = d.rawField("in");
        if (RET2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.orientechnologies.orient.core.db.record.OIdentifiable");
        }
        ORID inRid = ((OIdentifiable)RET2).getIdentity();
        StringBuilder stringBuilder2 = new StringBuilder().append(dataSource.getId()).append('_');
        ORID oRID2 = inRid;
        Intrinsics.checkNotNullExpressionValue((Object)oRID2, (String)"inRid");
        d.field("@inId", stringBuilder2.append(oRID2.getClusterId()).append('_').append(inRid.getClusterPosition()).toString());
        d.removeField("in");
        return d;
    }

    private final ODocument mapRid(DataSourceInfo dataSource, ODocument doc) {
        ORID rid = doc.getIdentity();
        StringBuilder stringBuilder = new StringBuilder().append(dataSource.getId()).append('_');
        ORID oRID = rid;
        Intrinsics.checkNotNullExpressionValue((Object)oRID, (String)"rid");
        doc.field("@id", stringBuilder.append(oRID.getClusterId()).append('_').append(rid.getClusterPosition()).toString());
        return doc;
    }

    private final ODocument populateClasses(Map<String, Map<String, Object>> classes, ODocument element) {
        classes.putIfAbsent(element.getClassName(), Maps.newHashMap());
        this.populateProperties(classes, element);
        return element;
    }

    private final void populateProperties(Map<String, ? extends Map<String, ? extends Object>> classes, ODocument element) {
        Map<String, ? extends Object> map = classes.get(element.getClassName());
        if (map == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.MutableMap<kotlin.String, kotlin.Any>");
        }
        Map properties = TypeIntrinsics.asMutableMap(map);
        Object[] objectArray = element.fieldNames();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"element.fieldNames()");
        Sequence $this$forEach$iv = SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)ArraysKt.asSequence((Object[])objectArray), (Function1)populateProperties.1.INSTANCE), (Function1)populateProperties.2.INSTANCE), (Function1)populateProperties.3.INSTANCE), (Function1)((Function1)new Function1<String, Boolean>(element){
            final /* synthetic */ ODocument $element;

            public final boolean invoke(String f) {
                OType fieldType = this.$element.fieldType(f);
                return fieldType != OType.LINK && fieldType != OType.LINKMAP && fieldType != OType.LINKSET && fieldType != OType.LINKLIST && fieldType != OType.LINKBAG;
            }
            {
                this.$element = oDocument;
                super(1);
            }
        }));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String f = (String)element$iv;
            boolean bl = false;
            OType type = element.fieldType(f);
            if (type == null) continue;
            properties.putIfAbsent(f, TypeMapperKt.mapType((String)type.name()));
        }
    }

    @NotNull
    public GraphData expand(@NotNull DataSourceInfo dataSource, @NotNull String[] ids, @NotNull String direction, @NotNull String edgeLabel, int maxTraversal) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        Intrinsics.checkNotNullParameter((Object)ids, (String)"ids");
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        Intrinsics.checkNotNullParameter((Object)edgeLabel, (String)"edgeLabel");
        String cleanedEdgeLabel = StringUtils.wrap(StringUtils.trimToEmpty(edgeLabel), "'");
        String query = "SELECT FROM (TRAVERSE ";
        switch (direction) {
            case "out": {
                query = query + "outE(" + cleanedEdgeLabel + "), inV()";
                break;
            }
            case "in": {
                query = query + "inE(" + cleanedEdgeLabel + "), outV()";
                break;
            }
            case "both": {
                query = query + "bothE(" + cleanedEdgeLabel + "), bothV()";
                break;
            }
        }
        query = query + " FROM [";
        query = query + SequencesKt.joinToString$default((Sequence)SequencesKt.map((Sequence)SequencesKt.map((Sequence)ArraysKt.asSequence((Object[])ids), (Function1)((Function1)new Function1<String, String>(dataSource){
            final /* synthetic */ DataSourceInfo $dataSource;

            @NotNull
            public final String invoke(@NotNull String r) {
                Intrinsics.checkNotNullParameter((Object)r, (String)"r");
                return StringsKt.removePrefix((String)r, (CharSequence)("" + this.$dataSource.getId() + '_'));
            }
            {
                this.$dataSource = dataSourceInfo;
                super(1);
            }
        })), (Function1)expand.2.INSTANCE), null, null, null, (int)0, null, (Function1)expand.3.INSTANCE, (int)31, null);
        query = query + "] MAXDEPTH 2) LIMIT " + maxTraversal;
        return this.fetchData(dataSource, query, maxTraversal);
    }

    @NotNull
    public GraphData edges(@NotNull DataSourceInfo dataSource, @NotNull String[] fromIds, @NotNull String[] edgesLabel, @NotNull String[] toIds) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        Intrinsics.checkNotNullParameter((Object)fromIds, (String)"fromIds");
        Intrinsics.checkNotNullParameter((Object)edgesLabel, (String)"edgesLabel");
        Intrinsics.checkNotNullParameter((Object)toIds, (String)"toIds");
        String cleanedFromIds = this.cleanIds(dataSource, fromIds);
        String cleanedToIds = this.cleanIds(dataSource, toIds);
        String cleanLabels = ArraysKt.joinToString$default((Object[])edgesLabel, (CharSequence)"','", (CharSequence)"'", (CharSequence)"'", (int)0, null, null, (int)56, null);
        String query = StringsKt.trimMargin$default((String)("MATCH {class: V, AS:node, WHERE: ( @rid IN [" + cleanedFromIds + "] ) }\n                    .bothE(" + cleanLabels + " ) { AS: rel }\n                    .bothV() { AS: target, WHERE: ( @rid IN [" + cleanedToIds + "] ) }\n                     RETURN $elements\n                    "), null, (int)1, null);
        return this.fetchData(dataSource, query, 10000);
    }

    @NotNull
    public GraphData load(@NotNull DataSourceInfo dataSource, @NotNull String[] ids) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        Intrinsics.checkNotNullParameter((Object)ids, (String)"ids");
        String query = "SELECT FROM [";
        query = query + SequencesKt.joinToString$default((Sequence)SequencesKt.map((Sequence)SequencesKt.map((Sequence)ArraysKt.asSequence((Object[])ids), (Function1)((Function1)new Function1<String, String>(dataSource){
            final /* synthetic */ DataSourceInfo $dataSource;

            @NotNull
            public final String invoke(@NotNull String r) {
                Intrinsics.checkNotNullParameter((Object)r, (String)"r");
                return StringsKt.removePrefix((String)r, (CharSequence)("" + this.$dataSource.getId() + '_'));
            }
            {
                this.$dataSource = dataSourceInfo;
                super(1);
            }
        })), (Function1)load.2.INSTANCE), null, null, null, (int)0, null, (Function1)load.3.INSTANCE, (int)31, null);
        query = query + "] ";
        return this.fetchData(dataSource, query, ids.length);
    }

    @NotNull
    public GraphData loadFromClass(@NotNull DataSourceInfo dataSource, @NotNull String className, int limit) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        String query = "select * from " + className + " limit " + limit;
        return this.fetchData(dataSource, query, limit);
    }

    @NotNull
    public GraphData loadFromClass(@NotNull DataSourceInfo dataSource, @NotNull String className, @NotNull String propName, @NotNull String propertyValue, int limit) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        Intrinsics.checkNotNullParameter((Object)propName, (String)"propName");
        Intrinsics.checkNotNullParameter((Object)propertyValue, (String)"propertyValue");
        String query = "select * from " + className + " where " + propName + " = '" + propertyValue + "' limit " + limit;
        return this.fetchData(dataSource, query, limit);
    }

    private final String cleanIds(DataSourceInfo dataSource, String[] ids) {
        return SequencesKt.joinToString$default((Sequence)SequencesKt.map((Sequence)SequencesKt.map((Sequence)ArraysKt.asSequence((Object[])ids), (Function1)((Function1)new Function1<String, String>(dataSource){
            final /* synthetic */ DataSourceInfo $dataSource;

            @NotNull
            public final String invoke(@NotNull String r) {
                Intrinsics.checkNotNullParameter((Object)r, (String)"r");
                return StringsKt.removePrefix((String)r, (CharSequence)("" + this.$dataSource.getId() + '_'));
            }
            {
                this.$dataSource = dataSourceInfo;
                super(1);
            }
        })), (Function1)cleanIds.2.INSTANCE), null, null, null, (int)0, null, (Function1)cleanIds.3.INSTANCE, (int)31, null);
    }

    public static final /* synthetic */ ODocument access$populateClasses(OrientDBDataSourceGraphDataProvider $this, Map classes, ODocument element) {
        return $this.populateClasses(classes, element);
    }

    public static final /* synthetic */ ODocument access$mapRid(OrientDBDataSourceGraphDataProvider $this, DataSourceInfo dataSource, ODocument doc) {
        return $this.mapRid(dataSource, doc);
    }

    public static final /* synthetic */ ODocument access$mapInAndOut(OrientDBDataSourceGraphDataProvider $this, DataSourceInfo dataSource, ODocument d) {
        return $this.mapInAndOut(dataSource, d);
    }

    public static final /* synthetic */ ODocument access$countInAndOut(OrientDBDataSourceGraphDataProvider $this, ODocument doc) {
        return $this.countInAndOut(doc);
    }

    public static final /* synthetic */ CytoData access$toData(OrientDBDataSourceGraphDataProvider $this, ODocument doc) {
        return $this.toData(doc);
    }
}

