/*
 * Decompiled with CFR 0.152.
 */
package com.arcadeanalytics.provider.orient2;

import com.arcadeanalytics.provider.DataSourceInfo;
import com.arcadeanalytics.provider.DataSourceMetadata;
import com.arcadeanalytics.provider.DataSourceMetadataProvider;
import com.arcadeanalytics.provider.TypeClass;
import com.arcadeanalytics.provider.TypeProperty;
import com.arcadeanalytics.provider.orient2.OrientDBDataSourceMetadataProvider;
import com.arcadeanalytics.provider.orient2.OrientDBUtilsKt;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.metadata.OMetadataDefault;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OImmutableSchema;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007j\u0002`\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J(\u0010\u0013\u001a\u0012\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007j\u0002`\u00142\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\b0\u0016H\u0016R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/arcadeanalytics/provider/orient2/OrientDBDataSourceMetadataProvider;", "Lcom/arcadeanalytics/provider/DataSourceMetadataProvider;", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "edgeClasses", "", "", "Lcom/arcadeanalytics/provider/TypeClass;", "Lcom/arcadeanalytics/provider/EdgesClasses;", "schema", "Lcom/orientechnologies/orient/core/metadata/schema/OImmutableSchema;", "db", "Lcom/orientechnologies/orient/core/db/document/ODatabaseDocumentTx;", "fetchMetadata", "Lcom/arcadeanalytics/provider/DataSourceMetadata;", "dataSource", "Lcom/arcadeanalytics/provider/DataSourceInfo;", "nodeClasses", "Lcom/arcadeanalytics/provider/NodesClasses;", "supportedDataSourceTypes", "", "arcade-connectors-orientdb2"})
public final class OrientDBDataSourceMetadataProvider
implements DataSourceMetadataProvider {
    private final Logger log = LoggerFactory.getLogger(OrientDBDataSourceMetadataProvider.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public DataSourceMetadata fetchMetadata(@NotNull DataSourceInfo dataSource) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        this.log.info("fetcing metadata from datasource '{}' ", (Object)dataSource.getId());
        Closeable closeable = OrientDBUtilsKt.open(dataSource);
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            OImmutableSchema schema;
            ODatabaseDocumentTx it = (ODatabaseDocumentTx)closeable;
            boolean bl3 = false;
            OMetadataDefault oMetadataDefault = it.getMetadata();
            Intrinsics.checkNotNullExpressionValue((Object)oMetadataDefault, (String)"it.metadata");
            OImmutableSchema oImmutableSchema = schema = oMetadataDefault.getImmutableSchemaSnapshot();
            Intrinsics.checkNotNullExpressionValue((Object)oImmutableSchema, (String)"schema");
            Map<String, TypeClass> nodesClasses = this.nodeClasses(oImmutableSchema, it);
            Map<String, TypeClass> edgeClasses2 = this.edgeClasses(schema, it);
            DataSourceMetadata dataSourceMetadata = new DataSourceMetadata(nodesClasses, edgeClasses2);
            return dataSourceMetadata;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final Map<String, TypeClass> edgeClasses(OImmutableSchema schema, ODatabaseDocumentTx db) {
        Collection<OClass> collection = schema.getClasses();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"schema.classes");
        return MapsKt.toMap((Sequence)SequencesKt.map((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)collection), (Function1)edgeClasses.1.INSTANCE), (Function1)edgeClasses.2.INSTANCE), (Function1)((Function1)new Function1<OClass, TypeClass>(db){
            final /* synthetic */ ODatabaseDocumentTx $db;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final TypeClass invoke(OClass it) {
                void $this$mapTo$iv$iv;
                Collection<OProperty> collection = it.properties();
                Intrinsics.checkNotNullExpressionValue(collection, (String)"it.properties()");
                Iterable $this$map$iv = collection;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void prop;
                    OProperty oProperty = (OProperty)item$iv$iv;
                    Collection collection2 = destination$iv$iv;
                    boolean bl = false;
                    void v1 = prop;
                    Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"prop");
                    String string = v1.getName();
                    String string2 = prop.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"prop.name");
                    Pair pair = TuplesKt.to((Object)string, (Object)new TypeProperty(string2, prop.getType().name()));
                    collection2.add(pair);
                }
                Map props = MapsKt.toMap((Iterable)((List)destination$iv$iv));
                OClass oClass = it;
                Intrinsics.checkNotNullExpressionValue((Object)oClass, (String)"it");
                String string = oClass.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.name");
                return new TypeClass(string, this.$db.countClass(it.getName(), true), props);
            }
            {
                this.$db = oDatabaseDocumentTx;
                super(1);
            }
        })), (Function1)edgeClasses.4.INSTANCE));
    }

    private final Map<String, TypeClass> nodeClasses(OImmutableSchema schema, ODatabaseDocumentTx db) {
        Collection<OClass> collection = schema.getClasses();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"schema.classes");
        return MapsKt.toMap((Sequence)SequencesKt.map((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)collection), (Function1)nodeClasses.1.INSTANCE), (Function1)nodeClasses.2.INSTANCE), (Function1)((Function1)new Function1<OClass, TypeClass>(db){
            final /* synthetic */ ODatabaseDocumentTx $db;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final TypeClass invoke(OClass it) {
                void $this$mapTo$iv$iv;
                Collection<OProperty> collection = it.properties();
                Intrinsics.checkNotNullExpressionValue(collection, (String)"it.properties()");
                Iterable $this$map$iv = collection;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void prop;
                    OProperty oProperty = (OProperty)item$iv$iv;
                    Collection collection2 = destination$iv$iv;
                    boolean bl = false;
                    void v1 = prop;
                    Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"prop");
                    String string = v1.getName();
                    String string2 = prop.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"prop.name");
                    Pair pair = TuplesKt.to((Object)string, (Object)new TypeProperty(string2, prop.getType().name()));
                    collection2.add(pair);
                }
                Map props = MapsKt.toMap((Iterable)((List)destination$iv$iv));
                OClass oClass = it;
                Intrinsics.checkNotNullExpressionValue((Object)oClass, (String)"it");
                String string = oClass.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.name");
                return new TypeClass(string, this.$db.countClass(it.getName(), true), props);
            }
            {
                this.$db = oDatabaseDocumentTx;
                super(1);
            }
        })), (Function1)nodeClasses.4.INSTANCE));
    }

    @NotNull
    public Set<String> supportedDataSourceTypes() {
        return SetsKt.setOf((Object)"ORIENTDB");
    }
}

