/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index;

import com.orientechnologies.common.util.OSizeable;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OIndexIsRebuildingException;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexChangesSizeable;
import com.orientechnologies.orient.core.index.OIndexCursor;
import java.util.Map;
import java.util.Set;

public class OIndexChangesWrapper
implements OIndexCursor {
    protected final OIndex<?> source;
    protected final OIndexCursor delegate;
    protected final long indexRebuildVersion;

    public OIndexChangesWrapper(OIndex<?> source, OIndexCursor delegate, long indexRebuildVersion) {
        this.source = source;
        this.delegate = delegate;
        this.indexRebuildVersion = indexRebuildVersion;
    }

    public static OIndexCursor wrap(OIndex<?> source, OIndexCursor cursor, long indexRebuildVersion) {
        if (cursor instanceof OIndexChangesWrapper) {
            return cursor;
        }
        if (cursor instanceof OSizeable) {
            return new OIndexChangesSizeable(source, cursor, indexRebuildVersion);
        }
        return new OIndexChangesWrapper(source, cursor, indexRebuildVersion);
    }

    @Override
    public void remove() {
        this.delegate.remove();
    }

    @Override
    public Map.Entry<Object, OIdentifiable> nextEntry() {
        if (this.source.isRebuilding()) {
            this.throwRebuildException();
        }
        Map.Entry<Object, OIdentifiable> entry = this.delegate.nextEntry();
        if (this.source.getRebuildVersion() != this.indexRebuildVersion) {
            this.throwRebuildException();
        }
        return entry;
    }

    @Override
    public Set<OIdentifiable> toValues() {
        if (this.source.isRebuilding()) {
            this.throwRebuildException();
        }
        Set<OIdentifiable> values = this.delegate.toValues();
        if (this.source.getRebuildVersion() != this.indexRebuildVersion) {
            this.throwRebuildException();
        }
        return values;
    }

    @Override
    public Set<Map.Entry<Object, OIdentifiable>> toEntries() {
        if (this.source.isRebuilding()) {
            this.throwRebuildException();
        }
        Set<Map.Entry<Object, OIdentifiable>> entries = this.delegate.toEntries();
        if (this.source.getRebuildVersion() != this.indexRebuildVersion) {
            this.throwRebuildException();
        }
        return entries;
    }

    @Override
    public Set<Object> toKeys() {
        if (this.source.isRebuilding()) {
            this.throwRebuildException();
        }
        Set<Object> keys2 = this.delegate.toKeys();
        if (this.source.getRebuildVersion() != this.indexRebuildVersion) {
            this.throwRebuildException();
        }
        return keys2;
    }

    @Override
    public void setPrefetchSize(int prefetchSize) {
        this.delegate.setPrefetchSize(prefetchSize);
    }

    @Override
    public boolean hasNext() {
        if (this.source.isRebuilding()) {
            this.throwRebuildException();
        }
        boolean isNext = this.delegate.hasNext();
        if (this.source.getRebuildVersion() != this.indexRebuildVersion) {
            this.throwRebuildException();
        }
        return isNext;
    }

    @Override
    public OIdentifiable next() {
        if (this.source.isRebuilding()) {
            this.throwRebuildException();
        }
        OIdentifiable next = (OIdentifiable)this.delegate.next();
        if (this.source.getRebuildVersion() != this.indexRebuildVersion) {
            this.throwRebuildException();
        }
        return next;
    }

    protected void throwRebuildException() {
        throw new OIndexIsRebuildingException("Index " + this.source.getName() + " is rebuilding at the moment and can not be used");
    }
}

