/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index.hashindex.local;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.exception.OLocalHashTableException;
import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.index.OIndexEngine;
import com.orientechnologies.orient.core.index.OIndexException;
import com.orientechnologies.orient.core.index.hashindex.local.OHashFunction;
import com.orientechnologies.orient.core.index.hashindex.local.OHashIndexBucket;
import com.orientechnologies.orient.core.index.hashindex.local.OHashIndexFileLevelMetadataPage;
import com.orientechnologies.orient.core.index.hashindex.local.OHashTable;
import com.orientechnologies.orient.core.index.hashindex.local.OHashTableDirectory;
import com.orientechnologies.orient.core.index.hashindex.local.ONullBucket;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.serialization.serializer.binary.OBinarySerializerFactory;
import com.orientechnologies.orient.core.storage.cache.OCacheEntry;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations.OAtomicOperation;
import com.orientechnologies.orient.core.storage.impl.local.paginated.base.ODurableComponent;
import com.orientechnologies.orient.core.storage.impl.local.statistic.OSessionStoragePerformanceStatistic;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;

public class OLocalHashTable<K, V>
extends ODurableComponent
implements OHashTable<K, V> {
    private static final int MAX_KEY_SIZE = OGlobalConfiguration.SBTREE_MAX_KEY_SIZE.getValueAsInteger();
    private static final long HASH_CODE_MIN_VALUE = 0L;
    private static final long HASH_CODE_MAX_VALUE = -1L;
    private final String metadataConfigurationFileExtension;
    private final String treeStateFileExtension;
    public static final int HASH_CODE_SIZE = 64;
    public static final int MAX_LEVEL_DEPTH = 8;
    public static final int MAX_LEVEL_SIZE = 256;
    public static final int LEVEL_MASK = 255;
    private final OHashFunction<K> keyHashFunction;
    private OBinarySerializer<K> keySerializer;
    private OBinarySerializer<V> valueSerializer;
    private OType[] keyTypes;
    private final OHashTable.KeyHashCodeComparator<K> comparator;
    private boolean nullKeyIsSupported;
    private long nullBucketFileId = -1L;
    private final String nullBucketFileExtension;
    private long fileStateId;
    private long fileId;
    private long hashStateEntryIndex;
    private OHashTableDirectory directory;
    private final boolean durableInNonTxMode;

    public OLocalHashTable(String name, String metadataConfigurationFileExtension, String treeStateFileExtension, String bucketFileExtension, String nullBucketFileExtension, OHashFunction<K> keyHashFunction, boolean durableInNonTxMode, OAbstractPaginatedStorage abstractPaginatedStorage) {
        super(abstractPaginatedStorage, name, bucketFileExtension, name + bucketFileExtension);
        this.metadataConfigurationFileExtension = metadataConfigurationFileExtension;
        this.treeStateFileExtension = treeStateFileExtension;
        this.keyHashFunction = keyHashFunction;
        this.nullBucketFileExtension = nullBucketFileExtension;
        this.durableInNonTxMode = durableInNonTxMode;
        this.comparator = new OHashTable.KeyHashCodeComparator<K>(this.keyHashFunction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressFBWarnings(value={"DLS_DEAD_LOCAL_STORE"})
    public void create(OBinarySerializer<K> keySerializer, OBinarySerializer<V> valueSerializer, OType[] keyTypes, boolean nullKeyIsSupported) {
        this.startOperation();
        try {
            OAtomicOperation atomicOperation;
            try {
                atomicOperation = this.startAtomicOperation(false);
            }
            catch (IOException e) {
                throw OException.wrapException(new OIndexException("Error during hash table creation"), e);
            }
            this.acquireExclusiveLock();
            try {
                try {
                    this.keyTypes = keyTypes != null ? Arrays.copyOf(keyTypes, keyTypes.length) : null;
                    this.nullKeyIsSupported = nullKeyIsSupported;
                    this.directory = new OHashTableDirectory(this.treeStateFileExtension, this.getName(), this.getFullName(), this.durableInNonTxMode, this.storage);
                    this.fileStateId = this.addFile(atomicOperation, this.getName() + this.metadataConfigurationFileExtension);
                    this.directory.create();
                    OCacheEntry hashStateEntry = this.addPage(atomicOperation, this.fileStateId);
                    this.pinPage(atomicOperation, hashStateEntry);
                    hashStateEntry.acquireExclusiveLock();
                    try {
                        OHashIndexFileLevelMetadataPage page = new OHashIndexFileLevelMetadataPage(hashStateEntry, this.getChanges(atomicOperation, hashStateEntry), true);
                        this.hashStateEntryIndex = hashStateEntry.getPageIndex();
                    }
                    finally {
                        hashStateEntry.releaseExclusiveLock();
                        this.releasePage(atomicOperation, hashStateEntry);
                    }
                    String fileName = this.getFullName();
                    this.fileId = this.addFile(atomicOperation, fileName);
                    this.setKeySerializer(keySerializer);
                    this.setValueSerializer(valueSerializer);
                    this.initHashTreeState(atomicOperation);
                    if (nullKeyIsSupported) {
                        this.nullBucketFileId = this.addFile(atomicOperation, this.getName() + this.nullBucketFileExtension);
                    }
                    this.endAtomicOperation(false, null);
                }
                catch (IOException e) {
                    this.endAtomicOperation(true, e);
                    throw e;
                }
                catch (Exception e) {
                    this.endAtomicOperation(true, e);
                    throw OException.wrapException(new OStorageException("Error during local hash table creation"), e);
                }
            }
            catch (IOException e) {
                throw OException.wrapException(new OIndexException("Error during local hash table creation"), e);
            }
            finally {
                this.releaseExclusiveLock();
            }
        }
        finally {
            this.completeOperation();
        }
    }

    @Override
    public OBinarySerializer<K> getKeySerializer() {
        this.acquireSharedLock();
        try {
            OBinarySerializer<K> oBinarySerializer = this.keySerializer;
            return oBinarySerializer;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setKeySerializer(OBinarySerializer<K> keySerializer) {
        this.startOperation();
        try {
            OAtomicOperation atomicOperation;
            try {
                atomicOperation = this.startAtomicOperation(true);
            }
            catch (IOException e) {
                throw OException.wrapException(new OIndexException("Error during hash set serializer for index keys"), e);
            }
            this.acquireExclusiveLock();
            try {
                this.keySerializer = keySerializer;
                OCacheEntry hashStateEntry = this.loadPage(atomicOperation, this.fileStateId, this.hashStateEntryIndex, true);
                hashStateEntry.acquireExclusiveLock();
                try {
                    OHashIndexFileLevelMetadataPage metadataPage = new OHashIndexFileLevelMetadataPage(hashStateEntry, this.getChanges(atomicOperation, hashStateEntry), false);
                    metadataPage.setKeySerializerId(keySerializer.getId());
                }
                finally {
                    hashStateEntry.releaseExclusiveLock();
                    this.releasePage(atomicOperation, hashStateEntry);
                }
                this.endAtomicOperation(false, null);
            }
            catch (IOException e) {
                this.rollback(e);
                throw OException.wrapException(new OIndexException("Cannot set serializer for index keys"), e);
            }
            catch (Exception e) {
                this.rollback(e);
                throw OException.wrapException(new OStorageException("Cannot set serializer for index keys"), e);
            }
            finally {
                this.releaseExclusiveLock();
            }
        }
        finally {
            this.completeOperation();
        }
    }

    private void rollback(Exception e) {
        try {
            this.endAtomicOperation(true, e);
        }
        catch (IOException ioe) {
            throw OException.wrapException(new OIndexException("Error during operation roolback"), ioe);
        }
    }

    @Override
    public OBinarySerializer<V> getValueSerializer() {
        this.acquireSharedLock();
        try {
            OBinarySerializer<V> oBinarySerializer = this.valueSerializer;
            return oBinarySerializer;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setValueSerializer(OBinarySerializer<V> valueSerializer) {
        this.startOperation();
        try {
            OAtomicOperation atomicOperation;
            try {
                atomicOperation = this.startAtomicOperation(true);
            }
            catch (IOException e) {
                throw OException.wrapException(new OIndexException("Error during hash table set serializer for index values"), e);
            }
            this.acquireExclusiveLock();
            try {
                this.valueSerializer = valueSerializer;
                OCacheEntry hashStateEntry = this.loadPage(atomicOperation, this.fileStateId, this.hashStateEntryIndex, true);
                hashStateEntry.acquireExclusiveLock();
                try {
                    OHashIndexFileLevelMetadataPage metadataPage = new OHashIndexFileLevelMetadataPage(hashStateEntry, this.getChanges(atomicOperation, hashStateEntry), false);
                    metadataPage.setValueSerializerId(valueSerializer.getId());
                }
                finally {
                    hashStateEntry.releaseExclusiveLock();
                    this.releasePage(atomicOperation, hashStateEntry);
                }
                this.endAtomicOperation(false, null);
            }
            catch (IOException e) {
                this.rollback(e);
                throw OException.wrapException(new OIndexException("Cannot set serializer for index values"), e);
            }
            catch (Exception e) {
                this.rollback(e);
                throw OException.wrapException(new OStorageException("Cannot set serializer for index values"), e);
            }
            finally {
                this.releaseExclusiveLock();
            }
        }
        finally {
            this.completeOperation();
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public V get(K key) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK], 2[TRYBLOCK]], but top level block is 34[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public boolean isNullKeyIsSupported() {
        this.acquireSharedLock();
        try {
            boolean bl = this.nullKeyIsSupported;
            return bl;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public void put(K key, V value) {
        this.put(key, value, null);
    }

    @Override
    public boolean validatedPut(K key, V value, OIndexEngine.Validator<K, V> validator) {
        return this.put(key, value, validator);
    }

    /*
     * Exception decompiling
     */
    @Override
    public V remove(K key) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 32[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeSize(int sizeDiff, OAtomicOperation atomicOperation) throws IOException {
        if (sizeDiff != 0) {
            OCacheEntry hashStateEntry = this.loadPage(atomicOperation, this.fileStateId, this.hashStateEntryIndex, true);
            hashStateEntry.acquireExclusiveLock();
            try {
                OHashIndexFileLevelMetadataPage page = new OHashIndexFileLevelMetadataPage(hashStateEntry, this.getChanges(atomicOperation, hashStateEntry), false);
                page.setRecordsCount(page.getRecordsCount() + (long)sizeDiff);
            }
            finally {
                hashStateEntry.releaseExclusiveLock();
                this.releasePage(atomicOperation, hashStateEntry);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        this.startOperation();
        try {
            OAtomicOperation atomicOperation;
            try {
                atomicOperation = this.startAtomicOperation(true);
            }
            catch (IOException e) {
                throw OException.wrapException(new OIndexException("Error during hash table clear"), e);
            }
            this.acquireExclusiveLock();
            try {
                if (this.nullKeyIsSupported) {
                    this.truncateFile(atomicOperation, this.nullBucketFileId);
                }
                this.initHashTreeState(atomicOperation);
                this.endAtomicOperation(false, null);
            }
            catch (IOException e) {
                this.rollback(e);
                throw OException.wrapException(new OLocalHashTableException("Error during hash table clear", this), e);
            }
            catch (Exception e) {
                this.rollback(e);
                throw OException.wrapException(new OLocalHashTableException("Error during hash table clear", this), e);
            }
            finally {
                this.releaseExclusiveLock();
            }
        }
        finally {
            this.completeOperation();
        }
    }

    @Override
    public OHashIndexBucket.Entry<K, V>[] higherEntries(K key) {
        return this.higherEntries(key, -1);
    }

    /*
     * Exception decompiling
     */
    @Override
    public OHashIndexBucket.Entry<K, V>[] higherEntries(K key, int limit) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK]], but top level block is 20[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load(String name, OType[] keyTypes, boolean nullKeyIsSupported) {
        this.startOperation();
        try {
            this.acquireExclusiveLock();
            try {
                this.keyTypes = keyTypes != null ? Arrays.copyOf(keyTypes, keyTypes.length) : null;
                this.nullKeyIsSupported = nullKeyIsSupported;
                OAtomicOperation atomicOperation = this.atomicOperationsManager.getCurrentOperation();
                this.fileStateId = this.openFile(atomicOperation, name + this.metadataConfigurationFileExtension);
                OCacheEntry hashStateEntry = this.loadPage(atomicOperation, this.fileStateId, 0L, true);
                this.hashStateEntryIndex = hashStateEntry.getPageIndex();
                this.directory = new OHashTableDirectory(this.treeStateFileExtension, name, this.getFullName(), this.durableInNonTxMode, this.storage);
                this.directory.open();
                this.pinPage(atomicOperation, hashStateEntry);
                hashStateEntry.acquireSharedLock();
                try {
                    OHashIndexFileLevelMetadataPage page = new OHashIndexFileLevelMetadataPage(hashStateEntry, this.getChanges(atomicOperation, hashStateEntry), false);
                    OBinarySerializerFactory serializerFactory = OBinarySerializerFactory.create(this.storage.getConfiguration().getBinaryFormatVersion());
                    this.keySerializer = serializerFactory.getObjectSerializer(page.getKeySerializerId());
                    this.valueSerializer = serializerFactory.getObjectSerializer(page.getValueSerializerId());
                }
                finally {
                    hashStateEntry.releaseSharedLock();
                    this.releasePage(atomicOperation, hashStateEntry);
                }
                if (nullKeyIsSupported) {
                    this.nullBucketFileId = this.openFile(atomicOperation, name + this.nullBucketFileExtension);
                }
                this.fileId = this.openFile(atomicOperation, this.getFullName());
            }
            catch (IOException e) {
                throw OException.wrapException(new OLocalHashTableException("Exception during hash table loading", this), e);
            }
            finally {
                this.releaseExclusiveLock();
            }
        }
        finally {
            this.completeOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteWithoutLoad(String name, OAbstractPaginatedStorage storageLocal) {
        this.startOperation();
        try {
            OAtomicOperation atomicOperation;
            try {
                atomicOperation = this.startAtomicOperation(false);
            }
            catch (IOException e) {
                throw OException.wrapException(new OLocalHashTableException("Error during hash table deletion", this), e);
            }
            this.acquireExclusiveLock();
            try {
                if (this.isFileExists(atomicOperation, name + this.metadataConfigurationFileExtension)) {
                    this.fileStateId = this.openFile(atomicOperation, name + this.metadataConfigurationFileExtension);
                    this.deleteFile(atomicOperation, this.fileStateId);
                }
                this.directory = new OHashTableDirectory(this.treeStateFileExtension, name, this.getFullName(), this.durableInNonTxMode, this.storage);
                this.directory.deleteWithoutOpen();
                if (this.isFileExists(atomicOperation, name + this.nullBucketFileExtension)) {
                    long nullBucketId = this.openFile(atomicOperation, name + this.nullBucketFileExtension);
                    this.deleteFile(atomicOperation, nullBucketId);
                }
                if (this.isFileExists(atomicOperation, this.getFullName())) {
                    long fileId = this.openFile(atomicOperation, this.getFullName());
                    this.deleteFile(atomicOperation, fileId);
                }
                this.endAtomicOperation(false, null);
            }
            catch (IOException ioe) {
                this.rollback(ioe);
                throw OException.wrapException(new OLocalHashTableException("Cannot delete hash table with name " + name, this), ioe);
            }
            catch (Exception e) {
                this.rollback(e);
                throw OException.wrapException(new OLocalHashTableException("Cannot delete hash table with name " + name, this), e);
            }
            finally {
                this.releaseExclusiveLock();
            }
        }
        finally {
            this.completeOperation();
        }
    }

    private OHashIndexBucket.Entry<K, V>[] convertBucketToEntries(OHashIndexBucket<K, V> bucket, int startIndex, int endIndex) {
        OHashIndexBucket.Entry[] entries = new OHashIndexBucket.Entry[endIndex - startIndex];
        Iterator<OHashIndexBucket.Entry<K, V>> iterator = bucket.iterator(startIndex);
        int i = 0;
        for (int k = startIndex; k < endIndex; ++k) {
            entries[i] = iterator.next();
            ++i;
        }
        return entries;
    }

    private OHashTable.BucketPath nextBucketToFind(OHashTable.BucketPath bucketPath, int bucketDepth) throws IOException {
        OHashTable.BucketPath bucketPathToFind;
        int offset = bucketPath.nodeGlobalDepth - bucketDepth;
        OHashTable.BucketPath currentNode = bucketPath;
        int nodeLocalDepth = this.directory.getNodeLocalDepth(bucketPath.nodeIndex);
        assert (this.directory.getNodeLocalDepth(bucketPath.nodeIndex) == bucketPath.nodeLocalDepth);
        while (offset > 0) {
            if ((offset -= nodeLocalDepth) <= 0) continue;
            currentNode = bucketPath.parent;
            nodeLocalDepth = currentNode.nodeLocalDepth;
            assert (this.directory.getNodeLocalDepth(currentNode.nodeIndex) == currentNode.nodeLocalDepth);
        }
        int diff = bucketDepth - (currentNode.nodeGlobalDepth - nodeLocalDepth);
        int firstStartIndex = currentNode.itemIndex & (255 << nodeLocalDepth - diff & 0xFF);
        int interval = 1 << nodeLocalDepth - diff;
        int globalIndex = firstStartIndex + interval + currentNode.hashMapOffset;
        if (globalIndex >= 256) {
            bucketPathToFind = this.nextLevelUp(currentNode);
        } else {
            int hashMapSize = 1 << currentNode.nodeLocalDepth;
            int hashMapOffset = globalIndex / hashMapSize * hashMapSize;
            int startIndex = globalIndex - hashMapOffset;
            bucketPathToFind = new OHashTable.BucketPath(currentNode.parent, hashMapOffset, startIndex, currentNode.nodeIndex, currentNode.nodeLocalDepth, currentNode.nodeGlobalDepth);
        }
        return this.nextNonEmptyNode(bucketPathToFind);
    }

    private OHashTable.BucketPath nextNonEmptyNode(OHashTable.BucketPath bucketPath) throws IOException {
        block0: while (bucketPath != null) {
            long[] node = this.directory.getNode(bucketPath.nodeIndex);
            int startIndex = bucketPath.itemIndex + bucketPath.hashMapOffset;
            int endIndex = 256;
            for (int i = startIndex; i < 256; ++i) {
                long position = node[i];
                if (position > 0L) {
                    int hashMapSize = 1 << bucketPath.nodeLocalDepth;
                    int hashMapOffset = i / hashMapSize * hashMapSize;
                    int itemIndex = i - hashMapOffset;
                    return new OHashTable.BucketPath(bucketPath.parent, hashMapOffset, itemIndex, bucketPath.nodeIndex, bucketPath.nodeLocalDepth, bucketPath.nodeGlobalDepth);
                }
                if (position >= 0L) continue;
                int childNodeIndex = (int)((position & Long.MAX_VALUE) >> 8);
                int childItemOffset = (int)position & 0xFF;
                OHashTable.BucketPath parent = new OHashTable.BucketPath(bucketPath.parent, 0, i, bucketPath.nodeIndex, bucketPath.nodeLocalDepth, bucketPath.nodeGlobalDepth);
                byte childLocalDepth = this.directory.getNodeLocalDepth(childNodeIndex);
                bucketPath = new OHashTable.BucketPath(parent, childItemOffset, 0, childNodeIndex, childLocalDepth, bucketPath.nodeGlobalDepth + childLocalDepth);
                continue block0;
            }
            bucketPath = this.nextLevelUp(bucketPath);
        }
        return null;
    }

    private OHashTable.BucketPath nextLevelUp(OHashTable.BucketPath bucketPath) throws IOException {
        if (bucketPath.parent == null) {
            return null;
        }
        int nodeLocalDepth = bucketPath.nodeLocalDepth;
        assert (this.directory.getNodeLocalDepth(bucketPath.nodeIndex) == bucketPath.nodeLocalDepth);
        int pointersSize = 1 << 8 - nodeLocalDepth;
        OHashTable.BucketPath parent = bucketPath.parent;
        if (parent.itemIndex < 128) {
            int nextParentIndex = (parent.itemIndex / pointersSize + 1) * pointersSize;
            return new OHashTable.BucketPath(parent.parent, 0, nextParentIndex, parent.nodeIndex, parent.nodeLocalDepth, parent.nodeGlobalDepth);
        }
        int nextParentIndex = ((parent.itemIndex - 128) / pointersSize + 1) * pointersSize + 128;
        if (nextParentIndex < 256) {
            return new OHashTable.BucketPath(parent.parent, 0, nextParentIndex, parent.nodeIndex, parent.nodeLocalDepth, parent.nodeGlobalDepth);
        }
        return this.nextLevelUp(new OHashTable.BucketPath(parent.parent, 0, 255, parent.nodeIndex, parent.nodeLocalDepth, parent.nodeGlobalDepth));
    }

    /*
     * Exception decompiling
     */
    @Override
    public OHashIndexBucket.Entry<K, V>[] ceilingEntries(K key) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK]], but top level block is 20[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public OHashIndexBucket.Entry<K, V> firstEntry() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK]], but top level block is 20[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public OHashIndexBucket.Entry<K, V> lastEntry() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK]], but top level block is 20[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public OHashIndexBucket.Entry<K, V>[] lowerEntries(K key) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK]], but top level block is 20[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public OHashIndexBucket.Entry<K, V>[] floorEntries(K key) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK]], but top level block is 20[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private OHashTable.BucketPath prevBucketToFind(OHashTable.BucketPath bucketPath, int bucketDepth) throws IOException {
        OHashTable.BucketPath bucketPathToFind;
        int offset = bucketPath.nodeGlobalDepth - bucketDepth;
        OHashTable.BucketPath currentBucket = bucketPath;
        int nodeLocalDepth = bucketPath.nodeLocalDepth;
        while (offset > 0) {
            if ((offset -= nodeLocalDepth) <= 0) continue;
            currentBucket = bucketPath.parent;
            nodeLocalDepth = currentBucket.nodeLocalDepth;
        }
        int diff = bucketDepth - (currentBucket.nodeGlobalDepth - nodeLocalDepth);
        int firstStartIndex = currentBucket.itemIndex & (255 << nodeLocalDepth - diff & 0xFF);
        int globalIndex = firstStartIndex + currentBucket.hashMapOffset - 1;
        if (globalIndex < 0) {
            bucketPathToFind = this.prevLevelUp(bucketPath);
        } else {
            int hashMapSize = 1 << currentBucket.nodeLocalDepth;
            int hashMapOffset = globalIndex / hashMapSize * hashMapSize;
            int startIndex = globalIndex - hashMapOffset;
            bucketPathToFind = new OHashTable.BucketPath(currentBucket.parent, hashMapOffset, startIndex, currentBucket.nodeIndex, currentBucket.nodeLocalDepth, currentBucket.nodeGlobalDepth);
        }
        return this.prevNonEmptyNode(bucketPathToFind);
    }

    private OHashTable.BucketPath prevNonEmptyNode(OHashTable.BucketPath nodePath) throws IOException {
        block0: while (nodePath != null) {
            int endIndex;
            long[] node = this.directory.getNode(nodePath.nodeIndex);
            boolean startIndex = false;
            for (int i = endIndex = nodePath.itemIndex + nodePath.hashMapOffset; i >= 0; --i) {
                long position = node[i];
                if (position > 0L) {
                    int hashMapSize = 1 << nodePath.nodeLocalDepth;
                    int hashMapOffset = i / hashMapSize * hashMapSize;
                    int itemIndex = i - hashMapOffset;
                    return new OHashTable.BucketPath(nodePath.parent, hashMapOffset, itemIndex, nodePath.nodeIndex, nodePath.nodeLocalDepth, nodePath.nodeGlobalDepth);
                }
                if (position >= 0L) continue;
                int childNodeIndex = (int)((position & Long.MAX_VALUE) >> 8);
                int childItemOffset = (int)position & 0xFF;
                byte nodeLocalDepth = this.directory.getNodeLocalDepth(childNodeIndex);
                int endChildIndex = (1 << nodeLocalDepth) - 1;
                OHashTable.BucketPath parent = new OHashTable.BucketPath(nodePath.parent, 0, i, nodePath.nodeIndex, nodePath.nodeLocalDepth, nodePath.nodeGlobalDepth);
                nodePath = new OHashTable.BucketPath(parent, childItemOffset, endChildIndex, childNodeIndex, nodeLocalDepth, parent.nodeGlobalDepth + nodeLocalDepth);
                continue block0;
            }
            nodePath = this.prevLevelUp(nodePath);
        }
        return null;
    }

    private OHashTable.BucketPath prevLevelUp(OHashTable.BucketPath bucketPath) {
        if (bucketPath.parent == null) {
            return null;
        }
        int nodeLocalDepth = bucketPath.nodeLocalDepth;
        int pointersSize = 1 << 8 - nodeLocalDepth;
        OHashTable.BucketPath parent = bucketPath.parent;
        if (parent.itemIndex > 128) {
            int prevParentIndex = (parent.itemIndex - 128) / pointersSize * pointersSize + 128 - 1;
            return new OHashTable.BucketPath(parent.parent, 0, prevParentIndex, parent.nodeIndex, parent.nodeLocalDepth, parent.nodeGlobalDepth);
        }
        int prevParentIndex = parent.itemIndex / pointersSize * pointersSize - 1;
        if (prevParentIndex >= 0) {
            return new OHashTable.BucketPath(parent.parent, 0, prevParentIndex, parent.nodeIndex, parent.nodeLocalDepth, parent.nodeGlobalDepth);
        }
        return this.prevLevelUp(new OHashTable.BucketPath(parent.parent, 0, 0, parent.nodeIndex, parent.nodeLocalDepth, -1));
    }

    /*
     * Exception decompiling
     */
    @Override
    public long size() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void close() {
        this.startOperation();
        try {
            this.acquireExclusiveLock();
            try {
                this.flush();
                this.directory.close();
                this.readCache.closeFile(this.fileStateId, true, this.writeCache);
                this.readCache.closeFile(this.fileId, true, this.writeCache);
            }
            catch (IOException e) {
                throw OException.wrapException(new OLocalHashTableException("Error during hash table close", this), e);
            }
            finally {
                this.releaseExclusiveLock();
            }
        }
        finally {
            this.completeOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete() {
        this.startOperation();
        try {
            OAtomicOperation atomicOperation;
            try {
                atomicOperation = this.startAtomicOperation(false);
            }
            catch (IOException e) {
                throw OException.wrapException(new OLocalHashTableException("Error during hash table deletion", this), e);
            }
            this.acquireExclusiveLock();
            try {
                this.directory.delete();
                this.deleteFile(atomicOperation, this.fileStateId);
                this.deleteFile(atomicOperation, this.fileId);
                if (this.nullKeyIsSupported) {
                    this.deleteFile(atomicOperation, this.nullBucketFileId);
                }
                this.endAtomicOperation(false, null);
            }
            catch (IOException e) {
                this.rollback(e);
                throw OException.wrapException(new OLocalHashTableException("Exception during index deletion", this), e);
            }
            catch (Exception e) {
                this.rollback(e);
                throw OException.wrapException(new OLocalHashTableException("Exception during index deletion", this), e);
            }
            finally {
                this.releaseExclusiveLock();
            }
        }
        finally {
            this.completeOperation();
        }
    }

    private void mergeNodeToParent(OHashTable.BucketPath nodePath) throws IOException {
        byte maxChildDepth;
        int startIndex = this.findParentNodeStartIndex(nodePath);
        int localNodeDepth = nodePath.nodeLocalDepth;
        int hashMapSize = 1 << localNodeDepth;
        int parentIndex = nodePath.parent.nodeIndex;
        int i = 0;
        int k = startIndex;
        while (i < 256) {
            this.directory.setNodePointer(parentIndex, k, this.directory.getNodePointer(nodePath.nodeIndex, i));
            i += hashMapSize;
            ++k;
        }
        this.directory.deleteNode(nodePath.nodeIndex);
        if (nodePath.parent.itemIndex < 128) {
            maxChildDepth = this.directory.getMaxLeftChildDepth(parentIndex);
            if (maxChildDepth == localNodeDepth) {
                this.directory.setMaxLeftChildDepth(parentIndex, (byte)this.getMaxLevelDepth(parentIndex, 0, 128));
            }
        } else {
            maxChildDepth = this.directory.getMaxRightChildDepth(parentIndex);
            if (maxChildDepth == localNodeDepth) {
                this.directory.setMaxRightChildDepth(parentIndex, (byte)this.getMaxLevelDepth(parentIndex, 128, 256));
            }
        }
    }

    @Override
    public void flush() {
        this.startOperation();
        try {
            this.acquireExclusiveLock();
            try {
                this.writeCache.flush(this.fileStateId);
                this.writeCache.flush(this.fileId);
                this.directory.flush();
                if (this.nullKeyIsSupported) {
                    this.writeCache.flush(this.nullBucketFileId);
                }
            }
            catch (IOException e) {
                throw OException.wrapException(new OLocalHashTableException("Error during hash table flush", this), e);
            }
            finally {
                this.releaseExclusiveLock();
            }
        }
        finally {
            this.completeOperation();
        }
    }

    @Override
    public void acquireAtomicExclusiveLock() {
        this.atomicOperationsManager.acquireExclusiveLockTillOperationComplete(this);
    }

    /*
     * Exception decompiling
     */
    private boolean put(K key, V value, OIndexEngine.Validator<K, V> validator) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doPut(K key, V value, OIndexEngine.Validator<K, V> validator, OAtomicOperation atomicOperation) throws IOException {
        int sizeDiff = 0;
        if (key == null) {
            boolean isNew;
            OCacheEntry cacheEntry;
            if (this.getFilledUpTo(atomicOperation, this.nullBucketFileId) == 0L) {
                cacheEntry = this.addPage(atomicOperation, this.nullBucketFileId);
                isNew = true;
            } else {
                cacheEntry = this.loadPage(atomicOperation, this.nullBucketFileId, 0L, false);
                isNew = false;
            }
            cacheEntry.acquireExclusiveLock();
            try {
                ONullBucket<V> nullBucket = new ONullBucket<V>(cacheEntry, this.getChanges(atomicOperation, cacheEntry), this.valueSerializer, isNew);
                V oldValue = nullBucket.getValue();
                if (validator != null) {
                    Object result = validator.validate(null, oldValue, value);
                    if (result == OIndexEngine.Validator.IGNORE) {
                        boolean bl = false;
                        return bl;
                    }
                    value = result;
                }
                if (oldValue != null) {
                    --sizeDiff;
                }
                nullBucket.setValue(value);
            }
            finally {
                cacheEntry.releaseExclusiveLock();
                this.releasePage(atomicOperation, cacheEntry);
            }
            this.changeSize(++sizeDiff, atomicOperation);
            return true;
        }
        long hashCode = this.keyHashFunction.hashCode(key);
        OHashTable.BucketPath bucketPath = this.getBucket(hashCode);
        long bucketPointer = this.directory.getNodePointer(bucketPath.nodeIndex, bucketPath.itemIndex + bucketPath.hashMapOffset);
        if (bucketPointer == 0L) {
            throw new IllegalStateException("In this version of hash table buckets are added through split only.");
        }
        long pageIndex = this.getPageIndex(bucketPointer);
        OCacheEntry cacheEntry = this.loadPage(atomicOperation, this.fileId, pageIndex, false);
        cacheEntry.acquireExclusiveLock();
        try {
            OHashIndexBucket<K, V> bucket = new OHashIndexBucket<K, V>(cacheEntry, this.keySerializer, this.valueSerializer, this.keyTypes, this.getChanges(atomicOperation, cacheEntry));
            int index = bucket.getIndex(hashCode, key);
            if (validator != null) {
                Object oldValue = index > -1 ? (Object)bucket.getValue(index) : null;
                Object result = validator.validate(key, oldValue, value);
                if (result == OIndexEngine.Validator.IGNORE) {
                    boolean bl = false;
                    return bl;
                }
                value = result;
            }
            if (index > -1) {
                int updateResult = bucket.updateEntry(index, value);
                if (updateResult == 0) {
                    this.changeSize(sizeDiff, atomicOperation);
                    boolean result = true;
                    return result;
                }
                if (updateResult == 1) {
                    this.changeSize(sizeDiff, atomicOperation);
                    boolean result = true;
                    return result;
                }
                assert (updateResult == -1);
                bucket.deleteEntry(index);
                --sizeDiff;
            }
            if (bucket.addEntry(hashCode, key, value)) {
                this.changeSize(++sizeDiff, atomicOperation);
                boolean updateResult = true;
                return updateResult;
            }
            OHashTable.BucketSplitResult splitResult = this.splitBucket(bucket, pageIndex, atomicOperation);
            long updatedBucketPointer = splitResult.updatedBucketPointer;
            long newBucketPointer = splitResult.newBucketPointer;
            int bucketDepth = splitResult.newDepth;
            if (bucketDepth <= bucketPath.nodeGlobalDepth) {
                this.updateNodeAfterBucketSplit(bucketPath, bucketDepth, newBucketPointer, updatedBucketPointer);
            } else if (bucketPath.nodeLocalDepth < 8) {
                OHashTable.NodeSplitResult nodeSplitResult = this.splitNode(bucketPath);
                assert (!nodeSplitResult.allLeftHashMapsEqual || !nodeSplitResult.allRightHashMapsEqual);
                long[] newNode = nodeSplitResult.newNode;
                int nodeLocalDepth = bucketPath.nodeLocalDepth + 1;
                int hashMapSize = 1 << nodeLocalDepth;
                assert (nodeSplitResult.allRightHashMapsEqual == this.checkAllMapsContainSameBucket(newNode, hashMapSize));
                int newNodeIndex = -1;
                if (!nodeSplitResult.allRightHashMapsEqual || bucketPath.itemIndex >= 128) {
                    newNodeIndex = this.directory.addNewNode((byte)0, (byte)0, (byte)nodeLocalDepth, newNode);
                }
                int updatedItemIndex = bucketPath.itemIndex << 1;
                int updatedOffset = bucketPath.hashMapOffset << 1;
                int updatedGlobalDepth = bucketPath.nodeGlobalDepth + 1;
                boolean allLeftHashMapsEqual = nodeSplitResult.allLeftHashMapsEqual;
                boolean allRightHashMapsEqual = nodeSplitResult.allRightHashMapsEqual;
                if (updatedOffset < 256) {
                    allLeftHashMapsEqual = false;
                    OHashTable.BucketPath updatedBucketPath = new OHashTable.BucketPath(bucketPath.parent, updatedOffset, updatedItemIndex, bucketPath.nodeIndex, nodeLocalDepth, updatedGlobalDepth);
                    this.updateNodeAfterBucketSplit(updatedBucketPath, bucketDepth, newBucketPointer, updatedBucketPointer);
                } else {
                    allRightHashMapsEqual = false;
                    OHashTable.BucketPath newBucketPath = new OHashTable.BucketPath(bucketPath.parent, updatedOffset - 256, updatedItemIndex, newNodeIndex, nodeLocalDepth, updatedGlobalDepth);
                    this.updateNodeAfterBucketSplit(newBucketPath, bucketDepth, newBucketPointer, updatedBucketPointer);
                }
                this.updateNodesAfterSplit(bucketPath, bucketPath.nodeIndex, newNode, nodeLocalDepth, hashMapSize, allLeftHashMapsEqual, allRightHashMapsEqual, newNodeIndex);
                if (allLeftHashMapsEqual) {
                    this.directory.deleteNode(bucketPath.nodeIndex);
                }
            } else {
                this.addNewLevelNode(bucketPath, bucketPath.nodeIndex, newBucketPointer, updatedBucketPointer);
            }
        }
        finally {
            cacheEntry.releaseExclusiveLock();
            this.releasePage(atomicOperation, cacheEntry);
        }
        this.changeSize(sizeDiff, atomicOperation);
        this.doPut(key, value, null, atomicOperation);
        return true;
    }

    private void checkNullSupport(K key) {
        if (key == null && !this.nullKeyIsSupported) {
            throw new OLocalHashTableException("Null keys are not supported.", this);
        }
    }

    private void updateNodesAfterSplit(OHashTable.BucketPath bucketPath, int nodeIndex, long[] newNode, int nodeLocalDepth, int hashMapSize, boolean allLeftHashMapEquals, boolean allRightHashMapsEquals, int newNodeIndex) throws IOException {
        long position;
        int i;
        int startIndex = this.findParentNodeStartIndex(bucketPath);
        int parentNodeIndex = bucketPath.parent.nodeIndex;
        assert (this.assertParentNodeStartIndex(bucketPath, this.directory.getNode(parentNodeIndex), startIndex));
        int pointersSize = 1 << 8 - nodeLocalDepth;
        if (allLeftHashMapEquals) {
            for (i = 0; i < pointersSize; ++i) {
                position = this.directory.getNodePointer(nodeIndex, i * hashMapSize);
                this.directory.setNodePointer(parentNodeIndex, startIndex + i, position);
            }
        } else {
            for (i = 0; i < pointersSize; ++i) {
                this.directory.setNodePointer(parentNodeIndex, startIndex + i, (long)(bucketPath.nodeIndex << 8 | i * hashMapSize) | Long.MIN_VALUE);
            }
        }
        if (allRightHashMapsEquals) {
            for (i = 0; i < pointersSize; ++i) {
                position = newNode[i * hashMapSize];
                this.directory.setNodePointer(parentNodeIndex, startIndex + pointersSize + i, position);
            }
        } else {
            for (i = 0; i < pointersSize; ++i) {
                this.directory.setNodePointer(parentNodeIndex, startIndex + pointersSize + i, (long)(newNodeIndex << 8 | i * hashMapSize) | Long.MIN_VALUE);
            }
        }
        this.updateMaxChildDepth(bucketPath.parent, bucketPath.nodeLocalDepth + 1);
    }

    private void updateMaxChildDepth(OHashTable.BucketPath parentPath, int childDepth) throws IOException {
        if (parentPath == null) {
            return;
        }
        if (parentPath.itemIndex < 128) {
            byte maxChildDepth = this.directory.getMaxLeftChildDepth(parentPath.nodeIndex);
            if (childDepth > maxChildDepth) {
                this.directory.setMaxLeftChildDepth(parentPath.nodeIndex, (byte)childDepth);
            }
        } else {
            byte maxChildDepth = this.directory.getMaxRightChildDepth(parentPath.nodeIndex);
            if (childDepth > maxChildDepth) {
                this.directory.setMaxRightChildDepth(parentPath.nodeIndex, (byte)childDepth);
            }
        }
    }

    private boolean assertParentNodeStartIndex(OHashTable.BucketPath bucketPath, long[] parentNode, int calculatedIndex) {
        int startIndex = -1;
        for (int i = 0; i < parentNode.length; ++i) {
            if (parentNode[i] >= 0L || (parentNode[i] & Long.MAX_VALUE) >>> 8 != (long)bucketPath.nodeIndex) continue;
            startIndex = i;
            break;
        }
        return startIndex == calculatedIndex;
    }

    private int findParentNodeStartIndex(OHashTable.BucketPath bucketPath) {
        OHashTable.BucketPath parentBucketPath = bucketPath.parent;
        int pointersSize = 1 << 8 - bucketPath.nodeLocalDepth;
        if (parentBucketPath.itemIndex < 128) {
            return parentBucketPath.itemIndex / pointersSize * pointersSize;
        }
        return (parentBucketPath.itemIndex - 128) / pointersSize * pointersSize + 128;
    }

    private void addNewLevelNode(OHashTable.BucketPath bucketPath, int nodeIndex, long newBucketPointer, long updatedBucketPointer) throws IOException {
        int newNodeStartIndex;
        int mapInterval;
        byte newNodeDepth;
        byte maxDepth;
        if (bucketPath.itemIndex < 128) {
            maxDepth = this.directory.getMaxLeftChildDepth(bucketPath.nodeIndex);
            assert (this.getMaxLevelDepth(bucketPath.nodeIndex, 0, 128) == maxDepth);
            newNodeDepth = maxDepth > 0 ? maxDepth : (byte)1;
            mapInterval = 1 << 8 - newNodeDepth;
            newNodeStartIndex = bucketPath.itemIndex / mapInterval * mapInterval;
        } else {
            maxDepth = this.directory.getMaxRightChildDepth(bucketPath.nodeIndex);
            assert (this.getMaxLevelDepth(bucketPath.nodeIndex, 128, 256) == maxDepth);
            newNodeDepth = maxDepth > 0 ? maxDepth : (byte)1;
            mapInterval = 1 << 8 - newNodeDepth;
            newNodeStartIndex = (bucketPath.itemIndex - 128) / mapInterval * mapInterval + 128;
        }
        int newNodeIndex = this.directory.addNewNode((byte)0, (byte)0, newNodeDepth, new long[256]);
        int mapSize = 1 << newNodeDepth;
        for (int i = 0; i < mapInterval; ++i) {
            int n;
            int nodeOffset = i + newNodeStartIndex;
            long bucketPointer = this.directory.getNodePointer(nodeIndex, nodeOffset);
            if (nodeOffset != bucketPath.itemIndex) {
                for (n = i << newNodeDepth; n < i + 1 << newNodeDepth; ++n) {
                    this.directory.setNodePointer(newNodeIndex, n, bucketPointer);
                }
            } else {
                for (n = i << newNodeDepth; n < 2 * i + 1 << newNodeDepth - 1; ++n) {
                    this.directory.setNodePointer(newNodeIndex, n, updatedBucketPointer);
                }
                for (n = 2 * i + 1 << newNodeDepth - 1; n < i + 1 << newNodeDepth; ++n) {
                    this.directory.setNodePointer(newNodeIndex, n, newBucketPointer);
                }
            }
            this.directory.setNodePointer(nodeIndex, nodeOffset, (long)(newNodeIndex << 8 | i * mapSize) | Long.MIN_VALUE);
        }
        this.updateMaxChildDepth(bucketPath, newNodeDepth);
    }

    private int getMaxLevelDepth(int nodeIndex, int start, int end) throws IOException {
        int currentIndex = -1;
        byte maxDepth = 0;
        for (int i = start; i < end; ++i) {
            int index;
            long nodePosition = this.directory.getNodePointer(nodeIndex, i);
            if (nodePosition >= 0L || (index = (int)((nodePosition & Long.MAX_VALUE) >>> 8)) == currentIndex) continue;
            currentIndex = index;
            byte nodeLocalDepth = this.directory.getNodeLocalDepth(index);
            if (maxDepth >= nodeLocalDepth) continue;
            maxDepth = nodeLocalDepth;
        }
        return maxDepth;
    }

    private void updateNodeAfterBucketSplit(OHashTable.BucketPath bucketPath, int bucketDepth, long newBucketPointer, long updatedBucketPointer) throws IOException {
        int i;
        int firstEndIndex;
        int offset = bucketPath.nodeGlobalDepth - (bucketDepth - 1);
        OHashTable.BucketPath currentNode = bucketPath;
        int nodeLocalDepth = bucketPath.nodeLocalDepth;
        while (offset > 0) {
            if ((offset -= nodeLocalDepth) <= 0) continue;
            currentNode = bucketPath.parent;
            nodeLocalDepth = currentNode.nodeLocalDepth;
        }
        int diff = bucketDepth - 1 - (currentNode.nodeGlobalDepth - nodeLocalDepth);
        int interval = 1 << nodeLocalDepth - diff - 1;
        int firstStartIndex = currentNode.itemIndex & (255 << nodeLocalDepth - diff & 0xFF);
        int secondStartIndex = firstEndIndex = firstStartIndex + interval;
        int secondEndIndex = secondStartIndex + interval;
        for (i = firstStartIndex; i < firstEndIndex; ++i) {
            this.updateBucket(currentNode.nodeIndex, i, currentNode.hashMapOffset, updatedBucketPointer);
        }
        for (i = secondStartIndex; i < secondEndIndex; ++i) {
            this.updateBucket(currentNode.nodeIndex, i, currentNode.hashMapOffset, newBucketPointer);
        }
    }

    private boolean checkAllMapsContainSameBucket(long[] newNode, int hashMapSize) {
        boolean allHashMapsEquals = true;
        block0: for (int n = 0; n < newNode.length; n += hashMapSize) {
            boolean allHashBucketEquals = true;
            for (int i = 0; i < hashMapSize - 1; ++i) {
                if (newNode[i + n] == newNode[i + n + 1]) continue;
                allHashBucketEquals = false;
                continue block0;
            }
            if (allHashBucketEquals) continue;
            allHashMapsEquals = false;
            break;
        }
        assert (this.assertAllNodesAreFilePointers(allHashMapsEquals, newNode, hashMapSize));
        return allHashMapsEquals;
    }

    private boolean assertAllNodesAreFilePointers(boolean allHashMapsEquals, long[] newNode, int hashMapSize) {
        if (allHashMapsEquals) {
            for (int n = 0; n < newNode.length; n += hashMapSize) {
                for (int i = 0; i < hashMapSize; ++i) {
                    if (newNode[i] >= 0L) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private OHashTable.NodeSplitResult splitNode(OHashTable.BucketPath bucketPath) throws IOException {
        long[] newNode = new long[256];
        int hashMapSize = 1 << bucketPath.nodeLocalDepth + 1;
        boolean hashMapItemsAreEqual = true;
        int mapCounter = 0;
        long firstPosition = -1L;
        long[] node = this.directory.getNode(bucketPath.nodeIndex);
        for (int i = 128; i < 256; ++i) {
            long position = node[i];
            if (hashMapItemsAreEqual && mapCounter == 0) {
                firstPosition = position;
            }
            newNode[2 * (i - 128)] = position;
            newNode[2 * (i - 128) + 1] = position;
            if (!hashMapItemsAreEqual) continue;
            boolean bl = hashMapItemsAreEqual = firstPosition == position;
            if ((mapCounter += 2) < hashMapSize) continue;
            mapCounter = 0;
        }
        mapCounter = 0;
        boolean allRightItemsAreEqual = hashMapItemsAreEqual;
        hashMapItemsAreEqual = true;
        long[] updatedNode = new long[node.length];
        for (int i = 0; i < 128; ++i) {
            long position = node[i];
            if (hashMapItemsAreEqual && mapCounter == 0) {
                firstPosition = position;
            }
            updatedNode[2 * i] = position;
            updatedNode[2 * i + 1] = position;
            if (!hashMapItemsAreEqual) continue;
            boolean bl = hashMapItemsAreEqual = firstPosition == position;
            if ((mapCounter += 2) < hashMapSize) continue;
            mapCounter = 0;
        }
        boolean allLeftItemsAreEqual = hashMapItemsAreEqual;
        this.directory.setNode(bucketPath.nodeIndex, updatedNode);
        this.directory.setNodeLocalDepth(bucketPath.nodeIndex, (byte)(this.directory.getNodeLocalDepth(bucketPath.nodeIndex) + 1));
        return new OHashTable.NodeSplitResult(newNode, allLeftItemsAreEqual, allRightItemsAreEqual);
    }

    private void splitBucketContent(OHashIndexBucket<K, V> bucket, OHashIndexBucket<K, V> newBucket, int newBucketDepth) throws IOException {
        assert (this.checkBucketDepth(bucket));
        ArrayList<OHashIndexBucket.Entry<K, V>> entries = new ArrayList<OHashIndexBucket.Entry<K, V>>(bucket.size());
        for (OHashIndexBucket.Entry<K, V> entry : bucket) {
            entries.add(entry);
        }
        bucket.init(newBucketDepth);
        for (OHashIndexBucket.Entry<K, V> entry : entries) {
            if ((this.keyHashFunction.hashCode(entry.key) >>> 64 - newBucketDepth & 1L) == 0L) {
                bucket.appendEntry(entry.hashCode, entry.key, entry.value);
                continue;
            }
            newBucket.appendEntry(entry.hashCode, entry.key, entry.value);
        }
        assert (this.checkBucketDepth(bucket));
        assert (this.checkBucketDepth(newBucket));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OHashTable.BucketSplitResult splitBucket(OHashIndexBucket<K, V> bucket, long pageIndex, OAtomicOperation atomicOperation) throws IOException {
        int bucketDepth = bucket.getDepth();
        int newBucketDepth = bucketDepth + 1;
        long updatedBucketIndex = pageIndex;
        OCacheEntry newBucketCacheEntry = this.addPage(atomicOperation, this.fileId);
        newBucketCacheEntry.acquireExclusiveLock();
        try {
            OHashIndexBucket<K, V> newBucket = new OHashIndexBucket<K, V>(newBucketDepth, newBucketCacheEntry, this.keySerializer, this.valueSerializer, this.keyTypes, this.getChanges(atomicOperation, newBucketCacheEntry));
            this.splitBucketContent(bucket, newBucket, newBucketDepth);
            long updatedBucketPointer = this.createBucketPointer(updatedBucketIndex);
            long newBucketPointer = this.createBucketPointer(newBucketCacheEntry.getPageIndex());
            OHashTable.BucketSplitResult bucketSplitResult = new OHashTable.BucketSplitResult(updatedBucketPointer, newBucketPointer, newBucketDepth);
            return bucketSplitResult;
        }
        finally {
            newBucketCacheEntry.releaseExclusiveLock();
            this.releasePage(atomicOperation, newBucketCacheEntry);
        }
    }

    private boolean checkBucketDepth(OHashIndexBucket<K, V> bucket) {
        int bucketDepth = bucket.getDepth();
        if (bucket.size() == 0) {
            return true;
        }
        Iterator<OHashIndexBucket.Entry<K, V>> positionIterator = bucket.iterator();
        long firstValue = this.keyHashFunction.hashCode(positionIterator.next().key) >>> 64 - bucketDepth;
        while (positionIterator.hasNext()) {
            long value = this.keyHashFunction.hashCode(positionIterator.next().key) >>> 64 - bucketDepth;
            if (value == firstValue) continue;
            return false;
        }
        return true;
    }

    private void updateBucket(int nodeIndex, int itemIndex, int offset, long newBucketPointer) throws IOException {
        long position = this.directory.getNodePointer(nodeIndex, itemIndex + offset);
        if (position >= 0L) {
            this.directory.setNodePointer(nodeIndex, itemIndex + offset, newBucketPointer);
        } else {
            int childNodeIndex = (int)((position & Long.MAX_VALUE) >>> 8);
            int childOffset = (int)(position & 0xFFL);
            byte childNodeDepth = this.directory.getNodeLocalDepth(childNodeIndex);
            int interval = 1 << childNodeDepth;
            for (int i = 0; i < interval; ++i) {
                this.updateBucket(childNodeIndex, i, childOffset, newBucketPointer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"DLS_DEAD_LOCAL_STORE"})
    private void initHashTreeState(OAtomicOperation atomicOperation) throws IOException {
        this.truncateFile(atomicOperation, this.fileId);
        for (long pageIndex = 0L; pageIndex < 256L; ++pageIndex) {
            OCacheEntry cacheEntry = this.addPage(atomicOperation, this.fileId);
            assert (cacheEntry.getPageIndex() == pageIndex);
            cacheEntry.acquireExclusiveLock();
            try {
                OHashIndexBucket<K, V> oHashIndexBucket = new OHashIndexBucket<K, V>(8, cacheEntry, this.keySerializer, this.valueSerializer, this.keyTypes, this.getChanges(atomicOperation, cacheEntry));
                continue;
            }
            finally {
                cacheEntry.releaseExclusiveLock();
                this.releasePage(atomicOperation, cacheEntry);
            }
        }
        long[] rootTree = new long[256];
        for (int pageIndex = 0; pageIndex < 256; ++pageIndex) {
            rootTree[pageIndex] = this.createBucketPointer(pageIndex);
        }
        this.directory.clear();
        this.directory.addNewNode((byte)0, (byte)0, (byte)8, rootTree);
        OCacheEntry hashStateEntry = this.loadPage(atomicOperation, this.fileStateId, this.hashStateEntryIndex, true);
        hashStateEntry.acquireExclusiveLock();
        try {
            OHashIndexFileLevelMetadataPage metadataPage = new OHashIndexFileLevelMetadataPage(hashStateEntry, this.getChanges(atomicOperation, hashStateEntry), false);
            metadataPage.setRecordsCount(0L);
        }
        finally {
            hashStateEntry.releaseExclusiveLock();
            this.releasePage(atomicOperation, hashStateEntry);
        }
    }

    private long createBucketPointer(long pageIndex) {
        return pageIndex + 1L;
    }

    private long getPageIndex(long bucketPointer) {
        return bucketPointer - 1L;
    }

    private OHashTable.BucketPath getBucket(long hashCode) throws IOException {
        int localNodeDepth;
        int nodeDepth = localNodeDepth = this.directory.getNodeLocalDepth(0);
        OHashTable.BucketPath parentNode = null;
        int nodeIndex = 0;
        int offset = 0;
        int index = (int)(hashCode >>> 64 - nodeDepth & (long)(255 >>> 8 - localNodeDepth));
        OHashTable.BucketPath currentNode = new OHashTable.BucketPath(null, 0, index, 0, localNodeDepth, nodeDepth);
        do {
            long position;
            if ((position = this.directory.getNodePointer(nodeIndex, index + offset)) >= 0L) {
                return currentNode;
            }
            nodeIndex = (int)((position & Long.MAX_VALUE) >>> 8);
            offset = (int)(position & 0xFFL);
            localNodeDepth = this.directory.getNodeLocalDepth(nodeIndex);
            index = (int)(hashCode >>> 64 - (nodeDepth += localNodeDepth) & (long)(255 >>> 8 - localNodeDepth));
            parentNode = currentNode;
            currentNode = new OHashTable.BucketPath(parentNode, offset, index, nodeIndex, localNodeDepth, nodeDepth);
        } while (nodeDepth <= 64);
        throw new IllegalStateException("Extendible hashing tree in corrupted state.");
    }

    @Override
    protected void startOperation() {
        OSessionStoragePerformanceStatistic sessionStoragePerformanceStatistic = this.performanceStatisticManager.getSessionPerformanceStatistic();
        if (sessionStoragePerformanceStatistic != null) {
            sessionStoragePerformanceStatistic.startComponentOperation(this.getFullName(), OSessionStoragePerformanceStatistic.ComponentType.INDEX);
        }
    }
}

