/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.functions.coll;

import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.common.util.OSupportsContains;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ridbag.ORidBag;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterItemVariable;
import com.orientechnologies.orient.core.sql.functions.coll.OSQLFunctionMultiValueAbstract;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class OSQLFunctionIntersect
extends OSQLFunctionMultiValueAbstract<Object> {
    public static final String NAME = "intersect";

    public OSQLFunctionIntersect() {
        super(NAME, 1, -1);
    }

    @Override
    public Object execute(Object iThis, OIdentifiable iCurrentRecord, Object iCurrentResult, Object[] iParams, OCommandContext iContext) {
        Object value = iParams[0];
        if (value instanceof OSQLFilterItemVariable) {
            value = ((OSQLFilterItemVariable)value).getValue(iCurrentRecord, iCurrentResult, iContext);
        }
        if (value == null) {
            return Collections.emptySet();
        }
        if (iParams.length == 1) {
            if (this.context == null) {
                this.context = value instanceof Collection ? ((Collection)value).iterator() : (value instanceof Iterator ? (Iterator)value : Arrays.asList(value).iterator());
            } else {
                Iterator<Object> contextIterator = null;
                if (this.context instanceof Iterator) {
                    contextIterator = (Iterator<Object>)this.context;
                } else if (OMultiValue.isMultiValue(this.context)) {
                    contextIterator = OMultiValue.getMultiValueIterator(this.context);
                }
                this.context = OSQLFunctionIntersect.intersectWith(contextIterator, value);
            }
            return null;
        }
        Iterator<Object> iterator = OMultiValue.getMultiValueIterator(value, false);
        for (int i = 1; i < iParams.length; ++i) {
            value = iParams[i];
            if (value instanceof OSQLFilterItemVariable) {
                value = ((OSQLFilterItemVariable)value).getValue(iCurrentRecord, iCurrentResult, iContext);
            }
            if (value == null) {
                return new ArrayList().iterator();
            }
            value = OSQLFunctionIntersect.intersectWith(iterator, value);
            iterator = OMultiValue.getMultiValueIterator(value, false);
        }
        return iterator;
    }

    @Override
    public Object getResult() {
        return OMultiValue.toSet(this.context);
    }

    static Collection intersectWith(Iterator current, Object value) {
        HashSet tempSet = new HashSet();
        if (!(value instanceof Set || value instanceof OSupportsContains && ((OSupportsContains)value).supportsFastContains())) {
            value = OMultiValue.toSet(value);
        }
        Iterator it = current;
        while (it.hasNext()) {
            Object curr = it.next();
            if (value instanceof ORidBag) {
                if (!((ORidBag)value).contains((OIdentifiable)curr)) continue;
                tempSet.add(curr);
                continue;
            }
            if (value instanceof Collection) {
                if (!((Collection)value).contains(curr)) continue;
                tempSet.add(curr);
                continue;
            }
            if (!(value instanceof OSupportsContains) || !((OSupportsContains)value).contains(curr)) continue;
            tempSet.add(curr);
        }
        return tempSet;
    }

    @Override
    public String getSyntax() {
        return "intersect(<field>*)";
    }

    @Override
    public Object mergeDistributedResult(List<Object> resultsToMerge) {
        Collection items;
        HashSet result = new HashSet();
        if (!resultsToMerge.isEmpty() && (items = (Collection)resultsToMerge.get(0)) != null) {
            result.addAll(items);
        }
        for (int i = 1; i < resultsToMerge.size(); ++i) {
            Collection items2 = (Collection)resultsToMerge.get(i);
            if (items2 == null) continue;
            result.retainAll(items2);
        }
        return result;
    }
}

