/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.sql.parser.OArrayNumberSelector;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import com.orientechnologies.orient.core.sql.parser.OrientSqlVisitor;
import com.orientechnologies.orient.core.sql.parser.SimpleNode;
import java.util.Arrays;
import java.util.Map;

public class OArrayRangeSelector
extends SimpleNode {
    protected Integer from;
    protected Integer to;
    boolean newRange = false;
    protected OArrayNumberSelector fromSelector;
    protected OArrayNumberSelector toSelector;

    public OArrayRangeSelector(int id) {
        super(id);
    }

    public OArrayRangeSelector(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public Object jjtAccept(OrientSqlVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        if (this.from != null) {
            builder.append(this.from);
        } else {
            this.fromSelector.toString(params, builder);
        }
        if (this.newRange) {
            builder.append("-");
        } else {
            builder.append("-");
        }
        if (this.to != null) {
            builder.append(this.to);
        } else {
            this.toSelector.toString(params, builder);
        }
    }

    public Object execute(OIdentifiable iCurrentRecord, Object result, OCommandContext ctx) {
        if (result == null) {
            return null;
        }
        if (!OMultiValue.isMultiValue(result)) {
            return null;
        }
        Integer lFrom = this.from;
        if (this.fromSelector != null) {
            lFrom = this.fromSelector.getValue(iCurrentRecord, result, ctx);
        }
        if (lFrom == null) {
            lFrom = 0;
        }
        Integer lTo = this.to;
        if (this.toSelector != null) {
            lTo = this.toSelector.getValue(iCurrentRecord, result, ctx);
        }
        if (lFrom > lTo) {
            return null;
        }
        Object[] arrayResult = OMultiValue.array(result);
        if (arrayResult == null || arrayResult.length == 0) {
            return arrayResult;
        }
        if (arrayResult.length < (lFrom = Integer.valueOf(Math.max(lFrom, 0)))) {
            return null;
        }
        lFrom = Math.min(lFrom, arrayResult.length - 1);
        lTo = Math.min(lTo, arrayResult.length);
        return Arrays.asList(Arrays.copyOfRange(arrayResult, (int)lFrom, (int)lTo));
    }
}

