/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.graph.sql.functions;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.sql.functions.OSQLFunction;
import com.orientechnologies.orient.core.sql.functions.OSQLFunctionFactory;
import com.orientechnologies.orient.graph.sql.functions.OSQLFunctionAstar;
import com.orientechnologies.orient.graph.sql.functions.OSQLFunctionBoth;
import com.orientechnologies.orient.graph.sql.functions.OSQLFunctionBothE;
import com.orientechnologies.orient.graph.sql.functions.OSQLFunctionBothV;
import com.orientechnologies.orient.graph.sql.functions.OSQLFunctionDijkstra;
import com.orientechnologies.orient.graph.sql.functions.OSQLFunctionGremlin;
import com.orientechnologies.orient.graph.sql.functions.OSQLFunctionIn;
import com.orientechnologies.orient.graph.sql.functions.OSQLFunctionInE;
import com.orientechnologies.orient.graph.sql.functions.OSQLFunctionInV;
import com.orientechnologies.orient.graph.sql.functions.OSQLFunctionLabel;
import com.orientechnologies.orient.graph.sql.functions.OSQLFunctionOut;
import com.orientechnologies.orient.graph.sql.functions.OSQLFunctionOutE;
import com.orientechnologies.orient.graph.sql.functions.OSQLFunctionOutV;
import com.orientechnologies.orient.graph.sql.functions.OSQLFunctionShortestPath;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class OGraphFunctionFactory
implements OSQLFunctionFactory {
    private static final Map<String, Object> FUNCTIONS = new HashMap<String, Object>();

    public static void register(String iName, Object iImplementation) {
        FUNCTIONS.put(iName.toLowerCase(Locale.ENGLISH), iImplementation);
    }

    @Override
    public Set<String> getFunctionNames() {
        return FUNCTIONS.keySet();
    }

    @Override
    public boolean hasFunction(String name) {
        return FUNCTIONS.containsKey(name.toLowerCase(Locale.ENGLISH));
    }

    @Override
    public OSQLFunction createFunction(String name) {
        Object obj = FUNCTIONS.get(name.toLowerCase(Locale.ENGLISH));
        if (obj == null) {
            throw new OCommandExecutionException("Unknown function name :" + name);
        }
        if (obj instanceof OSQLFunction) {
            return (OSQLFunction)obj;
        }
        Class clazz = (Class)obj;
        try {
            return (OSQLFunction)clazz.newInstance();
        }
        catch (Exception e) {
            throw OException.wrapException(new OCommandExecutionException("Error in creation of function " + name + "(). Probably there is not an empty constructor or the constructor generates errors"), e);
        }
    }

    static {
        OGraphFunctionFactory.register("gremlin", OSQLFunctionGremlin.class);
        OGraphFunctionFactory.register("dijkstra", new OSQLFunctionDijkstra());
        OGraphFunctionFactory.register("astar", OSQLFunctionAstar.class);
        OGraphFunctionFactory.register("shortestPath", new OSQLFunctionShortestPath());
        OGraphFunctionFactory.register("label", new OSQLFunctionLabel());
        OGraphFunctionFactory.register("out", new OSQLFunctionOut());
        OGraphFunctionFactory.register("in", new OSQLFunctionIn());
        OGraphFunctionFactory.register("both", new OSQLFunctionBoth());
        OGraphFunctionFactory.register("outE", new OSQLFunctionOutE());
        OGraphFunctionFactory.register("inE", new OSQLFunctionInE());
        OGraphFunctionFactory.register("bothE", new OSQLFunctionBothE());
        OGraphFunctionFactory.register("outV", new OSQLFunctionOutV());
        OGraphFunctionFactory.register("inV", new OSQLFunctionInV());
        OGraphFunctionFactory.register("bothV", new OSQLFunctionBothV());
    }
}

