/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.graph.stresstest;

import com.orientechnologies.orient.core.command.OCommandOutputListener;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.stresstest.ODatabaseIdentifier;
import com.orientechnologies.orient.stresstest.ODatabaseUtils;
import com.orientechnologies.orient.stresstest.workload.OBaseWorkload;
import com.orientechnologies.orient.stresstest.workload.OCheckWorkload;
import com.tinkerpop.blueprints.impls.orient.OGraphRepair;
import com.tinkerpop.blueprints.impls.orient.OrientBaseGraph;
import com.tinkerpop.blueprints.impls.orient.OrientGraph;
import com.tinkerpop.blueprints.impls.orient.OrientGraphFactory;
import com.tinkerpop.blueprints.impls.orient.OrientGraphNoTx;
import com.tinkerpop.blueprints.impls.orient.OrientVertex;

public abstract class OBaseGraphWorkload
extends OBaseWorkload
implements OCheckWorkload {
    protected String className = "TestVertex";

    @Override
    protected OBaseWorkload.OBaseWorkLoadContext getContext() {
        return new OWorkLoadContext();
    }

    protected OrientGraphNoTx getGraphNoTx(ODatabaseIdentifier databaseIdentifier) {
        ODatabase database = ODatabaseUtils.openDatabase(databaseIdentifier, this.connectionStrategy);
        if (database == null) {
            throw new IllegalArgumentException("Error on opening database " + databaseIdentifier.getName());
        }
        return (OrientGraphNoTx)OrientGraphFactory.getNoTxGraphImplFactory().getGraph((ODatabaseDocumentTx)database);
    }

    protected OrientGraph getGraph(ODatabaseIdentifier databaseIdentifier) {
        ODatabase database = ODatabaseUtils.openDatabase(databaseIdentifier, this.connectionStrategy);
        if (database == null) {
            throw new IllegalArgumentException("Error on opening database " + databaseIdentifier.getName());
        }
        database.setProperty("connectionStrategy", this.connectionStrategy.toString());
        OrientGraph g = (OrientGraph)OrientGraphFactory.getTxGraphImplFactory().getGraph((ODatabaseDocumentTx)database);
        g.setAutoStartTx(false);
        return g;
    }

    @Override
    public void check(ODatabaseIdentifier databaseIdentifier) {
        OGraphRepair repair = new OGraphRepair();
        repair.repair(this.getGraphNoTx(databaseIdentifier), new OCommandOutputListener(){

            @Override
            public void onMessage(String iText) {
                System.out.print("   - " + iText);
            }
        }, null);
    }

    @Override
    protected void beginTransaction(OBaseWorkload.OBaseWorkLoadContext context) {
        ((OWorkLoadContext)context).graph.begin();
    }

    @Override
    protected void commitTransaction(OBaseWorkload.OBaseWorkLoadContext context) {
        ((OWorkLoadContext)context).graph.commit();
    }

    public class OWorkLoadContext
    extends OBaseWorkload.OBaseWorkLoadContext {
        OrientBaseGraph graph;
        OrientVertex lastVertexToConnect;
        int lastVertexEdges;

        public OWorkLoadContext() {
            super(OBaseGraphWorkload.this);
        }

        @Override
        public void init(ODatabaseIdentifier dbIdentifier, int operationsPerTransaction) {
            this.graph = operationsPerTransaction > 0 ? OBaseGraphWorkload.this.getGraph(dbIdentifier) : OBaseGraphWorkload.this.getGraphNoTx(dbIdentifier);
        }

        @Override
        public void close() {
            if (this.graph != null) {
                this.graph.shutdown();
            }
        }
    }
}

