/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.http.command.post;

import com.orientechnologies.common.io.OIOUtils;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import com.orientechnologies.orient.core.serialization.serializer.record.string.ORecordSerializerCSVAbstract;
import com.orientechnologies.orient.server.network.protocol.http.OHttpRequest;
import com.orientechnologies.orient.server.network.protocol.http.OHttpResponse;
import com.orientechnologies.orient.server.network.protocol.http.command.OServerCommandDocumentAbstract;
import java.io.BufferedReader;
import java.io.StringReader;
import java.text.NumberFormat;
import java.util.InputMismatchException;
import java.util.List;
import java.util.Locale;

public class OServerCommandPostImportRecords
extends OServerCommandDocumentAbstract {
    private static final char CSV_SEPARATOR = ',';
    private static final char CSV_STR_DELIMITER = '\"';
    private static final String[] NAMES = new String[]{"POST|importRecords/*"};

    @Override
    public boolean execute(OHttpRequest iRequest, OHttpResponse iResponse) throws Exception {
        String[] urlParts = this.checkSyntax(iRequest.url, 4, "Syntax error: importRecords/<database>/<format>/<class>[/<separator>][/<string-delimiter>][/<locale>]");
        long start = System.currentTimeMillis();
        iRequest.data.commandInfo = "Import records";
        ODatabaseDocumentInternal db = this.getProfiledDatabaseInstance(iRequest);
        try {
            OClass cls = db.getMetadata().getSchema().getClass(urlParts[3]);
            if (cls == null) {
                throw new IllegalArgumentException("Class '" + urlParts[3] + " is not defined");
            }
            if (iRequest.content == null) {
                throw new IllegalArgumentException("Empty content");
            }
            if (urlParts[2].equalsIgnoreCase("csv")) {
                char separator = urlParts.length > 4 ? (char)urlParts[4].charAt(0) : (char)',';
                char stringDelimiter = urlParts.length > 5 ? (char)urlParts[5].charAt(0) : (char)'\"';
                Locale locale = urlParts.length > 6 ? new Locale(urlParts[6]) : Locale.getDefault();
                BufferedReader reader = new BufferedReader(new StringReader(iRequest.content));
                String header = reader.readLine();
                if (header == null || (header = header.trim()).length() == 0) {
                    throw new InputMismatchException("Missing CSV file header");
                }
                List<String> columns = OStringSerializerHelper.smartSplit(header, separator, new char[0]);
                for (int i = 0; i < columns.size(); ++i) {
                    columns.set(i, OIOUtils.getStringContent(columns.get(i)));
                }
                int imported = 0;
                int errors = 0;
                StringBuilder output = new StringBuilder(1024);
                int line = 0;
                int col = 0;
                String column = "?";
                String parsedCell = "?";
                NumberFormat numberFormat = NumberFormat.getNumberInstance(locale);
                line = 2;
                while (reader.ready()) {
                    try {
                        String parsedRow = reader.readLine();
                        if (parsedRow == null) break;
                        ODocument doc = new ODocument(cls);
                        String row = parsedRow.trim();
                        List<String> cells = OStringSerializerHelper.smartSplit(row, ',', new char[0]);
                        for (col = 0; col < columns.size(); ++col) {
                            Object value;
                            parsedCell = cells.get(col);
                            column = columns.get(col);
                            String cellValue = parsedCell.trim();
                            if (cellValue.length() == 0 || cellValue.equalsIgnoreCase("null")) continue;
                            if (cellValue.length() >= 2 && cellValue.charAt(0) == stringDelimiter && cellValue.charAt(cellValue.length() - 1) == stringDelimiter) {
                                value = OIOUtils.getStringContent(cellValue);
                            } else {
                                try {
                                    value = numberFormat.parse(cellValue);
                                }
                                catch (Exception e) {
                                    value = ORecordSerializerCSVAbstract.getTypeValue(cellValue);
                                }
                            }
                            doc.field(columns.get(col), value);
                        }
                        doc.save();
                        ++imported;
                    }
                    catch (Exception e) {
                        output.append(String.format("#%d: line %d column %s (%d) value '%s': '%s'\n", ++errors, line, column, col, parsedCell, e.toString()));
                    }
                    ++line;
                }
                float elapsed = (System.currentTimeMillis() - start) / 1000L;
                String message = String.format("Import of records of class '%s' completed in %5.3f seconds. Line parsed: %d, imported: %d, error: %d\nDetailed messages:\n%s", cls.getName(), Float.valueOf(elapsed), line, imported, errors, output);
                iResponse.send(201, "Created", "text/plain", message, null);
                boolean bl = false;
                return bl;
            }
            throw new UnsupportedOperationException("Unsupported format on importing record. Available formats are: csv");
        }
        finally {
            if (db != null) {
                db.close();
            }
        }
    }

    @Override
    public String[] getNames() {
        return NAMES;
    }
}

