/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.impls.orient;

import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.common.concur.ONeedRetryException;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.io.OFileUtils;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.util.OCallable;
import com.orientechnologies.common.util.OUncaughtExceptionHandler;
import com.orientechnologies.orient.core.OOrientListenerAbstract;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.traverse.OTraverse;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.config.OStorageEntryConfiguration;
import com.orientechnologies.orient.core.conflict.ORecordConflictStrategy;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.OPartitionedDatabasePool;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ridbag.ORidBag;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.index.OCompositeKey;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexManagerProxy;
import com.orientechnologies.orient.core.index.OPropertyIndexDefinition;
import com.orientechnologies.orient.core.intent.OIntent;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OImmutableClass;
import com.orientechnologies.orient.core.metadata.schema.OImmutableSchema;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OSchemaProxy;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ODocumentInternal;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.OStorageRecoverListener;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.GraphQuery;
import com.tinkerpop.blueprints.Index;
import com.tinkerpop.blueprints.Parameter;
import com.tinkerpop.blueprints.TransactionalGraph;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.impls.orient.OGraphRepair;
import com.tinkerpop.blueprints.impls.orient.OrientClassVertexIterable;
import com.tinkerpop.blueprints.impls.orient.OrientConfigurableGraph;
import com.tinkerpop.blueprints.impls.orient.OrientEdge;
import com.tinkerpop.blueprints.impls.orient.OrientEdgeType;
import com.tinkerpop.blueprints.impls.orient.OrientElement;
import com.tinkerpop.blueprints.impls.orient.OrientElementIterable;
import com.tinkerpop.blueprints.impls.orient.OrientElementScanIterable;
import com.tinkerpop.blueprints.impls.orient.OrientExtendedGraph;
import com.tinkerpop.blueprints.impls.orient.OrientGraphCommand;
import com.tinkerpop.blueprints.impls.orient.OrientGraphQuery;
import com.tinkerpop.blueprints.impls.orient.OrientIndex;
import com.tinkerpop.blueprints.impls.orient.OrientTransactionalGraph;
import com.tinkerpop.blueprints.impls.orient.OrientVertex;
import com.tinkerpop.blueprints.impls.orient.OrientVertexType;
import com.tinkerpop.blueprints.util.ExceptionFactory;
import com.tinkerpop.blueprints.util.StringFactory;
import com.tinkerpop.blueprints.util.wrappers.partition.PartitionVertex;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.apache.commons.configuration.Configuration;

public abstract class OrientBaseGraph
extends OrientConfigurableGraph
implements OrientExtendedGraph,
OStorageRecoverListener {
    public static final String CONNECTION_OUT = "out";
    public static final String CONNECTION_IN = "in";
    public static final String CLASS_PREFIX = "class:";
    public static final String CLUSTER_PREFIX = "cluster:";
    public static final String ADMIN = "admin";
    private static volatile ThreadLocal<OrientBaseGraph> activeGraph = new ThreadLocal();
    private static volatile ThreadLocal<Deque<OrientBaseGraph>> initializationStack = new InitializationStackThreadLocal();
    private Map<String, Object> properties;
    private final OPartitionedDatabasePool pool;
    protected ODatabaseDocumentTx database;
    private String url;
    private String username;
    private String password;

    public OrientBaseGraph(ODatabaseDocumentTx iDatabase, String iUserName, String iUserPassword, OrientConfigurableGraph.Settings iConfiguration) {
        this.pool = null;
        this.username = iUserName;
        this.password = iUserPassword;
        this.database = iDatabase;
        this.makeActive();
        this.putInInitializationStack();
        this.readDatabaseConfiguration();
        this.configure(iConfiguration);
    }

    public OrientBaseGraph(OPartitionedDatabasePool pool) {
        this.pool = pool;
        this.database = pool.acquire();
        this.makeActive();
        this.putInInitializationStack();
        this.username = this.getDatabase().getUser() != null ? this.getDatabase().getUser().getName() : null;
        this.readDatabaseConfiguration();
    }

    public OrientBaseGraph(OPartitionedDatabasePool pool, OrientConfigurableGraph.Settings iConfiguration) {
        this.pool = pool;
        this.database = pool.acquire();
        this.makeActive();
        this.putInInitializationStack();
        this.username = this.getDatabase().getUser() != null ? this.getDatabase().getUser().getName() : null;
        this.readDatabaseConfiguration();
        this.configure(iConfiguration);
    }

    public OrientBaseGraph(String url) {
        this(url, ADMIN, ADMIN);
    }

    public OrientBaseGraph(String url, String username, String password) {
        this.pool = null;
        this.url = OFileUtils.getPath(url);
        this.username = username;
        this.password = password;
        this.openOrCreate();
        this.readDatabaseConfiguration();
    }

    public OrientBaseGraph(Configuration configuration) {
        this(configuration.getString("blueprints.orientdb.url", null), configuration.getString("blueprints.orientdb.username", null), configuration.getString("blueprints.orientdb.password", null));
        super.init(configuration);
    }

    abstract OrientEdge addEdgeInternal(OrientVertex var1, String var2, OrientVertex var3, String var4, String var5, Object ... var6);

    abstract void removeEdgesInternal(OrientVertex var1, ODocument var2, OIdentifiable var3, boolean var4, boolean var5, boolean var6);

    abstract void removeEdgeInternal(OrientEdge var1);

    public static OrientBaseGraph getActiveGraph() {
        return activeGraph.get();
    }

    public static void clearInitStack() {
        ThreadLocal<OrientBaseGraph> ag;
        ThreadLocal<Deque<OrientBaseGraph>> is = initializationStack;
        if (is != null) {
            is.get().clear();
        }
        if ((ag = activeGraph) != null) {
            ag.remove();
        }
    }

    @Override
    public void onStorageRecover() {
        String sqlGraphConsistencyMode = OGlobalConfiguration.SQL_GRAPH_CONSISTENCY_MODE.getValueAsString();
        if ("notx_sync_repair".equalsIgnoreCase(sqlGraphConsistencyMode)) {
            new OGraphRepair().repair(this, OLogManager.instance().getCommandOutputListener(this, Level.INFO), null);
        } else if ("notx_async_repair".equalsIgnoreCase(sqlGraphConsistencyMode)) {
            final OrientBaseGraph g = this;
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    new OGraphRepair().repair(g, OLogManager.instance().getCommandOutputListener(this, Level.INFO), null);
                }
            });
            t.setUncaughtExceptionHandler(new OUncaughtExceptionHandler());
            t.start();
        }
    }

    public static void encodeClassNames(String ... iLabels) {
        if (iLabels != null) {
            for (int i = 0; i < iLabels.length; ++i) {
                iLabels[i] = OrientBaseGraph.encodeClassName(iLabels[i]);
            }
        }
    }

    public static void getEdgeClassNames(OrientBaseGraph graph, String ... iLabels) {
        if (iLabels != null && graph != null && graph.isUseClassForEdgeLabel()) {
            for (int i = 0; i < iLabels.length; ++i) {
                OrientEdgeType edgeType = graph.getEdgeType(iLabels[i]);
                if (edgeType == null) continue;
                iLabels[i] = edgeType.getName();
            }
        }
    }

    public static String encodeClassName(String iClassName) {
        if (iClassName == null) {
            return null;
        }
        if (Character.isDigit(iClassName.charAt(0))) {
            iClassName = "-" + iClassName;
        }
        try {
            return URLEncoder.encode(iClassName, "UTF-8").replaceAll("\\.", "%2E");
        }
        catch (UnsupportedEncodingException e) {
            OLogManager.instance().error(null, "Error on encoding class name using encoding '%s'", e, "UTF-8");
            return iClassName;
        }
    }

    public static String decodeClassName(String iClassName) {
        if (iClassName == null) {
            return null;
        }
        if (iClassName.charAt(0) == '-') {
            iClassName = iClassName.substring(1);
        }
        try {
            return URLDecoder.decode(iClassName, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            OLogManager.instance().error(null, "Error on decoding class name using encoding '%s'", e, "UTF-8");
            return iClassName;
        }
    }

    public void makeActive() {
        if (this.database == null) {
            throw new ODatabaseException("Database is closed");
        }
        activeGraph.set(this);
        ODatabaseDocumentInternal tlDb = ODatabaseRecordThreadLocal.instance().getIfDefined();
        if (tlDb != this.database) {
            ODatabaseRecordThreadLocal.instance().set(this.getDatabase());
        }
    }

    public OrientBaseGraph configure(OrientConfigurableGraph.Settings iSetting) {
        this.makeActive();
        if (iSetting != null) {
            if (this.settings == null) {
                this.settings = iSetting;
            } else {
                this.settings.copyFrom(iSetting);
            }
        }
        return this;
    }

    @Override
    public void drop() {
        this.makeActive();
        this.getRawGraph().drop();
        this.pollGraphFromStack(true);
    }

    @Override
    public <T extends Element> Index<T> createIndex(final String indexName, final Class<T> indexClass, Parameter ... indexParameters) {
        this.makeActive();
        return (Index)this.executeOutsideTx(new OCallable<Index<T>, OrientBaseGraph>(){

            @Override
            public Index<T> call(OrientBaseGraph g) {
                OIndexManagerProxy indexManager = OrientBaseGraph.this.getDatabase().getMetadata().getIndexManager();
                if (indexManager.getIndex(indexName) != null) {
                    throw ExceptionFactory.indexAlreadyExists(indexName);
                }
                OrientIndex index = new OrientIndex(g, indexName, indexClass, null);
                OrientBaseGraph.this.saveIndexConfiguration();
                return index;
            }
        }, "create index '", indexName, "'");
    }

    @Override
    public <T extends Element> Index<T> getIndex(String indexName, Class<T> indexClass) {
        this.makeActive();
        OIndexManagerProxy indexManager = this.getDatabase().getMetadata().getIndexManager();
        OIndex<?> idx = indexManager.getIndex(indexName);
        if (idx == null || !this.hasIndexClass(idx)) {
            return null;
        }
        OrientIndex index = new OrientIndex(this, idx);
        if (indexClass.isAssignableFrom(index.getIndexClass())) {
            return index;
        }
        throw ExceptionFactory.indexDoesNotSupportClass(indexName, indexClass);
    }

    @Override
    public Iterable<Index<? extends Element>> getIndices() {
        this.makeActive();
        return this.loadManualIndexes();
    }

    @Override
    public void dropIndex(final String indexName) {
        this.makeActive();
        this.executeOutsideTx(new OCallable<Object, OrientBaseGraph>(){

            @Override
            public Object call(OrientBaseGraph g) {
                try {
                    OIndexManagerProxy indexManager = OrientBaseGraph.this.getRawGraph().getMetadata().getIndexManager();
                    OIndex<?> index = indexManager.getIndex(indexName);
                    ODocument metadata = (ODocument)index.getConfiguration().field("metadata");
                    String recordMapIndexName = null;
                    if (metadata != null) {
                        recordMapIndexName = (String)metadata.field("record_map_name");
                    }
                    indexManager.dropIndex(indexName);
                    if (recordMapIndexName != null) {
                        OrientBaseGraph.this.getRawGraph().getMetadata().getIndexManager().dropIndex(recordMapIndexName);
                    }
                    OrientBaseGraph.this.saveIndexConfiguration();
                    return null;
                }
                catch (Exception e) {
                    g.rollback();
                    throw new RuntimeException(e.getMessage(), e);
                }
            }
        }, "drop index '", indexName, "'");
    }

    @Override
    public OrientVertex addVertex(Object id) {
        this.makeActive();
        return this.addVertex(id, (Object[])null);
    }

    @Override
    public ORecordConflictStrategy getConflictStrategy() {
        this.makeActive();
        return this.getDatabase().getStorage().getConflictStrategy();
    }

    @Override
    public OrientBaseGraph setConflictStrategy(String iStrategyName) {
        this.makeActive();
        this.getDatabase().setConflictStrategy(Orient.instance().getRecordConflictStrategy().getStrategy(iStrategyName));
        return this;
    }

    @Override
    public OrientBaseGraph setConflictStrategy(ORecordConflictStrategy iResolver) {
        this.makeActive();
        this.getDatabase().setConflictStrategy(iResolver);
        return this;
    }

    @Override
    public OrientVertex addVertex(Object id, Object ... prop) {
        this.makeActive();
        String className = null;
        String clusterName = null;
        Object[] fields = null;
        if (id != null) {
            if (id instanceof String) {
                String[] args;
                for (String s : args = ((String)id).split(",")) {
                    if (s.startsWith(CLASS_PREFIX)) {
                        className = s.substring(CLASS_PREFIX.length());
                        continue;
                    }
                    if (s.startsWith(CLUSTER_PREFIX)) {
                        clusterName = s.substring(CLUSTER_PREFIX.length());
                        continue;
                    }
                    id = s;
                }
            }
            if (this.isSaveOriginalIds()) {
                fields = new Object[]{OrientElement.DEF_ORIGINAL_ID_FIELDNAME, id};
            }
        }
        this.setCurrentGraphInThreadLocal();
        this.autoStartTransaction();
        OrientVertex vertex = this.getVertexInstance(className, fields);
        vertex.setPropertiesInternal(prop);
        if (clusterName != null) {
            vertex.save(clusterName);
        } else {
            vertex.save();
        }
        return vertex;
    }

    public OrientVertex addVertex(String iClassName, String iClusterName) {
        this.makeActive();
        this.setCurrentGraphInThreadLocal();
        this.autoStartTransaction();
        OrientVertex vertex = this.getVertexInstance(iClassName, new Object[0]);
        if (iClusterName != null) {
            vertex.save(iClusterName);
        } else {
            vertex.save();
        }
        return vertex;
    }

    @Override
    public OrientVertex addTemporaryVertex(String iClassName, Object ... prop) {
        this.makeActive();
        this.setCurrentGraphInThreadLocal();
        this.autoStartTransaction();
        OrientVertex vertex = this.getVertexInstance(iClassName, new Object[0]);
        vertex.setPropertiesInternal(prop);
        return vertex;
    }

    @Override
    public OrientEdge addEdge(Object id, Vertex outVertex, Vertex inVertex, String label) {
        Object[] fields;
        Object[] objectArray;
        this.makeActive();
        String className = null;
        String clusterName = null;
        if (id != null && id instanceof String) {
            String[] args;
            for (String s : args = ((String)id).split(",")) {
                if (s.startsWith(CLASS_PREFIX)) {
                    className = s.substring(CLASS_PREFIX.length());
                    continue;
                }
                if (!s.startsWith(CLUSTER_PREFIX)) continue;
                clusterName = s.substring(CLUSTER_PREFIX.length());
            }
        }
        if (this.isSaveOriginalIds() && id != null) {
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = OrientElement.DEF_ORIGINAL_ID_FIELDNAME;
            objectArray = objectArray2;
            objectArray2[1] = id;
        } else {
            objectArray = fields = null;
        }
        if (outVertex instanceof PartitionVertex) {
            outVertex = ((PartitionVertex)outVertex).getBaseVertex();
        }
        if (inVertex instanceof PartitionVertex) {
            inVertex = ((PartitionVertex)inVertex).getBaseVertex();
        }
        return ((OrientVertex)outVertex).addEdge(label, (OrientVertex)inVertex, className, clusterName, fields);
    }

    @Override
    public OrientVertex getVertex(Object id) {
        ORID rid;
        this.makeActive();
        if (null == id) {
            throw ExceptionFactory.vertexIdCanNotBeNull();
        }
        if (id instanceof OrientVertex) {
            return (OrientVertex)id;
        }
        if (id instanceof ODocument) {
            return this.getVertexInstance((OIdentifiable)id);
        }
        this.setCurrentGraphInThreadLocal();
        if (id instanceof OIdentifiable) {
            rid = ((OIdentifiable)id).getIdentity();
        } else {
            try {
                rid = new ORecordId(id.toString());
            }
            catch (IllegalArgumentException iae) {
                return null;
            }
        }
        if (!rid.isValid()) {
            return null;
        }
        Object rec = rid.getRecord();
        if (rec == null || !(rec instanceof ODocument)) {
            return null;
        }
        OClass cls = ((ODocument)rec).getSchemaClass();
        if (cls != null && cls.isEdgeType()) {
            throw new IllegalArgumentException("Cannot retrieve a vertex with the RID " + rid + " because it is an edge");
        }
        return this.getVertexInstance((OIdentifiable)rec);
    }

    @Override
    public void declareIntent(OIntent iIntent) {
        this.makeActive();
        this.getRawGraph().declareIntent(iIntent);
    }

    @Override
    public void removeVertex(Vertex vertex) {
        this.makeActive();
        vertex.remove();
    }

    @Override
    public Iterable<Vertex> getVertices() {
        this.makeActive();
        return this.getVerticesOfClass("V", true);
    }

    public Iterable<Vertex> getVertices(boolean iPolymorphic) {
        this.makeActive();
        return this.getVerticesOfClass("V", iPolymorphic);
    }

    public Iterable<Vertex> getVerticesOfClass(String iClassName) {
        this.makeActive();
        return this.getVerticesOfClass(iClassName, true);
    }

    public Iterable<Vertex> getVerticesOfClass(String iClassName, boolean iPolymorphic) {
        this.makeActive();
        OClass cls = this.getRawGraph().getMetadata().getSchema().getClass(iClassName);
        if (cls == null) {
            throw new IllegalArgumentException("Cannot find class '" + iClassName + "' in database schema");
        }
        if (!cls.isSubClassOf("V")) {
            throw new IllegalArgumentException("Class '" + iClassName + "' is not a vertex class");
        }
        return new OrientElementScanIterable<Vertex>(this, iClassName, iPolymorphic);
    }

    @Override
    public Iterable<Vertex> getVertices(String iKey, Object iValue) {
        this.makeActive();
        if (iKey.equals("@class")) {
            return this.getVerticesOfClass(iValue.toString());
        }
        int pos = iKey.indexOf(46);
        String className = pos > -1 ? iKey.substring(0, pos) : "V";
        String key = pos > -1 ? iKey.substring(pos + 1) : iKey;
        OClass clazz = this.getDatabase().getMetadata().getImmutableSchemaSnapshot().getClass(className);
        if (clazz == null) {
            throw new IllegalArgumentException("OClass not found in the schema: " + className);
        }
        OIndex idx = null;
        Set<OIndex<?>> indexes = clazz.getIndexes();
        for (OIndex oIndex : indexes) {
            List<String> indexedFields;
            OIndexDefinition indexDef = oIndex.getDefinition();
            if ("lucene".equalsIgnoreCase(oIndex.getAlgorithm()) || (indexedFields = indexDef.getFields()) == null || indexedFields.size() <= 0 || !indexedFields.get(0).equals(key)) continue;
            idx = oIndex;
            break;
        }
        if (idx == null) {
            idx = this.getDatabase().getMetadata().getIndexManager().getIndex(iKey);
        }
        if (idx != null) {
            Object indexValue = idx.get(iValue = this.convertKey(idx, iValue));
            if (indexValue != null && !(indexValue instanceof Iterable)) {
                indexValue = Arrays.asList(indexValue);
            }
            return new OrientElementIterable<Vertex>(this, (Iterable)indexValue);
        }
        OrientGraphQuery query = (OrientGraphQuery)this.query();
        query.labels(clazz.getName());
        return query.has(key, iValue).vertices();
    }

    @Deprecated
    public Vertex getVertexByKey(String iKey, Object iValue) {
        this.makeActive();
        String indexName = iKey.indexOf(46) > -1 ? iKey : "V." + iKey;
        OIndex<?> idx = this.getDatabase().getMetadata().getIndexManager().getIndex(indexName);
        if (idx != null) {
            Object v = idx.get(iValue = this.convertKey(idx, iValue));
            if (v != null) {
                return this.getVertex(v);
            }
            return null;
        }
        throw new IllegalArgumentException("Index '" + indexName + "' not found");
    }

    public Iterable<Vertex> getVertices(String label, String[] iKey, Object[] iValue) {
        if (iKey.length != iValue.length) {
            throw new IllegalArgumentException("key names and values must be arrays of the same size");
        }
        this.makeActive();
        OClass clazz = this.getDatabase().getMetadata().getImmutableSchemaSnapshot().getClass(label);
        if (clazz != null) {
            Set<OIndex<?>> indexes = clazz.getInvolvedIndexes(Arrays.asList(iKey));
            for (OIndex<?> idx : indexes) {
                if (idx == null || "lucene".equalsIgnoreCase(idx.getAlgorithm())) continue;
                Object[] sortedParams = new Object[iValue.length];
                List<String> indexFields = idx.getDefinition().getFields();
                for (int i = 0; i < iKey.length; ++i) {
                    sortedParams[indexFields.indexOf((Object)iKey[i])] = iValue[i];
                }
                List<Object> keys2 = Arrays.asList(this.convertKeys(idx, sortedParams));
                Object key = indexFields.size() == 1 ? keys2.get(0) : new OCompositeKey(keys2);
                Object indexValue = idx.get(key);
                if (indexValue != null && !(indexValue instanceof Iterable)) {
                    indexValue = Arrays.asList(indexValue);
                }
                return new OrientClassVertexIterable(this, (Iterable)indexValue, label);
            }
        }
        OrientGraphQuery query = (OrientGraphQuery)this.query();
        query.labels(label);
        for (int i = 0; i < iKey.length; ++i) {
            query.has(iKey[i], iValue[i]);
        }
        return query.vertices();
    }

    @Override
    public Iterable<Edge> getEdges() {
        this.makeActive();
        return this.getEdgesOfClass("E", true);
    }

    public Iterable<Edge> getEdges(boolean iPolymorphic) {
        this.makeActive();
        return this.getEdgesOfClass("E", iPolymorphic);
    }

    public Iterable<Edge> getEdgesOfClass(String iClassName) {
        this.makeActive();
        return this.getEdgesOfClass(iClassName, true);
    }

    public Iterable<Edge> getEdgesOfClass(String iClassName, boolean iPolymorphic) {
        this.makeActive();
        OClass cls = this.getRawGraph().getMetadata().getSchema().getClass(iClassName);
        if (cls == null) {
            throw new IllegalArgumentException("Cannot find class '" + iClassName + "' in database schema");
        }
        if (!cls.isSubClassOf("E")) {
            throw new IllegalArgumentException("Class '" + iClassName + "' is not an edge class");
        }
        return new OrientElementScanIterable<Edge>(this, iClassName, iPolymorphic);
    }

    @Override
    public Iterable<Edge> getEdges(String iKey, Object iValue) {
        String key;
        String indexName;
        this.makeActive();
        if (iKey.equals("@class")) {
            return this.getEdgesOfClass(iValue.toString());
        }
        int pos = iKey.indexOf(46);
        if (pos > -1) {
            indexName = iKey;
            key = iKey.substring(iKey.indexOf(46) + 1);
        } else {
            indexName = "E." + iKey;
            key = iKey;
        }
        OIndex<?> idx = this.getDatabase().getMetadata().getIndexManager().getIndex(indexName);
        if (idx != null) {
            Object indexValue = idx.get(iValue = this.convertKey(idx, iValue));
            if (indexValue != null && !(indexValue instanceof Iterable)) {
                indexValue = Arrays.asList(indexValue);
            }
            return new OrientElementIterable<Edge>(this, (Iterable)indexValue);
        }
        return this.query().has(key, iValue).edges();
    }

    @Override
    public OrientEdge getEdge(Object id) {
        OIdentifiable rec;
        this.makeActive();
        if (null == id) {
            throw ExceptionFactory.edgeIdCanNotBeNull();
        }
        if (id instanceof OrientEdge) {
            return (OrientEdge)id;
        }
        if (id instanceof ODocument) {
            return new OrientEdge(this, (OIdentifiable)id);
        }
        if (id instanceof OIdentifiable) {
            rec = (OIdentifiable)id;
        } else {
            String str = id.toString();
            int pos = str.indexOf("->");
            if (pos > -1) {
                String from = str.substring(0, pos);
                String to = str.substring(pos + 2);
                return this.getEdgeInstance(new ORecordId(from), new ORecordId(to), null);
            }
            try {
                rec = new ORecordId(str);
            }
            catch (IllegalArgumentException iae) {
                return null;
            }
        }
        ODocument doc = (ODocument)rec.getRecord();
        if (doc == null) {
            return null;
        }
        OClass cls = doc.getSchemaClass();
        if (cls != null) {
            if (cls.isVertexType()) {
                throw new IllegalArgumentException("Cannot retrieve an edge with the RID " + id + " because it is a vertex");
            }
            if (!cls.isEdgeType()) {
                throw new IllegalArgumentException("Class '" + doc.getClassName() + "' is not an edge class");
            }
        }
        return new OrientEdge(this, rec);
    }

    @Override
    public void removeEdge(Edge edge) {
        this.makeActive();
        edge.remove();
    }

    public OrientBaseGraph reuse(ODatabaseDocumentTx iDatabase) {
        ODatabaseRecordThreadLocal.instance().set(iDatabase);
        this.url = iDatabase.getURL();
        this.database = iDatabase;
        this.makeActive();
        return this;
    }

    public boolean isClosed() {
        return this.database == null || this.database.isClosed();
    }

    @Override
    public void shutdown() {
        this.shutdown(true);
    }

    public void shutdown(boolean closeDb) {
        this.shutdown(closeDb, true);
    }

    public void shutdown(boolean closeDb, boolean commitTx) {
        this.makeActive();
        try {
            if (!this.isClosed()) {
                if (commitTx) {
                    OStorage storage = this.getDatabase().getStorage().getUnderlying();
                    if (storage instanceof OAbstractPaginatedStorage && ((OAbstractPaginatedStorage)storage).getWALInstance() != null) {
                        this.getDatabase().commit();
                    }
                } else if (closeDb) {
                    this.getDatabase().rollback();
                }
            }
        }
        catch (ONeedRetryException e) {
            throw e;
        }
        catch (RuntimeException e) {
            OLogManager.instance().error(this, "Error during context close for db " + this.url, e, new Object[0]);
            throw e;
        }
        catch (Exception e) {
            OLogManager.instance().error(this, "Error during context close for db " + this.url, e, new Object[0]);
            throw OException.wrapException(new ODatabaseException("Error during context close for db " + this.url), e);
        }
        finally {
            try {
                if (closeDb) {
                    this.getDatabase().close();
                    if (this.getDatabase().isPooled()) {
                        this.database = null;
                    }
                }
                this.pollGraphFromStack(closeDb);
            }
            catch (Exception e) {
                OLogManager.instance().error(this, "Error during context close for db " + this.url, e, new Object[0]);
            }
        }
        this.url = null;
        this.username = null;
        this.password = null;
        if (!closeDb) {
            this.getDatabase().activateOnCurrentThread();
        }
    }

    public String toString() {
        return StringFactory.graphString(this, this.getRawGraph().getURL());
    }

    @Override
    public ODatabaseDocumentTx getRawGraph() {
        return this.getDatabase();
    }

    public void begin() {
        this.makeActive();
    }

    public void commit() {
        this.makeActive();
    }

    public void rollback() {
        this.makeActive();
    }

    @Override
    public OrientVertexType getVertexBaseType() {
        this.makeActive();
        return new OrientVertexType(this, this.getRawGraph().getMetadata().getSchema().getClass("V"));
    }

    @Override
    public OrientVertexType getVertexType(String iTypeName) {
        this.makeActive();
        OClass cls = this.getRawGraph().getMetadata().getSchema().getClass(iTypeName);
        if (cls == null) {
            return null;
        }
        OrientVertexType.checkType(cls);
        return new OrientVertexType(this, cls);
    }

    @Override
    public OrientVertexType createVertexType(String iClassName) {
        this.makeActive();
        return this.createVertexType(iClassName, (String)null);
    }

    @Override
    public OrientVertexType createVertexType(String iClassName, int clusters) {
        this.makeActive();
        return this.createVertexType(iClassName, (String)null, clusters);
    }

    @Override
    public OrientVertexType createVertexType(String iClassName, String iSuperClassName) {
        this.makeActive();
        return this.createVertexType(iClassName, iSuperClassName == null ? this.getVertexBaseType() : this.getVertexType(iSuperClassName));
    }

    @Override
    public OrientVertexType createVertexType(String iClassName, String iSuperClassName, int clusters) {
        this.makeActive();
        return this.createVertexType(iClassName, iSuperClassName == null ? this.getVertexBaseType() : this.getVertexType(iSuperClassName), clusters);
    }

    @Override
    public OrientVertexType createVertexType(final String iClassName, final OClass iSuperClass) {
        this.makeActive();
        OrientVertexType.checkType(iSuperClass);
        return this.executeOutsideTx(new OCallable<OrientVertexType, OrientBaseGraph>(){

            @Override
            public OrientVertexType call(OrientBaseGraph g) {
                return new OrientVertexType(g, OrientBaseGraph.this.getRawGraph().getMetadata().getSchema().createClass(iClassName, iSuperClass));
            }
        }, "create vertex type '", iClassName, "' as subclass of '", iSuperClass.getName(), "'");
    }

    @Override
    public OrientVertexType createVertexType(final String iClassName, final OClass iSuperClass, final int clusters) {
        this.makeActive();
        OrientVertexType.checkType(iSuperClass);
        return this.executeOutsideTx(new OCallable<OrientVertexType, OrientBaseGraph>(){

            @Override
            public OrientVertexType call(OrientBaseGraph g) {
                return new OrientVertexType(g, OrientBaseGraph.this.getRawGraph().getMetadata().getSchema().createClass(iClassName, clusters, iSuperClass));
            }
        }, "create vertex type '", iClassName, "' as subclass of '", iSuperClass.getName(), "' (clusters=" + clusters + ")");
    }

    @Override
    public void dropVertexType(final String iTypeName) {
        this.makeActive();
        if (this.getDatabase().countClass(iTypeName) > 0L) {
            throw new OCommandExecutionException("cannot drop vertex type '" + iTypeName + "' because it contains Vertices. Use 'DELETE VERTEX' command first to remove data");
        }
        this.executeOutsideTx(new OCallable<OClass, OrientBaseGraph>(){

            @Override
            public OClass call(OrientBaseGraph g) {
                ODatabaseDocumentTx rawGraph = OrientBaseGraph.this.getRawGraph();
                rawGraph.command(new OCommandSQL("delete vertex " + iTypeName)).execute(new Object[0]);
                rawGraph.getMetadata().getSchema().dropClass(iTypeName);
                return null;
            }
        }, "drop vertex type '", iTypeName, "'");
    }

    @Override
    public OrientEdgeType getEdgeBaseType() {
        this.makeActive();
        return new OrientEdgeType(this);
    }

    @Override
    public OrientEdgeType getEdgeType(String iTypeName) {
        this.makeActive();
        OClass cls = this.getRawGraph().getMetadata().getSchema().getClass(iTypeName);
        if (cls == null) {
            return null;
        }
        OrientEdgeType.checkType(cls);
        return new OrientEdgeType(this, cls);
    }

    @Override
    public OrientEdgeType createEdgeType(String iClassName) {
        this.makeActive();
        return this.createEdgeType(iClassName, (String)null);
    }

    public OrientEdgeType createEdgeType(String iClassName, int clusters) {
        this.makeActive();
        return this.createEdgeType(iClassName, (String)null, clusters);
    }

    @Override
    public OrientEdgeType createEdgeType(String iClassName, String iSuperClassName) {
        this.makeActive();
        return this.createEdgeType(iClassName, iSuperClassName == null ? this.getEdgeBaseType() : this.getEdgeType(iSuperClassName));
    }

    public OrientEdgeType createEdgeType(String iClassName, String iSuperClassName, int clusters) {
        this.makeActive();
        return this.createEdgeType(iClassName, iSuperClassName == null ? this.getEdgeBaseType() : this.getEdgeType(iSuperClassName), clusters);
    }

    @Override
    public OrientEdgeType createEdgeType(final String iClassName, final OClass iSuperClass, final int clusters) {
        this.makeActive();
        OrientEdgeType.checkType(iSuperClass);
        return this.executeOutsideTx(new OCallable<OrientEdgeType, OrientBaseGraph>(){

            @Override
            public OrientEdgeType call(OrientBaseGraph g) {
                return new OrientEdgeType(g, OrientBaseGraph.this.getRawGraph().getMetadata().getSchema().createClass(iClassName, clusters, iSuperClass));
            }
        }, "create edge type '", iClassName, "' as subclass of '", iSuperClass.getName(), "' (clusters=" + clusters + ")");
    }

    @Override
    public OrientEdgeType createEdgeType(final String iClassName, final OClass iSuperClass) {
        this.makeActive();
        OrientEdgeType.checkType(iSuperClass);
        return this.executeOutsideTx(new OCallable<OrientEdgeType, OrientBaseGraph>(){

            @Override
            public OrientEdgeType call(OrientBaseGraph g) {
                return new OrientEdgeType(g, OrientBaseGraph.this.getRawGraph().getMetadata().getSchema().createClass(iClassName, iSuperClass));
            }
        }, "create edge type '", iClassName, "' as subclass of '", iSuperClass.getName(), "'");
    }

    @Override
    public void dropEdgeType(final String iTypeName) {
        this.makeActive();
        if (this.getDatabase().countClass(iTypeName) > 0L) {
            throw new OCommandExecutionException("cannot drop edge type '" + iTypeName + "' because it contains Edges. Use 'DELETE EDGE' command first to remove data");
        }
        this.executeOutsideTx(new OCallable<OClass, OrientBaseGraph>(){

            @Override
            public OClass call(OrientBaseGraph g) {
                OrientBaseGraph.this.getRawGraph().getMetadata().getSchema().dropClass(iTypeName);
                return null;
            }
        }, "drop edge type '", iTypeName, "'");
    }

    @Override
    public OrientElement detach(OrientElement iElement) {
        this.makeActive();
        iElement.detach();
        return iElement;
    }

    @Override
    public OrientElement attach(OrientElement iElement) {
        this.makeActive();
        return iElement.attach(this);
    }

    public OrientElement getElement(Object id) {
        OIdentifiable rec;
        this.makeActive();
        if (null == id) {
            throw new IllegalArgumentException("id cannot be null");
        }
        if (id instanceof OrientElement) {
            return (OrientElement)id;
        }
        if (id instanceof OIdentifiable) {
            rec = (OIdentifiable)id;
        } else {
            try {
                rec = new ORecordId(id.toString());
            }
            catch (IllegalArgumentException iae) {
                return null;
            }
        }
        ODocument doc = (ODocument)rec.getRecord();
        if (doc != null) {
            OImmutableClass schemaClass = ODocumentInternal.getImmutableSchemaClass(doc);
            if (schemaClass != null && schemaClass.isEdgeType()) {
                return this.getEdge(doc);
            }
            return this.getVertexInstance(doc);
        }
        return null;
    }

    @Override
    public <T extends Element> void dropKeyIndex(final String key, final Class<T> elementClass) {
        this.makeActive();
        if (elementClass == null) {
            throw ExceptionFactory.classForElementCannotBeNull();
        }
        this.executeOutsideTx(new OCallable<OClass, OrientBaseGraph>(){

            @Override
            public OClass call(OrientBaseGraph g) {
                String className = OrientBaseGraph.this.getClassName(elementClass);
                OrientBaseGraph.this.getRawGraph().getMetadata().getIndexManager().dropIndex(className + "." + key);
                return null;
            }
        }, "drop key index '", elementClass.getSimpleName(), ".", key, "'");
    }

    @Override
    public <T extends Element> void createKeyIndex(final String key, final Class<T> elementClass, final Parameter ... indexParameters) {
        this.makeActive();
        if (elementClass == null) {
            throw ExceptionFactory.classForElementCannotBeNull();
        }
        this.executeOutsideTx(new OCallable<OClass, OrientBaseGraph>(){

            @Override
            public OClass call(OrientBaseGraph g) {
                ODatabaseDocumentTx db;
                OSchemaProxy schema;
                OClass cls;
                OProperty property;
                String indexType = OClass.INDEX_TYPE.NOTUNIQUE.name();
                OType keyType = OType.STRING;
                String className = null;
                String collate = null;
                ODocument metadata = null;
                String ancestorClassName = OrientBaseGraph.this.getClassName(elementClass);
                for (Parameter p : indexParameters) {
                    if (p.getKey().equals("type")) {
                        indexType = p.getValue().toString().toUpperCase(Locale.ENGLISH);
                        continue;
                    }
                    if (p.getKey().equals("keytype")) {
                        keyType = OType.valueOf(p.getValue().toString().toUpperCase(Locale.ENGLISH));
                        continue;
                    }
                    if (p.getKey().equals("class")) {
                        className = p.getValue().toString();
                        continue;
                    }
                    if (p.getKey().equals("collate")) {
                        collate = p.getValue().toString();
                        continue;
                    }
                    if (!p.getKey().toString().startsWith("metadata.")) continue;
                    if (metadata == null) {
                        metadata = new ODocument();
                    }
                    metadata.field(p.getKey().toString().substring("metadata.".length()), p.getValue());
                }
                if (className == null) {
                    className = ancestorClassName;
                }
                if ((property = (cls = (schema = (db = OrientBaseGraph.this.getRawGraph()).getMetadata().getSchema()).getOrCreateClass(className, schema.getClass(ancestorClassName))).getProperty(key)) != null) {
                    keyType = property.getType();
                }
                OPropertyIndexDefinition indexDefinition = new OPropertyIndexDefinition(className, key, keyType);
                if (collate != null) {
                    indexDefinition.setCollate(collate);
                }
                db.getMetadata().getIndexManager().createIndex(className + "." + key, indexType, indexDefinition, cls.getPolymorphicClusterIds(), null, metadata);
                return null;
            }
        }, "create key index on '", elementClass.getSimpleName(), ".", key, "'");
    }

    @Override
    public <T extends Element> Set<String> getIndexedKeys(Class<T> elementClass) {
        this.makeActive();
        return this.getIndexedKeys(elementClass, false);
    }

    public <T extends Element> Set<String> getIndexedKeys(Class<T> elementClass, boolean includeClassNames) {
        this.makeActive();
        if (elementClass == null) {
            throw ExceptionFactory.classForElementCannotBeNull();
        }
        OImmutableSchema schema = this.getRawGraph().getMetadata().getImmutableSchemaSnapshot();
        String elementOClassName = this.getClassName(elementClass);
        HashSet<String> result = new HashSet<String>();
        Collection<OIndex<?>> indexes = this.getRawGraph().getMetadata().getIndexManager().getIndexes();
        for (OIndex<?> index : indexes) {
            String oClassName;
            OClass oClass;
            String indexName = index.getName();
            int point = indexName.indexOf(".");
            if (point <= 0 || (oClass = schema.getClass(oClassName = indexName.substring(0, point))) == null || !oClass.isSubClassOf(elementOClassName)) continue;
            if (includeClassNames) {
                result.add(index.getName());
                continue;
            }
            result.add(index.getDefinition().getFields().get(0));
        }
        return result;
    }

    @Override
    public GraphQuery query() {
        this.makeActive();
        return new OrientGraphQuery(this);
    }

    @Override
    public OTraverse traverse() {
        this.makeActive();
        return new OTraverse();
    }

    @Override
    public OCommandRequest command(OCommandRequest iCommand) {
        this.makeActive();
        return new OrientGraphCommand(this, this.getRawGraph().command(iCommand));
    }

    @Override
    public long countVertices() {
        return this.countVertices("V");
    }

    @Override
    public long countVertices(String iClassName) {
        this.makeActive();
        return this.getRawGraph().countClass(iClassName);
    }

    @Override
    public long countEdges() {
        return this.countEdges("E");
    }

    @Override
    public long countEdges(String iClassName) {
        this.makeActive();
        if (this.isUseLightweightEdges()) {
            throw new UnsupportedOperationException("Graph set to use Lightweight Edges, count against edges is not supported");
        }
        return this.getRawGraph().countClass(iClassName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <RET> RET executeOutsideTx(OCallable<RET, OrientBaseGraph> iCallable, String ... iOperationStrings) throws RuntimeException {
        int committed;
        this.makeActive();
        ODatabaseDocumentTx raw = this.getRawGraph();
        if (raw.getTransaction().isActive()) {
            if (this.isWarnOnForceClosingTx() && OLogManager.instance().isWarnEnabled() && iOperationStrings.length > 0) {
                StringBuilder msg = new StringBuilder(256);
                for (String s : iOperationStrings) {
                    msg.append(s);
                }
                OLogManager.instance().warn((Object)this, "Requested command '%s' must be executed outside active transaction: the transaction will be committed and reopen right after it. To avoid this behavior execute it outside a transaction", msg.toString());
            }
            committed = raw.getTransaction().amountOfNestedTxs();
            raw.commit(true);
        } else {
            committed = 0;
        }
        try {
            RET RET = iCallable.call(this);
            return RET;
        }
        finally {
            if (this instanceof TransactionalGraph) {
                for (int i = 0; i < committed; ++i) {
                    ((OrientTransactionalGraph)this).begin();
                }
            }
        }
    }

    protected void autoStartTransaction() {
    }

    protected void saveIndexConfiguration() {
        this.getRawGraph().getMetadata().getIndexManager().getConfiguration().save();
    }

    protected <T> String getClassName(Class<T> elementClass) {
        if (elementClass.isAssignableFrom(Vertex.class)) {
            return "V";
        }
        if (elementClass.isAssignableFrom(Edge.class)) {
            return "E";
        }
        throw new IllegalArgumentException("Class '" + elementClass + "' is neither a Vertex, nor an Edge");
    }

    protected Object convertKey(OIndex<?> idx, Object iValue) {
        if (iValue != null) {
            OType[] types = idx.getKeyTypes();
            if (types.length == 0) {
                iValue = iValue.toString();
            } else if (types.length == 1) {
                iValue = OType.convert(iValue, types[0].getDefaultJavaType());
            } else if (!(iValue instanceof OCompositeKey) && OMultiValue.isMultiValue(iValue)) {
                Iterable<Object> values = OMultiValue.getMultiValueIterable(iValue);
                ArrayList<Object> keys2 = new ArrayList<Object>();
                for (Object value : values) {
                    keys2.add(value);
                }
                if (keys2.size() <= types.length) {
                    for (int i = 0; i < types.length; ++i) {
                        keys2.set(i, OType.convert(keys2.get(i), types[i].getDefaultJavaType()));
                    }
                } else {
                    throw new IllegalArgumentException("Cannot build a composite key from the input. The size of the parameters is major than the number indexed fields");
                }
                iValue = new OCompositeKey(keys2);
            }
        }
        return iValue;
    }

    protected Object[] convertKeys(OIndex<?> idx, Object[] iValue) {
        OType[] types;
        if (iValue != null && (types = idx.getKeyTypes()).length == iValue.length) {
            Object[] newValue = new Object[types.length];
            for (int i = 0; i < types.length; ++i) {
                newValue[i] = OType.convert(iValue[i], types[i].getDefaultJavaType());
            }
            iValue = newValue;
        }
        return iValue;
    }

    void throwRecordNotFoundException(ORID identity, String message) {
        if (this.settings.isStandardExceptions()) {
            throw new IllegalStateException(message);
        }
        throw new ORecordNotFoundException(identity, message);
    }

    protected void setCurrentGraphInThreadLocal() {
        if (this.getThreadMode() == OrientConfigurableGraph.THREAD_MODE.MANUAL) {
            return;
        }
        ODatabaseDocumentInternal tlDb = ODatabaseRecordThreadLocal.instance().getIfDefined();
        if ((this.getThreadMode() == OrientConfigurableGraph.THREAD_MODE.ALWAYS_AUTOSET || tlDb == null) && this.getDatabase() != null && tlDb != this.getDatabase()) {
            ODatabaseRecordThreadLocal.instance().set(this.getDatabase());
        }
    }

    private void putInInitializationStack() {
        Deque<OrientBaseGraph> stack = initializationStack.get();
        stack.push(this);
    }

    private void pollGraphFromStack(boolean updateDb) {
        Deque<OrientBaseGraph> stack = initializationStack.get();
        stack.remove(this);
        OrientBaseGraph prevGraph = stack.peek();
        if (prevGraph != null) {
            activeGraph.set(prevGraph);
            prevGraph.makeActive();
        } else {
            activeGraph.set(null);
            if (updateDb) {
                ODatabaseRecordThreadLocal.instance().set(null);
            }
        }
    }

    private void readDatabaseConfiguration() {
        ODatabaseDocumentTx databaseDocumentTx = this.getRawGraph();
        List custom = (List)databaseDocumentTx.get(ODatabase.ATTRIBUTES.CUSTOM);
        for (OStorageEntryConfiguration c : custom) {
            if (c.name.equals("useLightweightEdges")) {
                this.setUseLightweightEdges(Boolean.parseBoolean(c.value));
                continue;
            }
            if (c.name.equals("txRequiredForSQLGraphOperations")) {
                this.setTxRequiredForSQLGraphOperations(Boolean.parseBoolean(c.value));
                continue;
            }
            if (c.name.equals("maxRetries")) {
                this.setMaxRetries(Integer.parseInt(c.value));
                continue;
            }
            if (c.name.equals("useClassForEdgeLabel")) {
                this.setUseClassForEdgeLabel(Boolean.parseBoolean(c.value));
                continue;
            }
            if (c.name.equals("useClassForVertexLabel")) {
                this.setUseClassForVertexLabel(Boolean.parseBoolean(c.value));
                continue;
            }
            if (c.name.equals("useVertexFieldsForEdgeLabels")) {
                this.setUseVertexFieldsForEdgeLabels(Boolean.parseBoolean(c.value));
                continue;
            }
            if (!c.name.equals("standardElementConstraints")) continue;
            this.setStandardElementConstraints(Boolean.parseBoolean(c.value));
        }
    }

    private void openOrCreate() {
        if (this.url == null) {
            throw new IllegalStateException("Database is closed");
        }
        if (this.pool == null) {
            this.database = new ODatabaseDocumentTx(this.url);
            if (this.properties != null) {
                for (Map.Entry<String, Object> entry : this.properties.entrySet()) {
                    this.database.setProperty(entry.getKey(), entry.getValue());
                }
            }
            if (this.getDatabase().getStorage().getUnderlying() instanceof OAbstractPaginatedStorage) {
                ((OAbstractPaginatedStorage)this.getDatabase().getStorage().getUnderlying()).registerRecoverListener(this);
            }
            if (this.url.startsWith("remote:") || this.getDatabase().exists()) {
                if (this.getDatabase().isClosed()) {
                    this.getDatabase().open(this.username, this.password);
                }
            } else {
                this.getDatabase().create();
            }
        } else {
            this.database = this.pool.acquire();
            if (this.getDatabase().getStorage().getUnderlying() instanceof OAbstractPaginatedStorage) {
                ((OAbstractPaginatedStorage)this.getDatabase().getStorage().getUnderlying()).registerRecoverListener(this);
            }
        }
        this.makeActive();
        this.putInInitializationStack();
    }

    private List<Index<? extends Element>> loadManualIndexes() {
        ArrayList<Index<? extends Element>> result = new ArrayList<Index<? extends Element>>();
        for (OIndex<?> idx : this.getDatabase().getMetadata().getIndexManager().getIndexes()) {
            if (!this.hasIndexClass(idx)) continue;
            result.add(new OrientIndex(this, idx));
        }
        return result;
    }

    private boolean hasIndexClass(OIndex<?> idx) {
        ODocument metadata = idx.getMetadata();
        return metadata != null && metadata.field("blueprintsIndexClass") != null || idx.getConfiguration().field("blueprintsIndexClass") != null;
    }

    protected ODatabaseDocumentTx getDatabase() {
        if (this.database == null) {
            throw new ODatabaseException("Database is closed");
        }
        return this.database;
    }

    protected static void removeEdges(OrientBaseGraph graph, ODocument iVertex, String iFieldName, OIdentifiable iVertexToRemove, boolean iAlsoInverse, boolean useVertexFieldsForEdgeLabels, boolean autoScaleEdgeType, boolean forceReload) {
        Object fieldValue;
        if (iVertex == null) {
            return;
        }
        Object object = fieldValue = iVertexToRemove != null ? iVertex.field(iFieldName) : iVertex.removeField(iFieldName);
        if (fieldValue == null) {
            return;
        }
        if (fieldValue instanceof OIdentifiable) {
            if (iVertexToRemove != null) {
                if (!fieldValue.equals(iVertexToRemove)) {
                    return;
                }
                iVertex.removeField(iFieldName);
                OrientBaseGraph.deleteEdgeIfAny(iVertexToRemove, forceReload);
            }
            if (iAlsoInverse) {
                OrientBaseGraph.removeInverseEdge(graph, iVertex, iFieldName, iVertexToRemove, (OIdentifiable)fieldValue, useVertexFieldsForEdgeLabels, autoScaleEdgeType, forceReload);
            }
        } else if (fieldValue instanceof ORidBag) {
            ORidBag bag = (ORidBag)fieldValue;
            if (iVertexToRemove != null) {
                OClass cls = graph.getDatabase().getMetadata().getImmutableSchemaSnapshot().getClassByClusterId(iVertexToRemove.getIdentity().getClusterId());
                if (!iAlsoInverse && cls.isEdgeType()) {
                    bag.remove(iVertexToRemove);
                } else {
                    Iterator<OIdentifiable> it = bag.rawIterator();
                    while (it.hasNext()) {
                        Direction direction;
                        ODocument curr = OrientBaseGraph.getDocument(it.next(), forceReload);
                        if (curr == null) {
                            it.remove();
                            iVertex.save();
                            continue;
                        }
                        if (curr == null) {
                            it.remove();
                            continue;
                        }
                        if (iVertexToRemove.equals(curr)) {
                            it.remove();
                            if (!iAlsoInverse) break;
                            OrientBaseGraph.removeInverseEdge(graph, iVertex, iFieldName, iVertexToRemove, curr, useVertexFieldsForEdgeLabels, autoScaleEdgeType, forceReload);
                            break;
                        }
                        if (!ODocumentInternal.getImmutableSchemaClass(curr).isEdgeType() || !iVertexToRemove.equals(OrientEdge.getConnection(curr, (direction = OrientVertex.getConnectionDirection(iFieldName, useVertexFieldsForEdgeLabels)).opposite()))) continue;
                        it.remove();
                        if (!iAlsoInverse) break;
                        OrientBaseGraph.removeInverseEdge(graph, iVertex, iFieldName, iVertexToRemove, curr, useVertexFieldsForEdgeLabels, autoScaleEdgeType, forceReload);
                        break;
                    }
                }
                OrientBaseGraph.deleteEdgeIfAny(iVertexToRemove, forceReload);
            } else {
                Iterator<OIdentifiable> it = bag.rawIterator();
                while (it.hasNext()) {
                    OIdentifiable edge = it.next();
                    if (iAlsoInverse) {
                        OrientBaseGraph.removeInverseEdge(graph, iVertex, iFieldName, null, edge, useVertexFieldsForEdgeLabels, autoScaleEdgeType, forceReload);
                    }
                    OrientBaseGraph.deleteEdgeIfAny(edge, forceReload);
                }
            }
            if (autoScaleEdgeType && bag.isEmpty()) {
                iVertex.removeField(iFieldName);
            }
        } else if (fieldValue instanceof Collection) {
            Collection col = (Collection)fieldValue;
            if (iVertexToRemove != null) {
                Iterator it = col.iterator();
                while (it.hasNext()) {
                    Direction direction;
                    ODocument curr = OrientBaseGraph.getDocument((OIdentifiable)it.next(), forceReload);
                    if (curr == null) continue;
                    if (iVertexToRemove.equals(curr)) {
                        it.remove();
                        if (!iAlsoInverse) break;
                        OrientBaseGraph.removeInverseEdge(graph, iVertex, iFieldName, iVertexToRemove, curr, useVertexFieldsForEdgeLabels, autoScaleEdgeType, forceReload);
                        break;
                    }
                    if (!ODocumentInternal.getImmutableSchemaClass(curr).isVertexType() || !iVertexToRemove.equals(OrientEdge.getConnection(curr, (direction = OrientVertex.getConnectionDirection(iFieldName, useVertexFieldsForEdgeLabels)).opposite()))) continue;
                    it.remove();
                    if (!iAlsoInverse) break;
                    OrientBaseGraph.removeInverseEdge(graph, iVertex, iFieldName, iVertexToRemove, curr, useVertexFieldsForEdgeLabels, autoScaleEdgeType, forceReload);
                    break;
                }
                OrientBaseGraph.deleteEdgeIfAny(iVertexToRemove, forceReload);
            } else {
                for (OIdentifiable edge : col) {
                    if (iAlsoInverse) {
                        OrientBaseGraph.removeInverseEdge(graph, iVertex, iFieldName, null, edge, useVertexFieldsForEdgeLabels, autoScaleEdgeType, forceReload);
                    }
                    OrientBaseGraph.deleteEdgeIfAny(edge, forceReload);
                }
            }
            if (autoScaleEdgeType && col.isEmpty()) {
                iVertex.removeField(iFieldName);
            }
        }
    }

    private static void removeInverseEdge(OrientBaseGraph graph, ODocument iVertex, String iFieldName, OIdentifiable iVertexToRemove, OIdentifiable currentRecord, boolean useVertexFieldsForEdgeLabels, boolean autoScaleEdgeType, boolean forceReload) {
        OIdentifiable otherVertex;
        ODocument r = OrientBaseGraph.getDocument(currentRecord, forceReload);
        if (r == null) {
            return;
        }
        String inverseFieldName = OrientVertex.getInverseConnectionFieldName(iFieldName, useVertexFieldsForEdgeLabels);
        OClass klass = ODocumentInternal.getImmutableSchemaClass(r);
        if (klass == null) {
            graph.getDatabase().getMetadata().reload();
            klass = graph.getDatabase().getMetadata().getSchema().getClass(inverseFieldName);
            if (klass == null) {
                OLogManager.instance().warn(null, "Removing edge, schema class not found for " + r, new Object[0]);
                return;
            }
        }
        if (klass.isVertexType()) {
            OrientBaseGraph.removeEdges(graph, r, inverseFieldName, iVertex, false, useVertexFieldsForEdgeLabels, autoScaleEdgeType, forceReload);
            r.save();
        } else if (klass.isEdgeType() && (otherVertex = OrientEdge.getConnection(r, OrientVertex.getConnectionDirection(inverseFieldName, useVertexFieldsForEdgeLabels))) != null && (iVertexToRemove == null || otherVertex.equals(iVertexToRemove))) {
            int maxRetries = graph.getMaxRetries();
            for (int retry = 0; retry < maxRetries; ++retry) {
                try {
                    ODocument otherVertexRecord = OrientBaseGraph.getDocument(otherVertex, forceReload);
                    OrientBaseGraph.removeEdges(graph, otherVertexRecord, inverseFieldName, currentRecord, false, useVertexFieldsForEdgeLabels, autoScaleEdgeType, forceReload);
                    if (otherVertexRecord == null) break;
                    otherVertexRecord.save();
                    break;
                }
                catch (ONeedRetryException oNeedRetryException) {
                    continue;
                }
            }
        }
    }

    protected static ODocument getDocument(OIdentifiable id, boolean forceReload) {
        if (id == null) {
            return null;
        }
        ODocument doc = (ODocument)id.getRecord();
        if (doc != null && forceReload) {
            try {
                doc.reload();
            }
            catch (ORecordNotFoundException oRecordNotFoundException) {
                // empty catch block
            }
        }
        return doc;
    }

    protected static void deleteEdgeIfAny(OIdentifiable iRecord, boolean forceReload) {
        OImmutableClass clazz;
        ODocument doc;
        if (iRecord != null && (doc = OrientBaseGraph.getDocument(iRecord, forceReload)) != null && (clazz = ODocumentInternal.getImmutableSchemaClass(doc)) != null && clazz.isEdgeType()) {
            doc.delete();
        }
    }

    public OIntent getIntent() {
        return this.getDatabase().getActiveIntent();
    }

    protected OrientVertex getVertexInstance(OIdentifiable id) {
        return new OrientVertex(this, id);
    }

    protected OrientVertex getVertexInstance(String className, Object ... fields) {
        return new OrientVertex(this, className, fields);
    }

    protected OrientEdge getEdgeInstance(OIdentifiable id) {
        return new OrientEdge(this, id);
    }

    protected OrientEdge getEdgeInstance(String className, Object ... fields) {
        return new OrientEdge(this, className, fields);
    }

    protected OrientEdge getEdgeInstance(OIdentifiable from, OIdentifiable to, String label) {
        return new OrientEdge(this, from, to, label);
    }

    @Override
    protected Object setProperty(String iName, Object iValue) {
        if (this.properties == null) {
            this.properties = new HashMap<String, Object>();
        }
        return this.properties.put(iName, iValue);
    }

    @Override
    protected Object getProperty(String iName) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(iName);
    }

    @Override
    public Map<String, Object> getProperties() {
        return this.properties;
    }

    static {
        Orient.instance().registerListener(new OOrientListenerAbstract(){

            @Override
            public void onStartup() {
                if (activeGraph == null) {
                    activeGraph = new ThreadLocal();
                }
                if (initializationStack == null) {
                    initializationStack = new InitializationStackThreadLocal();
                }
            }

            @Override
            public void onShutdown() {
                activeGraph = null;
                initializationStack = null;
            }
        });
    }

    private static class InitializationStackThreadLocal
    extends ThreadLocal<Deque<OrientBaseGraph>> {
        private InitializationStackThreadLocal() {
        }

        @Override
        protected Deque<OrientBaseGraph> initialValue() {
            return new LinkedList<OrientBaseGraph>();
        }
    }
}

