/*
 * Decompiled with CFR 0.152.
 */
package com.arcadeanalytics.provider.orient2;

import com.arcadeanalytics.data.Sprite;
import com.arcadeanalytics.data.SpritePlayer;
import com.arcadeanalytics.provider.DataSourceGraphProvider;
import com.arcadeanalytics.provider.DataSourceInfo;
import com.arcadeanalytics.provider.orient2.OrientDBDataSourceGraphProvider;
import com.arcadeanalytics.provider.orient2.OrientDBUtilsKt;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import java.io.Closeable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00040\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/arcadeanalytics/provider/orient2/OrientDBDataSourceGraphProvider;", "Lcom/arcadeanalytics/provider/DataSourceGraphProvider;", "()V", "ALL_E", "", "ALL_V", "allFields", "Ljava/util/regex/Pattern;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "queries", "", "provideTo", "", "dataSource", "Lcom/arcadeanalytics/provider/DataSourceInfo;", "player", "Lcom/arcadeanalytics/data/SpritePlayer;", "supportedDataSourceTypes", "", "toSprite", "Lcom/arcadeanalytics/data/Sprite;", "document", "Lcom/orientechnologies/orient/core/record/impl/ODocument;", "arcade-connectors-orientdb2"})
public final class OrientDBDataSourceGraphProvider
implements DataSourceGraphProvider {
    private final Logger log = LoggerFactory.getLogger(OrientDBDataSourceGraphProvider.class);
    private final List<String> queries;
    private final String ALL_V = "SELECT FROM V LIMIT 1000";
    private final String ALL_E = "SELECT FROM E LIMIT 1000";
    private final Pattern allFields;

    @NotNull
    public Set<String> supportedDataSourceTypes() {
        return SetsKt.setOf((Object)"ORIENTDB");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void provideTo(@NotNull DataSourceInfo dataSource, @NotNull SpritePlayer player) {
        Intrinsics.checkParameterIsNotNull((Object)dataSource, (String)"dataSource");
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        Closeable closeable = OrientDBUtilsKt.open(dataSource);
        boolean bl = false;
        Throwable throwable = null;
        try {
            ODatabaseDocumentTx db = (ODatabaseDocumentTx)closeable;
            boolean bl2 = false;
            Sequence $this$forEach$iv = SequencesKt.onEach((Sequence)CollectionsKt.asSequence((Iterable)this.queries), (Function1)((Function1)new Function1<String, Unit>(this, dataSource, player){
                final /* synthetic */ OrientDBDataSourceGraphProvider this$0;
                final /* synthetic */ DataSourceInfo $dataSource$inlined;
                final /* synthetic */ SpritePlayer $player$inlined;
                {
                    this.this$0 = orientDBDataSourceGraphProvider;
                    this.$dataSource$inlined = dataSourceInfo;
                    this.$player$inlined = spritePlayer;
                    super(1);
                }

                public final void invoke(@NotNull String query) {
                    Intrinsics.checkParameterIsNotNull((Object)query, (String)"query");
                    OrientDBDataSourceGraphProvider.access$getLog$p(this.this$0).info("fetching documents from datasource {} with query ' {} ' ", (Object)this.$dataSource$inlined.getId(), (Object)query);
                }
            }));
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String sql = (String)element$iv;
                boolean bl3 = false;
                OSQLSynchQuery query = new OSQLSynchQuery(sql);
                Object resultset = db.query(query, new Object[0]);
                while (!resultset.isEmpty()) {
                    Object RET = resultset;
                    Intrinsics.checkExpressionValueIsNotNull(RET, (String)"resultset");
                    Sequence $this$forEach$iv2 = SequencesKt.map((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)RET)), (Function1)provideTo.1.2.1.INSTANCE), (Function1)provideTo.1.2.2.INSTANCE), (Function1)((Function1)new Function1<ODocument, Sprite>(db, this, dataSource, player){
                        final /* synthetic */ ODatabaseDocumentTx $db$inlined;
                        final /* synthetic */ OrientDBDataSourceGraphProvider this$0;
                        final /* synthetic */ DataSourceInfo $dataSource$inlined;
                        final /* synthetic */ SpritePlayer $player$inlined;
                        {
                            this.$db$inlined = oDatabaseDocumentTx;
                            this.this$0 = orientDBDataSourceGraphProvider;
                            this.$dataSource$inlined = dataSourceInfo;
                            this.$player$inlined = spritePlayer;
                            super(1);
                        }

                        @NotNull
                        public final Sprite invoke(@NotNull ODocument doc) {
                            Intrinsics.checkParameterIsNotNull((Object)doc, (String)"doc");
                            return OrientDBDataSourceGraphProvider.access$toSprite(this.this$0, doc);
                        }
                    }));
                    boolean $i$f$forEach2 = false;
                    for (Object element$iv2 : $this$forEach$iv2) {
                        Sprite doc = (Sprite)element$iv2;
                        boolean bl4 = false;
                        player.play(doc);
                    }
                    resultset = db.query(query, new Object[0]);
                }
                player.end();
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final Sprite toSprite(ODocument document) {
        ORID rid = document.getIdentity();
        Sprite sprite2 = new Sprite();
        Map<String, Object> map = document.toMap();
        Intrinsics.checkExpressionValueIsNotNull(map, (String)"document.toMap()");
        Sprite sprite3 = sprite2.load(map);
        OClass oClass = document.getSchemaClass();
        Intrinsics.checkExpressionValueIsNotNull((Object)oClass, (String)"document.schemaClass");
        Collection<OClass> collection = oClass.getAllSuperClasses();
        Intrinsics.checkExpressionValueIsNotNull(collection, (String)"document.schemaClass\n   \u2026         .allSuperClasses");
        Sprite sprite4 = sprite3.addAll("@class", SequencesKt.toList((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)collection), (Function1)toSprite.sprite.1.INSTANCE))).apply(this.allFields, (Function1)toSprite.sprite.2.INSTANCE).remove("@class", (Object)"V").remove("@class", (Object)"E").remove("@rid");
        StringBuilder stringBuilder = new StringBuilder();
        ORID oRID = rid;
        Intrinsics.checkExpressionValueIsNotNull((Object)oRID, (String)"rid");
        Sprite sprite5 = sprite4.add("_a_id", stringBuilder.append(oRID.getClusterId()).append('_').append(rid.getClusterPosition()).toString()).add("_a_type", OrientDBUtilsKt.type(document));
        return sprite5;
    }

    public OrientDBDataSourceGraphProvider() {
        Pattern pattern = Pattern.compile(".*");
        Intrinsics.checkExpressionValueIsNotNull((Object)pattern, (String)"Pattern.compile(\".*\")");
        this.allFields = pattern;
        this.queries = CollectionsKt.listOf((Object[])new String[]{this.ALL_V, this.ALL_E});
    }

    public static final /* synthetic */ Logger access$getLog$p(OrientDBDataSourceGraphProvider $this) {
        return $this.log;
    }

    public static final /* synthetic */ Sprite access$toSprite(OrientDBDataSourceGraphProvider $this, ODocument document) {
        return $this.toSprite(document);
    }
}

