/*
 * Decompiled with CFR 0.152.
 */
package com.arcadeanalytics.provider.orient2;

import com.arcadeanalytics.provider.DataSourceInfo;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.record.impl.ODocument;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000\"\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u000e\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u0004\u001a\n\u0010\u0007\u001a\u00020\b*\u00020\t\u001a\n\u0010\n\u001a\u00020\b*\u00020\t\u001a\n\u0010\u000b\u001a\u00020\u0001*\u00020\t\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"connectionTemplate", "", "createConnectionUrl", "dataSource", "Lcom/arcadeanalytics/provider/DataSourceInfo;", "open", "Lcom/orientechnologies/orient/core/db/document/ODatabaseDocumentTx;", "isEdgeType", "", "Lcom/orientechnologies/orient/core/record/impl/ODocument;", "isVertexType", "type", "arcade-connectors-orientdb2"})
public final class OrientDBUtilsKt {
    private static final String connectionTemplate = "remote:{server}:{port}/{database}";

    @NotNull
    public static final String createConnectionUrl(@NotNull DataSourceInfo dataSource) {
        Intrinsics.checkParameterIsNotNull((Object)dataSource, (String)"dataSource");
        return StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)connectionTemplate, (String)"{server}", (String)dataSource.getServer(), (boolean)false, (int)4, null), (String)"{port}", (String)String.valueOf(dataSource.getPort()), (boolean)false, (int)4, null), (String)"{database}", (String)dataSource.getDatabase(), (boolean)false, (int)4, null);
    }

    @NotNull
    public static final ODatabaseDocumentTx open(@NotNull DataSourceInfo dataSource) {
        Intrinsics.checkParameterIsNotNull((Object)dataSource, (String)"dataSource");
        String connectionUrl = OrientDBUtilsKt.createConnectionUrl(dataSource);
        ODatabaseDocumentTx db = new ODatabaseDocumentTx(connectionUrl);
        Object DB = db.open(dataSource.getUsername(), dataSource.getPassword());
        Intrinsics.checkExpressionValueIsNotNull(DB, (String)"db.open<ODatabaseDocumen\u2026ame, dataSource.password)");
        return (ODatabaseDocumentTx)DB;
    }

    public static final boolean isEdgeType(@NotNull ODocument $this$isEdgeType) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isEdgeType, (String)"$this$isEdgeType");
        OClass oClass = $this$isEdgeType.getSchemaClass();
        Intrinsics.checkExpressionValueIsNotNull((Object)oClass, (String)"this.schemaClass");
        return oClass.isEdgeType();
    }

    public static final boolean isVertexType(@NotNull ODocument $this$isVertexType) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isVertexType, (String)"$this$isVertexType");
        OClass oClass = $this$isVertexType.getSchemaClass();
        Intrinsics.checkExpressionValueIsNotNull((Object)oClass, (String)"this.schemaClass");
        return oClass.isVertexType();
    }

    @NotNull
    public static final String type(@NotNull ODocument $this$type) {
        Intrinsics.checkParameterIsNotNull((Object)$this$type, (String)"$this$type");
        return OrientDBUtilsKt.isEdgeType($this$type) ? "edge" : (OrientDBUtilsKt.isVertexType($this$type) ? "node" : "document");
    }

    static {
        connectionTemplate = connectionTemplate;
    }
}

