/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractIterator;
import com.carrotsearch.hppc.AbstractKTypeCollection;
import com.carrotsearch.hppc.HashContainerUtils;
import com.carrotsearch.hppc.Internals;
import com.carrotsearch.hppc.Intrinsics;
import com.carrotsearch.hppc.KTypeContainer;
import com.carrotsearch.hppc.KTypeLookupContainer;
import com.carrotsearch.hppc.KTypeSet;
import com.carrotsearch.hppc.cursors.KTypeCursor;
import com.carrotsearch.hppc.predicates.KTypePredicate;
import com.carrotsearch.hppc.procedures.KTypeProcedure;
import java.util.Arrays;
import java.util.Iterator;

public class KTypeOpenHashSet<KType>
extends AbstractKTypeCollection<KType>
implements KTypeLookupContainer<KType>,
KTypeSet<KType>,
Cloneable {
    public static final int MIN_CAPACITY = 4;
    public static final int DEFAULT_CAPACITY = 16;
    public static final float DEFAULT_LOAD_FACTOR = 0.75f;
    public KType[] keys;
    public boolean[] allocated;
    public int assigned;
    public final float loadFactor;
    protected int resizeAt;
    protected int lastSlot;
    protected int perturbation;

    public KTypeOpenHashSet() {
        this(16, 0.75f);
    }

    public KTypeOpenHashSet(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public KTypeOpenHashSet(int initialCapacity, float loadFactor) {
        initialCapacity = Math.max(initialCapacity, 4);
        assert (initialCapacity > 0) : "Initial capacity must be between (0, 2147483647].";
        assert (loadFactor > 0.0f && loadFactor <= 1.0f) : "Load factor must be between (0, 1].";
        this.loadFactor = loadFactor;
        this.allocateBuffers(HashContainerUtils.roundCapacity(initialCapacity));
    }

    public KTypeOpenHashSet(KTypeContainer<KType> container) {
        this((int)((float)container.size() * 1.75f));
        this.addAll(container);
    }

    @Override
    public boolean add(KType e) {
        assert (this.assigned < this.allocated.length);
        int mask = this.allocated.length - 1;
        int slot = Internals.rehash(e, this.perturbation) & mask;
        while (this.allocated[slot]) {
            if (Intrinsics.equalsKType(e, this.keys[slot])) {
                return false;
            }
            slot = slot + 1 & mask;
        }
        if (this.assigned == this.resizeAt) {
            this.expandAndAdd(e, slot);
        } else {
            ++this.assigned;
            this.allocated[slot] = true;
            this.keys[slot] = e;
        }
        return true;
    }

    public int add(KType e1, KType e2) {
        int count = 0;
        if (this.add(e1)) {
            ++count;
        }
        if (this.add(e2)) {
            ++count;
        }
        return count;
    }

    public int add(KType ... elements) {
        int count = 0;
        for (KType e : elements) {
            if (!this.add(e)) continue;
            ++count;
        }
        return count;
    }

    public int addAll(KTypeContainer<? extends KType> container) {
        return this.addAll((Iterable<? extends KTypeCursor<? extends KType>>)container);
    }

    public int addAll(Iterable<? extends KTypeCursor<? extends KType>> iterable) {
        int count = 0;
        for (KTypeCursor<KType> kTypeCursor : iterable) {
            if (!this.add((KType)kTypeCursor.value)) continue;
            ++count;
        }
        return count;
    }

    private void expandAndAdd(KType pendingKey, int freeSlot) {
        assert (this.assigned == this.resizeAt);
        assert (!this.allocated[freeSlot]);
        Object[] oldKeys = this.keys;
        boolean[] oldAllocated = this.allocated;
        this.allocateBuffers(HashContainerUtils.nextCapacity(this.keys.length));
        this.lastSlot = -1;
        ++this.assigned;
        oldAllocated[freeSlot] = true;
        oldKeys[freeSlot] = pendingKey;
        KType[] keys2 = this.keys;
        boolean[] allocated = this.allocated;
        int mask = allocated.length - 1;
        int i = oldAllocated.length;
        while (--i >= 0) {
            if (!oldAllocated[i]) continue;
            Object k = oldKeys[i];
            int slot = Internals.rehash(k, this.perturbation) & mask;
            while (allocated[slot]) {
                slot = slot + 1 & mask;
            }
            allocated[slot] = true;
            keys2[slot] = k;
        }
        Arrays.fill(oldKeys, null);
    }

    private void allocateBuffers(int capacity) {
        Object[] keys2 = (Object[])Intrinsics.newKTypeArray(capacity);
        boolean[] allocated = new boolean[capacity];
        this.keys = keys2;
        this.allocated = allocated;
        this.resizeAt = Math.max(2, (int)Math.ceil((float)capacity * this.loadFactor)) - 1;
        this.perturbation = this.computePerturbationValue(capacity);
    }

    protected int computePerturbationValue(int capacity) {
        return HashContainerUtils.PERTURBATIONS[Integer.numberOfLeadingZeros(capacity)];
    }

    @Override
    public int removeAllOccurrences(KType key) {
        return this.remove(key) ? 1 : 0;
    }

    public boolean remove(KType key) {
        int mask = this.allocated.length - 1;
        int slot = Internals.rehash(key, this.perturbation) & mask;
        while (this.allocated[slot]) {
            if (Intrinsics.equalsKType(key, this.keys[slot])) {
                --this.assigned;
                this.shiftConflictingKeys(slot);
                return true;
            }
            slot = slot + 1 & mask;
        }
        return false;
    }

    protected void shiftConflictingKeys(int slotCurr) {
        int mask = this.allocated.length - 1;
        while (true) {
            int slotPrev = slotCurr;
            slotCurr = slotPrev + 1 & mask;
            while (this.allocated[slotCurr]) {
                int slotOther = Internals.rehash(this.keys[slotCurr], this.perturbation) & mask;
                if (slotPrev <= slotCurr ? slotPrev >= slotOther || slotOther > slotCurr : slotPrev >= slotOther && slotOther > slotCurr) break;
                slotCurr = slotCurr + 1 & mask;
            }
            if (!this.allocated[slotCurr]) break;
            this.keys[slotPrev] = this.keys[slotCurr];
        }
        this.allocated[slotPrev] = false;
        this.keys[slotPrev] = Intrinsics.defaultKTypeValue();
    }

    public KType lkey() {
        assert (this.lastSlot >= 0) : "Call contains() first.";
        assert (this.allocated[this.lastSlot]) : "Last call to exists did not have any associated value.";
        return this.keys[this.lastSlot];
    }

    public int lslot() {
        assert (this.lastSlot >= 0) : "Call contains() first.";
        return this.lastSlot;
    }

    @Override
    public boolean contains(KType key) {
        int mask = this.allocated.length - 1;
        int slot = Internals.rehash(key, this.perturbation) & mask;
        while (this.allocated[slot]) {
            if (Intrinsics.equalsKType(key, this.keys[slot])) {
                this.lastSlot = slot;
                return true;
            }
            slot = slot + 1 & mask;
        }
        this.lastSlot = -1;
        return false;
    }

    @Override
    public void clear() {
        this.assigned = 0;
        Arrays.fill(this.allocated, false);
        Arrays.fill(this.keys, Intrinsics.defaultKTypeValue());
    }

    @Override
    public int size() {
        return this.assigned;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public int hashCode() {
        int h = 0;
        KType[] keys2 = this.keys;
        boolean[] states = this.allocated;
        int i = states.length;
        while (--i >= 0) {
            if (!states[i]) continue;
            h += Internals.rehash(keys2[i]);
        }
        return h;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj != null) {
            KTypeSet other;
            if (obj == this) {
                return true;
            }
            if (obj instanceof KTypeSet && (other = (KTypeSet)obj).size() == this.size()) {
                for (KTypeCursor<KType> c : this) {
                    if (other.contains(c.value)) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public Iterator<KTypeCursor<KType>> iterator() {
        return new EntryIterator();
    }

    @Override
    public <T extends KTypeProcedure<? super KType>> T forEach(T procedure) {
        KType[] keys2 = this.keys;
        boolean[] states = this.allocated;
        for (int i = 0; i < states.length; ++i) {
            if (!states[i]) continue;
            procedure.apply(keys2[i]);
        }
        return procedure;
    }

    @Override
    public Object[] toArray() {
        Object[] cloned = (Object[])Intrinsics.newKTypeArray(this.assigned);
        int j = 0;
        for (int i = 0; i < this.keys.length; ++i) {
            if (!this.allocated[i]) continue;
            cloned[j++] = this.keys[i];
        }
        return cloned;
    }

    public KTypeOpenHashSet<KType> clone() {
        try {
            KTypeOpenHashSet cloned = (KTypeOpenHashSet)super.clone();
            cloned.keys = (Object[])this.keys.clone();
            cloned.allocated = (boolean[])this.allocated.clone();
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <T extends KTypePredicate<? super KType>> T forEach(T predicate) {
        KType[] keys2 = this.keys;
        boolean[] states = this.allocated;
        for (int i = 0; i < states.length && (!states[i] || predicate.apply(keys2[i])); ++i) {
        }
        return predicate;
    }

    @Override
    public int removeAll(KTypePredicate<? super KType> predicate) {
        KType[] keys2 = this.keys;
        boolean[] allocated = this.allocated;
        int before = this.assigned;
        int i = 0;
        while (i < allocated.length) {
            if (allocated[i] && predicate.apply(keys2[i])) {
                --this.assigned;
                this.shiftConflictingKeys(i);
                continue;
            }
            ++i;
        }
        return before - this.assigned;
    }

    public static <KType> KTypeOpenHashSet<KType> from(KType ... elements) {
        KTypeOpenHashSet<KType> set = new KTypeOpenHashSet<KType>((int)((float)elements.length * 1.75f));
        set.add(elements);
        return set;
    }

    public static <KType> KTypeOpenHashSet<KType> from(KTypeContainer<KType> container) {
        return new KTypeOpenHashSet<KType>(container);
    }

    public static <KType> KTypeOpenHashSet<KType> newInstance() {
        return new KTypeOpenHashSet<KType>();
    }

    public static <KType> KTypeOpenHashSet<KType> newInstanceWithoutPerturbations() {
        return new KTypeOpenHashSet<KType>(){

            @Override
            protected int computePerturbationValue(int capacity) {
                return 0;
            }
        };
    }

    public static <KType> KTypeOpenHashSet<KType> newInstanceWithCapacity(int initialCapacity, float loadFactor) {
        return new KTypeOpenHashSet<KType>(initialCapacity, loadFactor);
    }

    public static <KType> KTypeOpenHashSet<KType> newInstanceWithExpectedSize(int expectedSize) {
        return KTypeOpenHashSet.newInstanceWithExpectedSize(expectedSize, 0.75f);
    }

    public static <KType> KTypeOpenHashSet<KType> newInstanceWithExpectedSize(int expectedSize, float loadFactor) {
        return KTypeOpenHashSet.newInstanceWithCapacity((int)((float)expectedSize / loadFactor) + 1, loadFactor);
    }

    private final class EntryIterator
    extends AbstractIterator<KTypeCursor<KType>> {
        private final KTypeCursor<KType> cursor = new KTypeCursor();

        public EntryIterator() {
            this.cursor.index = -1;
        }

        @Override
        protected KTypeCursor<KType> fetch() {
            int i;
            int max = KTypeOpenHashSet.this.keys.length;
            for (i = this.cursor.index + 1; i < KTypeOpenHashSet.this.keys.length && !KTypeOpenHashSet.this.allocated[i]; ++i) {
            }
            if (i == max) {
                return (KTypeCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.value = KTypeOpenHashSet.this.keys[i];
            return this.cursor;
        }
    }
}

