/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractIterator;
import com.carrotsearch.hppc.AbstractKTypeCollection;
import com.carrotsearch.hppc.HashContainerUtils;
import com.carrotsearch.hppc.Internals;
import com.carrotsearch.hppc.Intrinsics;
import com.carrotsearch.hppc.KTypeContainer;
import com.carrotsearch.hppc.KTypeLookupContainer;
import com.carrotsearch.hppc.KTypeVTypeAssociativeContainer;
import com.carrotsearch.hppc.KTypeVTypeMap;
import com.carrotsearch.hppc.cursors.KTypeCursor;
import com.carrotsearch.hppc.cursors.KTypeVTypeCursor;
import com.carrotsearch.hppc.predicates.KTypePredicate;
import com.carrotsearch.hppc.procedures.KTypeProcedure;
import com.carrotsearch.hppc.procedures.KTypeVTypeProcedure;
import java.util.Arrays;
import java.util.Iterator;

public class KTypeVTypeOpenHashMap<KType, VType>
implements KTypeVTypeMap<KType, VType>,
Cloneable {
    public static final int MIN_CAPACITY = 4;
    public static final int DEFAULT_CAPACITY = 16;
    public static final float DEFAULT_LOAD_FACTOR = 0.75f;
    public KType[] keys;
    public VType[] values;
    public boolean[] allocated;
    public int assigned;
    public final float loadFactor;
    protected int resizeAt;
    protected int lastSlot;
    protected int perturbation;

    public KTypeVTypeOpenHashMap() {
        this(16);
    }

    public KTypeVTypeOpenHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public KTypeVTypeOpenHashMap(int initialCapacity, float loadFactor) {
        initialCapacity = Math.max(initialCapacity, 4);
        assert (initialCapacity > 0) : "Initial capacity must be between (0, 2147483647].";
        assert (loadFactor > 0.0f && loadFactor <= 1.0f) : "Load factor must be between (0, 1].";
        this.loadFactor = loadFactor;
        this.allocateBuffers(HashContainerUtils.roundCapacity(initialCapacity));
    }

    public KTypeVTypeOpenHashMap(KTypeVTypeAssociativeContainer<KType, VType> container) {
        this((int)((float)container.size() * 1.75f));
        this.putAll(container);
    }

    @Override
    public VType put(KType key, VType value) {
        assert (this.assigned < this.allocated.length);
        int mask = this.allocated.length - 1;
        int slot = Internals.rehash(key, this.perturbation) & mask;
        while (this.allocated[slot]) {
            if (Intrinsics.equalsKType(key, this.keys[slot])) {
                VType oldValue = this.values[slot];
                this.values[slot] = value;
                return oldValue;
            }
            slot = slot + 1 & mask;
        }
        if (this.assigned == this.resizeAt) {
            this.expandAndPut(key, value, slot);
        } else {
            ++this.assigned;
            this.allocated[slot] = true;
            this.keys[slot] = key;
            this.values[slot] = value;
        }
        return (VType)Intrinsics.defaultVTypeValue();
    }

    @Override
    public int putAll(KTypeVTypeAssociativeContainer<? extends KType, ? extends VType> container) {
        int count = this.assigned;
        for (KTypeVTypeCursor<KType, VType> kTypeVTypeCursor : container) {
            this.put(kTypeVTypeCursor.key, kTypeVTypeCursor.value);
        }
        return this.assigned - count;
    }

    @Override
    public int putAll(Iterable<? extends KTypeVTypeCursor<? extends KType, ? extends VType>> iterable) {
        int count = this.assigned;
        for (KTypeVTypeCursor<KType, VType> kTypeVTypeCursor : iterable) {
            this.put(kTypeVTypeCursor.key, kTypeVTypeCursor.value);
        }
        return this.assigned - count;
    }

    public boolean putIfAbsent(KType key, VType value) {
        if (!this.containsKey(key)) {
            this.put(key, value);
            return true;
        }
        return false;
    }

    private void expandAndPut(KType pendingKey, VType pendingValue, int freeSlot) {
        assert (this.assigned == this.resizeAt);
        assert (!this.allocated[freeSlot]);
        Object[] oldKeys = this.keys;
        Object[] oldValues = this.values;
        boolean[] oldAllocated = this.allocated;
        this.allocateBuffers(HashContainerUtils.nextCapacity(this.keys.length));
        this.lastSlot = -1;
        ++this.assigned;
        oldAllocated[freeSlot] = true;
        oldKeys[freeSlot] = pendingKey;
        oldValues[freeSlot] = pendingValue;
        KType[] keys2 = this.keys;
        VType[] values = this.values;
        boolean[] allocated = this.allocated;
        int mask = allocated.length - 1;
        int i = oldAllocated.length;
        while (--i >= 0) {
            if (!oldAllocated[i]) continue;
            Object k = oldKeys[i];
            Object v = oldValues[i];
            int slot = Internals.rehash(k, this.perturbation) & mask;
            while (allocated[slot]) {
                slot = slot + 1 & mask;
            }
            allocated[slot] = true;
            keys2[slot] = k;
            values[slot] = v;
        }
        Arrays.fill(oldKeys, null);
        Arrays.fill(oldValues, null);
    }

    private void allocateBuffers(int capacity) {
        Object[] keys2 = (Object[])Intrinsics.newKTypeArray(capacity);
        Object[] values = (Object[])Intrinsics.newVTypeArray(capacity);
        boolean[] allocated = new boolean[capacity];
        this.keys = keys2;
        this.values = values;
        this.allocated = allocated;
        this.resizeAt = Math.max(2, (int)Math.ceil((float)capacity * this.loadFactor)) - 1;
        this.perturbation = this.computePerturbationValue(capacity);
    }

    protected int computePerturbationValue(int capacity) {
        return HashContainerUtils.PERTURBATIONS[Integer.numberOfLeadingZeros(capacity)];
    }

    @Override
    public VType remove(KType key) {
        int slot;
        int mask = this.allocated.length - 1;
        int wrappedAround = slot = Internals.rehash(key, this.perturbation) & mask;
        while (this.allocated[slot]) {
            if (Intrinsics.equalsKType(key, this.keys[slot])) {
                --this.assigned;
                VType v = this.values[slot];
                this.shiftConflictingKeys(slot);
                return v;
            }
            if ((slot = slot + 1 & mask) != wrappedAround) continue;
            break;
        }
        return (VType)Intrinsics.defaultVTypeValue();
    }

    protected void shiftConflictingKeys(int slotCurr) {
        int mask = this.allocated.length - 1;
        while (true) {
            int slotPrev = slotCurr;
            slotCurr = slotPrev + 1 & mask;
            while (this.allocated[slotCurr]) {
                int slotOther = Internals.rehash(this.keys[slotCurr], this.perturbation) & mask;
                if (slotPrev <= slotCurr ? slotPrev >= slotOther || slotOther > slotCurr : slotPrev >= slotOther && slotOther > slotCurr) break;
                slotCurr = slotCurr + 1 & mask;
            }
            if (!this.allocated[slotCurr]) break;
            this.keys[slotPrev] = this.keys[slotCurr];
            this.values[slotPrev] = this.values[slotCurr];
        }
        this.allocated[slotPrev] = false;
        this.keys[slotPrev] = Intrinsics.defaultKTypeValue();
        this.values[slotPrev] = Intrinsics.defaultVTypeValue();
    }

    @Override
    public int removeAll(KTypeContainer<? extends KType> container) {
        int before = this.assigned;
        for (KTypeCursor<KType> kTypeCursor : container) {
            this.remove(kTypeCursor.value);
        }
        return before - this.assigned;
    }

    @Override
    public int removeAll(KTypePredicate<? super KType> predicate) {
        int before = this.assigned;
        KType[] keys2 = this.keys;
        boolean[] states = this.allocated;
        int i = 0;
        while (i < states.length) {
            if (states[i] && predicate.apply(keys2[i])) {
                --this.assigned;
                this.shiftConflictingKeys(i);
                continue;
            }
            ++i;
        }
        return before - this.assigned;
    }

    @Override
    public VType get(KType key) {
        int slot;
        int mask = this.allocated.length - 1;
        int wrappedAround = slot = Internals.rehash(key, this.perturbation) & mask;
        while (this.allocated[slot]) {
            if (Intrinsics.equalsKType(key, this.keys[slot])) {
                return this.values[slot];
            }
            if ((slot = slot + 1 & mask) != wrappedAround) continue;
            break;
        }
        return (VType)Intrinsics.defaultVTypeValue();
    }

    @Override
    public VType getOrDefault(KType key, VType defaultValue) {
        int slot;
        int mask = this.allocated.length - 1;
        int wrappedAround = slot = Internals.rehash(key, this.perturbation) & mask;
        while (this.allocated[slot]) {
            if (Intrinsics.equalsKType(key, this.keys[slot])) {
                return this.values[slot];
            }
            if ((slot = slot + 1 & mask) != wrappedAround) continue;
            break;
        }
        return defaultValue;
    }

    public KType lkey() {
        return this.keys[this.lslot()];
    }

    public VType lget() {
        assert (this.lastSlot >= 0) : "Call containsKey() first.";
        assert (this.allocated[this.lastSlot]) : "Last call to exists did not have any associated value.";
        return this.values[this.lastSlot];
    }

    public VType lset(VType key) {
        assert (this.lastSlot >= 0) : "Call containsKey() first.";
        assert (this.allocated[this.lastSlot]) : "Last call to exists did not have any associated value.";
        VType previous = this.values[this.lastSlot];
        this.values[this.lastSlot] = key;
        return previous;
    }

    public int lslot() {
        assert (this.lastSlot >= 0) : "Call containsKey() first.";
        return this.lastSlot;
    }

    @Override
    public boolean containsKey(KType key) {
        int slot;
        int mask = this.allocated.length - 1;
        int wrappedAround = slot = Internals.rehash(key, this.perturbation) & mask;
        while (this.allocated[slot]) {
            if (Intrinsics.equalsKType(key, this.keys[slot])) {
                this.lastSlot = slot;
                return true;
            }
            if ((slot = slot + 1 & mask) != wrappedAround) continue;
        }
        this.lastSlot = -1;
        return false;
    }

    @Override
    public void clear() {
        this.assigned = 0;
        Arrays.fill(this.allocated, false);
        Arrays.fill(this.keys, null);
        Arrays.fill(this.values, null);
    }

    @Override
    public int size() {
        return this.assigned;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public int hashCode() {
        int h = 0;
        for (KTypeVTypeCursor<KType, VType> c : this) {
            h += Internals.rehash(c.key) + Internals.rehash(c.value);
        }
        return h;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj != null) {
            KTypeVTypeMap other;
            if (obj == this) {
                return true;
            }
            if (obj instanceof KTypeVTypeMap && (other = (KTypeVTypeMap)obj).size() == this.size()) {
                for (KTypeVTypeCursor<KType, VType> c : this) {
                    Object v;
                    if (other.containsKey(c.key) && Intrinsics.equalsVType(c.value, v = other.get(c.key))) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public Iterator<KTypeVTypeCursor<KType, VType>> iterator() {
        return new EntryIterator();
    }

    @Override
    public <T extends KTypeVTypeProcedure<? super KType, ? super VType>> T forEach(T procedure) {
        KType[] keys2 = this.keys;
        VType[] values = this.values;
        boolean[] states = this.allocated;
        for (int i = 0; i < states.length; ++i) {
            if (!states[i]) continue;
            procedure.apply(keys2[i], values[i]);
        }
        return procedure;
    }

    public KeysContainer keys() {
        return new KeysContainer();
    }

    @Override
    public KTypeContainer<VType> values() {
        return new ValuesContainer();
    }

    public KTypeVTypeOpenHashMap<KType, VType> clone() {
        try {
            KTypeVTypeOpenHashMap cloned = (KTypeVTypeOpenHashMap)super.clone();
            cloned.keys = (Object[])this.keys.clone();
            cloned.values = (Object[])this.values.clone();
            cloned.allocated = (boolean[])this.allocated.clone();
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[");
        boolean first = true;
        for (KTypeVTypeCursor<KType, VType> cursor : this) {
            if (!first) {
                buffer.append(", ");
            }
            buffer.append(cursor.key);
            buffer.append("=>");
            buffer.append(cursor.value);
            first = false;
        }
        buffer.append("]");
        return buffer.toString();
    }

    public static <KType, VType> KTypeVTypeOpenHashMap<KType, VType> from(KType[] keys2, VType[] values) {
        if (keys2.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        KTypeVTypeOpenHashMap<KType, VType> map = new KTypeVTypeOpenHashMap<KType, VType>();
        for (int i = 0; i < keys2.length; ++i) {
            map.put(keys2[i], values[i]);
        }
        return map;
    }

    public static <KType, VType> KTypeVTypeOpenHashMap<KType, VType> from(KTypeVTypeAssociativeContainer<KType, VType> container) {
        return new KTypeVTypeOpenHashMap<KType, VType>(container);
    }

    public static <KType, VType> KTypeVTypeOpenHashMap<KType, VType> newInstance() {
        return new KTypeVTypeOpenHashMap<KType, VType>();
    }

    public static <KType, VType> KTypeVTypeOpenHashMap<KType, VType> newInstanceWithoutPerturbations() {
        return new KTypeVTypeOpenHashMap<KType, VType>(){

            @Override
            protected int computePerturbationValue(int capacity) {
                return 0;
            }
        };
    }

    public static <KType, VType> KTypeVTypeOpenHashMap<KType, VType> newInstance(int initialCapacity, float loadFactor) {
        return new KTypeVTypeOpenHashMap<KType, VType>(initialCapacity, loadFactor);
    }

    public static <KType, VType> KTypeVTypeOpenHashMap<KType, VType> newInstanceWithExpectedSize(int expectedSize) {
        return KTypeVTypeOpenHashMap.newInstanceWithExpectedSize(expectedSize, 0.75f);
    }

    public static <KType, VType> KTypeVTypeOpenHashMap<KType, VType> newInstanceWithExpectedSize(int expectedSize, float loadFactor) {
        return KTypeVTypeOpenHashMap.newInstance((int)((float)expectedSize / loadFactor) + 1, loadFactor);
    }

    private final class ValuesIterator
    extends AbstractIterator<KTypeCursor<VType>> {
        private final KTypeCursor<VType> cursor = new KTypeCursor();

        public ValuesIterator() {
            this.cursor.index = -1;
        }

        @Override
        protected KTypeCursor<VType> fetch() {
            int i;
            int max = KTypeVTypeOpenHashMap.this.keys.length;
            for (i = this.cursor.index + 1; i < max && !KTypeVTypeOpenHashMap.this.allocated[i]; ++i) {
            }
            if (i == max) {
                return (KTypeCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.value = KTypeVTypeOpenHashMap.this.values[i];
            return this.cursor;
        }
    }

    private final class ValuesContainer
    extends AbstractKTypeCollection<VType> {
        private ValuesContainer() {
        }

        @Override
        public int size() {
            return KTypeVTypeOpenHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return KTypeVTypeOpenHashMap.this.isEmpty();
        }

        @Override
        public boolean contains(VType value) {
            boolean[] allocated = KTypeVTypeOpenHashMap.this.allocated;
            VType[] values = KTypeVTypeOpenHashMap.this.values;
            for (int slot = 0; slot < allocated.length; ++slot) {
                if (!allocated[slot] || !Intrinsics.equalsVType(value, values[slot])) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends KTypeProcedure<? super VType>> T forEach(T procedure) {
            boolean[] allocated = KTypeVTypeOpenHashMap.this.allocated;
            VType[] values = KTypeVTypeOpenHashMap.this.values;
            for (int i = 0; i < allocated.length; ++i) {
                if (!allocated[i]) continue;
                procedure.apply(values[i]);
            }
            return procedure;
        }

        @Override
        public <T extends KTypePredicate<? super VType>> T forEach(T predicate) {
            boolean[] allocated = KTypeVTypeOpenHashMap.this.allocated;
            VType[] values = KTypeVTypeOpenHashMap.this.values;
            for (int i = 0; i < allocated.length && (!allocated[i] || predicate.apply(values[i])); ++i) {
            }
            return predicate;
        }

        @Override
        public Iterator<KTypeCursor<VType>> iterator() {
            return new ValuesIterator();
        }

        @Override
        public int removeAllOccurrences(VType e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int removeAll(KTypePredicate<? super VType> predicate) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }
    }

    private final class KeysIterator
    extends AbstractIterator<KTypeCursor<KType>> {
        private final KTypeCursor<KType> cursor = new KTypeCursor();

        public KeysIterator() {
            this.cursor.index = -1;
        }

        @Override
        protected KTypeCursor<KType> fetch() {
            int i;
            int max = KTypeVTypeOpenHashMap.this.keys.length;
            for (i = this.cursor.index + 1; i < max && !KTypeVTypeOpenHashMap.this.allocated[i]; ++i) {
            }
            if (i == max) {
                return (KTypeCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.value = KTypeVTypeOpenHashMap.this.keys[i];
            return this.cursor;
        }
    }

    public final class KeysContainer
    extends AbstractKTypeCollection<KType>
    implements KTypeLookupContainer<KType> {
        private final KTypeVTypeOpenHashMap<KType, VType> owner;

        public KeysContainer() {
            this.owner = KTypeVTypeOpenHashMap.this;
        }

        @Override
        public boolean contains(KType e) {
            return KTypeVTypeOpenHashMap.this.containsKey(e);
        }

        @Override
        public <T extends KTypeProcedure<? super KType>> T forEach(T procedure) {
            KType[] localKeys = this.owner.keys;
            boolean[] localStates = this.owner.allocated;
            for (int i = 0; i < localStates.length; ++i) {
                if (!localStates[i]) continue;
                procedure.apply(localKeys[i]);
            }
            return procedure;
        }

        @Override
        public <T extends KTypePredicate<? super KType>> T forEach(T predicate) {
            KType[] localKeys = this.owner.keys;
            boolean[] localStates = this.owner.allocated;
            for (int i = 0; i < localStates.length && (!localStates[i] || predicate.apply(localKeys[i])); ++i) {
            }
            return predicate;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<KTypeCursor<KType>> iterator() {
            return new KeysIterator();
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public int removeAll(KTypePredicate<? super KType> predicate) {
            return this.owner.removeAll(predicate);
        }

        @Override
        public int removeAllOccurrences(KType e) {
            boolean hasKey = this.owner.containsKey(e);
            int result = 0;
            if (hasKey) {
                this.owner.remove(e);
                result = 1;
            }
            return result;
        }
    }

    private final class EntryIterator
    extends AbstractIterator<KTypeVTypeCursor<KType, VType>> {
        private final KTypeVTypeCursor<KType, VType> cursor = new KTypeVTypeCursor();

        public EntryIterator() {
            this.cursor.index = -1;
        }

        @Override
        protected KTypeVTypeCursor<KType, VType> fetch() {
            int i;
            int max = KTypeVTypeOpenHashMap.this.keys.length;
            for (i = this.cursor.index + 1; i < max && !KTypeVTypeOpenHashMap.this.allocated[i]; ++i) {
            }
            if (i == max) {
                return (KTypeVTypeCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.key = KTypeVTypeOpenHashMap.this.keys[i];
            this.cursor.value = KTypeVTypeOpenHashMap.this.values[i];
            return this.cursor;
        }
    }
}

