/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index;

import com.orientechnologies.orient.core.index.OIndexDefinition;
import java.util.Set;

public class OIndexMetadata {
    private final String name;
    private final OIndexDefinition indexDefinition;
    private final Set<String> clustersToIndex;
    private final String type;
    private final String algorithm;
    private final String valueContainerAlgorithm;

    public OIndexMetadata(String name, OIndexDefinition indexDefinition, Set<String> clustersToIndex, String type, String algorithm, String valueContainerAlgorithm) {
        this.name = name;
        this.indexDefinition = indexDefinition;
        this.clustersToIndex = clustersToIndex;
        this.type = type;
        this.algorithm = algorithm;
        this.valueContainerAlgorithm = valueContainerAlgorithm;
    }

    public String getName() {
        return this.name;
    }

    public OIndexDefinition getIndexDefinition() {
        return this.indexDefinition;
    }

    public Set<String> getClustersToIndex() {
        return this.clustersToIndex;
    }

    public String getType() {
        return this.type;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OIndexMetadata that = (OIndexMetadata)o;
        if (this.algorithm != null ? !this.algorithm.equals(that.algorithm) : that.algorithm != null) {
            return false;
        }
        if (!this.clustersToIndex.equals(that.clustersToIndex)) {
            return false;
        }
        if (this.indexDefinition != null ? !this.indexDefinition.equals(that.indexDefinition) : that.indexDefinition != null) {
            return false;
        }
        if (!this.name.equals(that.name)) {
            return false;
        }
        return this.type.equals(that.type);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + (this.indexDefinition != null ? this.indexDefinition.hashCode() : 0);
        result = 31 * result + this.clustersToIndex.hashCode();
        result = 31 * result + this.type.hashCode();
        result = 31 * result + (this.algorithm != null ? this.algorithm.hashCode() : 0);
        return result;
    }

    String getValueContainerAlgorithm() {
        return this.valueContainerAlgorithm;
    }
}

