/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index;

import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.OMultiValueChangeEvent;
import com.orientechnologies.orient.core.db.record.ridbag.ORidBag;
import com.orientechnologies.orient.core.index.OAbstractIndexDefinitionMultiValue;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class OPropertyRidBagIndexDefinition
extends OAbstractIndexDefinitionMultiValue {
    private static final long serialVersionUID = -8315498456603024776L;

    public OPropertyRidBagIndexDefinition() {
    }

    public OPropertyRidBagIndexDefinition(String className, String field) {
        super(className, field, OType.LINK);
    }

    @Override
    public Object createSingleValue(Object ... param) {
        return OType.convert(param[0], this.keyType.getDefaultJavaType());
    }

    @Override
    public void processChangeEvent(OMultiValueChangeEvent<?, ?> changeEvent, Map<Object, Integer> keysToAdd, Map<Object, Integer> keysToRemove) {
        switch (changeEvent.getChangeType()) {
            case ADD: {
                this.processAdd(this.createSingleValue(changeEvent.getValue()), keysToAdd, keysToRemove);
                break;
            }
            case REMOVE: {
                this.processRemoval(this.createSingleValue(changeEvent.getOldValue()), keysToAdd, keysToRemove);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid change type : " + (Object)((Object)changeEvent.getChangeType()));
            }
        }
    }

    @Override
    public Object getDocumentValueToIndex(ODocument iDocument) {
        return this.createValue(iDocument.field(this.field));
    }

    @Override
    public Object createValue(List<?> params) {
        if (!(params.get(0) instanceof ORidBag)) {
            return null;
        }
        ORidBag ridBag = (ORidBag)params.get(0);
        ArrayList<Object> values = new ArrayList<Object>();
        for (OIdentifiable item : ridBag) {
            values.add(this.createSingleValue(item));
        }
        return values;
    }

    @Override
    public Object createValue(Object ... params) {
        if (!(params[0] instanceof ORidBag)) {
            return null;
        }
        ORidBag ridBag = (ORidBag)params[0];
        ArrayList<Object> values = new ArrayList<Object>();
        for (OIdentifiable item : ridBag) {
            values.add(this.createSingleValue(item));
        }
        return values;
    }

    @Override
    public String toCreateIndexDDL(String indexName, String indexType, String engine) {
        return this.createIndexDDLWithoutFieldType(indexName, indexType, engine).toString();
    }
}

