/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index.sbtree.local;

import com.orientechnologies.common.comparator.ODefaultComparator;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.index.OAlwaysGreaterKey;
import com.orientechnologies.orient.core.index.OAlwaysLessKey;
import com.orientechnologies.orient.core.index.OCompositeKey;
import com.orientechnologies.orient.core.index.OIndexEngine;
import com.orientechnologies.orient.core.index.sbtree.local.OSBTreeBucket;
import com.orientechnologies.orient.core.index.sbtree.local.OSBTreeException;
import com.orientechnologies.orient.core.index.sbtree.local.OSBTreeValue;
import com.orientechnologies.orient.core.index.sbtree.local.OSBTreeValuePage;
import com.orientechnologies.orient.core.iterator.OEmptyIterator;
import com.orientechnologies.orient.core.iterator.OEmptyMapEntryIterator;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.storage.cache.OCacheEntry;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations.OAtomicOperation;
import com.orientechnologies.orient.core.storage.impl.local.paginated.base.ODurableComponent;
import com.orientechnologies.orient.core.storage.impl.local.statistic.OSessionStoragePerformanceStatistic;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class OSBTree<K, V>
extends ODurableComponent {
    private static final int MAX_KEY_SIZE = OGlobalConfiguration.SBTREE_MAX_KEY_SIZE.getValueAsInteger();
    private static final int MAX_EMBEDDED_VALUE_SIZE = OGlobalConfiguration.SBTREE_MAX_EMBEDDED_VALUE_SIZE.getValueAsInteger();
    private static final OAlwaysLessKey ALWAYS_LESS_KEY = new OAlwaysLessKey();
    private static final OAlwaysGreaterKey ALWAYS_GREATER_KEY = new OAlwaysGreaterKey();
    private static final int MAX_PATH_LENGTH = OGlobalConfiguration.SBTREE_MAX_DEPTH.getValueAsInteger();
    private static final long ROOT_INDEX = 0L;
    private final Comparator<? super K> comparator = ODefaultComparator.INSTANCE;
    private final String nullFileExtension;
    private final boolean durableInNonTxMode;
    private long fileId;
    private long nullBucketFileId = -1L;
    private int keySize;
    private OBinarySerializer<K> keySerializer;
    private OType[] keyTypes;
    private OBinarySerializer<V> valueSerializer;
    private boolean nullPointerSupport;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OSBTree(String name, String dataFileExtension, boolean durableInNonTxMode, String nullFileExtension, OAbstractPaginatedStorage storage) {
        super(storage, name, dataFileExtension, name + dataFileExtension);
        this.acquireExclusiveLock();
        try {
            this.nullFileExtension = nullFileExtension;
            this.durableInNonTxMode = durableInNonTxMode;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void create(OBinarySerializer<K> keySerializer, OBinarySerializer<V> valueSerializer, OType[] keyTypes, int keySize, boolean nullPointerSupport) {
        assert (keySerializer != null);
        this.startOperation();
        try {
            OAtomicOperation atomicOperation;
            try {
                atomicOperation = this.startAtomicOperation(false);
            }
            catch (IOException e) {
                throw OException.wrapException(new OSBTreeException("Error during sbtree creation", this), e);
            }
            this.acquireExclusiveLock();
            try {
                this.keySize = keySize;
                this.keyTypes = keyTypes != null ? Arrays.copyOf(keyTypes, keyTypes.length) : null;
                this.keySerializer = keySerializer;
                this.valueSerializer = valueSerializer;
                this.nullPointerSupport = nullPointerSupport;
                this.fileId = this.addFile(atomicOperation, this.getFullName());
                if (nullPointerSupport) {
                    this.nullBucketFileId = this.addFile(atomicOperation, this.getName() + this.nullFileExtension);
                }
                OCacheEntry rootCacheEntry = this.addPage(atomicOperation, this.fileId);
                rootCacheEntry.acquireExclusiveLock();
                try {
                    OSBTreeBucket<K, V> rootBucket = new OSBTreeBucket<K, V>(rootCacheEntry, true, keySerializer, keyTypes, valueSerializer, this.getChanges(atomicOperation, rootCacheEntry));
                    rootBucket.setTreeSize(0L);
                }
                finally {
                    rootCacheEntry.releaseExclusiveLock();
                    this.releasePage(atomicOperation, rootCacheEntry);
                }
                this.endAtomicOperation(false, null);
            }
            catch (IOException e) {
                try {
                    this.endAtomicOperation(true, e);
                }
                catch (IOException e1) {
                    OLogManager.instance().error(this, "Error during sbtree data rollback", e1, new Object[0]);
                }
                throw OException.wrapException(new OSBTreeException("Error creation of sbtree with name " + this.getName(), this), e);
            }
            catch (RuntimeException e) {
                try {
                    this.endAtomicOperation(true, e);
                }
                catch (IOException e1) {
                    OLogManager.instance().error(this, "Error during sbtree data rollback", e1, new Object[0]);
                }
                throw e;
            }
            finally {
                this.releaseExclusiveLock();
            }
        }
        finally {
            this.completeOperation();
        }
    }

    public boolean isNullPointerSupport() {
        this.acquireSharedLock();
        try {
            boolean bl = this.nullPointerSupport;
            return bl;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    /*
     * Exception decompiling
     */
    public V get(K key) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK], 1[TRYBLOCK]], but top level block is 34[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void put(K key, V value) {
        this.put(key, value, null);
    }

    public boolean validatedPut(K key, V value, OIndexEngine.Validator<K, V> validator) {
        return this.put(key, value, validator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(boolean flush) {
        this.startOperation();
        try {
            this.acquireExclusiveLock();
            try {
                this.readCache.closeFile(this.fileId, flush, this.writeCache);
                if (this.nullPointerSupport) {
                    this.readCache.closeFile(this.nullBucketFileId, flush, this.writeCache);
                }
            }
            catch (IOException e) {
                throw OException.wrapException(new OSBTreeException("Error during close of index " + this.getName(), this), e);
            }
            finally {
                this.releaseExclusiveLock();
            }
        }
        finally {
            this.completeOperation();
        }
    }

    public void close() {
        this.close(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.startOperation();
        try {
            OAtomicOperation atomicOperation;
            try {
                atomicOperation = this.startAtomicOperation(true);
            }
            catch (IOException e) {
                throw OException.wrapException(new OSBTreeException("Error during sbtree clear", this), e);
            }
            this.acquireExclusiveLock();
            try {
                OCacheEntry cacheEntry;
                this.truncateFile(atomicOperation, this.fileId);
                if (this.nullPointerSupport) {
                    this.truncateFile(atomicOperation, this.nullBucketFileId);
                }
                if ((cacheEntry = this.loadPage(atomicOperation, this.fileId, 0L, false)) == null) {
                    cacheEntry = this.addPage(atomicOperation, this.fileId);
                }
                cacheEntry.acquireExclusiveLock();
                try {
                    OSBTreeBucket<K, V> rootBucket = new OSBTreeBucket<K, V>(cacheEntry, true, this.keySerializer, this.keyTypes, this.valueSerializer, this.getChanges(atomicOperation, cacheEntry));
                    rootBucket.setTreeSize(0L);
                }
                finally {
                    cacheEntry.releaseExclusiveLock();
                    this.releasePage(atomicOperation, cacheEntry);
                }
                this.endAtomicOperation(false, null);
            }
            catch (IOException e) {
                this.rollback(e);
                throw OException.wrapException(new OSBTreeException("Error during clear of sbtree with name " + this.getName(), this), e);
            }
            catch (RuntimeException e) {
                this.rollback(e);
                throw e;
            }
            finally {
                this.releaseExclusiveLock();
            }
        }
        finally {
            this.completeOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete() {
        this.startOperation();
        try {
            OAtomicOperation atomicOperation;
            try {
                atomicOperation = this.startAtomicOperation(false);
            }
            catch (IOException e) {
                throw OException.wrapException(new OSBTreeException("Error during sbtree deletion", this), e);
            }
            this.acquireExclusiveLock();
            try {
                this.deleteFile(atomicOperation, this.fileId);
                if (this.nullPointerSupport) {
                    this.deleteFile(atomicOperation, this.nullBucketFileId);
                }
                this.endAtomicOperation(false, null);
            }
            catch (IOException e) {
                this.rollback(e);
                throw OException.wrapException(new OSBTreeException("Error during delete of sbtree with name " + this.getName(), this), e);
            }
            catch (Exception e) {
                this.rollback(e);
                throw OException.wrapException(new OSBTreeException("Error during delete of sbtree with name " + this.getName(), this), e);
            }
            finally {
                this.releaseExclusiveLock();
            }
        }
        finally {
            this.completeOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteWithoutLoad(String name) {
        this.startOperation();
        try {
            OAtomicOperation atomicOperation;
            try {
                atomicOperation = this.startAtomicOperation(false);
            }
            catch (IOException e) {
                throw OException.wrapException(new OSBTreeException("Error during sbtree deletion", this), e);
            }
            this.acquireExclusiveLock();
            try {
                if (this.isFileExists(atomicOperation, this.getFullName())) {
                    long fileId = this.openFile(atomicOperation, this.getFullName());
                    this.deleteFile(atomicOperation, fileId);
                }
                if (this.isFileExists(atomicOperation, this.getName() + this.nullFileExtension)) {
                    long nullFileId = this.openFile(atomicOperation, this.getName() + this.nullFileExtension);
                    this.deleteFile(atomicOperation, nullFileId);
                }
                this.endAtomicOperation(false, null);
            }
            catch (IOException ioe) {
                this.rollback(ioe);
                throw OException.wrapException(new OSBTreeException("Exception during deletion of sbtree " + this.getName(), this), ioe);
            }
            catch (Exception e) {
                this.rollback(e);
                throw OException.wrapException(new OSBTreeException("Exception during deletion of sbtree " + this.getName(), this), e);
            }
            finally {
                this.releaseExclusiveLock();
            }
        }
        finally {
            this.completeOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(String name, OBinarySerializer<K> keySerializer, OBinarySerializer<V> valueSerializer, OType[] keyTypes, int keySize, boolean nullPointerSupport) {
        this.startOperation();
        try {
            this.acquireExclusiveLock();
            try {
                this.keySize = keySize;
                this.keyTypes = keyTypes != null ? Arrays.copyOf(keyTypes, keyTypes.length) : null;
                this.nullPointerSupport = nullPointerSupport;
                OAtomicOperation atomicOperation = this.atomicOperationsManager.getCurrentOperation();
                this.fileId = this.openFile(atomicOperation, this.getFullName());
                if (nullPointerSupport) {
                    this.nullBucketFileId = this.openFile(atomicOperation, name + this.nullFileExtension);
                }
                this.keySerializer = keySerializer;
                this.valueSerializer = valueSerializer;
            }
            catch (IOException e) {
                throw OException.wrapException(new OSBTreeException("Exception during loading of sbtree " + name, this), e);
            }
            finally {
                this.releaseExclusiveLock();
            }
        }
        finally {
            this.completeOperation();
        }
    }

    /*
     * Exception decompiling
     */
    public long size() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public V remove(K key) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 28[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public OSBTreeCursor<K, V> iterateEntriesMinor(K key, boolean inclusive, boolean ascSortOrder) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public OSBTreeCursor<K, V> iterateEntriesMajor(K key, boolean inclusive, boolean ascSortOrder) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public K firstKey() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK], 2[TRYBLOCK]], but top level block is 20[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public K lastKey() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK], 2[TRYBLOCK]], but top level block is 20[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public OSBTreeKeyCursor<K> keyCursor() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public OSBTreeCursor<K, V> iterateEntriesBetween(K keyFrom, boolean fromInclusive, K keyTo, boolean toInclusive, boolean ascSortOrder) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void flush() {
        this.startOperation();
        try {
            this.atomicOperationsManager.acquireReadLock(this);
            try {
                this.acquireSharedLock();
                try {
                    this.writeCache.flush();
                }
                finally {
                    this.releaseSharedLock();
                }
            }
            finally {
                this.atomicOperationsManager.releaseReadLock(this);
            }
        }
        finally {
            this.completeOperation();
        }
    }

    public void acquireAtomicExclusiveLock() {
        this.atomicOperationsManager.acquireExclusiveLockTillOperationComplete(this);
    }

    private void checkNullSupport(K key) {
        if (key == null && !this.nullPointerSupport) {
            throw new OSBTreeException("Null keys are not supported.", this);
        }
    }

    /*
     * Exception decompiling
     */
    private boolean put(K key, V value, OIndexEngine.Validator<K, V> validator) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 37[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeLinkedValue(long removedLink, OAtomicOperation atomicOperation) throws IOException {
        long nextPage = removedLink;
        do {
            removedLink = nextPage;
            OCacheEntry valueEntry = this.loadPage(atomicOperation, this.fileId, removedLink, false);
            valueEntry.acquireSharedLock();
            try {
                OSBTreeValuePage valuePage = new OSBTreeValuePage(valueEntry, this.getChanges(atomicOperation, valueEntry), false);
                nextPage = valuePage.getNextPage();
            }
            finally {
                valueEntry.releaseSharedLock();
                this.releasePage(atomicOperation, valueEntry);
            }
            this.removeValuePage(removedLink, atomicOperation);
        } while (nextPage >= 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeValuePage(long pageIndex, OAtomicOperation atomicOperation) throws IOException {
        long prevFreeListItem;
        OCacheEntry rootCacheEntry = this.loadPage(atomicOperation, this.fileId, 0L, false);
        rootCacheEntry.acquireExclusiveLock();
        OSBTreeBucket<K, V> rootBucket = new OSBTreeBucket<K, V>(rootCacheEntry, this.keySerializer, this.keyTypes, this.valueSerializer, this.getChanges(atomicOperation, rootCacheEntry));
        try {
            prevFreeListItem = rootBucket.getValuesFreeListFirstIndex();
            rootBucket.setValuesFreeListFirstIndex(pageIndex);
        }
        finally {
            rootCacheEntry.releaseExclusiveLock();
            this.releasePage(atomicOperation, rootCacheEntry);
        }
        OCacheEntry valueEntry = this.loadPage(atomicOperation, this.fileId, pageIndex, false);
        valueEntry.acquireExclusiveLock();
        try {
            OSBTreeValuePage valuePage = new OSBTreeValuePage(valueEntry, this.getChanges(atomicOperation, valueEntry), false);
            valuePage.setNextFreeListPage(prevFreeListItem);
        }
        finally {
            valueEntry.releaseExclusiveLock();
            this.releasePage(atomicOperation, valueEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long createLinkToTheValue(V value, OAtomicOperation atomicOperation) throws IOException {
        byte[] serializeValue = new byte[this.valueSerializer.getObjectSize(value, new Object[0])];
        this.valueSerializer.serializeNativeObject(value, serializeValue, 0, new Object[0]);
        int amountOfPages = OSBTreeValuePage.calculateAmountOfPage(serializeValue.length);
        int position = 0;
        long freeListPageIndex = this.allocateValuePageFromFreeList(atomicOperation);
        OCacheEntry cacheEntry = freeListPageIndex < 0L ? this.addPage(atomicOperation, this.fileId) : this.loadPage(atomicOperation, this.fileId, freeListPageIndex, false);
        long valueLink = cacheEntry.getPageIndex();
        cacheEntry.acquireExclusiveLock();
        try {
            OSBTreeValuePage valuePage = new OSBTreeValuePage(cacheEntry, this.getChanges(atomicOperation, cacheEntry), freeListPageIndex >= 0L);
            position = valuePage.fillBinaryContent(serializeValue, position);
            valuePage.setNextFreeListPage(-1L);
            valuePage.setNextPage(-1L);
        }
        finally {
            cacheEntry.releaseExclusiveLock();
            this.releasePage(atomicOperation, cacheEntry);
        }
        long prevPage = valueLink;
        for (int i = 1; i < amountOfPages; ++i) {
            freeListPageIndex = this.allocateValuePageFromFreeList(atomicOperation);
            cacheEntry = freeListPageIndex < 0L ? this.addPage(atomicOperation, this.fileId) : this.loadPage(atomicOperation, this.fileId, freeListPageIndex, false);
            cacheEntry.acquireExclusiveLock();
            try {
                OSBTreeValuePage valuePage = new OSBTreeValuePage(cacheEntry, this.getChanges(atomicOperation, cacheEntry), freeListPageIndex >= 0L);
                position = valuePage.fillBinaryContent(serializeValue, position);
                valuePage.setNextFreeListPage(-1L);
                valuePage.setNextPage(-1L);
            }
            finally {
                cacheEntry.releaseExclusiveLock();
                this.releasePage(atomicOperation, cacheEntry);
            }
            OCacheEntry prevPageCacheEntry = this.loadPage(atomicOperation, this.fileId, prevPage, false);
            prevPageCacheEntry.acquireExclusiveLock();
            try {
                OSBTreeValuePage valuePage = new OSBTreeValuePage(prevPageCacheEntry, this.getChanges(atomicOperation, prevPageCacheEntry), freeListPageIndex >= 0L);
                valuePage.setNextPage(cacheEntry.getPageIndex());
            }
            finally {
                prevPageCacheEntry.releaseExclusiveLock();
                this.releasePage(atomicOperation, prevPageCacheEntry);
            }
            prevPage = cacheEntry.getPageIndex();
        }
        return valueLink;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long allocateValuePageFromFreeList(OAtomicOperation atomicOperation) throws IOException {
        long freeListFirstIndex;
        OSBTreeBucket<K, V> rootBucket;
        OCacheEntry rootCacheEntry = this.loadPage(atomicOperation, this.fileId, 0L, false);
        assert (rootCacheEntry != null);
        rootCacheEntry.acquireSharedLock();
        try {
            rootBucket = new OSBTreeBucket<K, V>(rootCacheEntry, this.keySerializer, this.keyTypes, this.valueSerializer, this.getChanges(atomicOperation, rootCacheEntry));
            freeListFirstIndex = rootBucket.getValuesFreeListFirstIndex();
        }
        finally {
            rootCacheEntry.releaseSharedLock();
            this.releasePage(atomicOperation, rootCacheEntry);
        }
        if (freeListFirstIndex >= 0L) {
            OCacheEntry freePageEntry = this.loadPage(atomicOperation, this.fileId, freeListFirstIndex, false);
            freePageEntry.acquireExclusiveLock();
            try {
                OSBTreeValuePage valuePage = new OSBTreeValuePage(freePageEntry, this.getChanges(atomicOperation, freePageEntry), false);
                long nextFreeListIndex = valuePage.getNextFreeListPage();
                rootCacheEntry = this.loadPage(atomicOperation, this.fileId, 0L, false);
                rootCacheEntry.acquireExclusiveLock();
                rootBucket = new OSBTreeBucket<K, V>(rootCacheEntry, this.keySerializer, this.keyTypes, this.valueSerializer, this.getChanges(atomicOperation, rootCacheEntry));
                try {
                    rootBucket.setValuesFreeListFirstIndex(nextFreeListIndex);
                }
                finally {
                    rootCacheEntry.releaseExclusiveLock();
                    this.releasePage(atomicOperation, rootCacheEntry);
                }
                valuePage.setNextFreeListPage(-1L);
            }
            finally {
                freePageEntry.releaseExclusiveLock();
                this.releasePage(atomicOperation, freePageEntry);
            }
            return freePageEntry.getPageIndex();
        }
        return -1L;
    }

    private void rollback(Exception e) {
        try {
            this.endAtomicOperation(true, e);
        }
        catch (IOException e1) {
            OLogManager.instance().error(this, "Error during sbtree operation  rollback", e1, new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSize(long size, OAtomicOperation atomicOperation) throws IOException {
        OCacheEntry rootCacheEntry = this.loadPage(atomicOperation, this.fileId, 0L, false);
        rootCacheEntry.acquireExclusiveLock();
        try {
            OSBTreeBucket<K, V> rootBucket = new OSBTreeBucket<K, V>(rootCacheEntry, this.keySerializer, this.keyTypes, this.valueSerializer, this.getChanges(atomicOperation, rootCacheEntry));
            rootBucket.setTreeSize(size);
        }
        finally {
            rootCacheEntry.releaseExclusiveLock();
            this.releasePage(atomicOperation, rootCacheEntry);
        }
    }

    private OSBTreeCursor<K, V> iterateEntriesMinorDesc(K key, boolean inclusive) {
        key = this.keySerializer.preprocess(key, (Object[])this.keyTypes);
        key = this.enhanceCompositeKeyMinorDesc(key, inclusive);
        return new OSBTreeCursorBackward(null, key, false, inclusive);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OSBTreeCursor<K, V> iterateEntriesMinorAsc(K key, boolean inclusive) {
        this.acquireSharedLock();
        try {
            key = this.keySerializer.preprocess(key, (Object[])this.keyTypes);
            key = this.enhanceCompositeKeyMinorAsc(key, inclusive);
            OSBTreeCursorForward oSBTreeCursorForward = new OSBTreeCursorForward(null, key, true, inclusive);
            return oSBTreeCursorForward;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    private K enhanceCompositeKeyMinorDesc(K key, boolean inclusive) {
        PartialSearchMode partialSearchMode = inclusive ? PartialSearchMode.HIGHEST_BOUNDARY : PartialSearchMode.LOWEST_BOUNDARY;
        key = this.enhanceCompositeKey(key, partialSearchMode);
        return key;
    }

    private K enhanceCompositeKeyMinorAsc(K key, boolean inclusive) {
        PartialSearchMode partialSearchMode = inclusive ? PartialSearchMode.HIGHEST_BOUNDARY : PartialSearchMode.LOWEST_BOUNDARY;
        key = this.enhanceCompositeKey(key, partialSearchMode);
        return key;
    }

    private OSBTreeCursor<K, V> iterateEntriesMajorAsc(K key, boolean inclusive) {
        key = this.keySerializer.preprocess(key, (Object[])this.keyTypes);
        key = this.enhanceCompositeKeyMajorAsc(key, inclusive);
        return new OSBTreeCursorForward(key, null, inclusive, false);
    }

    private OSBTreeCursor<K, V> iterateEntriesMajorDesc(K key, boolean inclusive) {
        this.acquireSharedLock();
        try {
            key = this.keySerializer.preprocess(key, (Object[])this.keyTypes);
            key = this.enhanceCompositeKeyMajorDesc(key, inclusive);
        }
        finally {
            this.releaseSharedLock();
        }
        return new OSBTreeCursorBackward(key, null, inclusive, true);
    }

    private K enhanceCompositeKeyMajorAsc(K key, boolean inclusive) {
        PartialSearchMode partialSearchMode = inclusive ? PartialSearchMode.LOWEST_BOUNDARY : PartialSearchMode.HIGHEST_BOUNDARY;
        key = this.enhanceCompositeKey(key, partialSearchMode);
        return key;
    }

    private K enhanceCompositeKeyMajorDesc(K key, boolean inclusive) {
        PartialSearchMode partialSearchMode = inclusive ? PartialSearchMode.LOWEST_BOUNDARY : PartialSearchMode.HIGHEST_BOUNDARY;
        key = this.enhanceCompositeKey(key, partialSearchMode);
        return key;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private BucketSearchResult firstItem(OAtomicOperation atomicOperation) throws IOException {
        LinkedList<PagePathItemUnit> path = new LinkedList<PagePathItemUnit>();
        long bucketIndex = 0L;
        OCacheEntry cacheEntry = this.loadPage(atomicOperation, this.fileId, bucketIndex, false);
        int itemIndex = 0;
        cacheEntry.acquireSharedLock();
        try {
            OSBTreeBucket<K, V> bucket = new OSBTreeBucket<K, V>(cacheEntry, this.keySerializer, this.keyTypes, this.valueSerializer, this.getChanges(atomicOperation, cacheEntry));
            while (true) {
                PagePathItemUnit pagePathItemUnit;
                if (!bucket.isLeaf()) {
                    if (bucket.isEmpty() || itemIndex > bucket.size()) {
                        if (path.isEmpty()) {
                            pagePathItemUnit = null;
                            return pagePathItemUnit;
                        }
                        pagePathItemUnit = (PagePathItemUnit)path.removeLast();
                        bucketIndex = pagePathItemUnit.pageIndex;
                        itemIndex = pagePathItemUnit.itemIndex + 1;
                    } else {
                        OSBTreeBucket.SBTreeEntry<K, V> entry;
                        path.add(new PagePathItemUnit(bucketIndex, itemIndex));
                        if (itemIndex < bucket.size()) {
                            entry = bucket.getEntry(itemIndex);
                            bucketIndex = entry.leftChild;
                        } else {
                            entry = bucket.getEntry(itemIndex - 1);
                            bucketIndex = entry.rightChild;
                        }
                        itemIndex = 0;
                    }
                } else if (bucket.isEmpty()) {
                    if (path.isEmpty()) {
                        pagePathItemUnit = null;
                        return pagePathItemUnit;
                    }
                    pagePathItemUnit = (PagePathItemUnit)path.removeLast();
                    bucketIndex = pagePathItemUnit.pageIndex;
                    itemIndex = pagePathItemUnit.itemIndex + 1;
                } else {
                    ArrayList<Long> resultPath = new ArrayList<Long>(path.size() + 1);
                    Object object = path.iterator();
                    while (true) {
                        if (!object.hasNext()) {
                            resultPath.add(bucketIndex);
                            object = new BucketSearchResult(0, resultPath);
                            return object;
                        }
                        PagePathItemUnit pathItemUnit = (PagePathItemUnit)object.next();
                        resultPath.add(pathItemUnit.pageIndex);
                    }
                }
                cacheEntry.releaseSharedLock();
                this.releasePage(atomicOperation, cacheEntry);
                cacheEntry = this.loadPage(atomicOperation, this.fileId, bucketIndex, false);
                cacheEntry.acquireSharedLock();
                bucket = new OSBTreeBucket<K, V>(cacheEntry, this.keySerializer, this.keyTypes, this.valueSerializer, this.getChanges(atomicOperation, cacheEntry));
            }
        }
        finally {
            cacheEntry.releaseSharedLock();
            this.releasePage(atomicOperation, cacheEntry);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private BucketSearchResult lastItem(OAtomicOperation atomicOperation) throws IOException {
        LinkedList<PagePathItemUnit> path = new LinkedList<PagePathItemUnit>();
        long bucketIndex = 0L;
        OCacheEntry cacheEntry = this.loadPage(atomicOperation, this.fileId, bucketIndex, false);
        cacheEntry.acquireSharedLock();
        OSBTreeBucket<K, V> bucket = new OSBTreeBucket<K, V>(cacheEntry, this.keySerializer, this.keyTypes, this.valueSerializer, this.getChanges(atomicOperation, cacheEntry));
        int itemIndex = bucket.size() - 1;
        try {
            while (true) {
                PagePathItemUnit pagePathItemUnit;
                if (!bucket.isLeaf()) {
                    if (itemIndex < -1) {
                        if (path.isEmpty()) {
                            pagePathItemUnit = null;
                            return pagePathItemUnit;
                        }
                        pagePathItemUnit = (PagePathItemUnit)path.removeLast();
                        bucketIndex = pagePathItemUnit.pageIndex;
                        itemIndex = pagePathItemUnit.itemIndex - 1;
                    } else {
                        OSBTreeBucket.SBTreeEntry<K, V> entry;
                        path.add(new PagePathItemUnit(bucketIndex, itemIndex));
                        if (itemIndex > -1) {
                            entry = bucket.getEntry(itemIndex);
                            bucketIndex = entry.rightChild;
                        } else {
                            entry = bucket.getEntry(0);
                            bucketIndex = entry.leftChild;
                        }
                        itemIndex = OSBTreeBucket.MAX_PAGE_SIZE_BYTES + 1;
                    }
                } else if (bucket.isEmpty()) {
                    if (path.isEmpty()) {
                        pagePathItemUnit = null;
                        return pagePathItemUnit;
                    }
                    pagePathItemUnit = (PagePathItemUnit)path.removeLast();
                    bucketIndex = pagePathItemUnit.pageIndex;
                    itemIndex = pagePathItemUnit.itemIndex - 1;
                } else {
                    ArrayList<Long> resultPath = new ArrayList<Long>(path.size() + 1);
                    Object object = path.iterator();
                    while (true) {
                        if (!object.hasNext()) {
                            resultPath.add(bucketIndex);
                            object = new BucketSearchResult(bucket.size() - 1, resultPath);
                            return object;
                        }
                        PagePathItemUnit pathItemUnit = (PagePathItemUnit)object.next();
                        resultPath.add(pathItemUnit.pageIndex);
                    }
                }
                cacheEntry.releaseSharedLock();
                this.releasePage(atomicOperation, cacheEntry);
                cacheEntry = this.loadPage(atomicOperation, this.fileId, bucketIndex, false);
                cacheEntry.acquireSharedLock();
                bucket = new OSBTreeBucket<K, V>(cacheEntry, this.keySerializer, this.keyTypes, this.valueSerializer, this.getChanges(atomicOperation, cacheEntry));
                if (itemIndex != OSBTreeBucket.MAX_PAGE_SIZE_BYTES + 1) continue;
                itemIndex = bucket.size() - 1;
            }
        }
        finally {
            cacheEntry.releaseSharedLock();
            this.releasePage(atomicOperation, cacheEntry);
        }
    }

    private OSBTreeCursor<K, V> iterateEntriesBetweenAscOrder(K keyFrom, boolean fromInclusive, K keyTo, boolean toInclusive) {
        keyFrom = this.keySerializer.preprocess(keyFrom, (Object[])this.keyTypes);
        keyTo = this.keySerializer.preprocess(keyTo, (Object[])this.keyTypes);
        keyFrom = this.enhanceFromCompositeKeyBetweenAsc(keyFrom, fromInclusive);
        keyTo = this.enhanceToCompositeKeyBetweenAsc(keyTo, toInclusive);
        return new OSBTreeCursorForward(keyFrom, keyTo, fromInclusive, toInclusive);
    }

    private OSBTreeCursor<K, V> iterateEntriesBetweenDescOrder(K keyFrom, boolean fromInclusive, K keyTo, boolean toInclusive) {
        keyFrom = this.keySerializer.preprocess(keyFrom, (Object[])this.keyTypes);
        keyTo = this.keySerializer.preprocess(keyTo, (Object[])this.keyTypes);
        keyFrom = this.enhanceFromCompositeKeyBetweenDesc(keyFrom, fromInclusive);
        keyTo = this.enhanceToCompositeKeyBetweenDesc(keyTo, toInclusive);
        return new OSBTreeCursorBackward(keyFrom, keyTo, fromInclusive, toInclusive);
    }

    private K enhanceToCompositeKeyBetweenAsc(K keyTo, boolean toInclusive) {
        PartialSearchMode partialSearchModeTo = toInclusive ? PartialSearchMode.HIGHEST_BOUNDARY : PartialSearchMode.LOWEST_BOUNDARY;
        keyTo = this.enhanceCompositeKey(keyTo, partialSearchModeTo);
        return keyTo;
    }

    private K enhanceFromCompositeKeyBetweenAsc(K keyFrom, boolean fromInclusive) {
        PartialSearchMode partialSearchModeFrom = fromInclusive ? PartialSearchMode.LOWEST_BOUNDARY : PartialSearchMode.HIGHEST_BOUNDARY;
        keyFrom = this.enhanceCompositeKey(keyFrom, partialSearchModeFrom);
        return keyFrom;
    }

    private K enhanceToCompositeKeyBetweenDesc(K keyTo, boolean toInclusive) {
        PartialSearchMode partialSearchModeTo = toInclusive ? PartialSearchMode.HIGHEST_BOUNDARY : PartialSearchMode.LOWEST_BOUNDARY;
        keyTo = this.enhanceCompositeKey(keyTo, partialSearchModeTo);
        return keyTo;
    }

    private K enhanceFromCompositeKeyBetweenDesc(K keyFrom, boolean fromInclusive) {
        PartialSearchMode partialSearchModeFrom = fromInclusive ? PartialSearchMode.LOWEST_BOUNDARY : PartialSearchMode.HIGHEST_BOUNDARY;
        keyFrom = this.enhanceCompositeKey(keyFrom, partialSearchModeFrom);
        return keyFrom;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BucketSearchResult splitBucket(List<Long> path, int keyIndex, K keyToInsert, OAtomicOperation atomicOperation) throws IOException {
        long pageIndex = path.get(path.size() - 1);
        OCacheEntry bucketEntry = this.loadPage(atomicOperation, this.fileId, pageIndex, false);
        bucketEntry.acquireExclusiveLock();
        try {
            int startRightIndex;
            OSBTreeBucket<K, V> bucketToSplit = new OSBTreeBucket<K, V>(bucketEntry, this.keySerializer, this.keyTypes, this.valueSerializer, this.getChanges(atomicOperation, bucketEntry));
            boolean splitLeaf = bucketToSplit.isLeaf();
            int bucketSize = bucketToSplit.size();
            int indexToSplit = bucketSize >>> 1;
            K separationKey = bucketToSplit.getKey(indexToSplit);
            ArrayList<OSBTreeBucket.SBTreeEntry<K, V>> rightEntries = new ArrayList<OSBTreeBucket.SBTreeEntry<K, V>>(indexToSplit);
            for (int i = startRightIndex = splitLeaf ? indexToSplit : indexToSplit + 1; i < bucketSize; ++i) {
                rightEntries.add(bucketToSplit.getEntry(i));
            }
            if (pageIndex != 0L) {
                BucketSearchResult bucketSearchResult = this.splitNonRootBucket(path, keyIndex, keyToInsert, pageIndex, bucketToSplit, splitLeaf, indexToSplit, separationKey, rightEntries, atomicOperation);
                return bucketSearchResult;
            }
            BucketSearchResult bucketSearchResult = this.splitRootBucket(path, keyIndex, keyToInsert, pageIndex, bucketEntry, bucketToSplit, splitLeaf, indexToSplit, separationKey, rightEntries, atomicOperation);
            return bucketSearchResult;
        }
        finally {
            bucketEntry.releaseExclusiveLock();
            this.releasePage(atomicOperation, bucketEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BucketSearchResult splitNonRootBucket(List<Long> path, int keyIndex, K keyToInsert, long pageIndex, OSBTreeBucket<K, V> bucketToSplit, boolean splitLeaf, int indexToSplit, K separationKey, List<OSBTreeBucket.SBTreeEntry<K, V>> rightEntries, OAtomicOperation atomicOperation) throws IOException {
        OCacheEntry rightBucketEntry = this.addPage(atomicOperation, this.fileId);
        rightBucketEntry.acquireExclusiveLock();
        try {
            OSBTreeBucket<K, V> newRightBucket = new OSBTreeBucket<K, V>(rightBucketEntry, splitLeaf, this.keySerializer, this.keyTypes, this.valueSerializer, this.getChanges(atomicOperation, rightBucketEntry));
            newRightBucket.addAll(rightEntries);
            bucketToSplit.shrink(indexToSplit);
            if (splitLeaf) {
                long rightSiblingPageIndex = bucketToSplit.getRightSibling();
                newRightBucket.setRightSibling(rightSiblingPageIndex);
                newRightBucket.setLeftSibling(pageIndex);
                bucketToSplit.setRightSibling(rightBucketEntry.getPageIndex());
                if (rightSiblingPageIndex >= 0L) {
                    OCacheEntry rightSiblingBucketEntry = this.loadPage(atomicOperation, this.fileId, rightSiblingPageIndex, false);
                    rightSiblingBucketEntry.acquireExclusiveLock();
                    OSBTreeBucket<K, V> rightSiblingBucket = new OSBTreeBucket<K, V>(rightSiblingBucketEntry, this.keySerializer, this.keyTypes, this.valueSerializer, this.getChanges(atomicOperation, rightSiblingBucketEntry));
                    try {
                        rightSiblingBucket.setLeftSibling(rightBucketEntry.getPageIndex());
                    }
                    finally {
                        rightSiblingBucketEntry.releaseExclusiveLock();
                        this.releasePage(atomicOperation, rightSiblingBucketEntry);
                    }
                }
            }
            long parentIndex = path.get(path.size() - 2);
            OCacheEntry parentCacheEntry = this.loadPage(atomicOperation, this.fileId, parentIndex, false);
            parentCacheEntry.acquireExclusiveLock();
            try {
                OSBTreeBucket parentBucket = new OSBTreeBucket(parentCacheEntry, this.keySerializer, this.keyTypes, this.valueSerializer, this.getChanges(atomicOperation, parentCacheEntry));
                OSBTreeBucket.SBTreeEntry parentEntry = new OSBTreeBucket.SBTreeEntry(pageIndex, rightBucketEntry.getPageIndex(), separationKey, null);
                int insertionIndex = parentBucket.find(separationKey);
                assert (insertionIndex < 0);
                insertionIndex = -insertionIndex - 1;
                while (!parentBucket.addEntry(insertionIndex, parentEntry, true)) {
                    parentCacheEntry.releaseExclusiveLock();
                    this.releasePage(atomicOperation, parentCacheEntry);
                    BucketSearchResult bucketSearchResult = this.splitBucket(path.subList(0, path.size() - 1), insertionIndex, separationKey, atomicOperation);
                    parentIndex = bucketSearchResult.getLastPathItem();
                    parentCacheEntry = this.loadPage(atomicOperation, this.fileId, parentIndex, false);
                    parentCacheEntry.acquireExclusiveLock();
                    insertionIndex = bucketSearchResult.itemIndex;
                    parentBucket = new OSBTreeBucket<K, V>(parentCacheEntry, this.keySerializer, this.keyTypes, this.valueSerializer, this.getChanges(atomicOperation, parentCacheEntry));
                }
            }
            finally {
                parentCacheEntry.releaseExclusiveLock();
                this.releasePage(atomicOperation, parentCacheEntry);
            }
        }
        finally {
            rightBucketEntry.releaseExclusiveLock();
            this.releasePage(atomicOperation, rightBucketEntry);
        }
        ArrayList<Long> resultPath = new ArrayList<Long>(path.subList(0, path.size() - 1));
        if (this.comparator.compare(keyToInsert, separationKey) < 0) {
            resultPath.add(pageIndex);
            return new BucketSearchResult(keyIndex, resultPath);
        }
        resultPath.add(rightBucketEntry.getPageIndex());
        if (splitLeaf) {
            return new BucketSearchResult(keyIndex - indexToSplit, resultPath);
        }
        resultPath.add(rightBucketEntry.getPageIndex());
        return new BucketSearchResult(keyIndex - indexToSplit - 1, resultPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BucketSearchResult splitRootBucket(List<Long> path, int keyIndex, K keyToInsert, long pageIndex, OCacheEntry bucketEntry, OSBTreeBucket<K, V> bucketToSplit, boolean splitLeaf, int indexToSplit, K separationKey, List<OSBTreeBucket.SBTreeEntry<K, V>> rightEntries, OAtomicOperation atomicOperation) throws IOException {
        long freeListPage = bucketToSplit.getValuesFreeListFirstIndex();
        long treeSize = bucketToSplit.getTreeSize();
        ArrayList leftEntries = new ArrayList(indexToSplit);
        for (int i = 0; i < indexToSplit; ++i) {
            leftEntries.add(bucketToSplit.getEntry(i));
        }
        OCacheEntry leftBucketEntry = this.addPage(atomicOperation, this.fileId);
        OCacheEntry rightBucketEntry = this.addPage(atomicOperation, this.fileId);
        leftBucketEntry.acquireExclusiveLock();
        try {
            OSBTreeBucket newLeftBucket = new OSBTreeBucket(leftBucketEntry, splitLeaf, this.keySerializer, this.keyTypes, this.valueSerializer, this.getChanges(atomicOperation, leftBucketEntry));
            newLeftBucket.addAll(leftEntries);
            if (splitLeaf) {
                newLeftBucket.setRightSibling(rightBucketEntry.getPageIndex());
            }
        }
        finally {
            leftBucketEntry.releaseExclusiveLock();
            this.releasePage(atomicOperation, leftBucketEntry);
        }
        rightBucketEntry.acquireExclusiveLock();
        try {
            OSBTreeBucket<K, V> newRightBucket = new OSBTreeBucket<K, V>(rightBucketEntry, splitLeaf, this.keySerializer, this.keyTypes, this.valueSerializer, this.getChanges(atomicOperation, rightBucketEntry));
            newRightBucket.addAll(rightEntries);
            if (splitLeaf) {
                newRightBucket.setLeftSibling(leftBucketEntry.getPageIndex());
            }
        }
        finally {
            rightBucketEntry.releaseExclusiveLock();
            this.releasePage(atomicOperation, rightBucketEntry);
        }
        bucketToSplit = new OSBTreeBucket<K, V>(bucketEntry, false, this.keySerializer, this.keyTypes, this.valueSerializer, this.getChanges(atomicOperation, bucketEntry));
        bucketToSplit.setTreeSize(treeSize);
        bucketToSplit.setValuesFreeListFirstIndex(freeListPage);
        bucketToSplit.addEntry(0, new OSBTreeBucket.SBTreeEntry(leftBucketEntry.getPageIndex(), rightBucketEntry.getPageIndex(), separationKey, null), true);
        ArrayList<Long> resultPath = new ArrayList<Long>(path.subList(0, path.size() - 1));
        if (this.comparator.compare(keyToInsert, separationKey) < 0) {
            resultPath.add(leftBucketEntry.getPageIndex());
            return new BucketSearchResult(keyIndex, resultPath);
        }
        resultPath.add(rightBucketEntry.getPageIndex());
        if (splitLeaf) {
            return new BucketSearchResult(keyIndex - indexToSplit, resultPath);
        }
        return new BucketSearchResult(keyIndex - indexToSplit - 1, resultPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BucketSearchResult findBucket(K key, OAtomicOperation atomicOperation) throws IOException {
        long pageIndex = 0L;
        ArrayList<Long> path = new ArrayList<Long>();
        while (true) {
            OSBTreeBucket.SBTreeEntry<K, V> entry;
            if (path.size() > MAX_PATH_LENGTH) {
                throw new OSBTreeException("We reached max level of depth of SBTree but still found nothing, seems like tree is in corrupted state. You should rebuild index related to given query.", this);
            }
            path.add(pageIndex);
            OCacheEntry bucketEntry = this.loadPage(atomicOperation, this.fileId, pageIndex, false);
            bucketEntry.acquireSharedLock();
            try {
                int insertionIndex;
                OSBTreeBucket<K, V> keyBucket = new OSBTreeBucket<K, V>(bucketEntry, this.keySerializer, this.keyTypes, this.valueSerializer, this.getChanges(atomicOperation, bucketEntry));
                int index = keyBucket.find(key);
                if (keyBucket.isLeaf()) {
                    BucketSearchResult bucketSearchResult = new BucketSearchResult(index, path);
                    return bucketSearchResult;
                }
                entry = index >= 0 ? keyBucket.getEntry(index) : ((insertionIndex = -index - 1) >= keyBucket.size() ? keyBucket.getEntry(insertionIndex - 1) : keyBucket.getEntry(insertionIndex));
            }
            finally {
                bucketEntry.releaseSharedLock();
                this.releasePage(atomicOperation, bucketEntry);
            }
            if (this.comparator.compare(key, entry.key) >= 0) {
                pageIndex = entry.rightChild;
                continue;
            }
            pageIndex = entry.leftChild;
        }
    }

    private K enhanceCompositeKey(K key, PartialSearchMode partialSearchMode) {
        if (!(key instanceof OCompositeKey)) {
            return key;
        }
        OCompositeKey compositeKey = (OCompositeKey)key;
        if (this.keySize != 1 && compositeKey.getKeys().size() != this.keySize && !partialSearchMode.equals((Object)PartialSearchMode.NONE)) {
            OCompositeKey fullKey = new OCompositeKey(compositeKey);
            int itemsToAdd = this.keySize - fullKey.getKeys().size();
            Comparable<Comparable<?>> keyItem = partialSearchMode.equals((Object)PartialSearchMode.HIGHEST_BOUNDARY) ? ALWAYS_GREATER_KEY : ALWAYS_LESS_KEY;
            for (int i = 0; i < itemsToAdd; ++i) {
                fullKey.addKey(keyItem);
            }
            return (K)fullKey;
        }
        return key;
    }

    private V readValue(OSBTreeValue<V> sbTreeValue, OAtomicOperation atomicOperation) throws IOException {
        if (!sbTreeValue.isLink()) {
            return sbTreeValue.getValue();
        }
        OCacheEntry cacheEntry = this.loadPage(atomicOperation, this.fileId, sbTreeValue.getLink(), false);
        cacheEntry.acquireSharedLock();
        OSBTreeValuePage valuePage = new OSBTreeValuePage(cacheEntry, this.getChanges(atomicOperation, cacheEntry), false);
        int totalSize = valuePage.getSize();
        int currentSize = 0;
        byte[] value = new byte[totalSize];
        while (currentSize < totalSize) {
            currentSize = valuePage.readBinaryContent(value, currentSize);
            long nextPage = valuePage.getNextPage();
            if (nextPage < 0L) continue;
            cacheEntry.releaseSharedLock();
            this.releasePage(atomicOperation, cacheEntry);
            cacheEntry = this.loadPage(atomicOperation, this.fileId, nextPage, false);
            cacheEntry.acquireSharedLock();
            valuePage = new OSBTreeValuePage(cacheEntry, this.getChanges(atomicOperation, cacheEntry), false);
        }
        cacheEntry.releaseSharedLock();
        this.releasePage(atomicOperation, cacheEntry);
        return this.valueSerializer.deserializeNativeObject(value, 0);
    }

    private Map.Entry<K, V> convertToMapEntry(OSBTreeBucket.SBTreeEntry<K, V> treeEntry, OAtomicOperation atomicOperation) throws IOException {
        final Object key = treeEntry.key;
        final Object value = this.readValue(treeEntry.value, atomicOperation);
        return new Map.Entry<K, V>(){

            @Override
            public K getKey() {
                return key;
            }

            @Override
            public V getValue() {
                return value;
            }

            @Override
            public V setValue(V value2) {
                throw new UnsupportedOperationException("setValue");
            }
        };
    }

    @Override
    protected void startOperation() {
        OSessionStoragePerformanceStatistic sessionStoragePerformanceStatistic = this.performanceStatisticManager.getSessionPerformanceStatistic();
        if (sessionStoragePerformanceStatistic != null) {
            sessionStoragePerformanceStatistic.startComponentOperation(this.getFullName(), OSessionStoragePerformanceStatistic.ComponentType.INDEX);
        }
    }

    private final class OSBTreeCursorBackward
    implements OSBTreeCursor<K, V> {
        private final K fromKey;
        private K toKey;
        private final boolean fromKeyInclusive;
        private boolean toKeyInclusive;
        private List<Map.Entry<K, V>> dataCache = new ArrayList();
        private Iterator<Map.Entry<K, V>> dataCacheIterator = OEmptyMapEntryIterator.INSTANCE;

        private OSBTreeCursorBackward(K fromKey, K toKey, boolean fromKeyInclusive, boolean toKeyInclusive) {
            this.fromKey = fromKey;
            this.toKey = toKey;
            this.fromKeyInclusive = fromKeyInclusive;
            this.toKeyInclusive = toKeyInclusive;
            if (toKey == null) {
                this.toKeyInclusive = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map.Entry<K, V> next(int prefetchSize) {
            OSessionStoragePerformanceStatistic statistic = OSBTree.this.performanceStatisticManager.getSessionPerformanceStatistic();
            OSBTree.this.startOperation();
            if (statistic != null) {
                statistic.startIndexEntryReadTimer();
            }
            try {
                if (this.dataCacheIterator == null) {
                    Map.Entry entry = null;
                    return entry;
                }
                if (this.dataCacheIterator.hasNext()) {
                    Map.Entry entry = this.dataCacheIterator.next();
                    this.toKey = entry.getKey();
                    this.toKeyInclusive = false;
                    Map.Entry entry2 = entry;
                    return entry2;
                }
                this.dataCache.clear();
                if (prefetchSize < 0 || prefetchSize > OGlobalConfiguration.INDEX_CURSOR_PREFETCH_SIZE.getValueAsInteger()) {
                    prefetchSize = OGlobalConfiguration.INDEX_CURSOR_PREFETCH_SIZE.getValueAsInteger();
                }
                OSBTree.this.atomicOperationsManager.acquireReadLock(OSBTree.this);
                try {
                    OSBTree.this.acquireSharedLock();
                    try {
                        OAtomicOperation atomicOperation = OSBTree.this.atomicOperationsManager.getCurrentOperation();
                        BucketSearchResult bucketSearchResult = this.toKey != null ? OSBTree.this.findBucket(this.toKey, atomicOperation) : OSBTree.this.lastItem(atomicOperation);
                        if (bucketSearchResult == null) {
                            this.dataCacheIterator = null;
                            Map.Entry entry = null;
                            return entry;
                        }
                        long pageIndex = bucketSearchResult.getLastPathItem();
                        int itemIndex = bucketSearchResult.itemIndex >= 0 ? (this.toKeyInclusive ? bucketSearchResult.itemIndex : bucketSearchResult.itemIndex - 1) : -bucketSearchResult.itemIndex - 2;
                        while (this.dataCache.size() < prefetchSize) {
                            if (pageIndex == -1L) {
                                break;
                            }
                            OCacheEntry cacheEntry = OSBTree.this.loadPage(atomicOperation, OSBTree.this.fileId, pageIndex, false);
                            cacheEntry.acquireSharedLock();
                            try {
                                OSBTreeBucket bucket = new OSBTreeBucket(cacheEntry, OSBTree.this.keySerializer, OSBTree.this.keyTypes, OSBTree.this.valueSerializer, OSBTree.this.getChanges(atomicOperation, cacheEntry));
                                if (itemIndex >= bucket.size()) {
                                    itemIndex = bucket.size() - 1;
                                }
                                if (itemIndex < 0) {
                                    pageIndex = bucket.getLeftSibling();
                                    itemIndex = Integer.MAX_VALUE;
                                    continue;
                                }
                                Map.Entry entry = OSBTree.this.convertToMapEntry(bucket.getEntry(itemIndex), atomicOperation);
                                --itemIndex;
                                if (this.toKey != null && (!this.toKeyInclusive ? OSBTree.this.comparator.compare(entry.getKey(), this.toKey) >= 0 : OSBTree.this.comparator.compare(entry.getKey(), this.toKey) > 0)) continue;
                                if (this.fromKey == null || !(this.fromKeyInclusive ? OSBTree.this.comparator.compare(entry.getKey(), this.fromKey) < 0 : OSBTree.this.comparator.compare(entry.getKey(), this.fromKey) <= 0)) {
                                    this.dataCache.add(entry);
                                    continue;
                                }
                                break;
                            }
                            finally {
                                cacheEntry.releaseSharedLock();
                                OSBTree.this.releasePage(atomicOperation, cacheEntry);
                            }
                        }
                    }
                    finally {
                        OSBTree.this.releaseSharedLock();
                    }
                }
                catch (IOException e) {
                    throw OException.wrapException(new OSBTreeException("Error during element iteration", OSBTree.this), e);
                }
                finally {
                    OSBTree.this.atomicOperationsManager.releaseReadLock(OSBTree.this);
                }
                if (this.dataCache.isEmpty()) {
                    this.dataCacheIterator = null;
                    Map.Entry e = null;
                    return e;
                }
                this.dataCacheIterator = this.dataCache.iterator();
                Map.Entry entry = this.dataCacheIterator.next();
                this.toKey = entry.getKey();
                this.toKeyInclusive = false;
                Map.Entry entry3 = entry;
                return entry3;
            }
            finally {
                if (statistic != null) {
                    statistic.stopIndexEntryReadTimer();
                }
                OSBTree.this.completeOperation();
            }
        }
    }

    private final class OSBTreeCursorForward
    implements OSBTreeCursor<K, V> {
        private K fromKey;
        private final K toKey;
        private boolean fromKeyInclusive;
        private final boolean toKeyInclusive;
        private List<Map.Entry<K, V>> dataCache = new ArrayList();
        private Iterator<Map.Entry<K, V>> dataCacheIterator = OEmptyMapEntryIterator.INSTANCE;

        private OSBTreeCursorForward(K fromKey, K toKey, boolean fromKeyInclusive, boolean toKeyInclusive) {
            this.fromKey = fromKey;
            this.toKey = toKey;
            this.fromKeyInclusive = fromKeyInclusive;
            this.toKeyInclusive = toKeyInclusive;
            if (fromKey == null) {
                this.fromKeyInclusive = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map.Entry<K, V> next(int prefetchSize) {
            OSessionStoragePerformanceStatistic statistic = OSBTree.this.performanceStatisticManager.getSessionPerformanceStatistic();
            OSBTree.this.startOperation();
            if (statistic != null) {
                statistic.startIndexEntryReadTimer();
            }
            try {
                if (this.dataCacheIterator == null) {
                    Map.Entry entry = null;
                    return entry;
                }
                if (this.dataCacheIterator.hasNext()) {
                    Map.Entry entry = this.dataCacheIterator.next();
                    this.fromKey = entry.getKey();
                    this.fromKeyInclusive = false;
                    Map.Entry entry2 = entry;
                    return entry2;
                }
                this.dataCache.clear();
                if (prefetchSize < 0 || prefetchSize > OGlobalConfiguration.INDEX_CURSOR_PREFETCH_SIZE.getValueAsInteger()) {
                    prefetchSize = OGlobalConfiguration.INDEX_CURSOR_PREFETCH_SIZE.getValueAsInteger();
                }
                if (prefetchSize == 0) {
                    prefetchSize = 1;
                }
                OSBTree.this.atomicOperationsManager.acquireReadLock(OSBTree.this);
                try {
                    OSBTree.this.acquireSharedLock();
                    try {
                        OAtomicOperation atomicOperation = OSBTree.this.atomicOperationsManager.getCurrentOperation();
                        BucketSearchResult bucketSearchResult = this.fromKey != null ? OSBTree.this.findBucket(this.fromKey, atomicOperation) : OSBTree.this.firstItem(atomicOperation);
                        if (bucketSearchResult == null) {
                            this.dataCacheIterator = null;
                            Map.Entry entry = null;
                            return entry;
                        }
                        long pageIndex = bucketSearchResult.getLastPathItem();
                        int itemIndex = bucketSearchResult.itemIndex >= 0 ? (this.fromKeyInclusive ? bucketSearchResult.itemIndex : bucketSearchResult.itemIndex + 1) : -bucketSearchResult.itemIndex - 1;
                        while (this.dataCache.size() < prefetchSize) {
                            if (pageIndex == -1L) {
                                break;
                            }
                            OCacheEntry cacheEntry = OSBTree.this.loadPage(atomicOperation, OSBTree.this.fileId, pageIndex, false);
                            cacheEntry.acquireSharedLock();
                            try {
                                OSBTreeBucket bucket = new OSBTreeBucket(cacheEntry, OSBTree.this.keySerializer, OSBTree.this.keyTypes, OSBTree.this.valueSerializer, OSBTree.this.getChanges(atomicOperation, cacheEntry));
                                if (itemIndex >= bucket.size()) {
                                    pageIndex = bucket.getRightSibling();
                                    itemIndex = 0;
                                    continue;
                                }
                                Map.Entry entry = OSBTree.this.convertToMapEntry(bucket.getEntry(itemIndex), atomicOperation);
                                ++itemIndex;
                                if (this.fromKey != null && (!this.fromKeyInclusive ? OSBTree.this.comparator.compare(entry.getKey(), this.fromKey) <= 0 : OSBTree.this.comparator.compare(entry.getKey(), this.fromKey) < 0)) continue;
                                if (this.toKey == null || !(this.toKeyInclusive ? OSBTree.this.comparator.compare(entry.getKey(), this.toKey) > 0 : OSBTree.this.comparator.compare(entry.getKey(), this.toKey) >= 0)) {
                                    this.dataCache.add(entry);
                                    continue;
                                }
                                break;
                            }
                            finally {
                                cacheEntry.releaseSharedLock();
                                OSBTree.this.releasePage(atomicOperation, cacheEntry);
                            }
                        }
                    }
                    finally {
                        OSBTree.this.releaseSharedLock();
                    }
                }
                catch (IOException e) {
                    throw OException.wrapException(new OSBTreeException("Error during element iteration", OSBTree.this), e);
                }
                finally {
                    OSBTree.this.atomicOperationsManager.releaseReadLock(OSBTree.this);
                }
                if (this.dataCache.isEmpty()) {
                    this.dataCacheIterator = null;
                    Map.Entry e = null;
                    return e;
                }
                this.dataCacheIterator = this.dataCache.iterator();
                Map.Entry entry = this.dataCacheIterator.next();
                this.fromKey = entry.getKey();
                this.fromKeyInclusive = false;
                Map.Entry entry3 = entry;
                return entry3;
            }
            finally {
                if (statistic != null) {
                    statistic.stopIndexEntryReadTimer();
                }
                OSBTree.this.completeOperation();
            }
        }
    }

    public class OSBTreeFullKeyCursor
    implements OSBTreeKeyCursor<K> {
        private long pageIndex;
        private int itemIndex;
        private List<K> keysCache = new ArrayList();
        private Iterator<K> keysIterator = new OEmptyIterator();

        public OSBTreeFullKeyCursor(long startPageIndex) {
            this.pageIndex = startPageIndex;
            this.itemIndex = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public K next(int prefetchSize) {
            OSessionStoragePerformanceStatistic statistic = OSBTree.this.performanceStatisticManager.getSessionPerformanceStatistic();
            OSBTree.this.startOperation();
            if (statistic != null) {
                statistic.startIndexEntryReadTimer();
            }
            try {
                Object k;
                if (this.keysIterator == null) {
                    Object k2 = null;
                    return k2;
                }
                if (this.keysIterator.hasNext()) {
                    Object k3 = this.keysIterator.next();
                    return k3;
                }
                this.keysCache.clear();
                if (prefetchSize < 0 || prefetchSize > OGlobalConfiguration.INDEX_CURSOR_PREFETCH_SIZE.getValueAsInteger()) {
                    prefetchSize = OGlobalConfiguration.INDEX_CURSOR_PREFETCH_SIZE.getValueAsInteger();
                }
                if (prefetchSize == 0) {
                    prefetchSize = 1;
                }
                OSBTree.this.atomicOperationsManager.acquireReadLock(OSBTree.this);
                try {
                    OSBTree.this.acquireSharedLock();
                    try {
                        OAtomicOperation atomicOperation = OSBTree.this.atomicOperationsManager.getCurrentOperation();
                        while (this.keysCache.size() < prefetchSize) {
                            if (this.pageIndex == -1L) {
                                break;
                            }
                            if (this.pageIndex >= OSBTree.this.getFilledUpTo(atomicOperation, OSBTree.this.fileId)) {
                                this.pageIndex = -1L;
                                break;
                            }
                            OCacheEntry cacheEntry = OSBTree.this.loadPage(atomicOperation, OSBTree.this.fileId, this.pageIndex, false);
                            cacheEntry.acquireSharedLock();
                            try {
                                OSBTreeBucket bucket = new OSBTreeBucket(cacheEntry, OSBTree.this.keySerializer, OSBTree.this.keyTypes, OSBTree.this.valueSerializer, OSBTree.this.getChanges(atomicOperation, cacheEntry));
                                if (this.itemIndex >= bucket.size()) {
                                    this.pageIndex = bucket.getRightSibling();
                                    this.itemIndex = 0;
                                    continue;
                                }
                                Map.Entry entry = OSBTree.this.convertToMapEntry(bucket.getEntry(this.itemIndex), atomicOperation);
                                ++this.itemIndex;
                                this.keysCache.add(entry.getKey());
                            }
                            finally {
                                cacheEntry.releaseSharedLock();
                                OSBTree.this.releasePage(atomicOperation, cacheEntry);
                            }
                        }
                    }
                    finally {
                        OSBTree.this.releaseSharedLock();
                    }
                }
                catch (IOException e) {
                    throw OException.wrapException(new OSBTreeException("Error during element iteration", OSBTree.this), e);
                }
                finally {
                    OSBTree.this.atomicOperationsManager.releaseReadLock(OSBTree.this);
                }
                if (this.keysCache.isEmpty()) {
                    this.keysCache = null;
                    k = null;
                    return k;
                }
                this.keysIterator = this.keysCache.iterator();
                k = this.keysIterator.next();
                return k;
            }
            finally {
                if (statistic != null) {
                    statistic.stopIndexEntryReadTimer();
                }
                OSBTree.this.completeOperation();
            }
        }
    }

    private static final class PagePathItemUnit {
        private final long pageIndex;
        private final int itemIndex;

        private PagePathItemUnit(long pageIndex, int itemIndex) {
            this.pageIndex = pageIndex;
            this.itemIndex = itemIndex;
        }
    }

    private static class BucketSearchResult {
        private final int itemIndex;
        private final ArrayList<Long> path;

        private BucketSearchResult(int itemIndex, ArrayList<Long> path) {
            this.itemIndex = itemIndex;
            this.path = path;
        }

        public long getLastPathItem() {
            return this.path.get(this.path.size() - 1);
        }

        static /* synthetic */ ArrayList access$100(BucketSearchResult x0) {
            return x0.path;
        }
    }

    public static interface OSBTreeKeyCursor<K> {
        public K next(int var1);
    }

    public static interface OSBTreeCursor<K, V> {
        public Map.Entry<K, V> next(int var1);
    }

    private static enum PartialSearchMode {
        NONE,
        HIGHEST_BOUNDARY,
        LOWEST_BOUNDARY;

    }
}

