/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.security.symmetrickey;

import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OSecurityException;
import com.orientechnologies.orient.core.metadata.security.OUser;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.security.symmetrickey.OSymmetricKeyConfig;
import java.util.Map;

public class OUserSymmetricKeyConfig
implements OSymmetricKeyConfig {
    private String keyString;
    private String keyFile;
    private String keyAlgorithm;
    private String keystoreFile;
    private String keystorePassword;
    private String keystoreKeyAlias;
    private String keystoreKeyPassword;

    @Override
    public String getKeyString() {
        return this.keyString;
    }

    @Override
    public String getKeyFile() {
        return this.keyFile;
    }

    @Override
    public String getKeyAlgorithm() {
        return this.keyAlgorithm;
    }

    @Override
    public String getKeystoreFile() {
        return this.keystoreFile;
    }

    @Override
    public String getKeystorePassword() {
        return this.keystorePassword;
    }

    @Override
    public String getKeystoreKeyAlias() {
        return this.keystoreKeyAlias;
    }

    @Override
    public String getKeystoreKeyPassword() {
        return this.keystoreKeyPassword;
    }

    @Override
    public boolean usesKeyString() {
        return this.keyString != null && !this.keyString.isEmpty() && this.keyAlgorithm != null && !this.keyAlgorithm.isEmpty();
    }

    @Override
    public boolean usesKeyFile() {
        return this.keyFile != null && !this.keyFile.isEmpty() && this.keyAlgorithm != null && !this.keyAlgorithm.isEmpty();
    }

    @Override
    public boolean usesKeystore() {
        return this.keystoreFile != null && !this.keystoreFile.isEmpty() && this.keystoreKeyAlias != null && !this.keystoreKeyAlias.isEmpty();
    }

    public OUserSymmetricKeyConfig(OUser user) {
        if (user == null) {
            throw new OSecurityException("OUserSymmetricKeyConfig() OUser is null");
        }
        OIdentifiable id = user.getIdentity();
        if (!(id instanceof ODocument)) {
            throw new OSecurityException("OUserSymmetricKeyConfig() Identity is not an ODocument");
        }
        ODocument doc = (ODocument)id;
        ODocument props = (ODocument)doc.field("properties");
        if (props == null) {
            throw new OSecurityException("OUserSymmetricKeyConfig() OUser properties is null");
        }
        this.keyString = (String)props.field("key");
        if (this.keyString != null) {
            this.keyAlgorithm = (String)props.field("keyAlgorithm");
            if (this.keyAlgorithm == null) {
                throw new OSecurityException("OUserSymmetricKeyConfig() keyAlgorithm is required with key");
            }
        } else {
            this.keyFile = (String)props.field("keyFile");
            if (this.keyFile != null) {
                this.keyAlgorithm = (String)props.field("keyAlgorithm");
                if (this.keyAlgorithm == null) {
                    throw new OSecurityException("OUserSymmetricKeyConfig() keyAlgorithm is required with keyFile");
                }
            } else {
                Map ksMap = (Map)props.field("keyStore");
                ODocument ksDoc = new ODocument().fromMap(ksMap);
                if (ksDoc == null) {
                    throw new OSecurityException("OUserSymmetricKeyConfig() key, keyFile, and keyStore cannot all be null");
                }
                this.keystoreFile = (String)ksDoc.field("file");
                this.keystorePassword = (String)ksDoc.field("passsword");
                this.keystoreKeyAlias = (String)ksDoc.field("keyAlias");
                this.keystoreKeyPassword = (String)ksDoc.field("keyPassword");
                if (this.keystoreFile == null) {
                    throw new OSecurityException("OUserSymmetricKeyConfig() keyStore.file is required");
                }
                if (this.keystoreKeyAlias == null) {
                    throw new OSecurityException("OUserSymmetricKeyConfig() keyStore.keyAlias is required");
                }
            }
        }
    }
}

