/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.orient.core.command.OCommandExecutor;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLAlterClass;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLAlterCluster;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLAlterDatabase;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLAlterProperty;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLAlterSequence;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLCreateClass;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLCreateCluster;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLCreateFunction;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLCreateIndex;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLCreateLink;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLCreateProperty;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLCreateSequence;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLCreateUser;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLDelete;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLDropClass;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLDropCluster;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLDropIndex;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLDropProperty;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLDropSequence;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLDropUser;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLExplain;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLFactory;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLFindReferences;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLGrant;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLHide;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLInsert;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLOptimizeDatabase;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLRebuildIndex;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLRevoke;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLSelect;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLTransactional;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLTraverse;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLTruncateClass;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLTruncateCluster;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLTruncateRecord;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLUpdate;
import com.orientechnologies.orient.core.sql.OCommandExecutorToOStatementWrapper;
import com.orientechnologies.orient.core.sql.parser.OMatchStatement;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ODefaultCommandExecutorSQLFactory
implements OCommandExecutorSQLFactory {
    private static final Map<String, Class<? extends OCommandExecutor>> COMMANDS;

    @Override
    public Set<String> getCommandNames() {
        return COMMANDS.keySet();
    }

    @Override
    public OCommandExecutor createCommand(String name) throws OCommandExecutionException {
        Class<? extends OCommandExecutor> clazz = COMMANDS.get(name);
        if (clazz == null) {
            throw new OCommandExecutionException("Unknowned command name :" + name);
        }
        try {
            return clazz.newInstance();
        }
        catch (Exception e) {
            throw OException.wrapException(new OCommandExecutionException("Error in creation of command " + name + "(). Probably there is not an empty constructor or the constructor generates errors"), e);
        }
    }

    static {
        HashMap<String, Class> commands = new HashMap<String, Class>();
        commands.put("ALTER DATABASE", OCommandExecutorSQLAlterDatabase.class);
        commands.put("SELECT", OCommandExecutorSQLSelect.class);
        commands.put("TRAVERSE", OCommandExecutorSQLTraverse.class);
        commands.put("INSERT", OCommandExecutorSQLInsert.class);
        commands.put("UPDATE", OCommandExecutorSQLUpdate.class);
        commands.put("DELETE FROM", OCommandExecutorSQLDelete.class);
        commands.put("HIDE FROM", OCommandExecutorSQLHide.class);
        commands.put("CREATE FUNCTION", OCommandExecutorSQLCreateFunction.class);
        commands.put("GRANT", OCommandExecutorSQLGrant.class);
        commands.put("REVOKE", OCommandExecutorSQLRevoke.class);
        commands.put("CREATE LINK", OCommandExecutorSQLCreateLink.class);
        commands.put("CREATE INDEX", OCommandExecutorSQLCreateIndex.class);
        commands.put("DROP INDEX", OCommandExecutorSQLDropIndex.class);
        commands.put("REBUILD INDEX", OCommandExecutorSQLRebuildIndex.class);
        commands.put("CREATE CLASS", OCommandExecutorSQLCreateClass.class);
        commands.put("CREATE CLUSTER", OCommandExecutorSQLCreateCluster.class);
        commands.put("CREATE BLOB CLUSTER", OCommandExecutorSQLCreateCluster.class);
        commands.put("ALTER CLASS", OCommandExecutorSQLAlterClass.class);
        commands.put("CREATE PROPERTY", OCommandExecutorSQLCreateProperty.class);
        commands.put("ALTER PROPERTY", OCommandExecutorSQLAlterProperty.class);
        commands.put("DROP CLUSTER", OCommandExecutorSQLDropCluster.class);
        commands.put("DROP CLASS", OCommandExecutorSQLDropClass.class);
        commands.put("DROP PROPERTY", OCommandExecutorSQLDropProperty.class);
        commands.put("FIND REFERENCES", OCommandExecutorSQLFindReferences.class);
        commands.put("TRUNCATE CLASS", OCommandExecutorSQLTruncateClass.class);
        commands.put("TRUNCATE CLUSTER", OCommandExecutorSQLTruncateCluster.class);
        commands.put("TRUNCATE RECORD", OCommandExecutorSQLTruncateRecord.class);
        commands.put("ALTER CLUSTER", OCommandExecutorSQLAlterCluster.class);
        commands.put("CREATE SEQUENCE", OCommandExecutorSQLCreateSequence.class);
        commands.put("ALTER SEQUENCE", OCommandExecutorSQLAlterSequence.class);
        commands.put("DROP SEQUENCE", OCommandExecutorSQLDropSequence.class);
        commands.put("CREATE USER", OCommandExecutorSQLCreateUser.class);
        commands.put("DROP USER", OCommandExecutorSQLDropUser.class);
        commands.put("EXPLAIN", OCommandExecutorSQLExplain.class);
        commands.put("TRANSACTIONAL", OCommandExecutorSQLTransactional.class);
        commands.put("MATCH", OMatchStatement.class);
        commands.put("OPTIMIZE", OCommandExecutorSQLOptimizeDatabase.class);
        commands.put("PROFILE", OCommandExecutorToOStatementWrapper.class);
        COMMANDS = Collections.unmodifiableMap(commands);
    }
}

