/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.sql.parser.OIdentifier;
import com.orientechnologies.orient.core.sql.parser.OInteger;
import com.orientechnologies.orient.core.sql.parser.OStatement;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import java.util.List;
import java.util.Map;

public class OCreateClassStatement
extends OStatement {
    public OIdentifier name;
    boolean ifNotExists = false;
    protected List<OIdentifier> superclasses;
    protected List<OInteger> clusters;
    protected OInteger totalClusterNo;
    protected boolean abstractClass = false;

    public OCreateClassStatement(int id) {
        super(id);
    }

    public OCreateClassStatement(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        boolean first;
        builder.append("CREATE CLASS ");
        this.name.toString(params, builder);
        if (this.ifNotExists) {
            builder.append(" IF NOT EXISTS");
        }
        if (this.superclasses != null && this.superclasses.size() > 0) {
            builder.append(" EXTENDS ");
            first = true;
            for (OIdentifier sup : this.superclasses) {
                if (!first) {
                    builder.append(", ");
                }
                sup.toString(params, builder);
                first = false;
            }
        }
        if (this.clusters != null && this.clusters.size() > 0) {
            builder.append(" CLUSTER ");
            first = true;
            for (OInteger cluster : this.clusters) {
                if (!first) {
                    builder.append(",");
                }
                cluster.toString(params, builder);
                first = false;
            }
        }
        if (this.totalClusterNo != null) {
            builder.append(" CLUSTERS ");
            this.totalClusterNo.toString(params, builder);
        }
        if (this.abstractClass) {
            builder.append(" ABSTRACT");
        }
    }

    public List<OIdentifier> getSuperclasses() {
        return this.superclasses;
    }
}

