/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.server.distributed.OModifiableDistributedConfiguration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class ODistributedConfiguration {
    public static final String NEW_NODE_TAG = "<NEW_NODE>";
    public static final String ALL_WILDCARD = "*";
    protected static final String SERVERS = "servers";
    protected static final String DCS = "dataCenters";
    protected static final String OWNER = "owner";
    protected static final String CLUSTERS = "clusters";
    protected static final String VERSION = "version";
    protected static final String AUTO_DEPLOY = "autoDeploy";
    protected static final String READ_QUORUM = "readQuorum";
    protected static final String WRITE_QUORUM = "writeQuorum";
    public static final String QUORUM_MAJORITY = "majority";
    public static final String QUORUM_ALL = "all";
    public static final String QUORUM_LOCAL_DC = "localDataCenter";
    public static final Integer DEFAULT_READ_QUORUM = 1;
    public static final String DEFAULT_WRITE_QUORUM = "majority";
    protected static final String NEW_NODE_STRATEGY = "newNodeStrategy";
    protected static final String READ_YOUR_WRITES = "readYourWrites";
    protected static final String EXECUTION_MODE = "executionMode";
    protected static final String EXECUTION_MODE_SYNCHRONOUS = "synchronous";
    protected final ODocument configuration;
    protected static final List<String> DEFAULT_CLUSTER_NAME = Collections.singletonList("*");
    private static ThreadLocal<Integer> overwriteWriteQuorum = new ThreadLocal();

    public ODistributedConfiguration(ODocument iConfiguration) {
        this.configuration = iConfiguration;
        this.configuration.setTrackingChanges(false);
    }

    public OModifiableDistributedConfiguration modify() {
        return new OModifiableDistributedConfiguration(this.configuration.copy());
    }

    public boolean isReplicationActive(String iClusterName, String iLocalNode) {
        Collection servers = (Collection)this.getClusterConfiguration(iClusterName).field(SERVERS);
        return servers != null && !servers.isEmpty();
    }

    public boolean hasDataCenterConfiguration() {
        return this.configuration.field(DCS) != null;
    }

    public boolean isAutoDeploy() {
        return this.configuration.field(AUTO_DEPLOY) != null ? (Boolean)this.configuration.field(AUTO_DEPLOY) : true;
    }

    public NEW_NODE_STRATEGIES getNewNodeStrategy() {
        String value = (String)this.configuration.field(NEW_NODE_STRATEGY);
        if (value != null) {
            return NEW_NODE_STRATEGIES.valueOf(value.toUpperCase(Locale.ENGLISH));
        }
        return NEW_NODE_STRATEGIES.STATIC;
    }

    public Boolean isExecutionModeSynchronous(String iClusterName) {
        Object value = this.getClusterConfiguration(iClusterName).field(EXECUTION_MODE);
        if (value == null && (value = this.configuration.field(EXECUTION_MODE)) == null) {
            return null;
        }
        if (value.toString().equalsIgnoreCase("undefined")) {
            return null;
        }
        return value.toString().equalsIgnoreCase(EXECUTION_MODE_SYNCHRONOUS);
    }

    public Boolean isReadYourWrites(String iClusterName) {
        Object value = this.getClusterConfiguration(iClusterName).field(READ_YOUR_WRITES);
        if (value == null && (value = this.configuration.field(READ_YOUR_WRITES)) == null) {
            OLogManager.instance().warn((Object)this, "%s setting not found for cluster=%s in distributed-config.json", READ_YOUR_WRITES, iClusterName);
            return true;
        }
        return (Boolean)value;
    }

    public Map<String, Collection<String>> getServerClusterMap(Collection<String> iClusterNames, String iLocalNode, boolean optimizeForLocalOnly) {
        if (iClusterNames == null || iClusterNames.isEmpty()) {
            iClusterNames = DEFAULT_CLUSTER_NAME;
        }
        HashMap<String, Collection<String>> servers = new HashMap<String, Collection<String>>(iClusterNames.size());
        boolean canUseLocalNode = true;
        for (String string : iClusterNames) {
            List serverList = (List)this.getClusterConfiguration(string).field(SERVERS);
            if (serverList == null || serverList.contains(iLocalNode)) continue;
            canUseLocalNode = false;
            break;
        }
        if (optimizeForLocalOnly && canUseLocalNode) {
            servers.put(iLocalNode, iClusterNames);
            return servers;
        }
        final HashMap<String, Collection<String>> serverMap = new HashMap<String, Collection<String>>();
        for (String p : iClusterNames) {
            List serverList = (List)this.getClusterConfiguration(p).field(SERVERS);
            for (String s : serverList) {
                if (NEW_NODE_TAG.equalsIgnoreCase(s)) continue;
                HashSet<String> clustersInServer = (HashSet<String>)serverMap.get(s);
                if (clustersInServer == null) {
                    clustersInServer = new HashSet<String>();
                    serverMap.put(s, clustersInServer);
                }
                clustersInServer.add(p);
            }
        }
        if (serverMap.size() == 1) {
            return serverMap;
        }
        if (!optimizeForLocalOnly) {
            return serverMap;
        }
        ArrayList arrayList = new ArrayList(serverMap.keySet());
        Collections.sort(arrayList, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return Integer.valueOf(((Collection)serverMap.get(o2)).size()).compareTo(((Collection)serverMap.get(o1)).size());
            }
        });
        HashSet<String> remainingClusters = new HashSet<String>(iClusterNames);
        HashSet includedClusters = new HashSet(iClusterNames.size());
        for (String s : arrayList) {
            Collection clusters = (Collection)serverMap.get(s);
            if (!servers.isEmpty()) {
                clusters.removeAll(includedClusters);
            }
            servers.put(s, clusters);
            remainingClusters.removeAll(clusters);
            includedClusters.addAll(clusters);
            if (!remainingClusters.isEmpty()) continue;
            break;
        }
        return servers;
    }

    public List<String> getOwnedClustersByServer(Collection<String> iClusterNames, String iNode) {
        if (iClusterNames == null || iClusterNames.isEmpty()) {
            iClusterNames = DEFAULT_CLUSTER_NAME;
        }
        ArrayList<String> notDefinedClusters = new ArrayList<String>(5);
        ArrayList<String> candidates = new ArrayList<String>(5);
        for (String p : iClusterNames) {
            if (p == null) continue;
            String ownerServer = this.getClusterOwner(p);
            if (ownerServer == null) {
                notDefinedClusters.add(p);
                continue;
            }
            if (!iNode.equals(ownerServer)) continue;
            candidates.add(p);
        }
        if (!candidates.isEmpty()) {
            return candidates;
        }
        String owner = this.getClusterOwner(ALL_WILDCARD);
        if (iNode.equals(owner)) {
            return notDefinedClusters;
        }
        return candidates;
    }

    public Set<String> getServers(Collection<String> iClusterNames) {
        if (iClusterNames == null || iClusterNames.isEmpty()) {
            return this.getAllConfiguredServers();
        }
        HashSet<String> partitions = new HashSet<String>(iClusterNames.size());
        for (String p : iClusterNames) {
            List serverList = (List)this.getClusterConfiguration(p).field(SERVERS);
            if (serverList == null) continue;
            for (String s : serverList) {
                if (s.equals(NEW_NODE_TAG)) continue;
                partitions.add(s);
            }
        }
        return partitions;
    }

    public boolean isServerContainingAllClusters(String server, Collection<String> clusters) {
        if (clusters == null || clusters.isEmpty()) {
            clusters = DEFAULT_CLUSTER_NAME;
        }
        for (String cluster : clusters) {
            List serverList = (List)this.getClusterConfiguration(cluster).field(SERVERS);
            if (serverList == null || serverList.contains(server)) continue;
            return false;
        }
        return true;
    }

    public boolean isServerContainingCluster(String server, String cluster) {
        List serverList;
        if (cluster == null) {
            cluster = ALL_WILDCARD;
        }
        if ((serverList = (List)this.getClusterConfiguration(cluster).field(SERVERS)) != null) {
            return serverList.contains(server);
        }
        return true;
    }

    public List<String> getServers(String iClusterName, String iExclude) {
        List serverList = (List)this.getClusterConfiguration(iClusterName).field(SERVERS);
        if (serverList != null) {
            ArrayList<String> filteredServerList = new ArrayList<String>(serverList.size());
            for (String s : serverList) {
                if (s.equals(NEW_NODE_TAG) || iExclude != null && iExclude.equals(s)) continue;
                filteredServerList.add(s);
            }
            return filteredServerList;
        }
        return Collections.EMPTY_LIST;
    }

    public List<String> getMasterServers() {
        List serverList = (List)this.getClusterConfiguration(null).field(SERVERS);
        if (serverList != null) {
            ArrayList<String> masters = new ArrayList<String>(serverList.size());
            for (String s : serverList) {
                if (s.equals(NEW_NODE_TAG)) continue;
                masters.add(s);
            }
            ROLES defRole = this.getDefaultServerRole();
            ODocument servers = (ODocument)this.configuration.field(SERVERS);
            if (servers != null) {
                Iterator it = masters.iterator();
                while (it.hasNext()) {
                    String server = (String)it.next();
                    String roleAsString = (String)servers.field(server);
                    ROLES role = roleAsString != null ? ROLES.valueOf(roleAsString.toUpperCase(Locale.ENGLISH)) : defRole;
                    if (role == ROLES.MASTER) continue;
                    it.remove();
                }
            }
            return masters;
        }
        return Collections.EMPTY_LIST;
    }

    public Set<String> getAllConfiguredServers() {
        HashSet<String> servers = new HashSet<String>();
        for (String p : this.getClusterNames()) {
            List serverList = (List)this.getClusterConfiguration(p).field(SERVERS);
            if (serverList == null) continue;
            for (String s : serverList) {
                if (s.equals(NEW_NODE_TAG)) continue;
                servers.add(s);
            }
        }
        return servers;
    }

    public Set<String> getClustersOnServer(String iNodeName) {
        HashSet<String> clusters = new HashSet<String>();
        for (String cl : this.getClusterNames()) {
            List<String> servers = this.getServers(cl, null);
            if (!servers.contains(iNodeName)) continue;
            clusters.add(cl);
        }
        return clusters;
    }

    public Set<String> getClustersOwnedByServer(String iNodeName) {
        HashSet<String> clusters = new HashSet<String>();
        for (String cl : this.getClusterNames()) {
            if (!iNodeName.equals(this.getClusterOwner(cl))) continue;
            clusters.add(cl);
        }
        return clusters;
    }

    public String getClusterOwner(String iClusterName) {
        String owner;
        ODocument cfg;
        ODocument clusters = this.getConfiguredClusters();
        ODocument oDocument = cfg = iClusterName != null ? (ODocument)clusters.field(iClusterName) : null;
        if (cfg != null) {
            owner = (String)cfg.field(OWNER);
            if (owner != null) {
                return owner;
            }
            List serverList = (List)cfg.field(SERVERS);
            if (serverList != null && !serverList.isEmpty() && NEW_NODE_TAG.equals(owner = (String)serverList.get(0)) && serverList.size() > 1) {
                owner = (String)serverList.get(1);
            }
        } else {
            return this.getClusterOwner(ALL_WILDCARD);
        }
        return owner;
    }

    public String getConfiguredClusterOwner(String iClusterName) {
        String owner = null;
        ODocument clusters = this.getConfiguredClusters();
        ODocument cfg = (ODocument)clusters.field(iClusterName);
        if (cfg != null) {
            owner = (String)cfg.field(OWNER);
        }
        return owner;
    }

    public List<String> getConfiguredServers(String iClusterName) {
        Collection list = (Collection)this.getClusterConfiguration(iClusterName).field(SERVERS);
        return list != null ? new ArrayList(list) : null;
    }

    public String[] getClusterNames() {
        ODocument clusters = (ODocument)this.configuration.field(CLUSTERS);
        return clusters.fieldNames();
    }

    public ROLES getDefaultServerRole() {
        ODocument servers = (ODocument)this.configuration.field(SERVERS);
        if (servers == null) {
            return ROLES.MASTER;
        }
        String role = (String)servers.field(ALL_WILDCARD);
        if (role == null) {
            return ROLES.MASTER;
        }
        return ROLES.valueOf(role.toUpperCase(Locale.ENGLISH));
    }

    public ROLES getServerRole(String iServerName) {
        ODocument servers = (ODocument)this.configuration.field(SERVERS);
        if (servers == null) {
            return ROLES.MASTER;
        }
        String role = (String)servers.field(iServerName);
        if (role == null && (role = (String)servers.field(ALL_WILDCARD)) == null) {
            return ROLES.MASTER;
        }
        return ROLES.valueOf(role.toUpperCase(Locale.ENGLISH));
    }

    public Set<String> getRegisteredServers() {
        ODocument servers = (ODocument)this.configuration.field(SERVERS);
        HashSet<String> result = new HashSet<String>();
        if (servers != null) {
            for (String s : servers.fieldNames()) {
                result.add(s);
            }
        }
        return result;
    }

    public ODocument getDocument() {
        return this.configuration;
    }

    public Set<String> getDataCenters() {
        ODocument dcs = (ODocument)this.configuration.field(DCS);
        if (dcs == null) {
            return Collections.EMPTY_SET;
        }
        HashSet<String> result = new HashSet<String>();
        for (String dc : dcs.fieldNames()) {
            result.add(dc);
        }
        return result;
    }

    public int getDataCenterWriteQuorum(String dataCenter) {
        ODocument dc = this.getDataCenterConfiguration(dataCenter);
        Object wq = dc.field(WRITE_QUORUM);
        if (wq instanceof String) {
            if (wq.toString().equalsIgnoreCase("majority")) {
                List servers = (List)dc.field(SERVERS);
                wq = servers.size() / 2 + 1;
            } else if (wq.toString().equalsIgnoreCase(QUORUM_ALL)) {
                List servers = (List)dc.field(SERVERS);
                wq = servers.size();
            }
        }
        return (Integer)wq;
    }

    public boolean isSharded() {
        List allServers;
        ODocument allCluster = this.getClusterConfiguration(ALL_WILDCARD);
        if (allCluster != null && (allServers = (List)allCluster.field(SERVERS)) != null && !allServers.isEmpty()) {
            for (String cl : this.getClusterNames()) {
                List<String> servers = this.getServers(cl, null);
                if (servers == null || servers.isEmpty() || allServers.containsAll(servers)) continue;
                return false;
            }
        }
        return false;
    }

    public List<String> getDataCenterServers(String dataCenter) {
        ODocument dc = this.getDataCenterConfiguration(dataCenter);
        List servers = (List)dc.field(SERVERS);
        if (servers == null || servers.isEmpty()) {
            throw new OConfigurationException("Data center '" + dataCenter + "' does not contain any server in distributed database configuration");
        }
        return new ArrayList<String>(servers);
    }

    public String getDataCenterOfServer(String server) {
        ODocument dcs = (ODocument)this.configuration.field(DCS);
        if (dcs != null) {
            for (String dc : dcs.fieldNames()) {
                List dcServers;
                ODocument dcConfig = (ODocument)dcs.field(dc);
                if (dcConfig == null || (dcServers = (List)dcConfig.field(SERVERS)) == null || dcServers.isEmpty() || !dcServers.contains(server)) continue;
                return dc;
            }
        }
        return null;
    }

    public int getVersion() {
        Integer v = (Integer)this.configuration.field(VERSION);
        if (v == null) {
            return 1;
        }
        return v;
    }

    public boolean isLocalDataCenterWriteQuorum() {
        return QUORUM_LOCAL_DC.equals(this.configuration.field(WRITE_QUORUM));
    }

    public Object getGlobalReadQuorum(String iClusterName) {
        Object value = this.getClusterConfiguration(iClusterName).field(READ_QUORUM);
        if (value == null) {
            value = this.configuration.field(READ_QUORUM);
        }
        return value;
    }

    public int getReadQuorum(String clusterName, int totalConfiguredServers, String server) {
        return this.getQuorum(READ_QUORUM, clusterName, totalConfiguredServers, DEFAULT_READ_QUORUM, server);
    }

    public int getWriteQuorum(String clusterName, int totalConfiguredMasterServers, String server) {
        Integer overWrite = overwriteWriteQuorum.get();
        if (overWrite != null) {
            return overWrite;
        }
        return this.getQuorum(WRITE_QUORUM, clusterName, totalConfiguredMasterServers, "majority", server);
    }

    private ODocument getConfiguredClusters() {
        ODocument clusters = (ODocument)this.configuration.field(CLUSTERS);
        if (clusters == null) {
            throw new OConfigurationException("Cannot find 'clusters' in distributed database configuration");
        }
        return clusters;
    }

    public String toString() {
        return this.configuration.toString();
    }

    protected ODocument getClusterConfiguration(String iClusterName) {
        ODocument cfg;
        ODocument clusters = this.getConfiguredClusters();
        if (iClusterName == null) {
            iClusterName = ALL_WILDCARD;
        }
        if ((cfg = !clusters.containsField(iClusterName) ? (ODocument)clusters.field(ALL_WILDCARD) : (ODocument)clusters.field(iClusterName)) == null) {
            return new ODocument();
        }
        return cfg;
    }

    private ODocument getDataCenterConfiguration(String dataCenter) {
        ODocument dcs = (ODocument)this.configuration.field(DCS);
        if (dcs != null) {
            return (ODocument)dcs.field(dataCenter);
        }
        throw new OConfigurationException("Cannot find the data center '" + dataCenter + "' in distributed database configuration");
    }

    public void forceWriteQuorum(int quorum) {
        overwriteWriteQuorum.set(quorum);
    }

    public void clearForceWriteQuorum() {
        overwriteWriteQuorum.remove();
    }

    private int getQuorum(String quorumSetting, String iClusterName, int totalServers, Object defaultValue, String server) {
        Object value = this.getClusterConfiguration(iClusterName).field(quorumSetting);
        if (value == null && (value = this.configuration.field(quorumSetting)) == null) {
            OLogManager.instance().warn((Object)this, "%s setting not found for cluster=%s in distributed-config.json", quorumSetting, iClusterName);
            value = defaultValue;
        }
        if (value instanceof String) {
            if (value.toString().equalsIgnoreCase("majority")) {
                value = totalServers / 2 + 1;
            } else if (value.toString().equalsIgnoreCase(QUORUM_ALL)) {
                value = totalServers;
            } else if (value.toString().equalsIgnoreCase(QUORUM_LOCAL_DC)) {
                String dc = this.getDataCenterOfServer(server);
                if (dc == null) {
                    throw new OConfigurationException("Data center not specified for server '" + server + "' in distributed configuration");
                }
                value = this.getDataCenterWriteQuorum(dc);
            } else {
                throw new OConfigurationException("The value '" + value + "' is not supported for " + quorumSetting + " in distributed configuration");
            }
        }
        return (Integer)value;
    }

    public static enum NEW_NODE_STRATEGIES {
        DYNAMIC,
        STATIC;

    }

    public static enum ROLES {
        MASTER,
        REPLICA;

    }
}

